export default {
	icon: 'far fa-random',
	name: 'swapVariable',
	label: 'Swap Variable',
	description: `
		Finds all occurrences of the given variable across whole scenario or in one module and
		replaces them with the new one. Wildcards are not supported. For example,
		let's have an object "{ a: { b: 1, c: 2 } }". You can swap \`a.b\` for \`a.c\`,
		but you can't swap \`a\` for \`d\``,
	theme: '#EEEEEE',
	modifier: true,
	input: [
		{
			name: 'toFind',
			label: 'Variable to find',
			type: 'text',
			help: 'Simply copy and paste the variable pill the from scenario. The value should look like "{{12.Items}}" or "{{13.Items[].Code}}"',
			required: true
		},
		{
			name: 'replaceWith',
			label: 'Replace with',
			type: 'text',
			help: 'Simply copy and paste the variable pill the from scenario. The value should look like "{{12.Items}}" or "{{13.Items[].Code}}"',
			required: true
		},
		{
			name: 'inModule',
			label: 'Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'Module to swap the variable in. If empty, variable is swapped in whole scenario.',
			mappable: true
		},
	],
	steps: [
		{
			type: 'javascript',
			code: `
				const toFind = IML.parse(parameters.toFind)[0].name;
				const replaceWith = IML.parse(parameters.replaceWith)[0].name;
				const replaceRecursively = (obj, toFind, replaceWith) => {
					for(const k of Object.keys(obj)) {
						if(typeof obj[k] === 'object' && obj[k] !== null && obj[k] !== undefined){
							if(!(Array.isArray(obj[k]))) {
								replaceRecursively(obj[k], toFind, replaceWith); 
							} else {
								for(const item of obj[k]) {
									replaceRecursively(item, toFind, replaceWith); 
								}
							}
						}
						else if(k !== '__IMTCONN__' && obj[k] !== null && obj[k] !== undefined && obj[k].includes && obj[k].includes(toFind)) {
							obj[k] = IML.stringify(IML.replace(IML.parse(obj[k]), 'variable', toFind, replaceWith));
						}
					}
				}
				const replaceConditions = (conditions, toFind, replaceWith) => {
					conditions && conditions.forEach(or => {
						or.forEach(and => {
							['a', 'b'].forEach(operand => {
								if(and[operand] !== null && and[operand] !== undefined && and[operand].includes && and[operand].includes(toFind)) {
									and[operand] = IML.stringify(IML.replace(IML.parse(and[operand]), 'variable', toFind, replaceWith));
								}
							})
						});
					});
				}
				if (parameters.inModule) {
					const m = Inspector.seek(parameters.inModule)
					m.mapper && replaceRecursively(m.mapper, toFind, replaceWith)
					m.parameters && replaceRecursively(m.parameters, toFind, replaceWith)
					m.filter && replaceConditions(m.filter.conditions, toFind, replaceWith)
				}
				else {
					Inspector.instance._surface.find(Surface.Module).forEach(m => {
						m.mapper && replaceRecursively(m.mapper, toFind, replaceWith)
						m.parameters && replaceRecursively(m.parameters, toFind, replaceWith)
						m.filter && replaceConditions(m.filter.conditions, toFind, replaceWith)
					})
				}
			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
