export default {
	icon: 'far fa-presentation',
	name: 'showcaseNames',
	label: 'Mock Labels',
	description: `This tool is able to change the label and description of the given Module.
	It's <strong>not meant</strong> for actual renaming the Modules, for that, use the Scenario Editor directly.
	Changes made by this tool <strong>aren't permanent</strong>, they don't affect the real scenarios
	and are meant only purely for the scenario presentation purposes.
	To <strong>reset</strong> the texts, just refresh the browser window.`,
	theme: '#61beed',
	input: [
		{
			name: 'mdl',
			label: 'Module',
			type: 'select',
			options: {
				store: 'rpc://listModules',
				nested: [
					{
						name: 'label',
						label: 'Label',
						type: 'text',
						help: 'Label of the module. The bold text under the Module. Empty value means no change, if you want to **blank** the field, enter ` ` (space).'
					},
					{
						name: 'description',
						label: 'Description',
						type: 'text',
						help: 'Description of the module. The small text under the Label. Empty value means no change, if you want to **blank** the field, enter ` ` (space).'
					}
				]
			},
			help: 'Select the Module to change the Label and Description.',
			mappable: true,
			required: true
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
					const mdl = Inspector.seek(parameters.mdl);
					if (!mdl) { return; }

					if (parameters.label && mdl._title) {
						mdl._title.text = parameters.label;
					}

					if (parameters.description && mdl._description) {
						mdl._description.text = parameters.description;
					}
			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
