// Generated by CoffeeScript 1.12.7
(function() {
  "use strict";
  var LOADED, handler, items, mark, ref, ref1, ref2, ref3, reload, renderNotification, svg, window,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  if ('undefined' === typeof imt) {
    return;
  }

  window = sim(global);

  (function() {
    var err, load, popups, show;
    load = function(next) {
      return Loader.api('timeline/popups/list', function(err, data) {
        if (err) {
          return console.error(err);
        }
        imt.localStorage.setItem('popups', JSON.stringify({
          updated: new Date().toISOString(),
          data: data
        }));
        return next();
      });
    };
    show = function() {
      var err, popup, popups;
      try {
        popups = JSON.parse(imt.localStorage.getItem('popups'));
      } catch (error) {
        err = error;
        if (err) {
          return console.error(err);
        }
      }
      popup = popups.data.find(function(p) {
        var ref;
        return !sim.cookies.get("popup-" + p.id) && (ref = "" + (imt.user.id ? 'private' : 'public'), indexOf.call(p.audience, ref) >= 0) && (!p.expiration || new Date(p.expiration) > new Date());
      });
      if (popup && !global.opener) {
        return new Flash({
          title: popup.title,
          text: popup.description,
          icon: popup.icon,
          permanent: true,
          closeable: true,
          link: popup.url || null
        }).on('close', function() {
          return sim.cookies.set("popup-" + popup.id, 'seen', 129600);
        }).css('background-color', '#efb534');
      }
    };
    try {
      popups = JSON.parse(imt.localStorage.getItem('popups'));
    } catch (error) {
      err = error;
      if (err) {
        return console.error(err);
      }
    }
    if (popups) {
      if (new Date() - new Date(popups.updated) > 60 * 60 * 1000) {
        return load(function() {
          return show();
        });
      } else {
        return show();
      }
    } else {
      return load(function() {
        return show();
      });
    }
  })();

  if (imt.promo === 'producthunt' && !sim.cookies.get('promo-producthunt')) {
    sim.cookies.set('promo-producthunt', 'seen', 129600);
  }

  if (false && imt.user.id && !global.opener && !sim.cookies.get('promo-producthunt')) {
    new Flash({
      text: 'We are on Product Hunt! Come check us out and join the conversation.',
      icon: '.fab.fa-product-hunt.fa-4x',
      permanent: true,
      closeable: true,
      link: 'https://www.producthunt.com/posts/workfrontfusion-mobile-app'
    }).on('close', function() {
      return sim.cookies.set('promo-producthunt', 'seen', 129600);
    });
  }

  sim('.content *[data-toggle="tooltip"]').each(function() {
    if (/^\{\{.*\}\}$/.test(this.data('title'))) {
      this.data('title', IML.execute(IML.parse(this.data('title')), {}, {
        functions: {
          format: format,
          parse: JSON.parse,
          data: this.data.bind(this)
        }
      }));
    }
    return this.tooltip({
      container: document.body
    });
  });

  sim(document).on('click', '.i-select-company', function(event) {
    var panel, pattern, ref, ref1, url;
    event.stopPropagation();
    if (((ref = Panels.one) != null ? ref._relative : void 0) === this) {
      Panels.one.close();
      return false;
    }
    url = this.attr('href');
    pattern = (ref1 = this.data('pattern')) != null ? ref1 : url + "?company={{id}}";
    panel = Panels.one = new Panel(this);
    panel.position = 'bottom';
    panel.offsetY = 20;
    if (this.data('headless') !== 'yes') {
      panel.title = imt.l('base', 'common.chooseorg');
    }
    panel.loading = true;
    Loader.api('companies/list', function(err, data) {
      if (err) {
        return panel.warn(err);
      }
      panel.loading = false;
      return panel.content = sim.div(function() {
        return this.div('.list-group.list-group-small', function() {
          var company, i, len, results;
          results = [];
          for (i = 0, len = data.length; i < len; i++) {
            company = data[i];
            results.push((function(_this) {
              return function(company) {
                return _this.a('.list-group-item.align-items-start', function() {
                  this.attr('href', pattern.replace(/{{id}}/g, company.id));
                  this.i(".far.fa-user" + (company["default"] ? "" : "s") + ".list-group-icon");
                  this.div('.list-group-title').text(company.name);
                  return this.on('click', function() {
                    return sim.cookies.set("company", company.id, {
                      secure: true,
                      maxAge: 31536000000
                    });
                  });
                });
              };
            })(this)(company));
          }
          return results;
        });
      });
    });
    return false;
  });

  sim('.checker').each(function() {
    var item, klass, type;
    item = this.data('item');
    klass = this.data('class');
    type = this.data('type');
    return this.on('click', item, (function(_this) {
      return function(event) {
        var target;
        if (type === 'radio') {
          _this.find('.' + klass).removeClass(klass).each(function(elm) {
            return _this.emit('check_change', {
              detail: {
                item: elm,
                checked: false
              }
            });
          });
        }
        target = sim(event.target);
        if (!target.is(item)) {
          target = target.closest(item);
        }
        target.toggleClass(klass);
        return _this.emit('check_change', {
          detail: {
            item: target,
            checked: target.hasClass(klass)
          }
        });
      };
    })(this));
  });

  sim('svg.desktop .runonce').on('click', function() {
    var scenario;
    scenario = this.closest('svg.desktop').find('svg.scenario').first();
    scenario.__dom.classList.remove('animate');
    setImmediate(function() {
      return scenario.__dom.classList.add('animate');
    });
    return false;
  });

  if (sim('.content-index').length) {
    svg = sim('#simple svg.scenario').first();
    if (svg) {
      handler = function() {
        if (svg.offset().top < this.scrollTop() + this.height() / 2) {
          sim(window).off('scroll', handler);
          return svg.__dom.classList.add('animate');
        }
      };
      sim(window).on('scroll', handler);
    }
  }

  if (sim('.content-scenarios').length) {
    sim('.folders').on('dragover', '.folder', function(event) {
      event.preventDefault();
      return event.dropEffect = 'move';
    });
    sim('.folders').on('dragenter', '.folder', function(event) {
      return sim(event.target).addClass('draghover');
    });
    sim('.folders').on('dragleave', '.folder', function(event) {
      return sim(event.target).removeClass('draghover');
    });
    sim('.folders').on('drop', '.folder:not(.active)', function(event) {
      var folder, scenario, target;
      sim(event.target).removeClass('draghover');
      event.preventDefault();
      scenario = parseInt(event.dataTransfer.getData((browser.ie ? 'Text' : 'text/plain')));
      folder = parseInt(this.data('id'));
      if (isNaN(scenario) || isNaN(folder)) {
        return;
      }
      target = sim(".scenario[data-id=\"" + scenario + "\"]").first();
      if (!target) {
        return;
      }
      if (target.data('folder') && parseInt(target.data('folder')) === folder) {
        return;
      }
      return Loader.api("scenario/" + scenario + "/folder/", {
        method: 'POST',
        data: {
          folder: folder
        }
      }, function(err, directives) {
        if (err) {
          return new Alert(err.message).show();
        }
        if ((directives != null) && 'object' === typeof directives) {
          return AJAXDirectives.process(target, directives, target);
        }
      });
    });
    sim('.scenario').each(function() {
      return this.on('dragstart', (function(_this) {
        return function(event) {
          event.effectAllowed = 'move';
          return event.dataTransfer.setData((browser.ie ? 'Text' : 'text/plain'), _this.data('id'));
        };
      })(this));
    });
  }

  if (sim('.content-accounts').length) {
    sim('.i-tester').each(function() {
      var self;
      self = this;
      return self.on('click', function(event) {
        event.preventDefault();
        if (self.data('working')) {
          return;
        }
        self.data('before-test', self.text());
        self.data('working', true);
        self.prop('enabled', false);
        self.text(imt.l('base', 'tester.testing'));
        Loader.api("account/" + (self.data('id')) + "/test", function(err, working) {
          self.text(self.data('before-test'));
          self.data('working', false);
          self.prop('enabled', true);
          if (working) {
            self.replaceWith(sim.i('.far.fa-fw.fa-check-circle.text-success'));
          } else {
            self.parent().children('.i-reauthorizer').removeClass('collapse');
            self.replaceWith(sim.i('.far.fa-fw.fa-exclamation-circle.text-danger'));
          }
          if (err) {
            return new Alert(err.message).show();
          }
        });
        return false;
      });
    });
    sim('.i-reauthorizer').each(function() {
      var self;
      self = this;
      return self.on('click', function(event) {
        var tmr, win;
        event.preventDefault();
        if (self.data('working')) {
          return;
        }
        win = window.open("/oauth/reauth/" + (self.data('id')), 'authAccountWindow', 'location=no,status=no,width=1024,height=768');
        if (!win) {
          return new Alert(imt.l('base', 'common.popup')).show();
        }
        self.data('before-reauth', self.text());
        self.data('working', true);
        self.prop('enabled', false);
        self.text(imt.l('base', 'reauthorizer.reauthorizing'));
        tmr = repeat(500, function() {
          if (win.closed) {
            unrepeat(tmr);
            self.text(imt.l('base', 'reauthorizer.verifying'));
            return Loader.api("account/" + (self.data('id')) + "/test", function(err, working) {
              var failIcon;
              self.text(self.data('before-reauth'));
              self.data('working', false);
              self.prop('enabled', true);
              if (working) {
                failIcon = self.parent().children('i.fa-exclamation-triangle.text-danger').first();
                if (failIcon) {
                  failIcon.replaceWith(sim.i('.far.fa-check-circle.text-success'));
                  self.addClass('collapse');
                } else {
                  self.replaceWith(sim.i('.far.fa-check-circle.text-success'));
                }
              }
              if (err) {
                return new Alert(err.message).show();
              }
            });
          }
        });
        return false;
      });
    });
  }

  if (sim('.content-notifications').length) {
    if ((ref = sim('#notifications')) != null) {
      ref.init();
    }
    LOADED = {};
    renderNotification = function(body, elm) {
      return sim.div('.list-group-item-detail.notification-body', function() {
        this.html(body);
        this.hide();
        this.insertAfter(elm);
        return this.slideDown('fast');
      });
    };
    sim('.list-group').on('click', '.list-group-item', function(event) {
      var elm, icon, id, next, target, title;
      target = sim(event.target);
      if (target.is('.btn') || target.parent().is('.btn')) {
        return;
      }
      if (this.hasClass('list-group-group')) {
        this.find('.list-group-item').insertBefore(this);
        this.remove();
        return;
      }
      elm = this;
      id = elm.data('id');
      next = elm.next('div.list-group-item-detail');
      icon = elm.find('.list-group-icon');
      title = elm.find('.list-group-title');
      if (next) {
        next.slideUp(function() {
          return next.remove();
        });
        return;
      }
      if (LOADED[id]) {
        return renderNotification(LOADED[id], elm);
      }
      icon.removeClass('fa-envelope fas').addClass('far fa-circle-notch fa-spin');
      Loader.api("notification/" + id, function(err, body) {
        icon.removeClass('fa-circle-notch fa-spin far');
        if (err) {
          icon.addClass('fas fa-envelope');
          return new Alert(err.message).show();
        }
        icon.addClass('far fa-envelope-open');
        title.removeClass('font-weight-bold');
        LOADED[id] = body;
        sim('.notifications-count').each(function() {
          if (parseInt(this.text()) <= 1) {
            return this.remove();
          } else {
            return this.text(Math.max(0, parseInt(this.text()) - 1));
          }
        });
        return renderNotification(body, elm);
      });
      event.preventDefault();
      return false;
    });
    if ((ref1 = sim('#allread')) != null) {
      ref1.on('click', function() {
        return new Prompt(this.data('confirm')).show((function(_this) {
          return function(result) {
            if (!result) {
              return;
            }
            _this.prop('disabled', true);
            return Loader.api("notifications/read", {
              method: 'POST'
            }, function(err) {
              _this.prop('disabled', false);
              if (err) {
                return new Alert(err.message).show();
              }
              sim('#notifications > .list-group-item > .list-group-icon').removeClass('fas fa-envelope').addClass('far fa-envelope-open');
              return sim('.notifications-count').remove();
            });
          };
        })(this));
      });
    }
    if ((ref2 = sim('#delall')) != null) {
      ref2.on('click', function() {
        return new Prompt(this.data('confirm')).show((function(_this) {
          return function(result) {
            if (!result) {
              return;
            }
            _this.prop('disabled', true);
            return Loader.api("notifications/delete", {
              method: 'DELETE'
            }, function(err) {
              _this.prop('disabled', false);
              if (err) {
                return new Alert(err.message).show();
              }
              sim('#notifications').empty();
              return sim('.notifications-count').remove();
            });
          };
        })(this));
      });
    }
  }

  if (sim('.content-dashboard').length) {
    sim.countdown();
    items = sim('#dashboard .list-group > .list-group-item').filter(function(item) {
      return item.find('.i-countdown').length > 0;
    });
    reload = function() {
      var ids, running;
      if (document.hidden) {
        return delay(10000, reload);
      }
      running = items.filter(function(item) {
        return item.find('.i-countdown[data-running="true"]').length > 0;
      });
      if (!running.length) {
        return delay(10000, reload);
      }
      ids = running.map(function(item) {
        return parseInt(item.data('id'));
      });
      return Loader.load('api://dashboard/scenarios', {
        method: 'POST',
        data: {
          scenarios: ids
        }
      }, function(err, data) {
        var elm, i, len, me, scenario;
        if (err) {
          return console.error("Failed to read scenario status.", err);
        }
        for (i = 0, len = data.length; i < len; i++) {
          scenario = data[i];
          me = items.filter("[data-id=\"" + scenario.id + "\"]").first();
          if (!me) {
            continue;
          }
          if (scenario.islinked) {
            if (scenario.next_exec_timestamp > new Date()) {
              elm = items.first();
              while (elm && parseInt(elm.find('.i-countdown').data('timestamp')) < +scenario.next_exec_timestamp) {
                elm = elm.next();
              }
              if (elm != null) {
                elm.before(me);
              }
              me.find('.i-countdown').first().reset(scenario.next_exec_timestamp);
            }
          } else {
            me.remove();
            items.remove(me);
          }
        }
        return delay(10000, reload);
      });
    };
    delay(10000, reload);
  }

  if (sim('.content-kb').length) {
    if (/^#highlight:(.+)$/.test(global.location.hash)) {
      mark = new Mark(sim('.content-kb .page').first().__dom);
      mark.mark(global.location.hash.substr(11), {
        done: function() {
          var elm;
          elm = sim('.content-kb .page mark').first();
          while (elm && !elm.parent().hasClass('page')) {
            elm = elm.parent();
          }
          return elm != null ? elm.__dom.scrollIntoView() : void 0;
        }
      });
    }
  }

  sim('.content-kb .page img, .content-blog article img, .content-features section img, .content-index section.features img, .content-index .video, .content-integrations .video').on('click', function() {
    var calculate, container, img, naturalHeight, naturalWidth, resize, self, youtube;
    if (this.parent().is('a')) {
      return;
    }
    self = this;
    youtube = this.data('youtube');
    if (youtube) {
      naturalWidth = 1280;
      naturalHeight = 720;
      img = sim.iframe(function() {
        this.attr('src', "https://www.youtube.com/embed/" + youtube + "?autoplay=1");
        this.attr('frameborder', "0");
        return this.attr('allowfullscreen', 'allowfullscreen');
      });
    } else {
      naturalWidth = this.__dom.naturalWidth;
      naturalHeight = this.__dom.naturalHeight;
      img = this.clone();
    }
    img.css({
      width: this.width(),
      height: this.height(),
      left: this.offset().left - window.scrollLeft(),
      top: this.offset().top - window.scrollTop()
    });
    this.css('visibility', 'hidden');
    if (this.hasClass('no-shadow')) {
      img.addClass('no-shadow');
    }
    container = sim.div('.i-zoomed-image').append(img);
    sim('body').append(container);
    setImmediate(function() {
      return container.addClass('in');
    });
    calculate = function() {
      var h, padding, w, wh, ww;
      padding = 30;
      ww = window.width();
      wh = window.height();
      w = naturalWidth;
      h = naturalHeight;
      if (w > ww - (padding * 2)) {
        w = ww - (padding * 2);
        h *= w / naturalWidth;
      }
      if (h > wh - (padding * 2)) {
        h = wh - (padding * 2);
        w = naturalWidth * (h / naturalHeight);
      }
      return {
        width: w,
        height: h,
        left: (ww - w) / 2,
        top: (wh - h) / 2
      };
    };
    resize = function() {
      return img.css(calculate());
    };
    img.animate(calculate());
    container.on('click', function() {
      container.removeClass('in');
      return img.stop().animate({
        width: self.width(),
        height: self.height(),
        left: self.offset().left - window.scrollLeft(),
        top: self.offset().top - window.scrollTop()
      }, {
        complete: function() {
          self.css('visibility', 'visible');
          container.remove();
          return window.off('resize', resize);
        }
      });
    });
    return window.on('resize', resize);
  });

  if (sim('.content-subscribe').length) {
    sim('.content-subscribe input.plan-quantity').on('input', function() {
      var plan, qty;
      qty = parseInt(this.val());
      plan = this.closest('.list-group-item');
      if (isNaN(qty) || qty < 1 || qty > 1000) {
        plan.find('.payment-methods a').addClass('disabled');
        plan.find('.payment-methods button').prop('disabled', true);
        plan.find('form input[name="qty"]').val(1);
        return;
      }
      plan.find('.payment-methods a').each(function() {
        if (!this.data('href')) {
          this.data('href', this.attr('href'));
        }
        return this.attr('href', (this.data('href')) + "?qty=" + qty);
      });
      plan.find('.payment-methods a').removeClass('disabled');
      plan.find('.payment-methods button').prop('disabled', false);
      plan.find('form input[name="qty"]').val(qty);
      return true;
    });
  }

  if (sim('.content-apps').length) {
    sim('.list-group-icon[class^="list-group-icon theme-"]').each(function() {
      this.css({
        'color': new Color("#" + (this.attr('class').substr(22))).determineForegroundColor().toHex(),
        'background-color': "#" + (this.attr('class').substr(22))
      });
      return this.children('img').on('error', function() {
        return this.attr('src', imt["static"]('/img/noicon.png'));
      });
    });
  }


  /*
  Common Stuff
   */

  sim('body > footer .languages a').each(function() {
    return this.attr('href', "/language/" + (this.attr('hreflang')) + "?go=" + (encodeURIComponent(this.attr('href'))));
  });

  sim('.progress').each(function() {
    return this.children('.progress-bar').css('width', this.data('value'));
  });

  if ((ref3 = sim('#subscribeform')) != null) {
    ref3.on('submit', function() {
      Loader.api('subscribe', {
        method: 'POST',
        data: {
          email: sim('#subscribeemail').val()
        }
      }, function(err, data) {
        var ref4, ref5;
        if (err) {
          if (err.name === 'BundleValidationError') {
            err = (ref4 = (ref5 = err.errors) != null ? ref5[0] : void 0) != null ? ref4 : err;
          }
          return new Alert(err.message).show();
        }
        if (typeof ga === "function") {
          ga('send', 'event', 'newsletter', 'send', window.location.pathname);
        }
        sim('#subscribeemail').val('');
        return new Flash('Email was saved. Thank you.');
      });
      return false;
    });
  }

  window.on('click', '.btn-share', function() {
    var url, wh, wl, wt, ww;
    ww = 520;
    wh = 350;
    wt = (screen.height / 2) - (wh / 2);
    wl = (screen.width / 2) - (ww / 2);
    if (this.hasClass('btn-share-facebook')) {
      url = "https://www.facebook.com/sharer.php?u=" + (encodeURIComponent(location.href));
    } else if (this.hasClass('btn-share-twitter')) {
      url = "https://twitter.com/intent/tweet?text=" + (this.data('text')) + "&url=" + (encodeURIComponent(location.href));
    } else if (this.hasClass('btn-share-gplus')) {
      url = "https://plus.google.com/share?url=" + (encodeURIComponent(location.href));
    }
    if (url) {
      return window.open(url, 'sharer', "top=" + wt + ",left=" + wl + ",toolbar=no,status=no,scrollbars=yes,resizable=yes,location=yes,width=" + ww + ",height=" + wh);
    }
  });

}).call(this);
