/*
Workfront Fusion IML

@license Copyright (c) 2021 Workfront - All rights reserved.
@version 1.21.4s
 */
(function(){"use strict";var ALT_OPS,Buffer,COMPARE,CONCAT,DEEP_EQUAL,Decimal,ESCAPE,ESCAPEABLE,ESCAPE_HTML,IML,IMLError,IML_ARRAY,IML_FILTERS,IML_FUNCTIONS,IML_KEYWORDS,IML_OPERATORS,IML_VARIABLES,IMTDate,IS_NUMBER,MAP_VARIABLE,PARSE_UNKNOWN,SIML,SPLIT_VARIABLE,TYPE_CHECK,UNESCAPE,VALUE_ERROR,crypto,exports,moment,require,slice=[].slice,indexOf=[].indexOf||function(item){for(var i=0,l=this.length;i<l;i++)if(i in this&&this[i]===item)return i;return-1},extend=function(child,parent){function ctor(){this.constructor=child}for(var key in parent)hasProp.call(parent,key)&&(child[key]=parent[key]);return ctor.prototype=parent.prototype,child.prototype=new ctor,child.__super__=parent.prototype,child},hasProp={}.hasOwnProperty;"undefined"!=typeof imt&&(global.IML||(imt.plugins.push({name:"IML",version:"1.21.4",author:"Workfront"}),exports={},Buffer={isBuffer:function(){return!1}},require=function(module){switch(module){case"@workfront/dateparser":if(!global.IMTDate)throw new Error("Date Parser is not present.");return{IMTDate:global.IMTDate};case"moment":case"moment-timezone":if(!global.moment)throw new Error("Moment is not present.");return global.moment;case"crypto":return{createHash:function(alg){return{update:function(data){return{digest:function(enc){return""}}}}},createHmac:function(alg,key){return{update:function(data){return{digest:function(enc){return""}}}}}};case"decimal.js":return function(){function Decimal(value){this.value=value}return Decimal.prototype.plus=function(value){return new Decimal(this.value+value)},Decimal.prototype.minus=function(value){return new Decimal(this.value-value)},Decimal.prototype.times=function(value){return new Decimal(this.value*value)},Decimal.prototype.dividedBy=function(value){return new Decimal(this.value/value)},Decimal.prototype.modulo=function(value){return new Decimal(this.value%value)},Decimal.prototype.valueOf=function(){return this.value},Decimal.prototype.toJSON=function(){return this.value},Decimal.prototype.toNumber=function(){return this.value},Decimal}();default:throw new Error("Module '"+module+"' is not present.")}return null},moment=require("moment-timezone"),crypto=require("crypto"),Decimal=require("decimal.js"),IMTDate=require("@workfront/dateparser").IMTDate,ALT_OPS={"&&":"&","||":"|","==":"=","===":"=","!==":"!="},PARSE_UNKNOWN=function(buffer,links){var cursor,link,ref,ref1;if("$"===buffer[0])if(-1===(cursor=buffer.indexOf(".")))link=buffer.substr(1),null==links[link]&&IML.errors.push(new IMLError("Linked source not found '"+buffer+"'.")),buffer=null!=(ref=links[link])?ref:"?";else{if(null==links)return{type:"link",name:buffer};link=buffer.substr(1,cursor-1),buffer=(null!=(ref1=links[link])?ref1:"?")+buffer.substr(cursor)}return IS_NUMBER(buffer)?{type:"number",value:parseFloat(buffer)}:IML_KEYWORDS[buffer]?{type:"keyword",name:buffer}:{type:"variable",name:buffer}},SPLIT_VARIABLE=function(variable){return variable=String(variable),-1===variable.indexOf("`")?variable.split("."):variable.split(/\.(?=(?:[^`]*`[^`]*`)*[^`]*$)/g).map(UNESCAPE)},MAP_VARIABLE=function(data,key){var k,n,ref,ref1,ref2;if(null==data){if(!1===(null!=(ref=this.passthrough)?ref.null:void 0))return;return this.passthrough?data:null}for(key=SPLIT_VARIABLE(key);key.length;){if(k=key.shift(),n=null,"prototype"===k||"constructor"===k||"__proto__"===k||"__super__"===k)return this.passthrough?void 0:null;if(/\[(\d+)?\]$/.exec(k)&&(n=RegExp.$1?parseInt(RegExp.$1):1,k=k.substr(0,k.length-RegExp.$1.length-2)),""===k&&Array.isArray(data)&&null!=n)data=data[n-1];else{if(Array.isArray(data)){if(k=parseInt(k),isNaN(k)&&this.passthrough)return;data=data[k-1]}else data=Object.prototype.hasOwnProperty.call(data,k)?data[k]:void 0;if("function"==typeof data){if(this.passthrough)return;return null}null!=n&&Array.isArray(data)&&(data=data[n-1])}if("function"==typeof data){if(this.passthrough)return;return null}if(null==data){if(!1===(null!=(ref1=this.passthrough)?ref1.null:void 0))return;return this.passthrough?data:null}}if(null==data){if(!1===(null!=(ref2=this.passthrough)?ref2.null:void 0))return;return this.passthrough?data:null}return data},TYPE_CHECK=function(variable){if(null==variable)return"null";switch(typeof variable){case"number":return"number";case"boolean":return"boolean";case"string":return IS_NUMBER(variable)?"number":"string";case"object":return Array.isArray(variable)?"array":variable instanceof Date?"date":variable instanceof String?"string":variable instanceof Number?"number":variable instanceof Boolean?"boolean":Buffer.isBuffer(variable)?"buffer":"object";default:return"unknown"}},DEEP_EQUAL=function(a,b){var aLength,index,item,key,l,len;if(null==a||null==b)return null!=a==(null!=b);switch(typeof a){case"string":case"number":case"boolean":return String(a)===String(b);case"object":if("object"!=typeof b)return!1;if(a instanceof Array){if(!(b instanceof Array))return!1;if(a.length!==b.length)return!1;if(0===a.length)return!0;for(index=l=0,len=a.length;l<len;index=++l)if(item=a[index],!DEEP_EQUAL(item,b[index]))return!1}else{if(a instanceof Date)return b instanceof Date&&a.getTime()===b.getTime();if((aLength=Object.keys(a).length)!==Object.keys(b).length)return!1;if(0===aLength)return!0;for(key in a)if(!DEEP_EQUAL(a[key],b[key]))return!1}break;default:return!1}return!0},UNESCAPE=function(value){return null==value?value:"string"!=typeof value?"":(/^`(.*)`(\[\d*\])?$/.exec(value)&&(value=RegExp.$1.replace(/``/g,"`")+RegExp.$2),value)},ESCAPE=function(value){return null==value?value:"string"!=typeof value?"":/^[a-z][a-z0-9_]*$/i.test(value)?value:"`"+value.replace(/`/g,"``")+"`"},ESCAPEABLE=function(value){return null!=value&&("string"==typeof value&&!/^[a-z][a-z0-9_]*$/i.test(value))},VALUE_ERROR=function(value,show,hide){var type;switch(type=TYPE_CHECK(value)){case"number":case"boolean":value=String(value);break;case"date":value=value.toISOString();break;case"array":case"object":case"buffer":value="{"+type+"}";break;case"string":if(value.length>100)return hide;break;case"null":value="{empty}";break;default:return hide}return show.replace(/\{\{value\}\}/g,value)},IML_KEYWORDS={true:{type:"boolean",group:"general",value:!0},false:{type:"boolean",group:"general",value:!1},space:{type:"text",group:"string",value:" "},nbsp:{type:"text",group:"string",value:String.fromCharCode(160)},tab:{type:"text",group:"string",value:"\t"},emptystring:{type:"text",group:"string",value:function(){return new String("")}},newline:{type:"text",group:"string",value:"\n"},carriagereturn:{type:"text",group:"string",value:"\r"},undefined:{type:"*",group:"general",value:void 0,hidden:!0},ignore:{type:"*",group:"general",value:void 0},null:{type:"*",group:"general",value:null},erase:{type:"*",group:"general",value:null},emptyarray:{type:"*",group:"array",value:function(){return[]}},erasearray:{type:"*",group:"array",value:function(){return[]},hidden:!0}},IML_FUNCTIONS={"":{type:"*",group:"general",value:function(value){return value},outputs:function(value){return value}},get:{type:"*",group:"general",value:function(value,property){return MAP_VARIABLE.call(this,value,property)}},average:{type:"number",group:"math",value:function(one){var arr,l,len,num,numArr,sum;for(arr="array"===TYPE_CHECK(one)?one:Array.prototype.slice.call(arguments),numArr=arr.filter(function(num){return IS_NUMBER(num)}),sum=0,l=0,len=numArr.length;l<len;l++)num=numArr[l],sum+=num;return sum/numArr.length}},ceil:{type:"integer",group:"math",value:function(num){if(null==num)return this.passthrough?num:null;if(""===num)return null;if("number"!==TYPE_CHECK(num))throw new Error(VALUE_ERROR(num,"'{{value}}' is not a valid number.","Invalid number."));return Math.ceil(num)}},floor:{type:"integer",group:"math",value:function(num){if(null==num)return this.passthrough?num:null;if(""===num)return null;if("number"!==TYPE_CHECK(num))throw new Error(VALUE_ERROR(num,"'{{value}}' is not a valid number.","Invalid number."));return Math.floor(num)}},if:{type:"*",group:"general",value:function(statement,exp1,exp2){return statement?exp1:exp2},outputs:function(statement,exp1,exp2){return exp1}},ifempty:{type:"*",group:"general",value:function(exp1,exp2){return"string"===TYPE_CHECK(exp1)?0===exp1.length?exp2:exp1:null!=exp1?exp1:exp2},outputs:function(exp1){return exp1}},switch:{type:"*",group:"general",value:function(value,k,v){var args,def,i,ref,ref1;if(args=Array.prototype.slice.call(arguments),args.length%2==0&&(def=args.pop()),"string"!==(ref=TYPE_CHECK(value))&&"number"!==ref&&"boolean"!==ref)return null!=def||this.passthrough?def:null;for(value=String(value),i=1;i<args.length;){if(("string"===(ref1=TYPE_CHECK(args[i]))||"number"===ref1||"boolean"===ref1)&&value===String(args[i]))return args[i+1];i+=2}return null!=def||this.passthrough?def:null}},join:{type:"text",group:"array",value:function(array,separator){var join,ref;return join=function(array,separator,brackets){var elem,i,l,len,out;for(null==separator&&(separator=","),null==brackets&&(brackets=!1),out="",brackets&&(out+="["),i=l=0,len=array.length;l<len;i=++l){switch(elem=array[i],TYPE_CHECK(elem)){case"null":out+="";break;case"object":out+="{object}";break;case"buffer":out+="{buffer}";break;case"date":out+=elem.toISOString();break;case"array":out+=join(elem,separator,brackets);break;default:out+=elem}i<array.length-1&&(out+=separator)}return brackets&&(out+="]"),out},"array"!==TYPE_CHECK(array)?"":null==separator||"string"!==(ref=TYPE_CHECK(separator))&&"number"!==ref?join(array,",",null!=arguments[2]&&!0===arguments[2]):join(array,separator,null!=arguments[2]&&!0===arguments[2])}},length:{type:"uinteger",group:["string","array"],value:function(text){if(null==text)return 0;switch(TYPE_CHECK(text)){case"array":case"buffer":return text.length;default:return String(text).length}}},lower:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:String(text).toLowerCase()}},capitalize:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:(text=String(text),text.charAt(0).toUpperCase()+text.slice(1))}},startcase:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:(text=String(text),text.split(" ").map(function(word){return IML_FUNCTIONS.capitalize.value(word.toLowerCase())}).join(" "))}},ascii:{type:"text",group:"string",value:function(text){if(null==text)return this.passthrough?text:null;if(text=String(text),arguments[1])try{text=text.normalize("NFD").replace(/[\u0300-\u036f]/g,"")}catch(error){error}return text.replace(/[^\x00-\x7F]/g,"")}},max:{type:"number",group:"math",value:function(one){var arr,numArr;return arr="array"===TYPE_CHECK(one)?one:Array.prototype.slice.call(arguments),numArr=arr.filter(function(num){return IS_NUMBER(num)}),Math.max.apply(null,numArr)}},min:{type:"number",group:"math",value:function(one){var arr,numArr;return arr="array"===TYPE_CHECK(one)?one:Array.prototype.slice.call(arguments),numArr=arr.filter(function(num){return IS_NUMBER(num)}),Math.min.apply(null,numArr)}},replace:{type:"text",group:"string",value:function(text,what,replace){var match,ref,ref1,ref2,ref3,regExp;if(null==text)return this.passthrough?text:null;if(null==what)return text;if(null==replace)return text;if("buffer"!==TYPE_CHECK(text)||"ascii"!==(ref=text.codepage)&&"utf8"!==ref||(text=text.toString(text.codepage)),"string"!==(ref1=TYPE_CHECK(text))&&"number"!==ref1)throw new Error(VALUE_ERROR(text,"'{{value}}' is not string or number.","Invalid string or number."));if("string"!==(ref2=TYPE_CHECK(what))&&"number"!==ref2)throw new Error(VALUE_ERROR(what,"'{{value}}' is not string or number.","Invalid string or number."));if("string"!==(ref3=TYPE_CHECK(replace))&&"number"!==ref3)throw new Error(VALUE_ERROR(replace,"'{{value}}' is not string or number.","Invalid string or number."));return/^\/.*\/[gim]?$/.test(what)?(match=/^\/(.*)\/([gim]?)$/.exec(what),regExp=new RegExp(match[1],match[2])):regExp=new RegExp(String(what).replace(/[^\w\s]/gi,"\\$&"),"g"),String(text).replace(regExp,replace)}},round:{type:"integer",group:"math",value:function(num){var ref;if(null==num)return this.passthrough?num:null;if(""===num)return null;if("string"!==(ref=TYPE_CHECK(num))&&"number"!==ref)throw new Error(VALUE_ERROR(num,"'{{value}}' is not a valid number.","Invalid number."));return Math.round(num)}},trim:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:String(text).trim()}},upper:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:String(text).toUpperCase()}},substring:{type:"text",group:"string",value:function(text,start,end){return null==text?this.passthrough?text:null:String(text).substring(start,end)}},indexOf:{type:"integer",group:"string",value:function(text,value){return null==text?this.passthrough?text:null:String(text).indexOf(value,arguments[2])}},sum:{type:"number",group:"math",value:function(one){var arr,l,len,num,sum;for(arr="array"===TYPE_CHECK(one)?one:Array.prototype.slice.call(arguments),sum=0,l=0,len=arr.length;l<len;l++)num=arr[l],IS_NUMBER(num)&&(sum+=parseFloat(num));return sum}},toBinary:{type:"text",group:"string",value:function(entry){var encoding;if(null==entry)return this.passthrough?entry:null;if("buffer"===TYPE_CHECK(entry))return entry;if(encoding="utf8",2===arguments.length&&(encoding=arguments[1]),"string"!==TYPE_CHECK(encoding))throw new Error(VALUE_ERROR(encoding,"'{{value}}' is not a valid encoding.","Invalid encoding."));if(encoding=encoding.toLowerCase(),"utf-8"===encoding&&(encoding="utf8"),"ascii"!==encoding&&"hex"!==encoding&&"base64"!==encoding&&"utf8"!==encoding&&"binary"!==encoding)throw new Error(VALUE_ERROR(encoding,"'{{value}}' is not a valid encoding.","Invalid encoding."));return"string"===TYPE_CHECK(entry)?Buffer.from(entry,encoding):Buffer.from(IML_FUNCTIONS.toString.value(entry))}},toString:{type:"text",group:"string",value:function(entry){var encoding;if(null==entry)return"";if(encoding="utf8",2===arguments.length&&(encoding=arguments[1]),"string"!==TYPE_CHECK(encoding))throw new Error(VALUE_ERROR(encoding,"'{{value}}' is not a valid encoding.","Invalid encoding."));if(encoding=encoding.toLowerCase(),"utf-8"===encoding&&(encoding="utf8"),"ascii"!==encoding&&"hex"!==encoding&&"base64"!==encoding&&"utf8"!==encoding&&"binary"!==encoding)throw new Error(VALUE_ERROR(encoding,"'{{value}}' is not a valid encoding.","Invalid encoding."));switch(TYPE_CHECK(entry)){case"number":return entry.toString();case"array":return IML_FUNCTIONS.join.value(entry,",",!0);case"date":return entry.toISOString();case"buffer":return entry.toString(encoding);case"object":return"{object}";case"null":case"unknown":return"";default:return String(entry)}}},encodeURL:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:encodeURIComponent(text)}},decodeURL:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:decodeURIComponent(text)}},escapeHTML:{type:"text",group:"string",value:function(text){var map;return null==text?this.passthrough?text:null:(map={"&":"&amp;","<":"&lt;",">":"&gt;"},String(text).replace(/[&<>]/g,function(tag){return map[tag]||tag}))}},stripHTML:{type:"text",group:"string",value:function(text){return null==text?this.passthrough?text:null:String(text).replace(/<style[^>]*>[\s\S]*?<\/style>/g,"").replace(/<script[^>]*>[\s\S]*?<\/script>/g,"").replace(/<br\s*\/?>/g,"\n").replace(/<\/?[^>]+>/g,"")}},addSeconds:{type:"date",group:"date",value:function(date,numberOfSeconds){var dateObj,seconds;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(seconds=Number(numberOfSeconds),!IS_NUMBER(seconds))throw new Error(VALUE_ERROR(numberOfSeconds,"'{{value}}' is not a valid number of seconds.","Invalid number of seconds."));return moment(dateObj).tz(this.timezone).add(seconds,"s").toDate()}},addMinutes:{type:"date",group:"date",value:function(date,numberOfMinutes){var dateObj,minutes;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(minutes=Number(numberOfMinutes),!IS_NUMBER(minutes))throw new Error(VALUE_ERROR(numberOfMinutes,"'{{value}}' is not a valid number of minutes.","Invalid number of minutes."));return moment(dateObj).tz(this.timezone).add(minutes,"m").toDate()}},addHours:{type:"date",group:"date",value:function(date,numberOfHours){var dateObj,hours;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(hours=Number(numberOfHours),!IS_NUMBER(hours))throw new Error(VALUE_ERROR(numberOfHours,"'{{value}}' is not a valid number of hours.","Invalid number of hours."));return moment(dateObj).tz(this.timezone).add(hours,"H").toDate()}},addDays:{type:"date",group:"date",value:function(date,numberOfDays){var dateObj,days;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(days=Number(numberOfDays),!IS_NUMBER(days))throw new Error(VALUE_ERROR(numberOfDays,"'{{value}}' is not a valid number of days.","Invalid number of days."));return moment(dateObj).tz(this.timezone).add(days,"d").toDate()}},addMonths:{type:"date",group:"date",value:function(date,numberOfMonths){var dateObj,months;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(months=Number(numberOfMonths),!IS_NUMBER(months))throw new Error(VALUE_ERROR(numberOfMonths,"'{{value}}' is not a valid number of months.","Invalid number of months."));return moment(dateObj).tz(this.timezone).add(months,"M").toDate()}},addYears:{type:"date",group:"date",value:function(date,numberOfYears){var dateObj,years;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(years=Number(numberOfYears),!IS_NUMBER(years))throw new Error(VALUE_ERROR(numberOfYears,"'{{value}}' is not a valid number of years.","Invalid number of years."));return moment(dateObj).tz(this.timezone).add(years,"Y").toDate()}},setSecond:{type:"date",group:"date",value:function(date,numberOfSeconds){var dateObj,seconds;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(seconds=Number(numberOfSeconds),!IS_NUMBER(seconds))throw new Error(VALUE_ERROR(numberOfSeconds,"'{{value}}' is not a valid number of seconds.","Invalid number of seconds."));return moment(dateObj).tz(this.timezone).second(seconds).toDate()}},setMinute:{type:"date",group:"date",value:function(date,numberOfMinutes){var dateObj,minutes;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(minutes=Number(numberOfMinutes),!IS_NUMBER(minutes))throw new Error(VALUE_ERROR(numberOfMinutes,"'{{value}}' is not a valid number of minutes.","Invalid number of minutes."));return moment(dateObj).tz(this.timezone).minute(minutes).toDate()}},setHour:{type:"date",group:"date",value:function(date,numberOfHours){var dateObj,hours;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(hours=Number(numberOfHours),!IS_NUMBER(hours))throw new Error(VALUE_ERROR(numberOfHours,"'{{value}}' is not a valid number of hours.","Invalid number of hours."));return moment(dateObj).tz(this.timezone).hours(hours).toDate()}},setDay:{type:"date",group:"date",value:function(date,numberOfDays){var dateObj,days;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(/^(monday|mon|tuesday|tue|wednesday|wed|thursday|thu|friday|fri|saturday|sat|sunday|sun)$/i.test(numberOfDays))return moment(dateObj).tz(this.timezone).day(numberOfDays).toDate();if(days=Number(numberOfDays),!IS_NUMBER(days))throw new Error(VALUE_ERROR(numberOfDays,"'{{value}}' is not a valid number of days.","Invalid number of days."));return moment(dateObj).tz(this.timezone).day(days-1).toDate()}},setDate:{type:"date",group:"date",value:function(date,numberOfDays){var dateObj,days;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(days=Number(numberOfDays),!IS_NUMBER(days))throw new Error(VALUE_ERROR(numberOfDays,"'{{value}}' is not a valid number of days.","Invalid number of days."));return moment(dateObj).tz(this.timezone).date(days).toDate()}},setMonth:{type:"date",group:"date",value:function(date,numberOfMonths){var dateObj,months;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(/^(january|jan|february|feb|march|mar|april|apr|may|june|jun|july|jul|august|aug|september|sep|october|oct|november|nov|december|dec)$/i.test(numberOfMonths))return moment(dateObj).tz(this.timezone).month(numberOfMonths).toDate();if(months=Number(numberOfMonths),!IS_NUMBER(months))throw new Error(VALUE_ERROR(numberOfMonths,"'{{value}}' is not a valid number of months.","Invalid number of months."));return moment(dateObj).tz(this.timezone).month(months-1).toDate()}},setYear:{type:"date",group:"date",value:function(date,numberOfYears){var dateObj,years;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":dateObj=new Date(+date);break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if(years=Number(numberOfYears),!IS_NUMBER(years))throw new Error(VALUE_ERROR(numberOfYears,"'{{value}}' is not a valid number of years.","Invalid number of years."));return moment(dateObj).tz(this.timezone).year(years).toDate()}},formatDate:{type:"text",group:"date",value:function(date,format){var dateObj;if(null==date)return this.passthrough?date:null;switch(format||(format="YYYY-MM-DDTHH:mm:ss.SSSZ"),TYPE_CHECK(date)){case"date":dateObj=date;break;case"number":dateObj=new Date(Number(date));break;case"string":dateObj=IMTDate.parse(date,this.timezone);break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(!dateObj||isNaN(dateObj.getTime()))throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."));if("string"!==TYPE_CHECK(format))throw new Error(VALUE_ERROR(format,"'{{value}}' is not a valid date format.","Invalid date format."));if(date=moment(dateObj),arguments[2]){if("string"!==TYPE_CHECK(arguments[2]))throw new Error(VALUE_ERROR(arguments[2],"'{{value}}' is not a valid time zone.","Invalid time zone."));date=date.tz(arguments[2])}else date=this.timezone?date.tz(this.timezone):date.utc();return date.format(String(format).trim())}},parseDate:{type:"date",group:"date",value:function(date,format){var mdate;if(null==date)return this.passthrough?date:null;switch(TYPE_CHECK(date)){case"date":return date;case"number":if("string"!==TYPE_CHECK(format)){if(null!=format)throw new Error(VALUE_ERROR(format,"'{{value}}' is not a valid date format.","Invalid date format."));return new Date(1e3*date)}if("X"===format)return new Date(1e3*date);if("x"===format)return new Date(date);date=String(date);break;case"string":if("string"!==TYPE_CHECK(format)){if(null!=format)throw new Error(VALUE_ERROR(format,"'{{value}}' is not a valid date format.","Invalid date format."));return IMTDate.parse(date,this.timezone)}break;default:throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date.","Invalid date."))}if(arguments[2])if("number"===TYPE_CHECK(arguments[2]))mdate=moment.utc(date,format,"en"),mdate.add(-parseFloat(arguments[2]),"hours");else{if("string"!==TYPE_CHECK(arguments[2]))throw new Error(VALUE_ERROR(arguments[2],"'{{value}}' is not a valid time zone.","Invalid time zone."));mdate=moment.tz(date,format,"en",arguments[2])}else mdate=this.timezone?moment.tz(date,format,"en",this.timezone):moment.utc(date,format,"en");if(!mdate.isValid())throw new Error(VALUE_ERROR(date,"'{{value}}' is not a valid date or does not match the date format.","Invalid date."));return mdate.toDate()}},parseNumber:{type:"number",group:"math",value:function(stringNumber,separator){var number,sign;if(null==separator&&(separator="."),null==stringNumber)return this.passthrough?stringNumber:null;if("number"===TYPE_CHECK(stringNumber))return Number(stringNumber);if("string"!==TYPE_CHECK(stringNumber))throw new Error(VALUE_ERROR(stringNumber,"'{{value}}' is not a valid number.","Invalid number."));if("string"!==TYPE_CHECK(separator)||","!==separator&&"."!==separator)throw new Error("Valid separators are ',' and '.'.");if(separator=separator.trim(),sign=stringNumber.substring(0,1).replace(/[^0-9\-]/g,""),number=stringNumber.substring(1).replace(/[^0-9,\.e]/g,""),stringNumber=sign+number,number=","===separator?Number(stringNumber.replace(/\./g,"").replace(/,/g,".")):Number(stringNumber.replace(/,/g,"")),!IS_NUMBER(number))throw new Error(VALUE_ERROR(stringNumber,"'{{value}}' is not a valid number or using unsuitable separator.","Invalid number or separator."));return number}},formatNumber:{type:"number",group:"math",value:function(number,decimalPoints,decimalSeparator,thousandsSeparator){var parts,ref;if(null==decimalSeparator&&(decimalSeparator=","),null==thousandsSeparator&&(thousandsSeparator="."),null==number)return this.passthrough?number:null;if("number"!==(ref=TYPE_CHECK(number))&&"string"!==ref)throw new Error(VALUE_ERROR(number,"'{{value}}' is not a valid number.","Invalid number."));if(number=Number(number),!IS_NUMBER(number))throw new Error(VALUE_ERROR(stringNumber,"'{{value}}' is not a valid number or using unsuitable separator.","Invalid number or separator."));return number=number.toFixed(decimalPoints),parts=number.split("."),parts[0]=parts[0].replace(/\B(?=(\d{3})+(?!\d))/g,thousandsSeparator),parts.join(decimalSeparator)}},keys:{type:"array",group:"array",value:function(object){var ref;return"object"!==(ref=TYPE_CHECK(object))&&"array"!==ref?[]:Object.keys(object)},outputs:function(array){return{type:"array",spec:{type:"text"}}}},slice:{type:"array",group:"array",value:function(array,begin){var end,ref;if(null==array)return this.passthrough?array:null;if(end=null!=(ref=arguments[2])?ref:void 0,"array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));if(!IS_NUMBER(begin))throw new Error(VALUE_ERROR(begin,"'{{value}}' is not a valid start number.","Invalid start number."));if(null!=end&&!IS_NUMBER(end))throw new Error(VALUE_ERROR(end,"'{{value}}' is not a valid end number.","Invalid end number."));return array.slice(begin,end)},outputs:function(array){return array}},merge:{type:"array",group:"array",value:function(array1,array2){var arrays,ref;return arrays=Array.prototype.slice.call(arguments),arrays=arrays.filter(function(arr){return Array.isArray(arr)}),arrays.length?(ref=[]).concat.apply(ref,arrays):null},outputs:function(array){return array}},contains:{type:"boolean",group:["array","string"],value:function(array,value){var ci;return null!=array&&null!=value&&(ci=Boolean(arguments[2]),"string"===TYPE_CHECK(array)?(ci&&(array=array.toLowerCase(),value=value.toLowerCase()),array.indexOf(value)>=0):"array"===TYPE_CHECK(array)&&COMPARE.call(this,array,value,"array:contain"+(ci?":ci":"")))}},split:{type:"array",group:"string",value:function(text,delimiter){var arr,keepEmpty;switch(null==delimiter&&(delimiter=","),arr=null,keepEmpty=Boolean(arguments[2]),TYPE_CHECK(text)){case"string":arr=text.split(delimiter);break;case"number":arr=[String(text)];break;case"date":arr=text.toISOString();break;default:return null}return arr=arr.map(function(item){return item.replace(/^\s+|\s+$/g,"")}),keepEmpty||(arr=arr.filter(function(item){return""!==item})),arr},outputs:function(){return{type:"text"}}},remove:{type:"array",
group:"array",value:function(){var array,values;if(array=arguments[0],values=2<=arguments.length?slice.call(arguments,1):[],null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));return values=values.filter(function(value){var ref;return"string"===(ref=TYPE_CHECK(value))||"number"===ref||"boolean"===ref||"null"===ref}),array.filter(function(item){var ref;return"string"!==(ref=TYPE_CHECK(item))&&"number"!==ref&&"boolean"!==ref&&"null"!==ref||!values.some(function(value){return null==value?null==item:null!=item&&String(value)===String(item)})})},outputs:function(array){return array}},add:{type:"array",group:"array",value:function(){var array,values;if(array=arguments[0],values=2<=arguments.length?slice.call(arguments,1):[],null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));return array.push.apply(array,values),array},outputs:function(array){return array}},map:{type:"array",group:"array",value:function(array,value){var key,keyNames,ref,ref1,ref2;if(null==array)return this.passthrough?array:null;if(!Array.isArray(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));if("string"!==(ref=TYPE_CHECK(value))&&"number"!==ref)throw new Error(VALUE_ERROR(value,"'{{value}}' is not a valid key.","Invalid key."));if(0===array.length)return[];if(null!=arguments[2]&&(key=arguments[2]),null!=arguments[3]&&(keyNames=arguments[3]),null!=key&&"string"!==(ref1=TYPE_CHECK(key))&&"number"!==ref1)throw new Error(VALUE_ERROR(key,"'{{value}}' is not a valid key for filtering.","Invalid key for filtering."));if(null!=keyNames){if("string"!==(ref2=TYPE_CHECK(keyNames))&&"number"!==ref2&&"boolean"!==ref2)throw new Error(VALUE_ERROR(keyNames,"'{{value}}' is not a valid list of key names for filtering.","Invalid key names for filtering."));keyNames=String(keyNames)}return null!=key&&null!=keyNames&&(keyNames=keyNames.split(/\s*,\s*/),array=array.filter(function(_this){return function(o){var ref3,ref4,val;return null!=(val=null!=(ref3=MAP_VARIABLE.call(_this,o,key))?ref3:o[key])&&(ref4=String(val),indexOf.call(keyNames,ref4)>=0)}}(this))),array=array.map(function(_this){return function(o){var ref3;return null!=(ref3=MAP_VARIABLE.call(_this,o,value))?ref3:o[value]}}(this))},outputs:function(array){var spec;return spec=void 0,Array.isArray(null!=array?array.spec:void 0)&&(spec=array.spec.find(function(item){return item.name===value})),{type:"array",spec:spec}}},shuffle:{type:"array",group:"array",value:function(array){var i,j,x;if(null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));for(array=array.slice(),i=array.length-1;i>0;)j=Math.floor(Math.random()*(i+1)),x=array[i],array[i]=array[j],array[j]=x,i--;return array},outputs:function(array){return array}},sort:{type:"array",group:"array",value:function(array){var ci,key,order,ref,ref1,ref2;if(null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));return"asc"===(ref=arguments[1])||"desc"===ref||"asc ci"===ref||"desc ci"===ref?(order="asc"===(ref1=arguments[1])||"asc ci"===ref1?"asc":"desc",key=arguments[2],ci="asc ci"===(ref2=arguments[1])||"desc ci"===ref2):(order="asc",key=arguments[1]),array.slice(0).sort(function(_this){return function(a,b){var r;return key&&(a=MAP_VARIABLE.call(_this,a,key)),key&&(b=MAP_VARIABLE.call(_this,b,key)),ci?(a=String(a).toLowerCase(),b=String(b).toLowerCase(),r=a.localeCompare(b),"asc"===order?r:1===r?-1:-1===r?1:r):null==a||null!=a&&a>b?"asc"===order?1:-1:null==b||null!=b&&a<b?"asc"===order?-1:1:0}}(this))},outputs:function(array){return array}},reverse:{type:"array",group:"array",value:function(array){if(null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));return array.slice(0).reverse()},outputs:function(array){return array}},flatten:{type:"array",group:"array",value:function(array){var depth,flatten,ref;if(null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));if(depth=arguments[1],"null"!==(ref=TYPE_CHECK(depth))&&"number"!==ref)throw new Error(VALUE_ERROR(depth,"'{{value}}' is not a valid number.","Invalid number."));return(flatten=function(array,depth){return null==depth&&(depth=1),array.reduce(function(acc,val){return"array"===TYPE_CHECK(val)&&depth>1?acc.concat(flatten(val,depth-1)):acc.concat(val)},[])})(array,depth)},outputs:function(array){return array}},distinct:{type:"array",group:"array",value:function(array){var key,values;if(null==array)return this.passthrough?array:null;if("array"!==TYPE_CHECK(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));return key=arguments[1],values=[],array.filter(function(_this){return function(value){var found,l,len,ref,val;if(key&&(value=MAP_VARIABLE.call(_this,value,key)),null==value&&-1!==values.indexOf(null))return!1;if("string"==(ref=typeof value)||"number"===ref||"boolean"===ref){if(value=String(value),-1!==values.indexOf(value))return!1}else if("date"===TYPE_CHECK(value)){if(value=value.getTime(),-1!==values.indexOf(value))return!1}else if(null!=value&&"object"==typeof value){for(found=!1,l=0,len=values.length;l<len;l++)if(null!=(val=values[l])&&"object"==typeof val&&DEEP_EQUAL(value,val)){found=!0;break}if(found)return!1}else if(null!=value)return!1;return values.push(null!=value?value:null),!0}}(this))},outputs:function(array){return array}},toCollection:{type:"array",group:"array",value:function(array,key,value){var ref,ref1,results;if(null==array||!key||!value)return{};if(!Array.isArray(array))throw new Error(VALUE_ERROR(array,"'{{value}}' is not a valid array.","Invalid array."));if("string"!==(ref=TYPE_CHECK(key))&&"number"!==ref)throw new Error(VALUE_ERROR(key,"'{{value}}' is not a valid key name.","Invalid key name."));if("string"!==(ref1=TYPE_CHECK(value))&&"number"!==ref1)throw new Error(VALUE_ERROR(value,"'{{value}}' is not a valid value name.","Invalid value name."));return 0===array.length?{}:(results={},array.forEach(function(_this){return function(o){var k,v;if(k=MAP_VARIABLE.call(_this,o,key),v=MAP_VARIABLE.call(_this,o,value),k)return results[k]=v}}(this)),results)},outputs:function(array){return{type:"collection"}}},deduplicate:{type:"array",group:"array",value:function(array,key){var deduplicatedArray,ref,visitedValues;if(!array)return[];if(!Array.isArray(array))throw new Error(VALUE_ERROR(array,"Passed array is not a valid array.","Invalid array."));if(0===array.length)return[];if("string"===(ref=TYPE_CHECK(array[0]))||"number"===ref||"boolean"===ref)return deduplicatedArray=[],array.forEach(function(_this){return function(member){var ref1;if("string"!==(ref1=TYPE_CHECK(member))&&"number"!==ref1&&"boolean"!==ref1)throw new Error(VALUE_ERROR(TYPE_CHECK(member),"Member of type '{{value}}' can't be mixed with primitive types.","Array types mixed."));if(indexOf.call(deduplicatedArray,member)<0)return deduplicatedArray.push(member)}}()),deduplicatedArray;if("object"===TYPE_CHECK(array[0])){if(null==key)throw new Error(VALUE_ERROR(key,"No key was provided to deduplicate array of objects.","No key provided."));if(!1===TYPE_CHECK(key))throw new Error(VALUE_ERROR(TYPE_CHECK(key),"Key is not a string. Found '{{value}}' instead.","Key not string."));return deduplicatedArray=[],visitedValues=[],array.forEach(function(_this){return function(member){var ref1;if(!1===TYPE_CHECK(member))throw new Error(VALUE_ERROR(TYPE_CHECK(member),"Member of type '{{value}}' can't be mixed with objects.","Array types mixed."));if(!member.hasOwnProperty(key))throw new Error(VALUE_ERROR(key,"Found an object without the required key '{{value}}'.","Object without key."));if(ref1=member[key],indexOf.call(visitedValues,ref1)<0)return visitedValues.push(member[key]),deduplicatedArray.push(member)}}()),deduplicatedArray}if("date"===TYPE_CHECK(array[0]))return deduplicatedArray=[],visitedValues=[],array.forEach(function(_this){return function(member){var ref1;if(!1===TYPE_CHECK(member))throw new Error(VALUE_ERROR(TYPE_CHECK(member),"Member of type '{{value}}' can't be mixed with dates.","Array types mixed."));if(ref1=member.getTime(),indexOf.call(visitedValues,ref1)<0)return visitedValues.push(member.getTime()),deduplicatedArray.push(member)}}()),deduplicatedArray;throw new Error(VALUE_ERROR(TYPE_CHECK(array[0]),"Members of type '{{value}}' can't be deduplicated.","Invalid array members."))},outputs:function(array){return array}},md5:{type:"text",group:"string",value:function(data){return"buffer"!==TYPE_CHECK(data)&&(data=IML_FUNCTIONS.toString.value(data)),crypto.createHash("md5").update(data).digest("hex")}},sha1:{type:"text",group:"string",value:function(data){var key,keyEncoding,outputEncoding,ref,ref1;if(outputEncoding=null!=(ref=arguments[1])?ref.toLowerCase():void 0,key=arguments[2],keyEncoding=null!=(ref1=arguments[3])?ref1.toLowerCase():void 0,"hex"!==outputEncoding&&"latin1"!==outputEncoding&&"base64"!==outputEncoding&&"binary"!==outputEncoding&&(outputEncoding="hex"),"text"!==keyEncoding&&"hex"!==keyEncoding&&"base64"!==keyEncoding&&"binary"!==keyEncoding&&(keyEncoding="text"),"buffer"!==TYPE_CHECK(data)&&(data=IML_FUNCTIONS.toString.value(data)),null!=key)if("text"===keyEncoding)key=IML_FUNCTIONS.toString.value(key);else if("binary"===keyEncoding){if("buffer"!==TYPE_CHECK(key))throw new Error(VALUE_ERROR(encoding,"Key '{{value}}' is not a valid buffer.","Invalid key."))}else key=Buffer.from(IML_FUNCTIONS.toString.value(key),keyEncoding);return null==key?crypto.createHash("sha1").update(data).digest(outputEncoding):crypto.createHmac("sha1",key).update(data).digest(outputEncoding)}},sha256:{type:"text",group:"string",value:function(data){var key,keyEncoding,outputEncoding,ref,ref1;if(outputEncoding=null!=(ref=arguments[1])?ref.toLowerCase():void 0,key=arguments[2],keyEncoding=null!=(ref1=arguments[3])?ref1.toLowerCase():void 0,"hex"!==outputEncoding&&"latin1"!==outputEncoding&&"base64"!==outputEncoding&&"binary"!==outputEncoding&&(outputEncoding="hex"),"text"!==keyEncoding&&"hex"!==keyEncoding&&"base64"!==keyEncoding&&"binary"!==keyEncoding&&(keyEncoding="text"),"buffer"!==TYPE_CHECK(data)&&(data=IML_FUNCTIONS.toString.value(data)),null!=key)if("text"===keyEncoding)key=IML_FUNCTIONS.toString.value(key);else if("binary"===keyEncoding){if("buffer"!==TYPE_CHECK(key))throw new Error(VALUE_ERROR(encoding,"Key '{{value}}' is not a valid buffer.","Invalid key."))}else key=Buffer.from(IML_FUNCTIONS.toString.value(key),keyEncoding);return null==key?crypto.createHash("sha256").update(data).digest(outputEncoding):crypto.createHmac("sha256",key).update(data).digest(outputEncoding)}},sha512:{type:"text",group:"string",value:function(data){var key,keyEncoding,outputEncoding,ref,ref1;if(outputEncoding=null!=(ref=arguments[1])?ref.toLowerCase():void 0,key=arguments[2],keyEncoding=null!=(ref1=arguments[3])?ref1.toLowerCase():void 0,"hex"!==outputEncoding&&"latin1"!==outputEncoding&&"base64"!==outputEncoding&&"binary"!==outputEncoding&&(outputEncoding="hex"),"text"!==keyEncoding&&"hex"!==keyEncoding&&"base64"!==keyEncoding&&"binary"!==keyEncoding&&(keyEncoding="text"),"buffer"!==TYPE_CHECK(data)&&(data=IML_FUNCTIONS.toString.value(data)),null!=key)if("text"===keyEncoding)key=IML_FUNCTIONS.toString.value(key);else if("binary"===keyEncoding){if("buffer"!==TYPE_CHECK(key))throw new Error(VALUE_ERROR(encoding,"Key '{{value}}' is not a valid buffer.","Invalid key."))}else key=Buffer.from(IML_FUNCTIONS.toString.value(key),keyEncoding);return null==key?crypto.createHash("sha512").update(data).digest(outputEncoding):crypto.createHmac("sha512",key).update(data).digest(outputEncoding)}},base64:{type:"text",group:"string",value:function(data){var ref;return"buffer"===TYPE_CHECK(data)?data.toString("base64"):(data=IML_FUNCTIONS.toString.value(data),null!=(ref="function"==typeof btoa?btoa(data):void 0)?ref:Buffer.from(data).toString("base64"))}}},IML_VARIABLES={timestamp:{type:"uinteger",group:"date",value:function(){return Math.floor(Date.now()/1e3)}},pi:{type:"number",group:"math",value:Math.PI},now:{type:"date",group:"date",value:function(){return new Date}},uuid:{type:"text",group:"string",value:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r,v;return r=16*Math.random()|0,v="x"===c?r:3&r|8,v.toString(16)})}},random:{type:"number",group:"math",value:function(){return Math.random()}}},IML_OPERATORS={"!":{type:"boolean",group:"general",label:"not",precedence:16,hidden:!0},"+":{type:"number",group:"math",precedence:13,value:function(a,b){var ref;return null==a&&null==b?null:null!=a&&null!=b||"number"!=(ref=typeof(null!=a?a:b))&&"string"!==ref&&"boolean"!==ref?"number"==typeof a&&"number"==typeof b?new Decimal(a).plus(new Decimal(b)).toNumber():a+b:null!=a?a:b}},"-":{type:"number",group:"math",precedence:13,value:function(a,b){return new Decimal(Number(a)).minus(new Decimal(Number(b))).toNumber()}},"*":{type:"number",group:"math",precedence:14,value:function(a,b){return new Decimal(Number(a)).times(new Decimal(Number(b))).toNumber()}},"/":{type:"number",group:"math",precedence:14,value:function(a,b){return new Decimal(Number(a)).dividedBy(new Decimal(Number(b))).toNumber()}},"%":{type:"number",group:"math",label:"mod",precedence:14,value:function(a,b){return new Decimal(Number(a)).modulo(new Decimal(Number(b))).toNumber()}},"<":{type:"boolean",group:"math",precedence:11,value:function(a,b){return a<b}},"<=":{type:"boolean",group:"math",precedence:11,value:function(a,b){return a<=b}},">":{type:"boolean",group:"math",precedence:11,value:function(a,b){return a>b}},">=":{type:"boolean",group:"math",precedence:11,value:function(a,b){return a>=b}},"=":{type:"boolean",group:"general",precedence:10,value:function(a,b){return a==b}},"!=":{type:"boolean",group:"general",precedence:10,value:function(a,b){return a!=b}},"&":{type:"boolean",group:"general",label:"and",precedence:6,value:function(a,b){return a&&b}},"|":{type:"boolean",group:"general",label:"or",precedence:5,value:function(a,b){return a||b}}},IML_FILTERS={exist:{symbol:"?"},notexist:{symbol:"!?"},"text:equal":{symbol:"="},"text:equal:ci":{symbol:"="},"text:notequal":{symbol:"!="},"text:notequal:ci":{symbol:"!="},"text:contain":{symbol:"~"},"text:contain:ci":{symbol:"~"},"text:notcontain":{symbol:"!~"},"text:notcontain:ci":{symbol:"!~"},"text:startwith":{symbol:"^."},"text:startwith:ci":{symbol:"^."},"text:notstartwith":{symbol:"!^."},"text:notstartwith:ci":{symbol:"!^."},"text:endwith":{symbol:".$"},"text:endwith:ci":{symbol:".$"},"text:notendwith":{symbol:"!.$"},"text:notendwith:ci":{symbol:"!.$"},"text:pattern":{symbol:"(.*)"},"text:pattern:ci":{symbol:"(.*)"},"text:notpattern":{symbol:"!(.*)"},"text:notpattern:ci":{symbol:"!(.*)"},"number:equal":{symbol:"="},"number:notequal":{symbol:"!="},"number:greater":{symbol:">"},"number:less":{symbol:"<"},"number:greaterorequal":{symbol:">="},"number:lessorequal":{symbol:"<="},"date:equal":{symbol:"="},"date:notequal":{symbol:"!="},"date:greater":{symbol:">"},"date:less":{symbol:"<"},"date:greaterorequal":{symbol:">="},"date:lessorequal":{symbol:"<="},"time:equal":{symbol:"="},"time:notequal":{symbol:"!="},"time:greater":{symbol:">"},"time:less":{symbol:"<"},"time:greaterorequal":{symbol:">="},"time:lessorequal":{symbol:"<="},"array:contain":{symbol:"@>"},"array:contain:ci":{symbol:"@>"},"array:notcontain":{symbol:"!@>"},"array:notcontain:ci":{symbol:"!@>"},"array:equal":{symbol:"=="},"array:notequal":{symbol:"!="},"array:greater":{symbol:">"},"array:less":{symbol:"<"},"array:greaterorequal":{symbol:">="},"array:lessorequal":{symbol:"<="},"boolean:equal":{symbol:"="},"boolean:notequal":{symbol:"!="}},CONCAT=function(item){return null==item?"":"object"==typeof item?item instanceof String||item instanceof Boolean||item instanceof Number?String(item.valueOf()):Array.isArray(item)?item.map(function(i){return CONCAT(i)}).join(", "):item instanceof Date?isNaN(item)?null:item.toISOString():"[Collection]":String(item)},COMPARE=function(a,b,operator){var category,cont,ref,type;switch(category=operator.split(":"),category[0]){case"exist":return null!=a&&""!==a;case"notexist":return!(null!=a&&""!==a);case"text":switch(a=String(null!=a?a:""),b=String(null!=b?b:""),"ci"===category[2]&&(a=a.toLowerCase(),b=b.toLowerCase()),category[1]){case"equal":return a===b;case"notequal":return a!==b;case"contain":return-1!==a.indexOf(b);case"notcontain":return-1===a.indexOf(b);case"startwith":return 0===a.indexOf(b);case"notstartwith":return 0!==a.indexOf(b);case"endwith":return-1!==a.lastIndexOf(b)&&a.lastIndexOf(b)===a.length-b.length;case"notendwith":return-1===a.lastIndexOf(b)||a.lastIndexOf(b)!==a.length-b.length;case"pattern":try{return new RegExp(b).test(a)}catch(error){return error,!1}break;case"notpattern":try{return!new RegExp(b).test(a)}catch(error){return error,!0}break;default:return!1}break;case"number":case"time":if("time"===category[0]&&(a=IMTDate.parseTime(a,this.timezone),b=IMTDate.parseTime(b,this.timezone)),null!=a&&""!==a||(a=NaN),null!=b&&""!==b||(b=NaN),a=Number(a),b=Number(b),isNaN(a||isNaN(b)))return"notequal"===category[1];switch(category[1]){case"equal":return a===b;case"notequal":return a!==b;case"greater":return a>b;case"less":return a<b;case"greaterorequal":return a>=b;case"lessorequal":return a<=b;default:return!1}break;case"date":if(a=IMTDate.parse(a,this.timezone),b=IMTDate.parse(b,this.timezone),null==a&&null==b)return"notequal"===category[1];if(!(a instanceof Date&&b instanceof Date))return"notequal"===category[1];if(isNaN(a.getTime()||isNaN(b.getTime())))return"notequal"===category[1];switch(category[1]){case"equal":return a.getTime()===b.getTime();case"notequal":return a.getTime()!==b.getTime();case"greater":return a.getTime()>b.getTime();case"less":return a.getTime()<b.getTime();case"greaterorequal":return a.getTime()>=b.getTime();case"lessorequal":return a.getTime()<=b.getTime();default:return!1}break;case"array":return"contain"===(ref=category[1])||"notcontain"===ref?null!=a&&null!=b&&("array"===TYPE_CHECK(a)&&(type=TYPE_CHECK(b),"string"===type&&"ci"===category[2]&&(b=b.toLowerCase()),cont=a.some(function(item){switch(type){case"string":case"number":switch(TYPE_CHECK(item)){case"string":case"number":return"ci"===category[2]&&(item=item.toLowerCase()),String(item)===String(b);default:return!1}break;case"date":return"date"===TYPE_CHECK(b)&&+item==+b;default:return item===b}}),"notcontain"===category[1]?!cont:cont)):(Array.isArray(a)&&(a=a.length),Array.isArray(b)&&(b=b.length),COMPARE.call(this,a,b,"number:"+category[1]));case"boolean":switch("string"===TYPE_CHECK(a)?(a=String(a),a=!(""===a||"false"===a)):"boolean"!=typeof a&&(a=null!=a),"string"===TYPE_CHECK(b)?(b=String(b),b=!(""===b||"false"===b)):"boolean"!=typeof b&&(b=null!=b),category[1]){case"equal":return a===b;case"notequal":return a!==b;default:return!1}break;case"object":if(null==a&&null==b)return!0;if(null==a||null==b)return!1;if("object"!=typeof a)return!1;if(typeof a!=typeof b)return!1;break;default:return!1}},ESCAPE_HTML=function(value){var map;return map={"&":"&amp;","<":"&lt;",">":"&gt;"},value=String(value).replace(/[&<>]/g,function(tag){return map[tag]||tag})},IS_NUMBER=function(value){return/^\-?\d+(\.\d+)?$/.test(value)},IML_ARRAY=function(source,defaults){var a,key,value;a=[],defaults=Object.assign({},IML.defaults,defaults),Object.defineProperty(a,"__imlAst__",{enumerable:!1,value:!0}),Object.defineProperty(a,"toJSON",{enumerable:!1,value:function(){return null!=source?source:"{{}}"}}),Object.defineProperty(a,"push",{enumerable:!1,value:function(node){var length;if(length=this.length,"operator"===node.type&&"!"!==node.name){if(0===length)return IML.errors.push(new IMLError("Operator on begining of an expression.")),node;if("operator"===this[length-1].type)return IML.errors.push(new IMLError("Operator next to operator.")),node}return Array.prototype.push.call(a,node)}}),Object.defineProperty(a,"clone",{enumerable:!1,value:function(deep){var cloned,item,l,len,ref;if(deep)throw new Error("Not implemented.");for(cloned=IML_ARRAY(source,defaults),ref=this,l=0,len=ref.length;l<len;l++)item=ref[l],cloned.push(item);return cloned}}),Object.defineProperty(a,"derive",{enumerable:!1,value:function(){return IML_ARRAY(source,defaults)}});for(key in defaults)value=defaults[key],"function"==typeof value?Object.defineProperty(a,key,{enumerable:!1,get:value}):Object.defineProperty(a,key,{enumerable:!1,value:value});return a},IML=function(){function IML(){}return IML.errors=[],IML.defaults=null,IML.KEYWORDS=IML_KEYWORDS,IML.FUNCTIONS=IML_FUNCTIONS,IML.OPERATORS=IML_OPERATORS,IML.VARIABLES=IML_VARIABLES,IML.FILTERS=IML_FILTERS,IML.Array=IML_ARRAY,IML._escape=ESCAPE,IML._unescape=UNESCAPE,IML._mapVariable=MAP_VARIABLE,IML._splitVariable=SPLIT_VARIABLE,IML.isAST=function(object){return(null!=object?object.__imlAst__:void 0)&&Array.isArray(object)},IML.validateName=function(name){return name?("number"==typeof name&&(name=name.toString()),"string"!=typeof name?"":(name=name.replace(/[^_a-z0-9]/gi,"_"),/^\d/.test(name)&&(name="_"+name),name)):null!=name?name:""},IML.parse=function(text,links,defaults){var buffer,char,cursor,escaped,fce,incode,incodetimes,inescape,instring,instringchar,length,nodes,oldparent,parent,parents,ref,ref1;if(IML.errors=[],null==text)return IML_ARRAY(null,defaults);if("object"==typeof text||"function"==typeof text){if(!(text instanceof Date))return IML.errors.push(new IMLError("Expected string, got "+typeof text+".")),IML_ARRAY(null,defaults);text=text.toISOString()}if("string"!=typeof text&&(text=String(text)),0===text.length)return nodes=IML_ARRAY("",defaults),nodes.push({type:"text",value:""}),nodes;if(-1===text.indexOf("{{"))return nodes=IML_ARRAY(text,defaults),nodes.push({type:"text",value:text}),nodes;for(length=text.length,cursor=-1,nodes=IML_ARRAY(text,defaults),buffer="",incode=!1,incodetimes=0,instring=!1,inescape=!1,escaped="",instringchar=null,parent=null,parents=[];++cursor<length;){if(char=text.charAt(cursor),oldparent=null,inescape){if("`"!==char){escaped+=char,buffer+=char;continue}if("`"===char&&"`"===text.charAt(cursor+1)){cursor++,escaped+="``",buffer+="``";continue}}switch(char){case"{":if(instring||incode||"{"!==text.charAt(cursor+1))buffer+=char;else{for(incode=!0,incodetimes++;"{"===text.charAt(++cursor+1);)buffer+="{";buffer.length&&nodes.push({type:"text",value:buffer}),buffer=""}break;case"}":!instring&&incode&&"}"===text.charAt(cursor+1)?(cursor++,incode=!1,parent&&IML.errors.push(new IMLError("Unclosed function at position "+(cursor-1)+".")),buffer=buffer.trim(),buffer.length&&(null!=parent?parent:nodes).push(PARSE_UNKNOWN(buffer,links)),buffer=""):buffer+=char;break;case"(":!instring&&incode?(buffer=buffer.trim(),parent&&(oldparent=parent,parents.push(parent)),parent=IML_ARRAY(null,defaults),parent.type="argument",fce={type:"function",name:buffer,arguments:[parent]},parents.push(fce),"argument"===(null!=oldparent?oldparent.type:void 0)?oldparent.push(fce):nodes.push(fce),buffer=""):buffer+=char;break;case")":!instring&&incode?parent?(buffer=buffer.trim(),buffer.length?parent.push(PARSE_UNKNOWN(buffer,links)):"operator"===(null!=(ref=parent[parent.length-1])?ref.type:void 0)&&(parent.pop(),IML.errors.push(new IMLError("Operator on end of an expression."))),buffer="",parent=null,parents.length&&(parents.pop(),parent=parents.pop())):IML.errors.push(new IMLError("Unexpected function close at position "+(cursor-1)+".")):buffer+=char;break;case"+":case"-":case"*":case"/":case"=":case"!":case"&":case"|":case">":case"<":case"%":if("-"===char){if(IS_NUMBER(text.charAt(cursor+1))&&/^\s*$/.test(buffer)){buffer+=char;continue}}else"!"===char?"="===text.charAt(cursor+1)&&(char+=text.charAt(++cursor),"="===text.charAt(cursor+1)&&(char+=text.charAt(++cursor))):"<"===char&&"="===text.charAt(cursor+1)?char+=text.charAt(++cursor):">"===char&&"="===text.charAt(cursor+1)?char+=text.charAt(++cursor):"&"===char&&"&"===text.charAt(cursor+1)?char+=text.charAt(++cursor):"|"===char&&"|"===text.charAt(cursor+1)?char+=text.charAt(++cursor):"="===char&&"="===text.charAt(cursor+1)&&("="===text.charAt(cursor+2)&&(char+=text.charAt(++cursor)),char+=text.charAt(++cursor));!instring&&incode?(buffer=buffer.trim(),buffer.length&&(null!=parent?parent:nodes).push(PARSE_UNKNOWN(buffer,links)),(null!=parent?parent:nodes).push({type:"operator",name:ALT_OPS[char]||char}),buffer=""):buffer+=char;break;case";":case",":!instring&&incode?"argument"===(null!=parent?parent.type:void 0)?(buffer=buffer.trim(),buffer.length&&parent.push(PARSE_UNKNOWN(buffer,links,nodes)),buffer="",parent=[],parent.type="argument",parents[parents.length-1].arguments.push(parent)):IML.errors.push(new IMLError("Unexpected argument separator at position "+(cursor-1)+".")):buffer+=char;break;case'"':case"'":if(incode){if(instring&&char!==instringchar){buffer+=char;continue}instring?char===text.charAt(cursor+1)?(buffer+=char,cursor++):(instring=!1,instringchar=null,(null!=parent?parent:nodes).push({type:"string",value:buffer}),buffer=""):(instring=!0,instringchar=char,buffer=buffer.trim(),buffer.length&&(null!=parent?parent:nodes).push(PARSE_UNKNOWN(buffer,links)),buffer="")}else buffer+=char;break;case" ":!instring&&incode?(buffer=buffer.trim(),buffer.length&&(null!=parent?parent:nodes).push(PARSE_UNKNOWN(buffer,links)),buffer=""):buffer+=char;break;case"`":if(!instring&&incode){if(inescape&&!ESCAPEABLE(escaped)){buffer=buffer.substr(0,buffer.length-(escaped.length+1))+escaped,inescape=!1,escaped="";continue}inescape=!inescape,escaped=""}buffer+=char;break;default:buffer+=char}}return incode&&IML.errors.push(new IMLError("Unclosed code at position "+(cursor-1)+".")),instring&&IML.errors.push(new IMLError("Unclosed string at position "+(cursor-1)+".")),buffer.length?nodes.push({type:"text",value:buffer}):"operator"===(null!=(ref1=nodes[nodes.length-1])?ref1.type:void 0)&&(nodes.pop(),IML.errors.push(new IMLError("Operator on end of an expression."))),1===incodetimes&&(nodes.length&&"text"===nodes[0].type&&/^\s*$/.test(nodes[0].value)&&nodes.shift(),nodes.length&&"text"===nodes[nodes.length-1].type&&/^\s*$/.test(nodes[nodes.length-1].value)&&nodes.pop()),nodes},IML.stringify=function(value,links){var incode,iterate,stringified;return IML.errors=[],incode=!1,iterate=function(nodes,level){var code,index,l,last,len,node,ref;for(null==level&&(level=1),code="",index=l=0,len=nodes.length;l<len;index=++l){switch(node=nodes[index],node.type){case"variable":incode?1===level&&"operator"!==last.type&&(code+="}}{{"):(incode=!0,code+="{{"),code+=node.name;break;case"link":incode?1===level&&"operator"!==last.type&&(code+="}}{{"):(incode=!0,code+="{{"),code+=null!=links?node.name.replace(/\$([^.]+)/g,function(a,b){return links[b]?links[b]:b}):node.name;break;case"function":incode?1===level&&"operator"!==last.type&&(code+="}}{{"):(incode=!0,code+="{{"),code+=node.name+"(",code+=node.arguments.map(function(item){return iterate(item,level+1)}).join("; "),code+=")";break;case"operator":incode?(1===level&&"operator"!==last.type&&"!"===node.name?code+="}}{{":"!"===node.name&&code.length&&" "!==(ref=code.charAt(code.length-1))&&"!"!==ref&&(code+=" "),"!"===node.name?code+="!":code+=" "+node.name+" "):(incode=!0,code+="{{","!"===node.name&&(code+="!"));break;case"text":incode&&(incode=!1,code+="}}"),code+=node.value;break;case"string":case"number":case"keyword":incode?1===level&&"operator"!==last.type&&(code+="}}{{"):(incode=!0,code+="{{"),"string"===node.type?code+='"'+node.value.replace(/\"/g,'""')+'"':"number"===node.type?code+=node.value.toString():code+=node.name}last=node}return code},stringified=iterate(value),incode&&(stringified+="}}"),stringified},IML.execute=function(ast,data,options){var context,evaluate,iterate,operate;if(null==options&&(options={}),null==ast){if(options.passthrough)return;return null}if(!IML.isAST(ast))throw new IMLError("Invalid AST!");if(context={timezone:ast.timezone,passthrough:options.passthrough||!1},!ast.length){if(options.passthrough)return;return null}return evaluate=function(node){var arg,args,err,ex,func,res;switch(node.type){case"link":throw new IMLError("Found link '"+node.name+"' is AST!");case"variable":return IML_VARIABLES[node.name]?IML_VARIABLES[node.name].value instanceof Function?IML_VARIABLES[node.name].value():IML_VARIABLES[node.name].value:MAP_VARIABLE.call(context,data,node.name);case"function":if(!(func=options.functions&&Object.prototype.hasOwnProperty.call(options.functions,node.name)?options.functions[node.name]:ast.functions&&Object.prototype.hasOwnProperty.call(ast.functions,node.name)?ast.functions[node.name]:Object.prototype.hasOwnProperty.call(IML_FUNCTIONS,node.name)?IML_FUNCTIONS[node.name].value:void 0))throw new IMLError("Function '"+node.name+"' not found!");if(func===Function||func===eval)throw new IMLError("Function '"+node.name+"' is not executable!");try{return"if"===node.name?(args=node.arguments.slice(0),args.length&&(args[0]=iterate(args[0])),iterate(func.apply(context,args))):"ifempty"===node.name?(args=node.arguments.slice(0),args.length&&(args[0]=iterate(args[0])),res=func.apply(context,args),res===args[0]?res:iterate(res)):(args=function(){var l,len,ref,ref1,results1;for(ref1=null!=(ref=node.arguments)?ref:[],results1=[],l=0,len=ref1.length;l<len;l++)arg=ref1[l],results1.push(iterate(arg));return results1}(),func.apply(context,args))}catch(error){throw ex=error,err=new IMLError("Function '"+node.name+"' finished with error! "+ex.message),err.imtInternalError=ex,err}break;case"text":case"string":case"number":return node.value;case"keyword":return"function"==typeof IML_KEYWORDS[node.name].value?IML_KEYWORDS[node.name].value():IML_KEYWORDS[node.name].value}if(!options.passthrough)return null},operate=function(operation,lhs,higherPrecedenceOnly){var op,rhs;for(null==higherPrecedenceOnly&&(higherPrecedenceOnly=!1);operation.length;){for(op=operation.shift(),rhs=operation.shift();operation.length&&operation[0].precedence>op.precedence;)rhs=operate(operation,rhs,!0);if(higherPrecedenceOnly)return op.value(lhs,rhs);lhs=op.value(lhs,rhs)}return lhs},(iterate=function(nodes){var doubleNegate,evaluated,index,negate,node,operation,res;if(!Array.isArray(nodes)){if(options.passthrough)return;return null}for(index=0,res=[];index<nodes.length;)if(node=nodes[index++],"operator"===node.type&&"!"!==node.name){if(res.length){for(operation=[res.pop()];"operator"===(null!=node?node.type:void 0);){if(!IML_OPERATORS[node.name])throw new IMLError("Operator '"+node.name+"' not found!");for(operation.push(IML_OPERATORS[node.name]),node=nodes[index++],negate=!1,doubleNegate=!1;"operator"===(null!=node?node.type:void 0)&&"!"===node.name;)negate&&(doubleNegate=!doubleNegate),negate=!0,node=nodes[index++];evaluated=evaluate(node),negate&&(evaluated=!evaluated),doubleNegate&&(evaluated=!evaluated),operation.push(evaluated),node=nodes[index++]}res.push(operate(operation,operation.shift())),index--}}else{for(negate=!1,doubleNegate=!1;"operator"===(null!=node?node.type:void 0)&&"!"===node.name;)negate&&(doubleNegate=!doubleNegate),negate=!0,node=nodes[index++];if(!node)continue;if("operator"===node.type)throw new Error("Operator next to not operator.");evaluated=evaluate(node),negate&&(evaluated=!evaluated),doubleNegate&&(evaluated=!evaluated),res.push(evaluated)}if(0===res.length){if(options.passthrough)return;return null}return 1===res.length?res[0]:res.map(options.concat||CONCAT).join("")})(ast)},IML.filter=function(orFilters,bundle,concat){
var a,andFilters,andReport,b,ex,filter,i,ii,l,len,len1,orReport,q,ref,ref1,ref2,result,truthy;if(orReport=[],!orFilters)return{match:!0,report:orReport};if(!Array.isArray(orFilters))return{match:!0,report:orReport};if(!orFilters.length)return{match:!0,report:orReport};for(i=l=0,len=orFilters.length;l<len;i=++l){for(andFilters=orFilters[i],truthy=!0,andReport=[],orReport.push(andReport),ref=null!=andFilters?andFilters:[],ii=q=0,len1=ref.length;q<len1;ii=++q){filter=ref[ii];try{a=IML.execute(filter.a,bundle,concat),b=IML.execute(filter.b,bundle,concat),result=COMPARE.call({timezone:(null!=(ref1=filter.a)?ref1.timezone:void 0)||(null!=(ref2=filter.b)?ref2.timezone:void 0)},a,b,filter.o)}catch(error){throw ex=error,new IMLError("Failed to evaluate filter '"+i+"-"+ii+"': "+ex.message)}if(andReport.push(result),!result){truthy=!1;break}}if(truthy)return{match:!0,report:orReport}}return{match:!1,report:orReport}},IML.references=function(ast,create,modules){var iterate;if(null==create&&(create=!1),null==modules&&(modules={}),IML.errors=[],!IML.isAST(ast)){if("string"!=typeof ast)return IML.errors.push(new IMLError("Invalid IML.")),modules;ast=IML.parse(ast)}return(iterate=function(nodes){var arg,cur,id,l,len,len1,node,q,ref,ref1,v,variable;for(0,l=0,len=nodes.length;l<len;l++)switch(node=nodes[l],node.type){case"variable":if(!IML_VARIABLES[node.name]){if(/^([0-9]+)\.(.*)$/.exec(node.name)){if(id=RegExp.$1,variable=RegExp.$2,!modules[id]){if(!create){IML.errors.push(new IMLError("Variable '"+node.name+"' references not existing module '"+id+"'."));continue}modules[id]={}}cur=modules[id]}else variable=node.name,cur=modules;for(variable=SPLIT_VARIABLE(variable);variable.length;)v=variable.shift(),/^(.*)\[\d*\]$/.exec(v)&&(v=RegExp.$1,variable=[]),variable.length?cur=!0===cur[v]?cur[v]={}:null!=cur[v]?cur[v]:cur[v]={}:cur[v]=!0}break;case"function":for(ref1=null!=(ref=node.arguments)?ref:[],q=0,len1=ref1.length;q<len1;q++)arg=ref1[q],iterate(arg)}return modules})(ast)},IML.outputs=function(ast){var evaluate,iterate,operate;if(!IML.isAST(ast))throw new IMLError("Invalid AST!");return ast.length?(evaluate=function(node){var arg,args,ref,ref1;switch(node.type){case"variable":return{type:"variable",name:node.name};case"function":if(!IML_FUNCTIONS[node.name])throw new IMLError("Function '"+node.name+"' not found!");return args=function(){var l,len,ref,ref1,results1;for(ref1=null!=(ref=node.arguments)?ref:[],results1=[],l=0,len=ref1.length;l<len;l++)arg=ref1[l],results1.push(iterate(arg));return results1}(),null!=(ref=null!=(ref1=IML_FUNCTIONS[node.name].outputs)?ref1.apply(null,args):void 0)?ref:{type:IML_FUNCTIONS[node.name].type};case"text":case"string":return{type:"text"};case"number":return{type:"number"};case"keyword":return{type:IML_KEYWORDS[node.name].type}}return null},operate=function(operation,lhs){var op,rhs;return op=operation.shift(),rhs=operation.shift(),operation.length&&operation[0].precedence>op.precedence&&(rhs=operate(operation,rhs)),operation.length?op!==IML_OPERATORS["+"]||"text"!==lhs.type&&"text"!==rhs.type?operate(operation,op.type):operate(operation,{type:"text"}):op!==IML_OPERATORS["+"]||"text"!==lhs.type&&"text"!==rhs.type?{type:op.type}:{type:"text"}},(iterate=function(nodes){var index,node,operation,res;for(index=0,res=[];index<nodes.length;)switch(node=nodes[index++],node.type){case"operator":if(res.length){for(operation=[res.pop()];"operator"===(null!=node?node.type:void 0);){if(!IML_OPERATORS[node.name])throw new IMLError("Operator '"+node.name+"' not found!");operation.push(IML_OPERATORS[node.name]),operation.push(evaluate(nodes[index++])),node=nodes[index++]}res.push(operate(operation,operation.shift())),index--}break;default:res.push(evaluate(node))}return 0===res.length?{type:"null"}:1===res.length?res[0]:{type:"text"}})(ast)):{type:"null"}},IML.wrap=function(ast,func){var args,index,wrapper;if(!IML.isAST(ast))throw new IMLError("Invalid AST!");if(this.isWrapped(ast,func))return ast;for(ast=ast.clone(),args=[ast],args.type="argument",wrapper=ast.derive(),wrapper.push({type:"function",name:func,arguments:args}),index=0;index<ast.length;)"text"===ast[index].type&&(ast[index]={type:"string",value:ast[index].value},0===index&&ast.length>1?(ast.splice(index+1,0,{type:"operator",name:"+"}),index++):index>0&&ast.splice(index,0,{type:"operator",name:"+"})),index++;return wrapper},IML.unwrap=function(ast,func){var index;if(!IML.isAST(ast))throw new IMLError("Invalid AST!");if(!this.isWrapped(ast,func))return ast;for(ast=ast[0].arguments[0].clone(),index=0;index<ast.length;)"string"===ast[index].type&&(ast[index]={type:"text",value:ast[index].value},index>0&&"operator"===ast[index-1].type&&(ast.splice(index-1,1),index--),index+1<ast.length&&"operator"===ast[index+1].type&&ast.splice(index+1,1)),index++;return ast},IML.isWrapped=function(ast,func){if(!IML.isAST(ast))throw new IMLError("Invalid AST!");return 1===ast.length&&"function"===ast[0].type&&ast[0].name===func},IML.containsIML=function(text){return text.indexOf("{{")>-1&&text.indexOf("}}")>-1},IML.replace=function(ast,type,find,replace){var iterate;if(!IML.isAST(ast))throw new IMLError("Invalid AST!");return iterate=function(nodes){var arg,l,len,len1,node,q,ref,ref1;for(l=0,len=nodes.length;l<len;l++)switch(node=nodes[l],node.type){case"keyword":"keyword"===type&&find===node.name&&(node.name=replace);break;case"function":for(ref1=null!=(ref=node.arguments)?ref:[],q=0,len1=ref1.length;q<len1;q++)arg=ref1[q],iterate(arg);break;case"variable":"variable"===type&&find===node.name&&(node.name=replace)}return null},iterate(ast),ast},IML}(),SIML=function(){function SIML(){}return SIML.execute=function(text,data,escape){return null==text&&(text=""),null==escape&&(escape=!1),String(text).replace(/{{([^}]*)}}/g,function(p){var cur,key,value;if(!data)return"";if(key=p.substr(2,p.length-4).split("."),key.length>1){for(cur=data;cur&&key.length;)cur=cur[key.shift()];value=null!=cur?cur:""}else value=data[key[0]];return escape&&(value=ESCAPE_HTML(value)),value})},SIML.resolveContext=function(spec,data){var context,findSIML,resolveContext,resolveValue;return null==spec&&(spec=[]),null==data&&(data={}),context={},resolveValue=function(value,pre,siml,post){return value&&"string"===TYPE_CHECK(value)?post.length>0?value.slice(pre.length,-post.length):value.slice(pre.length):value},resolveContext=function(text,value){if((text.match(/{{([^}]*)}}/g)||[]).length>1)throw new Error("String contains more than one SIML expression.");return String(text).replace(/(.*?){{([^}]*)}}(.*)/,function(m,pre,siml,post){var cur,i,k,l,len,path,results1;if(!/^[^.]+(\.[^.]+)*$/.test(siml))throw new Error("Invalid SIML.");for(path=siml.split("."),cur=context,results1=[],i=l=0,len=path.length;l<len;i=++l)k=path[i],i<path.length-1?results1.push(cur=null!=cur[k]?cur[k]:cur[k]={}):results1.push(cur[k]=resolveValue(value,pre,siml,post));return results1})},findSIML=function(spec,data){var dt,key,results1,sp;results1=[];for(key in spec)switch(sp=spec[key],dt=null!=data?data[key]:void 0,TYPE_CHECK(sp)){case"string":IML.containsIML(sp)?results1.push(resolveContext(sp,dt)):results1.push(void 0);break;case"object":results1.push(findSIML(sp,dt));break;default:results1.push(void 0)}return results1},findSIML(spec,data),context},SIML}(),IMLError=function(superClass){function IMLError(message){this.name=this.constructor.name,this.message=message,IMLError.__super__.constructor.call(this),"function"==typeof Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}return extend(IMLError,superClass),IMLError}(Error),exports.IML=IML,exports.SIML=SIML,exports.IMLError=IMLError,global.IML=exports.IML,global.SIML=exports.SIML,global.IMLError=exports.IMLError,IML.defaults={timezone:function(){return imt.user.timezone}}))}).call(this);