export default {
	icon: 'far fa-random',
	name: 'remapSource',
	label: 'Remap Source',
	description: `
	Use this tool to remap modules in scenario from one source to another. Optionally, you can specify only a one module to be remapped.
	`,
	theme: '#EEEEEE',
	modifier: true,
	input: [
		{
			name: 'source',
			label: 'Source Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'The original module to be remapped.',
			mappable: true,
			required: true
		},
		{
			name: 'target',
			label: 'Target Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'The new module to be used as a source for the other modules.',
			mappable: true,
			required: true
		},
		{
			name: 'concrete',
			label: 'Module to Edit',
			type: 'select',
			options: 'rpc://listModules',
			help: 'You can specify only one module to be remapped.',
			mappable: true,
			required: false
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `

					const toFind = parameters.source;
					const replaceWith = parameters.target;
					const replaceRecursively = (obj, toFind, replaceWith) => {
						for(const k of Object.keys(obj)) {

							// debugger;

							if(typeof obj[k] === 'object' && obj[k] !== null && obj[k] !== undefined){
								if(!(Array.isArray(obj[k]))) {
									replaceRecursively(obj[k], toFind, replaceWith); 
								} else {
									for(const item of obj[k]) {
										replaceRecursively(item, toFind, replaceWith); 
									}
								}
							}


							else if(k !== '__IMTCONN__' && obj[k] !== null && obj[k] !== undefined) {

								// Cannot be used, too naive solution. We need to explore the object deeply.
								// obj[k] = IML.stringify(IML.replace(IML.parse(obj[k]), 'variable', toFind, replaceWith));
								// console.log('Mam te, hajzle:\\n', obj[k], obj);

								const parsed = IML.parse(obj[k]);
								// console.log(parsed);

								const variables = parsed.filter(e => e.type === 'variable') || [];

								// debugger;

								const fmap = (arr) => arr.flatMap(f => (f.arguments || [])
															.flatMap(a => {
																const b = a[0];
																if (b.type === 'variable') return b;
																else if (b.type === 'function') return fmap([b]);
																else return [];
															})
														) || [];

								const arguments = fmap(parsed.filter(e => e.type === 'function'))
														

								// console.log(variables);
								// console.log(arguments);

								// debugger;

								variables.concat(arguments).forEach(v => {
									if (v.name.startsWith(toFind + '.')) {
										// console.log('Replacing\\n', v);

										const s = '^' + toFind + '\\.';
										const r = new RegExp(s);
										const t = v.name.replace(r, replaceWith + '.');

										// console.log(s,r,t);

										v.name = t;

										// console.log('Replaced\\n', v);
									}
								});
								// console.log(parsed);

								obj[k] = IML.stringify(parsed);

							}


						}
					}

					let modules = [];
					if(!(parameters.concrete)) {
						modules = Inspector.instance._surface.find(Surface.Module);
					} else {
						modules = [Inspector.seek(parameters.concrete)];
					}

					// console.log(toFind);
					// console.log(replaceWith);

					modules.forEach(m => {
						// console.log(m);
						m.mapper && replaceRecursively(m.mapper, toFind, replaceWith)
						m.parameters && replaceRecursively(m.parameters, toFind, replaceWith)
					})

			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
