export default {
	icon: 'far fa-clone',
	name: 'copyMapping',
	label: 'Copy Mapping',
	description: 'Copies mapping from one module to another.',
	theme: '#EEEEEE',
	modifier: true,
	input: [
		{
			name: 'source',
			label: 'Source Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'Source module to get the mapping.',
			mappable: true,
			required: true
		},
		{
			name: 'target',
			label: 'Target Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'Target module to paste the mapping.',
			mappable: true,
			required: true
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
					Inspector.seek(parameters.target).mapper = Inspector.seek(parameters.source).mapper;
					Inspector.seek(parameters.target).parameters = Inspector.seek(parameters.source).parameters;
			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
