
/*
Workfront Fusion Formula

@license Copyright 2021 Workfront. All right reserved.
 */

(function() {
  "use strict";
  var CAST_OPTION_VALUE, DEFAULT_OPERATOR, DEFAULT_OPERATORS, Domains, EDIT_MODE_ONLY, EditableInput, FileInput, FormulaOAuth, Group, INPUT_TYPES, InplaceFormula, Input, RESOLVE_DEFAULT, SEMANTIC_TYPES, SORT_METHOD, SemanticGroup, UDT_SPEC, UDT_TYPES, Values, debug, moment, nestedToEditMode,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    extend1 = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  if ('undefined' === typeof imt) {
    return;
  }

  imt.plugins.push({
    name: 'Formula',
    version: '3.49.0',
    author: 'Workfront'
  });

  debug = imt.debug('imt:formula', '#fa6f57');

  INPUT_TYPES = {};

  sim(document).on('click', '.i-remote-formula', function() {
    var cfg, ifa, key, ocn, ref, value;
    if (indexOf.call(imt.remotes, this) >= 0) {
      return;
    }
    imt.remotes.push(this);
    cfg = {
      options: {}
    };
    ref = this.data();
    for (key in ref) {
      value = ref[key];
      if (/^options-(.*)$/.exec(key)) {
        cfg.options[RegExp.$1] = value;
      } else if (key === 'company') {
        cfg[key] = parseInt(value);
      } else if (key === 'href') {
        cfg.url = value;
      } else {
        cfg[key] = value;
      }
    }
    if (cfg.name == null) {
      cfg.name = 'Remote';
    }
    if (cfg.save == null) {
      cfg.save = 'Save';
    }
    if (cfg.url == null) {
      cfg.url = this.attr('href');
    }
    if (this.is('button') || this.is('a')) {
      ifa = this.children('i').first();
      if (ifa) {
        ocn = ifa.attr('class');
        ifa.attr('class', 'far fa-fw fa-spinner-third fa-spin ' + ocn.replace(/(far|fal|fab|fas|fa-[^ ]+)( |$)/g, ' '));
      }
      this.prop('disabled', true);
    }
    new RemoteFormulaModal(cfg, this, (function(_this) {
      return function() {
        imt.remotes.splice(imt.remotes.indexOf(_this), 1);
        if (_this.is('button') || _this.is('a')) {
          if (ifa) {
            ifa.attr('class', ocn);
          }
          return _this.prop('disabled', false);
        }
      };
    })(this));
    return false;
  });

  moment = require('moment-timezone');

  global.IMTDate = {
    timezone: 'UTC',
    parse: function(value, timezone) {
      var ampm, d, day, dd, fraction, hour, minute, month, offset, ref, ref1, ref2, ref3, ref4, second, time, timestamp, year;
      if (value instanceof Date) {
        return value;
      }
      if (typeof value === 'number') {
        value = String(value);
      }
      if (typeof value !== 'string') {
        return null;
      }
      value = value.trim();
      timezone || (timezone = IMTDate.timezone);
      if (/^\d+$/.test(value)) {
        return new Date(parseInt(value));
      }
      hour = 0;
      minute = 0;
      second = 0;
      fraction = 0;
      offset = null;
      dd = function(val, digs) {
        if (digs == null) {
          digs = 2;
        }
        return "" + ("0".repeat(digs - String(val).length)) + val;
      };
      if (/^(\d{4})[\-\/](\d{1,2})[\-\/](\d{1,2})[T\s]?(.+)?$/i.exec(value)) {
        year = parseInt(RegExp.$1);
        month = parseInt(RegExp.$2);
        day = parseInt(RegExp.$3);
        time = (ref = RegExp.$4) != null ? ref.trim() : void 0;
        if (month > 12) {
          d = day;
          day = month;
          month = d;
        }
      }
      if (/^(\d{1,2})[\.\-]\s?(\d{1,2})[\.\-]\s?(\d{4})\s*(.+)?$/i.exec(value)) {
        year = parseInt(RegExp.$3);
        month = parseInt(RegExp.$2);
        day = parseInt(RegExp.$1);
        time = (ref1 = RegExp.$4) != null ? ref1.trim() : void 0;
        if (month > 12) {
          d = day;
          day = month;
          month = d;
        }
      }
      if (/^(\d{1,2})\/(\d{1,2})\/(\d{4})\s*(.+)?$/i.exec(value)) {
        year = parseInt(RegExp.$3);
        month = parseInt(RegExp.$1);
        day = parseInt(RegExp.$2);
        time = (ref2 = RegExp.$4) != null ? ref2.trim() : void 0;
        if (month > 12) {
          d = day;
          day = month;
          month = d;
        }
      }
      if (time && /^(.+)?([+\-])(\d\d):?(\d\d)$/i.exec(time)) {
        offset = (parseInt(RegExp.$3) * 60 * 60 + parseInt(RegExp.$4) * 60) * 1000;
        if (RegExp.$2 === '-') {
          offset *= -1;
        }
        time = (ref3 = RegExp.$1) != null ? ref3.trim() : void 0;
      }
      if (time && /^(.+)?(Z|UTC|GMT)$/i.exec(time)) {
        offset || (offset = 0);
        time = (ref4 = RegExp.$1) != null ? ref4.trim() : void 0;
      }
      if (time && /^(\d{1,2}):(\d{1,2})(?:\:(\d{1,2})(?:\.(\d+))?)?$/i.exec(time)) {
        hour = parseInt(RegExp.$1);
        minute = parseInt(RegExp.$2);
        second = parseInt(RegExp.$3 || 0);
        fraction = parseInt((RegExp.$4 || 0).toString().substr(0, 3));
      } else if (time && /^(\d{1,2})(?:\:(\d{1,2}))?\s*(AM|PM)$/i.exec(time)) {
        hour = parseInt(RegExp.$1);
        minute = parseInt(RegExp.$2 || 0);
        ampm = RegExp.$3.toLowerCase();
        if (ampm === 'am' && hour === 12) {
          hour = 0;
        } else if (ampm === 'pm' && hour !== 12) {
          hour += 12;
        }
      } else if (time) {
        return null;
      }
      if (year) {
        timestamp = Date.UTC(year, month - 1, day, hour, minute, second, fraction);
        if (isNaN(timestamp)) {
          return null;
        }
        if (offset != null) {
          return new Date(timestamp - offset);
        } else if (timezone && timezone !== 'UTC') {
          return moment.tz(year + "-" + (dd(month)) + "-" + (dd(day)) + "T" + (dd(hour)) + ":" + (dd(minute)) + ":" + (dd(second)) + "." + (dd(fraction, 3)), timezone).toDate();
        } else {
          return new Date(timestamp);
        }
      }
      return null;
    },
    parseTime: function(value, timezone) {
      var ampm, fraction, hour, minute, second;
      timezone || (timezone = IMTDate.timezone);
      if (value instanceof Date) {
        value = moment(value).tz(timezone).format('HH:mm:ss.SSS');
      }
      if (typeof value !== 'string') {
        return null;
      }
      value = value.trim();
      hour = 0;
      minute = 0;
      second = 0;
      fraction = 0;
      if (value && /^(\d{1,2}):(\d{1,2})(?:\:(\d{1,2})(?:\.(\d{1,3}))?)?$/i.exec(value)) {
        hour = parseInt(RegExp.$1);
        minute = parseInt(RegExp.$2);
        second = parseInt(RegExp.$3 || 0);
        fraction = parseInt(RegExp.$4 || 0);
      } else if (/^(\d{1,2})(?:\:(\d{1,2}))?\s*(AM|PM)$/i.exec(value)) {
        hour = parseInt(RegExp.$1);
        minute = parseInt(RegExp.$2 || 0);
        ampm = RegExp.$3.toLowerCase();
        if (ampm === 'am' && hour === 12) {
          hour = 0;
        } else if (ampm === 'pm' && hour !== 12) {
          hour += 12;
        }
      } else {
        value = IMTDate.parse(value, timezone);
        if (value) {
          return IMTDate.parseTime(value, timezone);
        }
        return null;
      }
      if (hour >= 24) {
        return null;
      }
      if (minute >= 60) {
        return null;
      }
      if (second >= 60) {
        return null;
      }
      if (fraction >= 1000) {
        return null;
      }
      return fraction + second * 1000 + minute * 60 * 1000 + hour * 60 * 60 * 1000;
    },
    timeToString: function(number) {
      var dd, fraction, hour, minute, second, txt;
      if ('number' !== typeof number) {
        return null;
      }
      if (number >= 86400000) {
        return null;
      }
      dd = function(val, digs) {
        if (digs == null) {
          digs = 2;
        }
        return "" + ("0".repeat(digs - String(val).length)) + val;
      };
      hour = Math.floor(number / 3600000);
      number = number % 3600000;
      minute = Math.floor(number / 60000);
      number = number % 60000;
      second = Math.floor(number / 1000);
      fraction = number % 1000;
      txt = '' + dd(hour);
      txt += ':' + dd(minute);
      if (second || fraction) {
        txt += ':' + dd(second);
      }
      if (fraction) {
        txt += '.' + dd(fraction, 3);
      }
      return txt;
    }
  };

  Object.defineProperty(IMTDate, 'timezone', {
    enumerable: false,
    get: function() {
      return imt.user.timezone;
    }
  });

  UDT_TYPES = function() {
    return [
      {
        label: 'Array',
        value: 'array',
        nested: [
          {
            name: 'spec',
            type: 'collection',
            label: 'Array Item Specification',
            spec: [
              {
                name: 'type',
                label: 'Type',
                type: 'udttype',
                required: true,
                "default": 'text'
              }
            ]
          }
        ]
      }, {
        label: 'Collection',
        value: 'collection',
        nested: [
          {
            name: 'spec',
            label: 'Specification',
            type: 'udtspec'
          }, {
            name: 'sequence',
            label: 'Preserve the order of object keys',
            type: 'boolean'
          }
        ]
      }, {
        label: 'Date',
        value: 'date'
      }, {
        label: 'Text',
        value: 'text',
        nested: [
          {
            name: 'default',
            label: 'Default',
            help: 'Default value.',
            type: 'text'
          }, {
            name: 'required',
            label: 'Required',
            type: 'boolean',
            required: true,
            "default": false
          }, {
            name: 'multiline',
            label: 'Multi-line',
            type: 'boolean',
            required: true,
            "default": false
          }
        ]
      }, {
        label: 'Number',
        value: 'number',
        nested: [
          {
            name: 'default',
            label: 'Default',
            help: 'Default value.',
            type: 'number'
          }, {
            name: 'required',
            label: 'Required',
            type: 'boolean',
            required: true,
            "default": false
          }
        ]
      }, {
        label: 'Boolean',
        value: 'boolean',
        nested: [
          {
            name: 'default',
            label: 'Default',
            help: 'Default value.',
            type: 'boolean'
          }, {
            name: 'required',
            label: 'Required',
            type: 'boolean',
            required: true,
            "default": false
          }
        ]
      }, {
        label: 'Binary Data',
        value: 'buffer',
        nested: [
          {
            name: 'required',
            label: 'Required',
            type: 'boolean',
            required: true,
            "default": false
          }, {
            name: 'codepage',
            label: 'Codepage',
            type: 'text',
            help: 'Possible values: `binary`, `utf8`. Leave empty if you\'re not sure.'
          }
        ]
      }
    ];
  };

  UDT_SPEC = function() {
    return [
      {
        name: 'name',
        label: 'Name',
        help: 'Name of the property.',
        type: 'text',
        required: true
      }, {
        name: 'label',
        label: 'Label',
        help: 'Display name for better readability. Optional.',
        type: 'text',
        advanced: true
      }, {
        name: 'type',
        label: 'Type',
        help: 'Property data type.',
        type: 'udttype',
        required: true,
        "default": 'text'
      }
    ];
  };

  EDIT_MODE_ONLY = function() {
    return this.mode === 'edit';
  };


  /*
  @property {Form} form Form that owns this fieldset.
  @property {Input} parent Contains input, that controlls this fieldset.
   */

  global.Fieldset = (function(superClass) {
    extend1(Fieldset, superClass);

    Fieldset.prototype.form = null;

    Fieldset.prototype.parent = null;

    Fieldset.prototype.inputs = null;

    Fieldset.prototype.groups = null;

    Fieldset.prototype.domain = null;

    Fieldset.prototype.initialized = false;

    Fieldset.prototype.advanced = false;

    Fieldset.prototype.dynamic = false;

    Fieldset.prototype.destroyed = false;

    Fieldset.prototype._valueOfParent = null;

    Fieldset.prototype._built = false;

    Fieldset.prototype._legend = null;

    Fieldset.prototype.__active = true;

    Fieldset.prototype.__expanded = true;

    Fieldset.prototype.__legend = '';

    Fieldset.prototype.__preview = false;

    Fieldset.property('active', {
      get: function() {
        return this.__active;
      },
      set: function(value) {
        if (value === this.__active) {
          return;
        }
        this.__active = value;
        return this._resolveVisibility();
      }
    });

    Fieldset.property('expanded', {
      get: function() {
        return this.__expanded;
      },
      set: function(value) {
        if (value === this.__expanded) {
          return;
        }
        this.__expanded = value;
        return this._resolveVisibility(false);
      }
    });

    Fieldset.property('legend', {
      get: function() {
        return this.__legend;
      },
      set: function(value) {
        var ref;
        if (value === this.__legend) {
          return;
        }
        this.__legend = value;
        if (value) {
          if (this._legend) {
            this._legend.text(value);
          } else {
            this._legend = sim.legend().appendTo(this).text(value);
          }
        } else {
          if ((ref = this._legend) != null) {
            ref.detach();
          }
        }
        return this.visible = value;
      }
    });

    Fieldset.property('preview', {
      get: function() {
        return this.__preview;
      },
      set: function(value) {
        var input, j, len, ref, results;
        if (value === this.__preview) {
          return;
        }
        this.__preview = value;
        ref = this.inputs;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          input = ref[j];
          results.push(input.preview = value);
        }
        return results;
      }
    });


    /*
    	Return all parameters is nested path from form to this fieldset
     */

    Fieldset.property('path', {
      get: function() {
        var body, key, parent, ref, ref1, ref2, value;
        body = {};
        if ((ref = this.form) != null ? (ref1 = ref.options) != null ? ref1.parentFieldset : void 0 : void 0) {
          ref2 = this.form.options.parentFieldset.path;
          for (key in ref2) {
            value = ref2[key];
            body[key] = value;
          }
        }
        if (this.parent) {
          parent = this.parent;
          while (parent) {
            if (parent.name) {
              body[parent.name] = parent.toJSON();
            }
            parent = parent.fieldset.parent;
          }
        }
        return body;
      }
    });

    function Fieldset(parent) {
      if (parent instanceof Formula) {
        this.form = parent;
      } else {
        if (parent instanceof Fieldset) {
          this.form = parent.form;
        } else if (parent instanceof Input) {
          this.parent = parent;
          this.form = parent.fieldset.form;
        } else {
          throw new TypeError("Formula, Fieldset or Input expected.");
        }
      }
      Fieldset.__super__.constructor.call(this, 'fieldset');
      this.inputs = [];
      this.groups = [];
      if (this.parent) {
        this.insertAfter(this.parent);
      } else {
        this.appendTo(this.form);
      }
      this.form.fieldsets.push(this);
    }

    Fieldset.prototype._resolveVisibility = function(animate) {
      if (animate == null) {
        animate = true;
      }
      if ((this.active && !this.advanced) || (this.active && this.advanced && this.expanded)) {
        if (!this.initialized) {
          if (!this._built) {
            this.build((function(_this) {
              return function() {
                return _this.initialize();
              };
            })(this));
          } else {
            this.initialize();
          }
        }
        if (this.initialized) {
          if (animate) {
            return this.slideDown({
              duration: 'fast',
              progress: (function(_this) {
                return function() {
                  return _this.form.emit('resize');
                };
              })(this),
              complete: (function(_this) {
                return function() {
                  return _this.form.emit('resize');
                };
              })(this)
            });
          } else {
            this.show();
            return this.form.emit('resize');
          }
        } else {
          this.show();
          return this.form.emit('resize');
        }
      } else {
        if (this.initialized) {
          if (animate) {
            return this.slideUp({
              duration: 'fast',
              progress: (function(_this) {
                return function() {
                  return _this.form.emit('resize');
                };
              })(this),
              complete: (function(_this) {
                return function() {
                  return _this.form.emit('resize');
                };
              })(this)
            });
          } else {
            this.hide();
            return this.form.emit('resize');
          }
        } else {
          this.hide();
          return this.form.emit('resize');
        }
      }
    };


    /*
    	Build fieldset from config.
     */

    Fieldset.prototype.build = function(callback) {
      var build, resolve, self;
      this._built = true;
      self = this;
      this.attr('data-domain', this.domain);
      build = (function(_this) {
        return function(config, prefix, group, done) {
          var base, base1, base2, base3, base4, base5, base6, base7, cfg, g, input, j, len, ref, ref1, ref10, ref11, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, scope, semantics;
          if (_this.destroyed) {
            return;
          }
          if ('function' === typeof prefix) {
            done = prefix;
            prefix = ((ref = self.parent) != null ? ref.prefix : void 0) || void 0;
            group = ((ref1 = self.parent) != null ? ref1.group : void 0) || void 0;
          }
          if (!config) {
            return setImmediate(function() {
              return done();
            });
          }
          debug("build fieldset from config", config);
          semantics = {};
          config = config.reduce(function(arr, cfg) {
            var ref2, semanticType, semanticValue;
            cfg = Object.cloneDeep(cfg, {
              preserveFunctions: true
            });
            if (!cfg.semantic) {
              arr.push(cfg);
              return arr;
            }
            ref2 = cfg.semantic.split(':'), semanticType = ref2[0], semanticValue = ref2[1];
            cfg.semantic = void 0;
            cfg.mean = semanticValue;
            if (!semantics[semanticType]) {
              semantics[semanticType] = [];
              semantics[semanticType].push(cfg);
              arr.push({
                type: 'semantic',
                mean: semanticType,
                spec: semantics[semanticType],
                advanced: cfg.advanced === true
              });
            } else {
              semantics[semanticType].push(cfg);
            }
            return arr;
          }, []);
          for (j = 0, len = config.length; j < len; j++) {
            cfg = config[j];
            cfg.prefix = prefix;
            if (cfg.label == null) {
              cfg.label = (ref2 = cfg.name) != null ? ref2 : '';
            }
            if (cfg.type == null) {
              cfg.type = 'text';
            }
            cfg.type = cfg.type.toLowerCase();
            switch (cfg.type) {
              case 'html':
                input = null;
                if ((ref3 = self.form.options) != null ? ref3.inline : void 0) {
                  (group != null ? group : _this).append(sim.div('.form-html .row .justify-content-end').append(sim.div('.col-8').append(sim.parse(cfg.label))));
                } else {
                  (group != null ? group : _this).append(sim.div('.form-html').append(sim.parse(cfg.label)));
                }
                break;
              case 'divider':
                input = null;
                (group != null ? group : _this).append(sim.div('.form-divider'));
                break;
              case 'markdown':
                input = null;
                if ((ref4 = self.form.options) != null ? ref4.inline : void 0) {
                  (group != null ? group : _this).append(sim.div('.form-html .row .justify-content-end').append(sim.div('.col-8').append(sim.parse(format(cfg.label, 'markdown')))));
                } else {
                  (group != null ? group : _this).append(sim.div('.form-html').append(sim.parse(format(cfg.label, 'markdown'))));
                }
                break;
              case 'suggestion':
                input = new Suggestion(_this, group, cfg.container);
                break;
              case 'link':
                input = new Link(_this, group);
                break;
              case 'submit':
                input = new Submit(_this, group);
                break;
              case 'boolean':
              case 'checkbox':
                input = new CheckInput(_this, group);
                break;
              case 'radio':
                input = new RadioInput(_this, group);
                break;
              case 'select':
                if (cfg.reloadable == null) {
                  cfg.reloadable = true;
                }
                input = new SelectInput(_this, group);
                break;
              case 'hidden':
                input = new HiddenInput(_this, group);
                break;
              case 'upload':
                input = new UploadInput(_this, group);
                break;
              case 'filter':
                input = new FilterInput(_this, group);
                break;
              case 'array':
                input = new ArrayInput(_this, group);
                break;
              case 'folder':
                input = new FolderInput(_this, group);
                break;
              case 'file':
                input = new FileInput(_this, group);
                break;
              case 'list':
                input = new ListInput(_this, group);
                break;
              case 'creditcard':
                input = new CreditCardInput(_this, group);
                break;
              case 'collection':
                if (!cfg.spec) {
                  continue;
                }
                g = new Group(_this, group, cfg);
                build(cfg.spec, (prefix != null ? prefix : []).concat([cfg.name]), g);
                _this.groups.push(g);
                continue;
              case 'semantic':
                g = new SemanticGroup(_this, group, cfg);
                build(cfg.spec, prefix, g);
                _this.groups.push(g);
                continue;
              case 'country':
                cfg.type = 'select';
                if (cfg.options == null) {
                  cfg.options = {};
                }
                cfg.options.store = "api://countries";
                input = new SelectInput(_this, group);
                break;
              case 'timezone':
                cfg.type = 'select';
                if (cfg.options == null) {
                  cfg.options = {};
                }
                cfg.options.store = "api://timezones";
                if ((base = cfg.options).value == null) {
                  base.value = "code";
                }
                if ((base1 = cfg.options).label == null) {
                  base1.label = "name";
                }
                input = new SelectInput(_this, group);
                break;
              case 'pkey':
              case 'cert':
                cfg.multiline = true;
                (function(cfg, scope) {
                  var panel;
                  panel = null;
                  return cfg.buttons = [
                    {
                      label: imt.l('formula', 'buttons.extract'),
                      on: {
                        click: function() {
                          if (panel != null) {
                            return;
                          }
                          this.enabled = false;
                          panel = new RemoteFormulaPanel(this._inputGroup, {
                            name: imt.l('formula', 'buttons.extract'),
                            url: "api://keys/extractor?type=" + cfg.type,
                            success: (function(_this) {
                              return function(spec) {
                                return _this.value = spec;
                              };
                            })(this)
                          });
                          panel.offsetX = 5;
                          return panel.once('destroy', (function(_this) {
                            return function() {
                              _this.enabled = true;
                              return panel = null;
                            };
                          })(this));
                        }
                      }
                    }
                  ];
                })(cfg, scope);
                input = new TextInput(_this, group);
                break;
              case 'udttype':
                cfg.type = 'select';
                cfg.options = UDT_TYPES();
                input = new SelectInput(_this, group);
                break;
              case 'udtspec':
                (function(cfg, scope) {
                  var panel;
                  panel = null;
                  return cfg.buttons = [
                    {
                      label: imt.l('formula', 'buttons.generator'),
                      on: {
                        click: function() {
                          var ref5, ref6;
                          if (panel != null) {
                            return;
                          }
                          this.enabled = false;
                          panel = new RemoteFormulaPanel(this._inputGroup, {
                            name: imt.l('formula', 'buttons.generator'),
                            url: "api://udts/generator?type=" + (((ref5 = self.form.options) != null ? (ref6 = ref5["package"]) != null ? ref6.name : void 0 : void 0) === 'xml' ? 'xml' : 'json'),
                            help: 'kb://data-structures.html',
                            expandable: true,
                            success: (function(_this) {
                              return function(spec) {
                                return _this.value = spec;
                              };
                            })(this)
                          });
                          panel.offsetX = 5;
                          return panel.once('destroy', (function(_this) {
                            return function() {
                              _this.enabled = true;
                              return panel = null;
                            };
                          })(this));
                        }
                      }
                    }
                  ];
                })(cfg, scope);
                cfg.spec = UDT_SPEC();
                input = new ArrayInput(_this, group);
                break;
              default:
                if (/^tokens(?::(.*))?$/.exec(cfg.type)) {
                  cfg.type = 'tokens';
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  cfg.options.tokenType = RegExp.$1;
                  input = new TokensInput(_this, group);
                } else if (/^hook:(.*)$/.exec(cfg.type)) {
                  cfg.type = 'hook';
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base2 = cfg.options).company == null) {
                    base2.company = (ref5 = _this.form.options.company) != null ? ref5 : imt.company.id;
                  }
                  cfg.options.hookType = RegExp.$1;
                  cfg.options.store = "api://hooks/list/" + cfg.options.company + "/" + (encodeURIComponent(cfg.options.hookType));
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  cfg.options.data = {
                    editable: 'editable'
                  };
                  if (_this.form.options["package"]) {
                    if (cfg.help == null) {
                      cfg.help = imt.l('formula', 'hints.webhook', {
                        data: {
                          service: _this.form.options["package"].label,
                          name: _this.form.options["package"].name.replace(/^app#/, '')
                        }
                      });
                    }
                  }
                  (function(cfg) {
                    var panel;
                    panel = null;
                    return cfg.buttons = [
                      [
                        {
                          label: imt.l('formula', 'buttons.edititem'),
                          enabled: function() {
                            var sel;
                            if (!this.value) {
                              return false;
                            }
                            sel = sim(this._input.__dom.options[this._input.__dom.selectedIndex]);
                            if (sel.data('editable') !== 'true') {
                              return false;
                            }
                            return true;
                          },
                          on: {
                            click: function() {
                              var sel;
                              if (panel != null) {
                                return;
                              }
                              sel = sim(this._input.__dom.options[this._input.__dom.selectedIndex]);
                              this.enabled = false;
                              panel = new RemoteFormulaPanel(this._inputGroup, {
                                name: sel.text(),
                                url: "api://hook/" + this.value + "/edit",
                                help: 'kb://webhooks.html',
                                options: {
                                  company: cfg.options.company
                                }
                              });
                              panel.offsetX = 5;
                              return panel.once('destroy', (function(_this) {
                                return function() {
                                  _this.enabled = true;
                                  return panel = null;
                                };
                              })(this));
                            }
                          }
                        }
                      ], {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new RemoteFormulaPanel(this._inputGroup, {
                              name: imt.l('inspector', 'panels.hooks.create'),
                              url: "api://hooks/add/" + cfg.options.company + "?inspector=yes&type=" + (encodeURIComponent(cfg.options.hookType)),
                              help: 'kb://webhooks.html',
                              options: {
                                company: cfg.options.company,
                                "package": this.form.options["package"],
                                config: this.form.options.config
                              },
                              success: (function(_this) {
                                return function(id, name) {
                                  return _this.addOption({
                                    label: name,
                                    value: id
                                  }, true);
                                };
                              })(this)
                            });
                            panel.offsetX = 5;
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                  })(cfg);
                  input = new HookSelectInput(_this, group);
                } else if (/^account:(.*)$/.exec(cfg.type)) {
                  cfg.type = 'account';
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base3 = cfg.options).company == null) {
                    base3.company = (ref6 = _this.form.options.company) != null ? ref6 : imt.company.id;
                  }
                  cfg.options.accountTypes = RegExp.$1.split(',').map(function(type) {
                    var ref7, ref8, scope;
                    scope = (ref7 = cfg.options.scope) != null ? ref7 : (ref8 = _this.form.options.config) != null ? ref8.scope : void 0;
                    if (scope && !Array.isArray(scope)) {
                      scope = scope[type];
                    }
                    return {
                      type: type,
                      scope: scope != null ? scope : []
                    };
                  });
                  cfg.options.store = "api://accounts/list" + (cfg.options.company ? "/" + cfg.options.company : '');
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  if (cfg.required) {
                    cfg.options["default"] = "scoped";
                  }
                  cfg.options.data = {
                    scoped: 'scoped',
                    account: 'account_name'
                  };
                  if (!cfg.options.company) {
                    cfg.grouped = true;
                  }
                  if (_this.form.options["package"]) {
                    if (cfg.help == null) {
                      cfg.help = imt.l('formula', 'hints.account', {
                        data: {
                          service: _this.form.options["package"].label,
                          name: _this.form.options["package"].name.replace(/^app#/, '')
                        }
                      });
                    }
                  }
                  (function(cfg) {
                    var acc, l, len1, len2, n, panel, qs, ref7, ref8, scope, types;
                    qs = [];
                    types = [];
                    ref7 = cfg.options.accountTypes;
                    for (l = 0, len1 = ref7.length; l < len1; l++) {
                      acc = ref7[l];
                      qs.push("type=" + (encodeURIComponent(acc.type)));
                      types.push("type=" + (encodeURIComponent(acc.type)));
                      ref8 = acc.scope;
                      for (n = 0, len2 = ref8.length; n < len2; n++) {
                        scope = ref8[n];
                        qs.push((encodeURIComponent(acc.type)) + "=" + (encodeURIComponent(scope)));
                      }
                    }
                    cfg.options.store += qs.length ? "?" + (qs.join('&')) : '';
                    panel = null;
                    cfg.buttons = [
                      {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            var ref9;
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new RemoteFormulaPanel(this._inputGroup, {
                              name: imt.l('formula', 'panels.account.create'),
                              save: imt.l('base', 'common.continue'),
                              url: "api://accounts/add" + (cfg.options.company ? "/" + cfg.options.company : '') + "?inspector=yes&" + (types.join('&')),
                              help: ((ref9 = self.closest('.i-panel')) != null ? ref9.help : void 0) || 'kb://connections.html',
                              options: {
                                company: cfg.options.company,
                                "package": this.form.options["package"],
                                config: this.form.options.config,
                                oauth: {
                                  scope: cfg.options.accountTypes.toObject('type', 'scope')
                                }
                              },
                              success: (function(_this) {
                                return function(id, name, type) {
                                  return _this.addOption({
                                    label: name,
                                    value: id,
                                    scoped: true,
                                    account_name: type
                                  }, true);
                                };
                              })(this)
                            });
                            panel.offsetX = 5;
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                    return cfg.options.beforeChange = function(callback) {
                      var accountId, resolved, sel;
                      sel = sim(this._input.__dom.options[this._input.__dom.selectedIndex]);
                      if (sel.data('scoped') === 'true') {
                        return setImmediate(function() {
                          return callback(true);
                        });
                      }
                      if (panel != null) {
                        return;
                      }
                      resolved = false;
                      accountId = parseInt(this.value);
                      panel = new Panel(this._inputGroup);
                      panel.title = imt.l('formula', 'panels.account.extend');
                      panel.content = sim.p().text(imt.l('formula', 'panels.account.extendhelp'));
                      panel.offsetX = 5;
                      panel.once('destroy', (function(_this) {
                        return function() {
                          _this.enabled = true;
                          panel = null;
                          if (!resolved) {
                            resolved = true;
                            return callback(false);
                          }
                        };
                      })(this));
                      return sim.button('.btn.btn-primary', function() {
                        this.attr('type', 'button');
                        this.text(imt.l('base', 'common.continue'));
                        this.appendTo(panel._footer);
                        return this.on('click', function() {
                          var ref10, ref9;
                          panel.loading = true;
                          panel.status = imt.l('inspector', 'panels.accounts.extending');
                          scope = (ref9 = (ref10 = cfg.options.accountTypes.filter(function(acc) {
                            return acc.type === sel.data('account');
                          })[0]) != null ? ref10.scope : void 0) != null ? ref9 : [];
                          return FormulaOAuth.extend.call(panel, accountId, scope, function(err) {
                            if (resolved) {
                              return;
                            }
                            if (err) {
                              return panel.warn(err, sim.p().text(imt.l('formula', 'panels.account.extendhelp')));
                            }
                            panel.close();
                            resolved = true;
                            sel.data('scoped', 'true');
                            return callback(true);
                          });
                        });
                      });
                    };
                  })(cfg);
                  input = new SelectInput(_this, group);
                } else if (/^keychain:(.*)$/.exec(cfg.type)) {
                  cfg.type = 'keychain';
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base4 = cfg.options).company == null) {
                    base4.company = (ref7 = _this.form.options.company) != null ? ref7 : imt.company.id;
                  }
                  cfg.options.keyType = RegExp.$1;
                  cfg.options.store = "api://keys/list/" + cfg.options.company + "/" + (encodeURIComponent(cfg.options.keyType));
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  (function(cfg) {
                    var panel;
                    panel = null;
                    return cfg.buttons = [
                      {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new Inspector.KeychainPanel(this._inputGroup, 'create', cfg.options.keyType, cfg.options.company, this);
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                  })(cfg);
                  input = new SelectInput(_this, group);
                } else if (/^device(?:\:(.*))?$/.exec(cfg.type)) {
                  scope = (ref8 = RegExp.$1) != null ? ref8.split(',') : void 0;
                  cfg.type = 'device';
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base5 = cfg.options).company == null) {
                    base5.company = (ref9 = _this.form.options.company) != null ? ref9 : imt.company.id;
                  }
                  cfg.options.store = "api://devices/list/" + cfg.options.company + (scope != null ? "/?scope=" + (scope.join('&scope=')) : "");
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  (function(cfg, scope) {
                    var panel;
                    panel = null;
                    return cfg.buttons = [
                      {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new RemoteFormulaPanel(this._inputGroup, {
                              name: imt.l('formula', 'panels.device.add'),
                              url: "api://devices/add/" + cfg.options.company + "?inspector=yes",
                              help: 'kb://mobile-app.html',
                              save: imt.l('base', 'common.continue'),
                              success: (function(_this) {
                                return function(id, name, scopes) {
                                  var l, len1, s;
                                  for (l = 0, len1 = scope.length; l < len1; l++) {
                                    s = scope[l];
                                    if (!(indexOf.call(scopes, s) >= 0)) {
                                      continue;
                                    }
                                    _this.addOption({
                                      label: name,
                                      value: id
                                    }, true);
                                    return;
                                  }
                                  new Alert(imt.l('formula', 'errors.devicescope')).show();
                                  return null;
                                };
                              })(this)
                            });
                            panel.offsetX = 5;
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                  })(cfg, scope);
                  input = new SelectInput(_this, group);
                } else if (cfg.type === 'udt') {
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base6 = cfg.options).company == null) {
                    base6.company = (ref10 = _this.form.options.company) != null ? ref10 : imt.company.id;
                  }
                  cfg.options.store = "api://udts/list/" + cfg.options.company;
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  (function(cfg, scope) {
                    var panel;
                    panel = null;
                    return cfg.buttons = [
                      [
                        {
                          label: imt.l('formula', 'buttons.edititem'),
                          enabled: function() {
                            if (this.value) {
                              return true;
                            } else {
                              return false;
                            }
                          },
                          on: {
                            click: function() {
                              var sel;
                              if (panel != null) {
                                return;
                              }
                              sel = sim(this._input.__dom.options[this._input.__dom.selectedIndex]);
                              this.enabled = false;
                              panel = new RemoteFormulaPanel(this._inputGroup, {
                                name: sel.text(),
                                url: "api://udt/" + this.value + "/edit",
                                help: 'kb://data-structures.html',
                                expandable: true,
                                options: {
                                  company: cfg.options.company
                                }
                              });
                              panel.offsetX = 5;
                              panel.once('save', (function(_this) {
                                return function() {
                                  return _this.emit('update');
                                };
                              })(this));
                              return panel.once('destroy', (function(_this) {
                                return function() {
                                  _this.enabled = true;
                                  return panel = null;
                                };
                              })(this));
                            }
                          }
                        }, {
                          label: imt.l('formula', 'buttons.cloneitem'),
                          enabled: function() {
                            if (this.value) {
                              return true;
                            } else {
                              return false;
                            }
                          },
                          on: {
                            click: function() {
                              if (panel != null) {
                                return;
                              }
                              this.enabled = false;
                              panel = new RemoteFormulaPanel(this._inputGroup, {
                                name: 'buttons.cloneitem',
                                save: 'buttons.cloneitem',
                                url: "api://udt/" + this.value + "/clone?inspector=yes",
                                expandable: true,
                                success: (function(_this) {
                                  return function(id, name) {
                                    return _this.addOption({
                                      label: name,
                                      value: id
                                    }, true);
                                  };
                                })(this)
                              });
                              panel.offsetX = 5;
                              return panel.once('destroy', (function(_this) {
                                return function() {
                                  _this.enabled = true;
                                  return panel = null;
                                };
                              })(this));
                            }
                          }
                        }
                      ], {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            var ref11;
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new RemoteFormulaPanel(this._inputGroup, {
                              name: imt.l('formula', 'panels.udt.add'),
                              url: "api://udts/add/" + cfg.options.company + "?inspector=yes",
                              options: {
                                "package": (ref11 = self.form.options) != null ? ref11["package"] : void 0
                              },
                              help: 'kb://data-structures.html',
                              expandable: true,
                              success: (function(_this) {
                                return function(id, name) {
                                  return _this.addOption({
                                    label: name,
                                    value: id
                                  }, true);
                                };
                              })(this)
                            });
                            panel.offsetX = 5;
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                  })(cfg, scope);
                  input = new SelectInput(_this, group);
                } else if (cfg.type === 'datastore') {
                  if (cfg.options == null) {
                    cfg.options = {};
                  }
                  if ((base7 = cfg.options).company == null) {
                    base7.company = (ref11 = _this.form.options.company) != null ? ref11 : imt.company.id;
                  }
                  cfg.options.store = "api://datastores/list/" + cfg.options.company;
                  cfg.options.value = "id";
                  cfg.options.label = "name";
                  (function(cfg, scope) {
                    var panel;
                    panel = null;
                    return cfg.buttons = [
                      {
                        label: imt.l('formula', 'buttons.browse'),
                        on: {
                          click: function() {
                            if (!this.value) {
                              return;
                            }
                            return sim(window).openPopup("/datastore/" + this.value + "/browse", 'datastore');
                          }
                        }
                      }, {
                        label: imt.l('base', 'common.add'),
                        on: {
                          click: function() {
                            if (panel != null) {
                              return;
                            }
                            this.enabled = false;
                            panel = new RemoteFormulaPanel(this._inputGroup, {
                              name: imt.l('inspector', 'panels.datastores.create'),
                              url: "api://datastores/add/" + cfg.options.company + "?inspector=yes",
                              help: 'kb://data-stores.html',
                              success: (function(_this) {
                                return function(id, name) {
                                  return _this.addOption({
                                    label: name,
                                    value: id
                                  }, true);
                                };
                              })(this)
                            });
                            panel.offsetX = 5;
                            return panel.once('destroy', (function(_this) {
                              return function() {
                                _this.enabled = true;
                                return panel = null;
                              };
                            })(this));
                          }
                        }
                      }
                    ];
                  })(cfg, scope);
                  input = new SelectInput(_this, group);
                } else {
                  input = new TextInput(_this, group);
                }
            }
            if (input != null) {
              input.config = cfg;
            }
            if (input != null) {
              input.build();
            }
          }
          return typeof done === "function" ? done(null) : void 0;
        };
      })(this);
      resolve = (function(_this) {
        return function(config, done) {
          var body;
          if (typeof config === 'string') {
            _this.addClass('i-loading');
            _this.form.loadings++;
            body = _this.path;
            _this.form.emit('loading-status', {
              detail: {
                status: imt.l('formula', 'common.loading')
              }
            });
            return Loader.load(config, {
              data: body,
              parser: 'manifest'
            }, function(err, config, headers) {
              _this.removeClass('i-loading');
              _this.form.loadings--;
              if (err) {
                _this.addClass('i-failed');
                _this.text(err.message);
                return typeof done === "function" ? done(err) : void 0;
              }
              if (headers['remote-formula'] === 'yes') {
                config = config.config;
              }
              if (_this.form.built) {
                _this.addClass('i-yellow-fade');
                delay(3000, function() {
                  return _this.removeClass('i-yellow-fade');
                });
              }
              return resolve(config, done);
            });
          } else if (Array.isArray(config)) {
            if (config.some((function(item) {
              return 'string' === typeof item;
            }))) {
              _this.addClass('i-loading');
              _this.form.loadings++;
              body = _this.path;
              return async.map(config, function(item, next) {
                if ('string' !== typeof item) {
                  return next(null, item);
                }
                _this.form.emit('loading-status', {
                  detail: {
                    status: imt.l('formula', 'common.loading')
                  }
                });
                return Loader.load(item, {
                  data: body,
                  parser: 'manifest'
                }, function(err, config, headers) {
                  if (err) {
                    return next(err);
                  }
                  if (headers['remote-formula'] === 'yes') {
                    config = config.config;
                  }
                  return next(null, config);
                });
              }, function(err, config) {
                _this.removeClass('i-loading');
                _this.form.loadings--;
                config = [].concat.apply([], config);
                if (err) {
                  _this.addClass('i-failed');
                  _this.text(err.message);
                  return typeof done === "function" ? done(err) : void 0;
                }
                if (_this.form.built) {
                  _this.addClass('i-yellow-fade');
                  delay(3000, function() {
                    return _this.removeClass('i-yellow-fade');
                  });
                }
                return typeof done === "function" ? done(null, config) : void 0;
              });
            } else {
              return typeof done === "function" ? done(null, config) : void 0;
            }
          } else {
            return typeof done === "function" ? done() : void 0;
          }
        };
      })(this);
      resolve(this.config, function(err, config) {
        if (err) {
          return typeof callback === "function" ? callback(err) : void 0;
        }
        return build(config, callback);
      });
      if (this.dynamic) {
        this._addField = this.button('.btn.btn-xs.btn-primary[type="button"]', function() {
          this.text(imt.l('formula', 'panels.addfield.title'));
          return this.on('click', function(event) {
            var form, panel;
            panel = self._addPanel = new Panel(this);
            panel.offsetX = 5;
            panel.title = imt.l('formula', 'panels.addfield.title');
            panel.loading = true;
            form = new Formula(imt.l('formula', 'panels.addfield.title'));
            form.on('resize', panel._resize);
            form.config = [
              {
                name: 'name',
                label: imt.l('base', 'common.name'),
                type: 'text',
                required: true
              }, {
                name: 'label',
                label: imt.l('base', 'common.label'),
                type: 'text'
              }, {
                name: 'type',
                label: imt.l('base', 'common.type'),
                type: 'select',
                required: true,
                "default": 'text',
                options: [
                  {
                    label: 'Text',
                    value: 'text',
                    nested: [
                      {
                        name: 'multiline',
                        label: 'Multiline',
                        type: 'boolean',
                        required: true,
                        "default": false
                      }
                    ]
                  }
                ]
              }
            ];
            form.build(function(err) {
              if (err) {
                return panel.warn(err.message);
              }
              panel.loading = false;
              panel.content = form;
              return form.focusFirst();
            });
            sim.button('.btn.btn-outline-secondary.btn-sm', function() {
              this.attr('type', 'button');
              this.text(imt.l('base', 'common.cancel'));
              this.appendTo(panel._footer);
              return this.on('click', function() {
                return panel.close();
              });
            });
            sim.button('.btn.btn-primary.btn-sm', function() {
              this.attr('type', 'button');
              this.text(imt.l('base', 'common.add'));
              this.appendTo(panel._footer);
              return this.on('click', function() {
                if (form.isValid()) {
                  build([form.toJSON()]);
                  panel.close();
                  self.form.emit('resize');
                  return self.append(self._addField);
                }
              });
            });
            panel.once('destroy', function() {
              form.destroy();
              return self._addPanel = null;
            });
            return false;
          });
        });
      }
      return this;
    };

    Fieldset.prototype.rebuild = function(callback) {
      var input, j, len, ref;
      this._built = false;
      this.initialized = false;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        input.destroy();
      }
      this.inputs.clear();
      this.form.emit('resize');
      return this.build(callback);
    };


    /*
    	Destroy fieldset.
     */

    Fieldset.prototype.destroy = function() {
      var input, j, len, ref;
      this.destroyed = true;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        input.destroy();
      }
      this.inputs.clear();
      this.form.fieldsets.splice(this.form.fieldsets.indexOf(this), 1);
      return this.remove();
    };

    Fieldset.prototype.focusFirst = function() {
      var input, j, len, ref;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (!(input.name && input.enabled)) {
          continue;
        }
        input._focus();
        return true;
      }
      return false;
    };

    Fieldset.prototype.initialize = function(callback) {
      this.initialized = true;
      debug("initialize fieldset");
      this.form.emit('resize');
      return async.map(this.inputs.concat(this.groups), function(input, next) {
        return input.initialize(next);
      }, (function(_this) {
        return function(err) {
          debug("fieldset initialized");
          _this.form.emit('resize');
          if (err) {
            return typeof callback === "function" ? callback(err) : void 0;
          }
          return typeof callback === "function" ? callback(null) : void 0;
        };
      })(this));
    };

    Fieldset.prototype.save = function(state) {
      var base, cur, input, j, k, len, path, ref, s;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (!input.name) {
          continue;
        }
        s = input.save(state);
        if (Object.keys(s).length) {
          if (input.prefix != null) {
            path = input.prefix.slice(0);
            cur = state;
            while (path.length) {
              k = path.shift();
              if (!cur[k]) {
                cur[k] = {};
              }
              if ((base = cur[k]).nested == null) {
                base.nested = {};
              }
              cur = cur[k].nested;
            }
            cur[input.name] = s;
          } else {
            state[input.name] = s;
          }
        }
      }
      return state;
    };

    Fieldset.prototype.toJSON = function(json) {
      var cur, input, j, k, len, path, processValue, ref;
      processValue = function(input, value) {
        if (input.config.erasable) {
          if (value === '' || Array.isArray(value) && value.length === 0) {
            value = void 0;
          }
        }
        return value;
      };
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (input.name && input.enabled) {
          if (input.prefix != null) {
            path = input.prefix.slice(0);
            cur = json;
            while (path.length) {
              k = path.shift();
              if (!cur[k]) {
                cur[k] = {};
              }
              cur = cur[k];
            }
            cur[input.name] = processValue(input, input.toJSON());
          } else {
            json[input.name] = processValue(input, input.toJSON());
          }
        }
      }
      return json;
    };

    Fieldset.prototype.toConfig = function(json) {
      var cfg, group, input, j, l, len, len1, processedGroups, ref, ref1, ref2, ref3;
      processedGroups = [];
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (!(input.name && input.enabled)) {
          continue;
        }
        if (input.group != null) {
          if (input.group.group === null && (ref1 = input.group, indexOf.call(this.groups, ref1) >= 0) && (ref2 = input.group, indexOf.call(processedGroups, ref2) < 0)) {
            processedGroups.push(input.group);
            cfg = input.group.toConfig();
            if (Array.isArray(cfg)) {
              json.push.apply(json, cfg);
            } else {
              json.push(cfg);
            }
          }
          continue;
        }
        json.push(input.toConfig());
      }
      ref3 = this.groups;
      for (l = 0, len1 = ref3.length; l < len1; l++) {
        group = ref3[l];
        if (!(group.group === null && indexOf.call(processedGroups, group) < 0)) {
          continue;
        }
        cfg = group.toConfig();
        if (Array.isArray(cfg)) {
          json.push.apply(json, cfg);
        } else {
          json.push(cfg);
        }
      }
      return json;
    };

    Fieldset.prototype.toTemplate = function(ctrl) {
      var input, j, len, ref, template;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (!(input.name && input.enabled)) {
          continue;
        }
        template = input.toTemplate();
        if (template != null) {
          ctrl[input.name] = template;
        }
      }
      return ctrl;
    };

    Fieldset.prototype.validate = function() {
      var index, input, j, len, ref;
      ref = this.inputs;
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (!(input.enabled && input.validatable)) {
          continue;
        }
        input.validate();
        index = this.form.invalids.indexOf(input);
        if (input.errors.length) {
          if (index === -1) {
            this.form.invalids.push(input);
          }
        } else {
          if (index !== -1) {
            this.form.invalids.splice(index, 1);
          }
        }
      }
      return this;
    };


    /*
    	How fieldsets may look like:
    	
    	```coffeescript
    	[
    		value: "1" # value that must be selected in parent input to activate fieldset
    		config: [] # standard array of inputs
    	]
    	```
    	or
    	```coffeescript
    	[
    		value: "1"
    		config: "rpc://..." # RPC url
    	]
    	```
    	or
    	```coffeescript
    	[
    		value: "1"
    		config: # detail description
    			domain: "custom" # new domain (inherited by default)
    			store: "rpc://..." # array or url
    	]
    	```
     */

    Fieldset.createSubFieldsets = function(input, fieldsets, callback) {
      if (fieldsets != null ? fieldsets.length : void 0) {
        return async.map(fieldsets, function(fieldset, next) {
          var fs, j, l, len, len1, ref, ref1, ref2, ref3, selected;
          if ('function' === typeof fieldset.value) {
            ref = input.form.fieldsets;
            for (j = 0, len = ref.length; j < len; j++) {
              fs = ref[j];
              if (fs.parent === input && fs._valueOfParent === fieldset.value) {
                return next();
              }
            }
          } else {
            ref1 = input.form.fieldsets;
            for (l = 0, len1 = ref1.length; l < len1; l++) {
              fs = ref1[l];
              if (fs.parent === input && String(fs._valueOfParent) === String(fieldset.value)) {
                return next();
              }
            }
          }
          if (Array.isArray(fieldset.config)) {
            fieldset.config = {
              store: fieldset.config
            };
          } else if (typeof fieldset.config === 'string') {
            fieldset.config = {
              store: fieldset.config
            };
          }
          if (fieldset.independent) {
            selected = (input.value != null) && input.value.length > 0;
          } else {
            if ('function' === typeof fieldset.value) {
              selected = fieldset.value.call(input);
            } else if (input instanceof SelectInput && input.config.multiple) {
              selected = input.mode !== 'edit' && (ref2 = String(fieldset.value), indexOf.call(input.value, ref2) >= 0);
            } else {
              selected = input.mode !== 'edit' && String(fieldset.value) === String(input.value);
            }
          }
          fs = new Fieldset(input);
          fs._valueOfParent = fieldset.value;
          fs.config = fieldset.config.store;
          fs.domain = (ref3 = fieldset.config.domain) != null ? ref3 : input.fieldset.domain;
          fs.advanced = input.advanced;
          if (fs.advanced) {
            if (!input.form.advancedParametersVisible) {
              fs.expanded = false;
            }
          }
          input.on('change', function() {
            var ref4;
            if (fs.destroyed) {
              return;
            }
            fs.find('.i-template-invisible').removeClass('i-template-invisible');
            if (fieldset.independent) {
              fs.active = (input.value != null) && input.value.length > 0;
            } else {
              if ('function' === typeof fieldset.value) {
                fs.active = fieldset.value.call(input);
              } else if (input instanceof SelectInput && input.config.multiple) {
                fs.active = input.mode !== 'edit' && (ref4 = String(fieldset.value), indexOf.call(input.value, ref4) >= 0);
              } else {
                fs.active = input.mode !== 'edit' && String(fieldset.value) === String(input.value);
              }
            }
            return null;
          });
          input.on('update', function() {
            if (fs.destroyed) {
              return;
            }
            if (fieldset.independent) {
              return;
            }
            if (input instanceof SelectInput && input.config.multiple) {
              return;
            }
            if (('function' === typeof fieldset.value && fieldset.value.call(input)) || (input.mode !== 'edit' && String(fieldset.value) === String(input.value))) {
              return fs.rebuild(function() {
                input.enabled = false;
                return fs.initialize(function() {
                  return input.enabled = true;
                });
              });
            }
          });
          if (selected) {
            return fs.build(function() {
              return fs.initialize(function(err) {
                return next(err, fs);
              });
            });
          } else {
            fs.active = false;
            return next(null, fs);
          }
        }, function(err, fieldsets) {
          return typeof callback === "function" ? callback(err, fieldsets) : void 0;
        });
      } else {
        return typeof callback === "function" ? callback(null, []) : void 0;
      }
    };

    Fieldset.destroySubFieldsets = function(input) {
      var fieldsets, fs, j, len;
      fieldsets = input.form.fieldsets.filter(function(fs) {
        return fs.parent === input;
      });
      for (j = 0, len = fieldsets.length; j < len; j++) {
        fs = fieldsets[j];
        fs.destroy();
      }
      if (fieldsets.length) {
        input.form.emit('resize');
      }
      return null;
    };

    return Fieldset;

  })(SIMElement);


  /*
  @property {Array|String} config Form config - Array of inputs or remote URL.
   */

  Values = (function(superClass) {
    extend1(Values, superClass);

    Values.prototype._data = null;

    function Values(_domain) {
      this._domain = _domain;
      Values.__super__.constructor.call(this);
      this.reset();
    }


    /*
    	Value names might contain spaces so we need to make sure we don't pass those spaces into EventEmitter becuase it handlers
    	spaces inside event name as separator of multiple events.
     */

    Values.prototype.on = function(event, handler) {
      event = String(event).replace(/ /g, '-');
      return Values.__super__.on.call(this, event, handler);
    };

    Values.prototype.once = function(event, handler) {
      event = String(event).replace(/ /g, '-');
      return Values.__super__.once.call(this, event, handler);
    };

    Values.prototype.off = function(event, handler) {
      event = String(event).replace(/ /g, '-');
      return Values.__super__.off.call(this, event, handler);
    };


    /*
    	@returns {Array} List of changed keys.
     */

    Values.prototype.commit = function() {
      var changed, key, ref, ref1, ref2, value;
      changed = [];
      ref = this._data;
      for (key in ref) {
        value = ref[key];
        if (((ref1 = this._original[key]) != null ? ref1 : null) !== (value != null ? value : null)) {
          changed.push(key);
        }
      }
      this._original = Object.create(null);
      ref2 = this._data;
      for (key in ref2) {
        value = ref2[key];
        this._original[key] = value;
      }
      return changed;
    };

    Values.prototype.fetch = function(values) {
      var key, ref, value;
      if ((values != null) && 'object' === typeof values) {
        ref = Object.cloneDeep(values);
        for (key in ref) {
          value = ref[key];
          this._data[key] = value;
          this._original[key] = value;
        }
      }
      return this;
    };

    Values.prototype.get = function(input) {
      var data, k, prefix, ref;
      if (((ref = input.prefix) != null ? ref.length : void 0) > 0) {
        prefix = input.prefix.concat([input.name]);
        data = this._data;
        while (prefix.length) {
          k = prefix.shift();
          if (data == null) {
            return void 0;
          }
          data = data[k];
        }
        return data;
      } else {
        return this._data[input.name];
      }
    };

    Values.prototype.set = function(input, value) {
      var data, k, prefix, ref, ref1;
      if (JSON.stringify(this.get(input)) === JSON.stringify(value)) {
        return;
      }
      debug("value of '" + input.name + "' in domain '" + this._domain + "' changed from", this.get(input), 'to', value);
      if (((ref = input.prefix) != null ? ref.length : void 0) > 0) {
        prefix = input.prefix.slice(0);
        data = this._data;
        while (prefix.length) {
          k = prefix.shift();
          if (!data[k]) {
            data[k] = Object.create(null);
          }
          data = data[k];
        }
        data[input.name] = value;
      } else {
        this._data[input.name] = value;
      }
      this.emit(((ref1 = input.prefix) != null ? ref1 : []).concat([input.name]).join('|!|!|'), value, input);
      return value;
    };


    /*
    	TODO: Rollback now doesn't emit events for values nested in collections (with prefix)
     */

    Values.prototype.rollback = function() {
      var key, keys, ref, ref1, ref2, value;
      keys = Object.keys((ref = this._original) != null ? ref : {});
      ref1 = this._data;
      for (key in ref1) {
        value = ref1[key];
        if (!(indexOf.call(keys, key) < 0)) {
          continue;
        }
        debug("value of '" + key + "' in domain '" + this._domain + "' rolled back from", this._data[key], "to undefined");
        this._data[key] = void 0;
        this.emit(key, void 0);
      }
      if (this._original != null) {
        ref2 = this._original;
        for (key in ref2) {
          value = ref2[key];
          if (value !== this._data[key]) {
            debug("value of '" + key + "' in domain '" + this._domain + "' rolled back from", this._data[key], 'to', value);
            this._data[key] = value;
            this.emit(key, value);
          }
        }
      }
      return this;
    };

    Values.prototype.reset = function() {
      this._data = Object.create(null);
      this._original = Object.create(null);
      return this;
    };

    return Values;

  })(EventEmitter);


  /*
  Domains serves to logically separate inputs in one form.
   */

  Domains = (function() {
    Domains.prototype._configs = null;

    function Domains() {
      this._configs = {};
    }

    Domains.prototype.get = function(name) {
      return this._configs[name];
    };

    Domains.prototype.set = function(name, config, values) {
      var base;
      if ((base = this._configs)[name] == null) {
        base[name] = {
          defaults: {},
          dynamic: false,
          root: null,
          name: name,
          priority: 0,
          values: new Values(name).fetch(values)
        };
      }
      if (this._configs[name].config === config) {
        return this._configs[name];
      }
      this._configs[name].config = config;
      return this._configs[name];
    };

    Domains.prototype.primary = function() {
      var cfg, name, ref, results;
      ref = this._configs;
      results = [];
      for (name in ref) {
        cfg = ref[name];
        if ((cfg.config != null) || cfg.dynamic) {
          results.push(cfg);
        }
      }
      return results;
    };

    Domains.prototype.roots = function() {
      var cfg, name, ref, results;
      ref = this._configs;
      results = [];
      for (name in ref) {
        cfg = ref[name];
        if (cfg.root != null) {
          results.push(cfg);
        }
      }
      return results;
    };

    Domains.prototype.commit = function() {
      var cfg, name;
      return Array.prototype.concat.apply([], (function() {
        var ref, results;
        ref = this._configs;
        results = [];
        for (name in ref) {
          cfg = ref[name];
          results.push(cfg.values.commit());
        }
        return results;
      }).call(this));
    };

    Domains.prototype.rollback = function() {
      var cfg, name, ref;
      ref = this._configs;
      for (name in ref) {
        cfg = ref[name];
        cfg.values.rollback();
      }
      return null;
    };

    return Domains;

  })();


  /*
  Formula
  
  **Options**
  - **inline** - Use inline style
  - **defaults** - Collection of defaults for all nested inputs.
  - **company** - ID of the relevant company.
  - **pills** - Pills.
  - **samples** - Sample data.
  - **commonRpcParameters** - Common RPC parameters.
  - **coder** - Coder option to use as default for inputs.
  - **package** - Package config.
  - **config** - Module config.
  - **parentFieldset** - Used in arrays, when nested panel is created and needs to access parameters inside parent fieldset.
  
  @property {Object} options Options.
   */

  global.Formula = (function(superClass) {
    extend1(Formula, superClass);

    Formula.prototype.domains = null;

    Formula.prototype.fieldsets = null;

    Formula.prototype.options = null;

    Formula.prototype.invalids = null;

    Formula.prototype.built = false;

    Formula.prototype.destroyed = false;

    Formula.prototype._restore = null;

    Formula.prototype.__loadings = 0;

    Formula.prototype.__preview = false;

    Formula.prototype.__advancedParametersVisible = false;

    Formula.prototype.__hasAdvancedParameters = false;

    Formula.property('advancedParametersVisible', {
      get: function() {
        return this.__advancedParametersVisible;
      },
      set: function(value) {
        var fieldset, group, input, j, l, len, len1, len2, n, ref, ref1, ref2, ref3;
        if (((ref = this.options) != null ? ref.template : void 0) != null) {
          return;
        }
        if (value === this.__advancedParametersVisible) {
          return;
        }
        this.__advancedParametersVisible = value;
        ref1 = this.fieldsets;
        for (j = 0, len = ref1.length; j < len; j++) {
          fieldset = ref1[j];
          if (fieldset.advanced) {
            fieldset.expanded = value;
          }
          ref2 = fieldset.inputs;
          for (l = 0, len1 = ref2.length; l < len1; l++) {
            input = ref2[l];
            if (input.advanced) {
              if (value) {
                input.show();
              } else {
                input.hide();
              }
            }
          }
          ref3 = fieldset.groups;
          for (n = 0, len2 = ref3.length; n < len2; n++) {
            group = ref3[n];
            if (group.advanced) {
              if (value) {
                group.show();
              } else {
                group.hide();
              }
            }
          }
        }
        return this.emit('resize');
      }
    });

    Formula.property('hasAdvancedParameters', {
      get: function() {
        return this.__hasAdvancedParameters;
      },
      set: function(value) {
        if (value === this.__hasAdvancedParameters) {
          return;
        }
        this.__hasAdvancedParameters = value;
        if (value) {
          return this.emit('has_advanced_parameters');
        }
      }
    });

    Formula.property('config', {
      get: function() {
        var ref;
        return (ref = this.domains.get('default')) != null ? ref.config : void 0;
      },
      set: function(config) {
        if (config == null) {
          return;
        }
        return this.domains.set('default', config);
      }
    });

    Formula.property('loadings', {
      get: function() {
        return this.__loadings;
      },
      set: function(value) {
        if (value < 0) {
          value = 0;
        }
        if (value === this.__loadings) {
          return;
        }
        if (this.__loadings === 0 && value > 0) {
          this.emit('loading-start');
        }
        if (this.__loadings > 0 && value === 0) {
          this.emit('loading-stop');
        }
        this.__loadings = value;
        return this.emit('resize');
      }
    });

    Formula.property('preview', {
      get: function() {
        return this.__preview;
      },
      set: function(value) {
        var fieldset, j, len, ref, results;
        if (value === this.__preview) {
          return;
        }
        this.__preview = value;
        ref = this.fieldsets;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          fieldset = ref[j];
          results.push(fieldset.preview = value);
        }
        return results;
      }
    });

    Formula.property('values', {
      get: function() {
        var ref;
        return (ref = this.domains.get('default')) != null ? ref.values : void 0;
      },
      set: function(values) {
        var ref;
        if (values == null) {
          return;
        }
        return (ref = this.domains.get('default')) != null ? ref.values.fetch(values) : void 0;
      }
    });


    /*
     */

    function Formula(name1, title) {
      this.name = name1 != null ? name1 : '';
      this.title = title;
      if (this.name instanceof HTMLFormElement) {
        Formula.__super__.constructor.call(this, this.name);
        this.name = 'Inplace Formula';
      } else {
        Formula.__super__.constructor.call(this, 'form');
      }
      this.addClass('i-formula');
      this.fieldsets = [];
      this.invalids = [];
      this.domains = new Domains;
      this.fieldsets.add = function() {
        return new Fieldset(this);
      };
      this.on('submit', function(event) {
        event.preventDefault();
        return false;
      });
    }


    /*
    	Build form from config.
    	
    	@callback [callback] Callback to call when build is complete.
     */

    Formula.prototype.build = function(callback) {
      var ref;
      this.built = false;
      if ((ref = this.options) != null ? ref.inline : void 0) {
        this.addClass('i-inline-formula');
      }
      debug("build form '" + this.name + "' with options", this.options);
      return async.mapSeries(this.domains.primary().sortOn('priority', function(a, b) {
        return a - b;
      }), (function(_this) {
        return function(domain, next) {
          var fs;
          if (_this.destroyed) {
            return;
          }
          debug("build domain '" + domain.name + "' from config", domain.config);
          fs = domain.root = new Fieldset(_this);
          fs.domain = domain.name;
          fs.config = domain.config;
          fs.dynamic = domain.dynamic;
          if (domain.name === 'default' && (_this.title != null) && domain.config.length) {
            fs.legend = _this.title;
          }
          return fs.build(function(err) {
            if (err) {
              return typeof callback === "function" ? callback(err) : void 0;
            }
            return fs.initialize(function(err) {
              if (err) {
                return typeof callback === "function" ? callback(err) : void 0;
              }
              debug("domain '" + domain.name + "' built");
              return next();
            });
          });
        };
      })(this), (function(_this) {
        return function(err) {
          return setImmediate(function() {
            if (_this.destroyed) {
              return;
            }
            if (err) {
              return typeof callback === "function" ? callback(err) : void 0;
            }
            _this.built = true;
            debug("form '" + _this.name + "' built");
            return typeof callback === "function" ? callback(null) : void 0;
          });
        };
      })(this));
    };


    /*
    	@returns {Array} Array of post-change actions.
     */

    Formula.prototype.commit = function() {
      var action, actions, changed, fs, input, j, l, len, len1, len2, n, output, ref, ref1, ref2, ref3;
      changed = this.domains.commit();
      output = [];
      ref = this.fieldsets;
      for (j = 0, len = ref.length; j < len; j++) {
        fs = ref[j];
        ref1 = fs.inputs;
        for (l = 0, len1 = ref1.length; l < len1; l++) {
          input = ref1[l];
          if (!(ref2 = input.name, indexOf.call(changed, ref2) >= 0)) {
            continue;
          }
          actions = (ref3 = input.config.on) != null ? ref3.change : void 0;
          if (actions != null) {
            if (!Array.isArray(action)) {
              actions = [actions];
            }
            for (n = 0, len2 = actions.length; n < len2; n++) {
              action = actions[n];
              debug("input '" + input.name + "' created post-submit action '" + action + "'.");
              if (typeof action === 'string') {
                output.push({
                  type: action
                });
              } else {
                output.push(action);
              }
            }
          }
        }
      }
      return output;
    };


    /*
    	Destroy fieldset.
     */

    Formula.prototype.destroy = function() {
      this.destroyed = true;
      while (this.fieldsets.length) {
        this.fieldsets[0].destroy();
      }
      return this.remove();
    };


    /*
    	Sets focus to first element in the form.
     */

    Formula.prototype.focusFirst = function() {
      var d, fieldset, fieldsets;
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.domains.roots();
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          d = ref[j];
          results.push(d.root);
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        if (fieldset.focusFirst()) {
          return this;
        }
      }
      return this;
    };


    /*
    	Used by form submits.
     */

    Formula.prototype.isValid = function() {
      var diff, parent, ref, top;
      if (this.loadings > 0) {
        return false;
      }
      this.invalids.clear();
      this.validate();
      if (this.invalids.length === 0) {
        return true;
      }
      parent = (ref = this.closest('.i-panel-scroll')) != null ? ref : sim('body');
      top = this.invalids[0].offset().top - parent.offset().top;
      if (top < 0) {
        parent.animate({
          scrollTop: parent.scrollTop() + top - 5
        });
      } else if (top + this.invalids[0].outerHeight() > parent.height()) {
        diff = (top + this.invalids[0].outerHeight()) - parent.height();
        parent.animate({
          scrollTop: parent.scrollTop() + diff + 5
        });
      }
      return false;
    };


    /*
    	Event handling tweaks.
     */

    Formula.prototype.on = function(event, selector, handler) {
      if ('function' === typeof selector) {
        handler = selector;
        selector = void 0;
      }
      if (event === 'has_advanced_parameters' && this.hasAdvancedParameters) {
        handler.call(this);
        return this;
      }
      return Formula.__super__.on.call(this, event, selector, handler);
    };

    Formula.prototype.once = function(event, selector, handler) {
      if ('function' === typeof selector) {
        handler = selector;
        selector = void 0;
      }
      if (event === 'has_advanced_parameters' && this.hasAdvancedParameters) {
        handler.call(this);
        return this;
      }
      return Formula.__super__.once.call(this, event, selector, handler);
    };


    /*
    	Get current state.
     */

    Formula.prototype.save = function() {
      var fs, j, len, ref, state;
      state = {};
      ref = this.fieldsets;
      for (j = 0, len = ref.length; j < len; j++) {
        fs = ref[j];
        if (fs.active) {
          fs.save(state);
        }
      }
      if (Object.keys(state).length === 0) {
        return void 0;
      }
      return state;
    };


    /*
    	Restore form from saved state.
    	
    	@param {Object} state Saved state.
     */

    Formula.prototype.restore = function(state) {
      return this._restore = state;
    };


    /*
     */

    Formula.prototype.rollback = function() {
      this.domains.rollback();
      return this;
    };


    /*
    	Serialize form values.
    	
    	@returns {Object}
     */

    Formula.prototype.toJSON = function(domain) {
      var d, fieldset, fieldsets, fs, j, json, len, ref, ref1;
      if (domain == null) {
        domain = 'default';
      }
      json = {};
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.domains.roots();
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          d = ref[j];
          results.push(d.root);
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        if (fieldset.domain === domain) {
          fieldset.toJSON(json);
        }
        ref = this.fieldsets;
        for (j = 0, len = ref.length; j < len; j++) {
          fs = ref[j];
          if (((ref1 = fs.parent) != null ? ref1.fieldset : void 0) === fieldset && fs.active) {
            fieldsets.push(fs);
          }
        }
      }
      return json;
    };


    /*
    	Return same structure that created the form.
    	
    	@returns {Array}
     */

    Formula.prototype.toConfig = function(domain) {
      var d, fieldset, fieldsets, fs, j, json, len, ref, ref1;
      if (domain == null) {
        domain = 'default';
      }
      json = [];
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.domains.roots();
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          d = ref[j];
          results.push(d.root);
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        if (fieldset.domain === domain) {
          fieldset.toConfig(json);
        }
        ref = this.fieldsets;
        for (j = 0, len = ref.length; j < len; j++) {
          fs = ref[j];
          if (((ref1 = fs.parent) != null ? ref1.fieldset : void 0) === fieldset && fs.active) {
            fieldsets.push(fs);
          }
        }
      }
      if (json.length === 0) {
        return void 0;
      }
      return json;
    };


    /*
    	Returns structure for usage in templates.
     */

    Formula.prototype.toTemplate = function() {
      var ctrl, fieldset, fieldsets, fs, j, len, ref, ref1;
      ctrl = {};
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.fieldsets;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          fieldset = ref[j];
          if (!fieldset.parent && fieldset.active) {
            results.push(fieldset);
          }
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        fieldset.toTemplate(ctrl);
        ref = this.fieldsets;
        for (j = 0, len = ref.length; j < len; j++) {
          fs = ref[j];
          if (((ref1 = fs.parent) != null ? ref1.fieldset : void 0) === fieldset && fs.active) {
            fieldsets.push(fs);
          }
        }
      }
      return ctrl;
    };


    /*
    	Validate form.
    	
    	@returns {Formula}
     */

    Formula.prototype.validate = function() {
      var fieldset, fieldsets, fs, j, len, ref, ref1;
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.fieldsets;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          fieldset = ref[j];
          if (!fieldset.parent && fieldset.active) {
            results.push(fieldset);
          }
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        fieldset.validate();
        ref = this.fieldsets;
        for (j = 0, len = ref.length; j < len; j++) {
          fs = ref[j];
          if (((ref1 = fs.parent) != null ? ref1.fieldset : void 0) === fieldset && fs.active) {
            fieldsets.push(fs);
          }
        }
      }
      return this;
    };


    /*
     */

    Formula.prototype.getDataValueOfSelectedItem = function(name, dataName) {
      var fieldset, fieldsets, fs, input, j, l, len, len1, ref, ref1, ref2;
      fieldsets = (function() {
        var j, len, ref, results;
        ref = this.fieldsets;
        results = [];
        for (j = 0, len = ref.length; j < len; j++) {
          fieldset = ref[j];
          if (!fieldset.parent && fieldset.active) {
            results.push(fieldset);
          }
        }
        return results;
      }).call(this);
      while ((fieldset = fieldsets.shift())) {
        ref = fieldset.inputs;
        for (j = 0, len = ref.length; j < len; j++) {
          input = ref[j];
          if (input.enabled && input instanceof SelectInput && input.name === name) {
            return input.getDataValue(dataName);
          }
        }
        ref1 = this.fieldsets;
        for (l = 0, len1 = ref1.length; l < len1; l++) {
          fs = ref1[l];
          if (((ref2 = fs.parent) != null ? ref2.fieldset : void 0) === fieldset && fs.active) {
            fieldsets.push(fs);
          }
        }
      }
      return null;
    };

    return Formula;

  })(SIMElement);

  InplaceFormula = (function(superClass) {
    extend1(InplaceFormula, superClass);

    function InplaceFormula() {
      InplaceFormula.__super__.constructor.apply(this, arguments);
      this.addClass('i-inplace-formula');
    }

    return InplaceFormula;

  })(Formula);

  sim.registerComponent('inplace-formula', InplaceFormula);

  SEMANTIC_TYPES = {
    file: {
      label: imt.l('formula', 'semantic.file.label'),
      icon: 'files-o',
      fields: ['name', 'data']
    }
  };

  Group = (function(superClass) {
    extend1(Group, superClass);

    Group.prototype.advanced = false;

    Group.prototype.fieldset = null;

    Group.prototype.group = null;

    Group.prototype.name = null;

    function Group(fieldset1, group, config1) {
      var ref;
      this.fieldset = fieldset1;
      this.config = config1;
      Group.__super__.constructor.call(this, 'div');
      this.addClass('i-group');
      this.name = this.config.name;
      this.form = this.fieldset.form;
      if (group != null) {
        this.group = group;
      }
      if (((ref = this.fieldset.parent) != null ? ref.group : void 0) === group) {
        this.appendTo(this.fieldset);
      } else {
        this.appendTo(group != null ? group : this.fieldset);
      }
      this.attr('data-label', this.config.label);
      if (this.config.advanced === true) {
        this.advanced = true;
        this.form.hasAdvancedParameters = true;
        if (!this.form.advancedParametersVisible) {
          this.hide();
        }
      }
    }

    Group.prototype.initialize = function(done) {
      return setImmediate(done);
    };

    Group.prototype.toConfig = function() {
      var cfg, fieldset, fieldsets, fs, group, input, j, l, len, len1, len2, n, ref, ref1, ref2, spec;
      spec = [];
      fieldsets = [this.fieldset];
      while (fieldsets.length) {
        fieldset = fieldsets.pop();
        ref = fieldset.groups;
        for (j = 0, len = ref.length; j < len; j++) {
          group = ref[j];
          if (!(group.group === this)) {
            continue;
          }
          cfg = group.toConfig();
          if (Array.isArray(cfg)) {
            spec.push.apply(spec, cfg);
          } else {
            spec.push(cfg);
          }
        }
        ref1 = fieldset.inputs;
        for (l = 0, len1 = ref1.length; l < len1; l++) {
          input = ref1[l];
          if (!(input.name && input.enabled && input.group === this)) {
            continue;
          }
          ref2 = this.form.fieldsets;
          for (n = 0, len2 = ref2.length; n < len2; n++) {
            fs = ref2[n];
            if (fs.parent === input && fs.active) {
              fieldsets.push(fs);
            }
          }
          spec.push(input.toConfig());
        }
      }
      return {
        name: this.name,
        type: 'collection',
        label: this.config.label,
        required: this.config.required,
        sequence: this.config.sequence,
        meta: this.config.meta,
        spec: spec
      };
    };

    return Group;

  })(SIMElement);

  SemanticGroup = (function(superClass) {
    extend1(SemanticGroup, superClass);

    function SemanticGroup(fieldset, group, config) {
      var ref;
      SemanticGroup.__super__.constructor.call(this, fieldset, group, config);
      this.addClass('i-group-semantic');
      this.attr('data-label', SEMANTIC_TYPES[this.config.mean].label);
      if ((ref = this.form.options) != null ? ref.template : void 0) {
        this.hide();
      }
    }

    SemanticGroup.prototype.initialize = function(done) {
      var choose, filled, inputs, matchFound, ref, ref1, ref2, ref3, required, self, values;
      self = this;
      matchFound = false;
      inputs = self.fieldset.inputs.filter(function(item) {
        return item.config.mean != null;
      });
      values = (ref = (ref1 = this.form.options) != null ? (ref2 = ref1.pills) != null ? (ref3 = ref2.semantic) != null ? ref3.filter((function(_this) {
        return function(item) {
          return item.type === _this.config.mean;
        };
      })(this)) : void 0 : void 0 : void 0) != null ? ref : [];
      filled = inputs.some(function(input) {
        return (input.value != null) && input.value !== "";
      });
      required = inputs.some(function(input) {
        return input.config.required;
      });
      if (required) {
        this.addClass('i-required');
      }
      choose = function(map) {
        var input, j, len, results;
        results = [];
        for (j = 0, len = inputs.length; j < len; j++) {
          input = inputs[j];
          if (map[input.config.mean] != null) {
            results.push(input.value = "{{" + map[input.config.mean] + "}}");
          } else {
            results.push(input.value = null);
          }
        }
        return results;
      };
      if (values.length) {
        this.prepend(sim.ul('.list-unstyled', function() {
          var fn, j, len, value;
          fn = (function(_this) {
            return function(value) {
              return _this.li(".theme-" + (value.node["package"].theme.toHex().substr(1)), function() {
                var i, l, len1, matches;
                this.text(value.node["package"].label + " - " + value.node.config.label);
                if (filled) {
                  matches = true;
                  for (l = 0, len1 = inputs.length; l < len1; l++) {
                    i = inputs[l];
                    if (!(i.value !== ("{{" + value.map[i.config.mean] + "}}"))) {
                      continue;
                    }
                    matches = false;
                    break;
                  }
                  if (matches) {
                    matchFound = true;
                    this.addClass('active');
                  }
                } else if (required && !matchFound) {
                  matchFound = true;
                  this.addClass('active');
                  choose(value.map);
                }
                this.on('click', function() {
                  this.parent().children().removeClass('active');
                  this.addClass('active');
                  self.removeClass('i-group-semantic-manual');
                  self.form.emit('resize');
                  choose(value.map);
                  return false;
                });
                this.on('mouseenter', function() {
                  var ref4;
                  return (ref4 = value.node) != null ? ref4.enlarged = true : void 0;
                });
                return this.on('mouseleave', function() {
                  var ref4;
                  return (ref4 = value.node) != null ? ref4.enlarged = false : void 0;
                });
              });
            };
          })(this);
          for (j = 0, len = values.length; j < len; j++) {
            value = values[j];
            fn(value);
          }
          this.li(function() {
            this.text(imt.l('formula', 'buttons.map'));
            if (!matchFound && filled) {
              this.addClass('active');
              self.addClass('i-group-semantic-manual');
            }
            return this.on('click', function() {
              this.parent().children().removeClass('active');
              this.addClass('active');
              self.addClass('i-group-semantic-manual');
              self.form.emit('resize');
              return false;
            });
          });
          if (!required) {
            return this.prepend(sim.li(function() {
              this.text(imt.l('formula', 'fields.empty'));
              if (!filled) {
                this.addClass('active');
              }
              return this.on('click', function() {
                var input, l, len1;
                this.parent().children().removeClass('active');
                this.addClass('active');
                self.removeClass('i-group-semantic-manual');
                self.form.emit('resize');
                for (l = 0, len1 = inputs.length; l < len1; l++) {
                  input = inputs[l];
                  input.value = null;
                }
                return false;
              });
            }));
          }
        }));
      } else {
        self.addClass('i-group-semantic-manual');
      }
      return SemanticGroup.__super__.initialize.call(this, done);
    };

    SemanticGroup.prototype.toConfig = function() {
      var input, j, len, ref, results;
      ref = this.fieldset.inputs;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        input = ref[j];
        if (input.name && input.enabled && input.group === this) {
          results.push(input.toConfig());
        }
      }
      return results;
    };

    return SemanticGroup;

  })(Group);

  sim('@inplace-formula').each(function() {
    var build, cfg, ref, ref1, submitStyle, values;
    cfg = {
      url: this.data('url'),
      save: this.data('save'),
      submit: this.data('submit'),
      options: {
        inline: (ref = this.data('inline')) === 'yes' || ref === 'true' || ref === '1',
        placeholders: (ref1 = this.data('placeholders')) === 'yes' || ref1 === 'true' || ref1 === '1'
      }
    };
    submitStyle = this.data('submit-style');
    values = {};
    this.children('input[type="hidden"]').each(function(index, item) {
      values[item.attr('name')] = item.attr('value');
      return item.remove();
    });
    build = function(cfg, form) {
      return Loader.load(cfg.url, {
        headers: {
          'x-imt-remote-formula': 'yes'
        }
      }, function(err, data) {
        var base, button, submit;
        if (err) {
          return new Alert(err.message).show();
        }
        button = null;
        submit = form._submitForm = function() {
          var elm, file, formData, j, key, l, len, len1, ref2, value;
          if (button == null) {
            button = this;
          }
          if (form.isValid()) {
            button.prop('disabled', true);
            if (data.multipart) {
              formData = new FormData;
              ref2 = form.toJSON();
              for (key in ref2) {
                value = ref2[key];
                if (value instanceof FileList) {
                  for (j = 0, len = value.length; j < len; j++) {
                    file = value[j];
                    formData.append(key + "[]", file);
                  }
                } else if (Array.isArray(value)) {
                  for (l = 0, len1 = value.length; l < len1; l++) {
                    elm = value[l];
                    formData.append(key + "[]", elm);
                  }
                } else {
                  formData.append(key, value);
                }
              }
            } else {
              formData = form.toJSON();
            }
            Loader.load(cfg.url, {
              method: 'POST',
              data: formData,
              headers: {
                'x-imt-remote-formula': 'yes'
              }
            }, function(err, directives) {
              var f, rebuilding, ref3;
              if (err) {
                button.prop('disabled', false);
                return new Alert(err.message).show();
              }
              rebuilding = false;
              if (directives.formula) {
                if (directives.formula.rebuild) {
                  rebuilding = true;
                  button.remove();
                  f = new Formula(cfg.name);
                  form.replaceWith(f);
                  build(extend(cfg, directives.formula.rebuild), f);
                }
                if (directives.formula.success) {
                  if ((ref3 = cfg.success) != null) {
                    ref3.apply(form, directives.formula.success);
                  }
                }
                delete directives.formula;
              }
              if (false !== AJAXDirectives.process(form, directives)) {
                if (!rebuilding) {
                  return form.__dom.reset();
                }
              }
            });
          }
          return false;
        };
        form.config = data.config;
        form.values = data.values;
        form.values = values;
        form.options = cfg.options;
        if ((base = form.options).company == null) {
          base.company = cfg.company;
        }
        form.build(function(err) {
          var btn, ref2;
          if (err) {
            return new Alert(err.message).show();
          }
          if (cfg.submit === 'false') {
            return;
          }
          btn = sim.button(".btn.btn-" + (submitStyle || 'primary') + ".btn-block.i-formula-submit", function() {
            this.attr('type', 'button');
            this.text(cfg.save || imt.l('base', 'common.save'));
            this.appendTo(form);
            button = this;
            this.on('click', submit);
            form.on('loading-start', (function(_this) {
              return function() {
                return _this.prop('disabled', true);
              };
            })(this));
            return form.on('loading-stop', (function(_this) {
              return function() {
                return _this.prop('disabled', false);
              };
            })(this));
          });
          if ((ref2 = cfg.options) != null ? ref2.inline : void 0) {
            return form.div('.row').div('.col-8.ml-auto').append(btn);
          }
        });
        return form.on('keydown', function(event) {
          if (event.keyCode === 13 && sim(event.target).is('input, select')) {
            return submit();
          }
        });
      });
    };
    return build(cfg, this);
  });


  /*
   */

  Input = (function(superClass) {
    extend1(Input, superClass);

    Input.prototype.config = null;

    Input.prototype.name = '';

    Input.prototype.prefix = null;

    Input.prototype.form = null;

    Input.prototype.fieldset = null;

    Input.prototype.errors = null;

    Input.prototype.hints = null;

    Input.prototype.validatable = true;

    Input.prototype.initialized = false;

    Input.prototype.advanced = false;

    Input.prototype.built = false;

    Input.prototype.group = null;

    Input.prototype.destroyed = false;

    Input.prototype._input = null;

    Input.prototype._coder = null;

    Input.prototype._focusOwner = null;

    Input.prototype._inputGroup = null;

    Input.prototype._inputRoot = null;

    Input.prototype._rpcPanel = null;

    Input.prototype._disableableSwitch = null;

    Input.prototype._templaterSwitch = null;

    Input.prototype._templaterDefaultSwitch = null;

    Input.prototype._templaterHelp = null;

    Input.prototype._loadingError = null;

    Input.prototype._editableHelp = null;

    Input.prototype._propagateChanges = true;

    Input.prototype.__mode = 'chose';

    Input.prototype.__preview = false;

    Input.property('active', {
      get: function() {
        var parent;
        parent = this.fieldset;
        while (parent) {
          if (parent instanceof Fieldset) {
            if (!parent.active) {
              return false;
            }
            parent = parent.parent;
            continue;
          } else if (parent instanceof Input) {
            if (!parent.fieldset.active) {
              return false;
            }
            parent = parent.fieldset;
            continue;
          }
          return false;
        }
        return true;
      }
    });

    Input.property('enabled', {
      get: function() {
        return this._input.enabled;
      },
      set: function(value) {
        var ref;
        this._input.enabled = value;
        return (ref = this._coder) != null ? ref.enabled = value : void 0;
      }
    });

    Input.property('mode', {
      get: function() {
        return this.__mode;
      },
      set: function(value) {
        var ref, ref1, val;
        if (value === this.__mode) {
          return;
        }
        this.emit('before_mode_change');
        val = this.value;
        this.__mode = value;
        this._loadingError = null;
        if (value === 'edit') {
          this.find('.i-mode-switch .switch').data('status', 'on').addClass('active');
          this._coder.insertBefore(this._inputRoot);
          this._inputRoot.detach();
          this._focusOwner = this._coder._root;
          this._coder.focus();
          this._coder.value = this._toCoder(val);
          if ((ref = this._editableHelp) != null) {
            ref.show();
          }
          this.addClass('i-edit-mode');
        } else {
          this.find('.i-mode-switch .switch').data('status', 'off').removeClass('active');
          this.removeClass('i-edit-mode');
          this._inputRoot.insertBefore(this._coder);
          this._coder.detach();
          this._focusOwner = this._input;
          this._input.focus();
          if ((ref1 = this._editableHelp) != null) {
            ref1.hide();
          }
          if (this.initialized) {
            this._input.value = this._fromCoder(val);
          } else {
            this.initialize();
          }
        }
        this._changed();
        this.emit('change');
        this.emit('mode_change');
        return this.form.emit('resize');
      }
    });

    Input.property('preview', {
      get: function() {
        return this.__preview;
      },
      set: function(value) {
        var ref;
        if (value === this.__preview) {
          return;
        }
        this.__preview = value;
        return (ref = this._coder) != null ? ref.preview = value : void 0;
      }
    });

    Input.property('restored', {
      get: function() {
        var k, path, ref, ref1, ref2, restore;
        restore = this.form._restore;
        if (!restore) {
          return {};
        }
        if (this.prefix) {
          path = this.prefix.slice(0);
          while (path.length) {
            k = path.shift();
            restore = (ref = restore[k]) != null ? ref.nested : void 0;
            if (!restore) {
              return (ref1 = this.form._restore[this.name]) != null ? ref1 : {};
            }
          }
        }
        return (ref2 = restore[this.name]) != null ? ref2 : {};
      }
    });

    Input.property('imlVariable', {
      get: function() {
        var group, path, ref;
        if (((ref = this.form.options) != null ? ref.moduleId : void 0) == null) {
          return null;
        }
        path = [];
        group = this.group;
        while (group) {
          path.push(IML._escape(group.name));
          group = group.group;
        }
        path.push(IML._escape(this.name));
        return this.form.options.moduleId + "." + (path.join('.'));
      }
    });


    /*
    	@param {Fieldset} fieldset Fieldset to attach input to.
    	@param {*} [appendTo] DOM element to append input to.
     */

    function Input(fieldset1, group) {
      var ref, ref1;
      this.fieldset = fieldset1;
      Input.__super__.constructor.call(this, 'div', '.form-group');
      this.errors = [];
      this.hints = [];
      this.id = "input_" + (guid());
      this.form = this.fieldset.form;
      this.fieldset.inputs.push(this);
      if (group != null) {
        this.group = group;
      }
      if (((ref = this.fieldset.parent) != null ? ref.group : void 0) === group) {
        this.appendTo(this.fieldset);
      } else {
        this.appendTo(group != null ? group : this.fieldset);
      }
      if ((ref1 = this.form.options) != null ? ref1.inline : void 0) {
        this.addClass('row');
      }
      this.on('focusin', (function(_this) {
        return function(event) {
          var ref2;
          if ((ref2 = _this._focusOwner) != null ? ref2.is(event.target) : void 0) {
            return _this.addClass('i-focus');
          }
        };
      })(this));
      this.on('focusout', (function(_this) {
        return function(event) {
          var ref2;
          if ((ref2 = _this._focusOwner) != null ? ref2.is(event.target) : void 0) {
            return _this.removeClass('i-focus');
          }
        };
      })(this));
    }


    /*
    	Used to convert values when switching between coder and gui input.
     */

    Input.prototype._toCoder = function(value) {
      return String(value != null ? value : '');
    };

    Input.prototype._fromCoder = function(value) {
      return value;
    };


    /*
    	Dispatched when any child input changes its value.
     */

    Input.prototype._changed = function(validate) {
      var value;
      if (validate == null) {
        validate = true;
      }
      if (!this.built) {
        return;
      }
      if (!this.initialized && this.mode !== 'edit') {
        return;
      }
      value = this.value;
      this[(value == null) || value === '' ? 'addClass' : 'removeClass']('i-empty');
      if (this._propagateChanges) {
        this.form.domains.get(this.fieldset.domain).values.set(this, value);
      }
      if (validate) {
        this.validate();
      }
      return true;
    };


    /*
    	Sets focus to the input.
     */

    Input.prototype._focus = function() {
      return this._input.focus();
    };


    /*
    	Used by `build` to create common wrapper.
    	
    	Options:
    	- **label** - If 'false', label is hidden
    	- **group** - If 'true', input-group is created even if no buttons or disableable is set
    	
    	@param {Array} [buttons] Buttons to add to input.
    	@param {Function} builder Input builder.
     */

    Input.prototype._wrap = function(options, builder) {
      var btn, buttons, ref, ref1, ref2, self;
      if (options instanceof Function) {
        builder = options;
        options = void 0;
      }
      self = this;
      buttons = (ref = (ref1 = this.config.buttons) != null ? ref1.clone() : void 0) != null ? ref : [];
      if (this.config.editable && this instanceof EditableInput) {
        this.div('.i-mode-switch', function() {
          return this.div('.switch.switch-xs', function() {
            this["switch"]();
            return this.on('change', function() {
              return self.mode = this.data('status') === 'on' ? 'edit' : 'chose';
            });
          });
        });
        sim.textarea('.form-control', function() {
          var ref2, ref3, ref4, ref5;
          this.attr('id', self.id + "_editable");
          this.attr('name', self.name);
          if (self.config.required) {
            this.prop('required', true);
          }
          self._coder = this.coder({
            name: self.name,
            type: self.config.type,
            samples: (ref2 = self.config.samples) != null ? ref2 : (ref3 = self.form.options) != null ? ref3.samples : void 0,
            pills: (ref4 = self.config.pills) != null ? ref4 : (ref5 = self.form.options) != null ? ref5.pills : void 0,
            showErasePill: self.config.showErasePill
          });
          return this.on('change', function() {
            return self._changed();
          });
        });
      }
      if (this.config.rpc) {
        btn = {
          label: this.config.rpc.label,
          on: {
            click: function() {
              var form, panel;
              if (self._rpcPanel != null) {
                return;
              }
              panel = self._rpcPanel = new Panel(this);
              panel.offsetX = 5;
              panel.title = self.config.rpc.label;
              panel.loading = true;
              form = new Formula(self.config.rpc.label);
              form.on('resize', panel._resize);
              form.config = self.config.rpc.parameters;
              form.options = {
                parentFieldset: self.fieldset
              };
              form.build(function(err) {
                if (err) {
                  return panel.warn(err.message);
                }
                panel.loading = false;
                panel.content = form;
                return form.focusFirst();
              });
              sim.button('.btn.btn-outline-secondary.btn-sm', function() {
                this.attr('type', 'button');
                this.text(imt.l('base', 'common.cancel'));
                this.appendTo(panel._footer);
                return this.on('click', function() {
                  return panel.close();
                });
              });
              sim.button('.btn.btn-primary.btn-sm', function() {
                this.attr('type', 'button');
                this.text(imt.l('base', 'common.ok'));
                this.appendTo(panel._footer);
                return this.on('click', (function(_this) {
                  return function() {
                    var body, k, ref2, v;
                    if (form.isValid()) {
                      panel.loading = true;
                      body = self.fieldset.path;
                      ref2 = form.toJSON();
                      for (k in ref2) {
                        v = ref2[k];
                        body[k] = v;
                      }
                      return Loader.load(self.config.rpc.url, {
                        data: body
                      }, function(err, values) {
                        if (err) {
                          return panel.warn(err.message, form);
                        }
                        if (!Array.isArray(values)) {
                          return panel.warn(imt.l('formula', 'errors.invalidresponse'), form);
                        }
                        if (values.length === 0) {
                          return panel.warn(imt.l('formula', 'errors.nomatches'), form);
                        }
                        _this.hide();
                        if (values.length === 1) {
                          panel.close();
                          if (self instanceof ArrayInput) {
                            return self.addItem(values[0].value);
                          } else {
                            self.value = values[0].value;
                            self._changed();
                            return self.emit('change');
                          }
                        } else {
                          panel.loading = false;
                          return panel.content = sim.div('.list-group', function() {
                            var item, j, len, results;
                            results = [];
                            for (j = 0, len = values.length; j < len; j++) {
                              item = values[j];
                              results.push((function(_this) {
                                return function(item) {
                                  return _this.a('.list-group-item', function() {
                                    var ref3;
                                    this.attr('href', '#');
                                    this.text((ref3 = item.label) != null ? ref3 : item.value);
                                    return this.on('click', function(event) {
                                      panel.close();
                                      if (self instanceof ArrayInput) {
                                        self.addItem(item.value);
                                      } else {
                                        self.value = item.value;
                                        self._changed();
                                        self.emit('change');
                                      }
                                      event.preventDefault();
                                      return false;
                                    });
                                  });
                                };
                              })(this)(item));
                            }
                            return results;
                          });
                        }
                      });
                    }
                  };
                })(this));
              });
              return panel.once('destroy', function() {
                form.destroy();
                return self._rpcPanel = null;
              });
            }
          }
        };
        buttons.push(btn);
      }
      if ((this.config.label != null) && this.config.label !== '' && !((ref2 = this.form.options) != null ? ref2.placeholders : void 0)) {
        this.label('.form-control-label', function() {
          var ref3;
          this.attr('for', self.id);
          if ((ref3 = self.form.options) != null ? ref3.inline : void 0) {
            this.addClass('col-form-label col-4 text-right');
          }
          if ((options != null ? options.label : void 0) === false) {
            return this.data('label-edit', self.config.label);
          } else {
            return this.text(self.config.label);
          }
        });
      }
      return this.div(function() {
        var ctrl, ref3, ref4, ref5, ref6;
        if ((ref3 = self.form.options) != null ? ref3.inline : void 0) {
          this.addClass('col-8');
        }
        if (self.config.disableable || (buttons != null ? buttons.length : void 0) || (options != null ? options.group : void 0)) {
          this.div('.input-group.align-items-stretch', function() {
            self._inputGroup = this;
            self._focusOwner = builder.call(this);
            if (self.config.disableable) {
              if (self.restored.disabled === true) {
                self.enabled = false;
              } else if (self.restored.disabled === false) {
                self.enabled = true;
              } else if (self.config.disabled === true) {
                self.enabled = false;
              } else if (self.config.disabled === false) {
                self.enabled = true;
              }
              this.span('.input-group-addon', function() {
                this.input(function() {
                  self._disableableSwitch = this;
                  this.attr('type', 'checkbox');
                  this.prop('checked', self.enabled);
                  return this.on('change', (function(_this) {
                    return function() {
                      return self.enabled = _this.checked;
                    };
                  })(this));
                });
                return this.on('click', function(event) {
                  event.stopPropagation();
                  return true;
                });
              });
            }
            if (buttons != null ? buttons.length : void 0) {
              this.span('.input-group-btn.d-flex', function() {
                var btnGroup, button, j, len, results;
                btnGroup = this;
                results = [];
                for (j = 0, len = buttons.length; j < len; j++) {
                  button = buttons[j];
                  if (Array.isArray(button)) {
                    this.button('.btn.btn-outline-secondary.dropdown-toggle.border-radius-0', function() {
                      this.attr('type', 'button');
                      this.attr('data-toggle', 'dropdown');
                      if (button["class"] != null) {
                        return this.addClass(button["class"]);
                      }
                    });
                    this.div('.dropdown-menu.dropdown-menu-right', function() {
                      var butt, l, len1, results1;
                      results1 = [];
                      for (l = 0, len1 = button.length; l < len1; l++) {
                        butt = button[l];
                        results1.push(this.a('.dropdown-item', function() {
                          var fce, fn, name, ref4;
                          this.attr('href', '#');
                          this.text(butt.label);
                          if (butt["class"] != null) {
                            this.addClass(butt["class"]);
                          }
                          if (butt.on) {
                            ref4 = butt.on;
                            fn = (function(_this) {
                              return function(fce) {
                                return _this.on(name, function(event) {
                                  if (this.hasClass('disabled')) {
                                    event.stopPropagation();
                                    return;
                                  }
                                  return fce.call(self, event);
                                });
                              };
                            })(this);
                            for (name in ref4) {
                              fce = ref4[name];
                              fn(fce);
                            }
                          }
                          if ('function' === typeof butt.enabled) {
                            return btnGroup.toJquery().on('show.bs.dropdown', (function(_this) {
                              return function() {
                                return _this[butt.enabled.call(self) ? 'removeClass' : 'addClass']('disabled');
                              };
                            })(this));
                          }
                        }));
                      }
                      return results1;
                    });
                    continue;
                  }
                  results.push(this.button('.btn.btn-outline-secondary', function() {
                    var fce, name, ref4, results1;
                    this.attr('type', 'button');
                    this.text(button.label);
                    if (button["class"] != null) {
                      this.addClass(button["class"]);
                    }
                    if (button.on) {
                      ref4 = button.on;
                      results1 = [];
                      for (name in ref4) {
                        fce = ref4[name];
                        results1.push(this.on(name, fce.bind(self)));
                      }
                      return results1;
                    }
                  }));
                }
                return results;
              });
            }
            return this.on('click', function(event) {
              if (self.config.disableable && !self.enabled) {
                self._disableableSwitch.checked = true;
                self.enabled = true;
                return self._focusOwner.focus();
              }
            });
          });
        } else {
          self._focusOwner = builder.call(this);
          if (self.config.disabled) {
            self.enabled = false;
          }
        }
        self._help_block = this.div('.invalid-feedback');
        self._hint_block = this.div('.hint-block');
        if ((ref4 = self.form.options) != null ? ref4.templater : void 0) {
          ctrl = (ref5 = self.form.options) != null ? ref5.templater[self.name] : void 0;
          this.div('.i-templater-block', function() {
            this.label(function() {
              this.input(function() {
                self._templaterSwitch = this;
                this.attr('type', 'checkbox');
                if (ctrl != null) {
                  this.prop('checked', true);
                }
                return this.on('change', (function(_this) {
                  return function() {
                    self._templaterDefaultSwitch.enabled = _this.prop('checked');
                    self._templaterHelp.visible = _this.prop('checked');
                    return self.form.emit('resize');
                  };
                })(this));
              });
              return this.span().text(' ' + imt.l('formula', 'templates.inwizard'));
            });
            this.label(function() {
              this.input(function() {
                self._templaterDefaultSwitch = this;
                this.attr('type', 'checkbox');
                this.enabled = ctrl != null;
                if ((ctrl != null ? ctrl["default"] : void 0) === true) {
                  return this.prop('checked', true);
                }
              });
              return this.span().text(' ' + imt.l('formula', 'templates.asdefault'));
            });
            return this.textarea('.form-control', function() {
              var ref6;
              self._templaterHelp = this;
              this.attr('placeholder', imt.l('base', 'common.help'));
              this.visible = ctrl != null;
              return this.val((ref6 = ctrl != null ? ctrl.help : void 0) != null ? ref6 : '');
            });
          });
        }
        if (self.config.help) {
          this.div('.form-text', function() {
            var help;
            help = format(self.config.help, 'markdown');
            return this.html(help);
          });
        }
        if ((ref6 = self.config.editable) != null ? ref6.help : void 0) {
          return self._editableHelp = this.div('.form-text', function() {
            var help;
            help = format(self.config.editable.help, 'markdown');
            this.hide();
            return this.html(help);
          });
        }
      });
    };


    /*
    	Build input from config.
     */

    Input.prototype.build = function() {
      var base, key, ref, ref1, ref2, ref3, ref4, self, value;
      self = this;
      ref2 = (ref = (ref1 = this.form.domains.get(this.fieldset.domain)) != null ? ref1.defaults : void 0) != null ? ref : {};
      for (key in ref2) {
        value = ref2[key];
        if ((base = this.config)[key] == null) {
          base[key] = value;
        }
      }
      debug("build input '" + this.config.name + "' from config", this.config);
      if (this instanceof EditableInput && this.config.mappable) {
        this.config.editable = this.config.mappable;
      }
      this.name = this.config.name;
      if (this.config.prefix != null) {
        this.prefix = this.config.prefix;
      }
      if (((ref3 = this.form.options) != null ? ref3.template : void 0) != null) {
        if (this.form.options.template[this.name] != null) {
          if (this.form.options.template[this.name].help) {
            sim.div('.i-template-help-block', function() {
              var help;
              help = format(self.form.options.template[self.name].help, 'markdown');
              this.html(help);
              return this.insertBefore(self);
            });
          }
        } else {
          this.addClass('i-template-invisible');
        }
      } else {
        if (!this.fieldset.advanced && this.config.advanced === true) {
          this.form.hasAdvancedParameters = true;
          this.advanced = true;
          if (!this.form.advancedParametersVisible) {
            this.hide();
          }
        }
      }
      if (this.config.required) {
        this.addClass('i-required');
      }
      return this.form.domains.get(this.fieldset.domain).values.on(((ref4 = this.prefix) != null ? ref4 : []).concat([this.name]).join('|!|!|'), (function(_this) {
        return function(value, sender) {
          if (_this.destroyed) {
            return;
          }
          if (sender !== _this) {
            _this._propagateChanges = false;
            _this.value = value;
            return _this._propagateChanges = true;
          }
        };
      })(this));
    };


    /*
    	Destroy input.
     */

    Input.prototype.destroy = function() {
      var ref;
      this.destroyed = true;
      if ((ref = this._coder) != null) {
        ref.destroy();
      }
      Fieldset.destroySubFieldsets(this);
      return this.remove();
    };


    /*
    	Initialize input with initial value.
     */

    Input.prototype.initialize = function(callback) {
      var base, domain, value;
      if (this.name === 'maxResults' && /\{\{l:panels\.module\.maxresults@inspector\}\}/.test(this.config.help)) {
        if ((base = this.config)["default"] == null) {
          base["default"] = 2;
        }
      }
      domain = this.form.domains.get(this.fieldset.domain);
      value = domain.values.get(this);
      if ((value == null) && (this.config["default"] != null)) {
        value = domain.values.set(this, this.config["default"]);
      }
      debug("initialize input '" + this.name + "' with value", value);
      this.value = value;
      if ((this.value == null) || this.value === '') {
        this.addClass('i-empty');
      }
      if (this.config.validate != null) {
        this.validatable = this.config.validate;
      }
      if (this.config.visible != null) {
        if ('string' === typeof this.config.visible) {
          this.config.visible = -1 !== this.config.visible.indexOf(imt.env);
        }
        this.visible = this.config.visible;
      }
      this.initialized = true;
      return typeof callback === "function" ? callback(null) : void 0;
    };

    Input.prototype.inspect = function() {
      return "[Input(type=" + this.config.type + ")]";
    };


    /*
    	Get current state.
     */

    Input.prototype.save = function() {
      var state;
      state = {};
      if (this.config.disableable) {
        state.disabled = !this.enabled;
      }
      if (this.config.editable && this instanceof EditableInput) {
        state.mode = this.mode;
      }
      return state;
    };

    Input.prototype.toJSON = function() {
      return this.value;
    };

    Input.prototype.toConfig = function() {
      return Input.toConfig(this.config);
    };

    Input.toConfig = function(config, includeNested) {
      var key, obj, value;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = {};
      for (key in config) {
        value = config[key];
        if (!(key !== 'help' && key !== 'coder' && key !== 'buttons' && key !== 'on' && key !== 'advanced' && key !== 'editable' && key !== 'default' && key !== 'prefix' && key !== 'erasable' && key !== 'showErasePill' && key !== 'mappable')) {
          continue;
        }
        if (key === 'required' && value === false) {
          continue;
        }
        obj[key] = value;
      }
      if (obj.label === obj.name) {
        delete obj.label;
      }
      return obj;
    };

    Input.prototype.toTemplate = function() {
      var ctrl, ref;
      if (!this._templaterSwitch) {
        return void 0;
      }
      if ((ref = this.config.type) === 'account' || ref === 'device' || ref === 'hook' || ref === 'keychain' || ref === 'udt') {
        this._templaterSwitch.prop('checked', true);
        this._templaterDefaultSwitch.prop('checked', false);
      }
      if (this._templaterSwitch.is(':checked')) {
        ctrl = {};
        if (this._templaterDefaultSwitch.is(':checked')) {
          ctrl["default"] = true;
        }
        if (this._templaterHelp.val()) {
          ctrl.help = this._templaterHelp.val();
        }
        return ctrl;
      }
      return void 0;
    };

    Input.prototype.validate = function() {
      var ast, ex, hints, prev, ref, ref1, ref2, ref3, ref4, ref5, value;
      if (!this.validatable) {
        return;
      }
      this.errors.clear();
      this.hints.clear();
      value = this.value;
      if (this._loadingError != null) {
        this.errors.push(this._loadingError);
      } else {
        if (this.config.required && ((value == null) || value === '')) {
          this.errors.push(imt.l('formula', 'errors.required', {
            data: {
              field: (ref = this.config.label) != null ? ref : this.config.name
            }
          }));
        } else if (value) {
          try {
            ast = IML.parse(value);
            if (ast && ast.length === 1 && ast[0].type === 'text') {
              this._validate(value);
            } else if (ast && ast.length) {
              this._validateIML(ast);
            }
          } catch (error) {
            ex = error;
            console.error(ex);
          }
        }
      }
      if (this.errors.length) {
        if ((ref1 = this.addClass('i-has-error')._input) != null) {
          ref1.addClass('is-invalid');
        }
        if (this.hasClass('i-template-invisible')) {
          prev = this;
          while (prev) {
            prev.removeClass('i-template-invisible');
            prev = (ref2 = prev.closest('fieldset')) != null ? ref2.prev('.i-template-invisible') : void 0;
          }
        }
      } else {
        if ((ref3 = this.removeClass('i-has-error')._input) != null) {
          ref3.removeClass('is-invalid');
        }
      }
      hints = this.hints;
      if ((ref4 = this._hint_block) != null) {
        ref4.empty()["do"](function() {
          var hint, j, len;
          for (j = 0, len = hints.length; j < len; j++) {
            hint = hints[j];
            this.a(function() {
              this.attr('href', '#');
              this.text(hint.text);
              return this.on('click', hint.action);
            });
          }
          return null;
        });
      }
      if ((ref5 = this._help_block) != null) {
        ref5.text(this.errors.join('\n'));
      }
      return this.form.emit('resize');
    };

    Input.prototype._validate = function() {};

    Input.prototype._validateIML = function() {};

    Input.prototype.disable = function() {
      return this.enabled = false;
    };

    Input.prototype.enable = function() {
      return this.enabled = true;
    };

    return Input;

  })(SIMElement);

  EditableInput = (function(superClass) {
    extend1(EditableInput, superClass);

    function EditableInput() {
      return EditableInput.__super__.constructor.apply(this, arguments);
    }

    return EditableInput;

  })(Input);

  global.ArrayInput = (function(superClass) {
    extend1(ArrayInput, superClass);

    function ArrayInput() {
      return ArrayInput.__super__.constructor.apply(this, arguments);
    }

    ArrayInput.prototype._items = null;

    ArrayInput.prototype._openedPanel = null;

    ArrayInput.property('value', {
      get: function() {
        if (this.mode === 'edit') {
          return IML.stringify(IML.replace(IML.parse(this._coder._input.value), 'keyword', 'erase', 'erasearray'));
        } else {
          return this._items.children('li').map(function(item) {
            return item.data('value');
          });
        }
      },
      set: function(value) {
        var index, item, j, l, len, len1, ref;
        if (this.mode === 'edit') {
          if ('string' === typeof value) {
            return this._coder.value = IML.stringify(IML.replace(IML.parse(value), 'keyword', 'erasearray', 'erase'));
          } else {
            return this._coder.value = value;
          }
        } else {
          this._items.empty();
          if (!Array.isArray(value)) {
            if ((value != null) && this.config.editable) {
              this.mode = 'edit';
              this._coder.value = value;
            }
            return;
          }
          if (!this.initialized) {
            for (index = j = 0, len = value.length; j < len; index = ++j) {
              item = value[index];
              this.addItem(item, null, (ref = this.restored.items) != null ? ref[index] : void 0);
            }
          } else {
            for (l = 0, len1 = value.length; l < len1; l++) {
              item = value[l];
              this.addItem(item);
            }
          }
          this._changed();
          return this.emit('change');
        }
      }
    });

    ArrayInput.prototype._openPanel = function(relative, value, restore) {
      var config, domain, form, panel, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, self, spec;
      if (this._openedPanel != null) {
        return;
      }
      self = this;
      panel = this._openedPanel = new Panel(relative);
      panel.offsetX = 5;
      panel.title = value ? ((ref = this.config.labels) != null ? ref.edit : void 0) || imt.l('formula', 'buttons.edititem') : ((ref1 = this.config.labels) != null ? ref1.add : void 0) || imt.l('formula', 'buttons.additem');
      panel.loading = true;
      form = new Formula(imt.l('formula', 'buttons.additem'));
      form.on('resize', panel._resize);
      form.options = {
        pills: (ref2 = this.form.options) != null ? ref2.pills : void 0,
        parentFieldset: this.fieldset,
        timezone: (ref3 = this.form.options) != null ? ref3.timezone : void 0
      };
      form.restore(restore);
      if (Array.isArray(this.config.spec) && this.config.spec.length) {
        config = this.config.spec;
      } else if (!Array.isArray(this.config.spec) && 'object' === typeof this.config.spec) {
        if (this.config.spec.type === 'collection') {
          config = this.config.spec.spec;
        } else {
          spec = Object.clone(this.config.spec);
          spec.name = 'value';
          if (spec.type == null) {
            spec.type = 'text';
          }
          if (spec.label == null) {
            spec.label = 'Value';
          }
          config = [spec];
        }
      } else {
        config = [
          {
            name: 'text',
            label: ((ref4 = this.config.labels) != null ? ref4.field : void 0) || 'Text'
          }
        ];
      }
      domain = form.domains.set(this.fieldset.domain, config);
      domain.defaults.coder = (ref5 = this.form.domains.get(this.fieldset.domain)) != null ? (ref6 = ref5.defaults) != null ? ref6.coder : void 0 : void 0;
      domain.defaults.editable = (ref7 = this.form.domains.get(this.fieldset.domain)) != null ? (ref8 = ref7.defaults) != null ? ref8.coder : void 0 : void 0;
      domain.defaults.mappable = (ref9 = this.form.domains.get(this.fieldset.domain)) != null ? (ref10 = ref9.defaults) != null ? ref10.mappable : void 0 : void 0;
      domain.defaults.erasable = (ref11 = this.form.domains.get(this.fieldset.domain)) != null ? (ref12 = ref11.defaults) != null ? ref12.erasable : void 0 : void 0;
      domain.defaults.showErasePill = (ref13 = this.form.domains.get(this.fieldset.domain)) != null ? (ref14 = ref13.defaults) != null ? ref14.showErasePill : void 0 : void 0;
      if (value != null) {
        if (Array.isArray(this.config.spec) && this.config.spec.length) {
          domain.values.fetch(value);
        } else if (!Array.isArray(this.config.spec) && 'object' === typeof this.config.spec) {
          if (this.config.spec.type === 'collection') {
            domain.values.fetch(value);
          } else {
            domain.values.fetch({
              value: value
            });
          }
        } else {
          domain.values.fetch({
            text: value
          });
        }
      }
      form.build(function(err) {
        if (err) {
          return panel.warn(err.message);
        }
        panel.loading = false;
        panel.content = form;
        return form.focusFirst();
      });
      sim.button('.btn.btn-outline-secondary.btn-sm', function() {
        this.attr('type', 'button');
        this.text(imt.l('base', 'common.cancel'));
        this.appendTo(panel._footer);
        return this.on('click', function() {
          return panel.close();
        });
      });
      sim.button('.btn.btn-primary.btn-sm', function() {
        this.attr('type', 'button');
        this.text(value ? imt.l('base', 'common.save') : imt.l('base', 'common.add'));
        this.appendTo(panel._footer);
        return this.on('click', function() {
          if (form.isValid()) {
            if (Array.isArray(self.config.spec) && self.config.spec.length) {
              self.addItem(form.toJSON(self.fieldset.domain), (value != null ? relative : null), form.save());
            } else if (!Array.isArray(self.config.spec) && 'object' === typeof self.config.spec) {
              if (self.config.spec.type === 'collection') {
                self.addItem(form.toJSON(self.fieldset.domain), (value != null ? relative : null), form.save());
              } else {
                self.addItem(form.toJSON(self.fieldset.domain).value, (value != null ? relative : null), form.save());
              }
            } else {
              self.addItem(form.toJSON(self.fieldset.domain).text, (value != null ? relative : null), form.save());
            }
            panel.close();
            self._changed();
            return self.emit('change');
          }
        });
      });
      form.once('has_advanced_parameters', function() {
        return sim.label('.i-advanced-parameters', function() {
          this.appendTo(panel._footer);
          this.input(function() {
            var ref15;
            this.attr('type', 'checkbox');
            this.on('change', (function(_this) {
              return function() {
                return form.advancedParametersVisible = _this.is(':checked');
              };
            })(this));
            if (((ref15 = relative.metadata) != null ? ref15.advanced : void 0) === true) {
              form.advancedParametersVisible = true;
              return this.prop('checked', true);
            }
          });
          this.write(imt.l('formula', 'buttons.showadvanced'));
          if (form.built) {
            this.addClass('i-yellow-fade');
            return delay(3000, (function(_this) {
              return function() {
                return _this.removeClass('i-yellow-fade');
              };
            })(this));
          }
        });
      });
      return panel.once('destroy', function() {
        form.destroy();
        return self._openedPanel = null;
      });
    };

    ArrayInput.prototype.addItem = function(value, replace, restore) {
      var coder, item, pills, ref, ref1, ref2, self;
      if (value == null) {
        return;
      }
      self = this;
      coder = ((ref = this.form.domains.get(this.fieldset.domain)) != null ? (ref1 = ref.defaults) != null ? ref1.coder : void 0 : void 0) || false;
      pills = (ref2 = this.form.options) != null ? ref2.pills : void 0;
      item = sim.li('.clearfix', function() {
        var i, j, l, labels, len, len1, ref3, ref4, ref5;
        this.data('value', value);
        this.data('restore', restore);
        if (Array.isArray(self.config.spec) && self.config.spec.length) {
          labels = Object.create(null);
          ref3 = self.config.spec;
          for (j = 0, len = ref3.length; j < len; j++) {
            i = ref3[j];
            if (i.name && i.label) {
              labels[i.name] = i.label;
            }
          }
          this.pre(function() {
            var base, ref4;
            this.text(JSON.stringify((ref4 = typeof (base = self.config).visualize === "function" ? base.visualize(value) : void 0) != null ? ref4 : value));
            return this.visualizer({
              type: (coder ? 'mixed' : 'json'),
              labels: labels,
              pills: pills
            }).on('resize', self.form.emit.bind(self.form, 'resize'));
          });
        } else if (!Array.isArray(self.config.spec) && 'object' === typeof self.config.spec && ((ref4 = self.config.spec.type) === 'array' || ref4 === 'collection')) {
          labels = Object.create(null);
          if (self.config.spec.type === 'collection') {
            ref5 = self.config.spec.spec;
            for (l = 0, len1 = ref5.length; l < len1; l++) {
              i = ref5[l];
              if (i.name && i.label) {
                labels[i.name] = i.label;
              }
            }
          }
          this.pre(function() {
            var base, ref6;
            this.text(JSON.stringify((ref6 = typeof (base = self.config).visualize === "function" ? base.visualize(value) : void 0) != null ? ref6 : value));
            return this.visualizer({
              type: (coder ? 'mixed' : 'json'),
              labels: labels,
              pills: pills
            }).on('resize', self.form.emit.bind(self.form, 'resize'));
          });
        } else {
          if (coder) {
            this.pre(function() {
              this.text(value);
              return this.visualizer({
                type: 'iml',
                pills: pills
              }).on('resize', self.form.emit.bind(self.form, 'resize'));
            });
          } else {
            this.text(value);
          }
        }
        return this.prepend(sim.span('.float-right', function() {
          this.i('.btn.fas.fa-chevron-up', function() {
            return this.on('click', function(event) {
              var prev;
              event.preventDefault();
              event.stopPropagation();
              prev = item.prev('li');
              if (!prev) {
                return false;
              }
              prev.before(item);
              self._changed();
              self.emit('change');
              return false;
            });
          });
          this.i('.btn.fas.fa-chevron-down', function() {
            return this.on('click', function(event) {
              var next;
              event.preventDefault();
              event.stopPropagation();
              next = item.next('li');
              if (!next) {
                return false;
              }
              next.after(item);
              self._changed();
              self.emit('change');
              return false;
            });
          });
          this.i('.btn.far.fa-edit', function() {
            return this.on('click', function(event) {
              event.preventDefault();
              event.stopPropagation();
              self._openPanel(item, item.data('value'), item.data('restore'));
              return false;
            });
          });
          return this.i('.btn.far.fa-trash', function() {
            return this.on('click', function(event) {
              event.preventDefault();
              event.stopPropagation();
              item.detach();
              self._changed();
              self.emit('change');
              return false;
            });
          });
        }));
      });
      if (replace != null) {
        replace.before(item).remove();
      } else {
        this._items.append(item);
      }
      this.form.emit('resize');
      return this;
    };


    /*
    	Build ArrayInput from config.
     */

    ArrayInput.prototype.build = function() {
      var block, ref, ref1, self;
      ArrayInput.__super__.build.call(this);
      self = this;
      this.addClass('i-array-composer');
      this._wrap(function() {
        this.div('.form-control.d-block', function() {
          var add;
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          this.attr('tabindex', 0);
          this.ul('.list-unstyled.i-array-list', function() {
            return self._items = this;
          });
          add = this.button('.btn.btn-transparent.btn-xs.text-primary', function() {
            var ref;
            this.attr('type', 'button');
            this.text(((ref = self.config.labels) != null ? ref.add : void 0) || imt.l('formula', 'buttons.additem'));
            this.prepend(sim.i('.fas.fa-fw.fa-plus-circle.mr-1'));
            return this.on('click', (function(_this) {
              return function() {
                return self._openPanel(_this);
              };
            })(this));
          });
          Object.defineProperty(this, 'enabled', {
            get: function() {
              return !this.attr('disabled');
            },
            set: function(value) {
              this.attr('disabled', !value);
              add.enabled = value;
              if (value) {
                return this.attr('tabindex', 0);
              } else {
                return this.attr('tabindex', -1);
              }
            }
          });
          return this.on('click', function() {
            if (self._items.children('li').length === 0) {
              return self._openPanel(add);
            }
          });
        });
        return self._input;
      });
      if (this.config.editable && (this.restored.mode != null)) {
        this.mode = this.restored.mode;
      } else if (this.config.mode != null) {
        this.mode = this.config.mode;
      }
      block = sim.ul('.i-validations-block.list-unstyled');
      if (((ref = self.config.validate) != null ? ref.minItems : void 0) > 0) {
        block.li('.i-validation-higher').text(imt.l('formula', 'hints.containleast', {
          data: {
            value: self.config.validate.minItems
          }
        }));
      }
      if (((ref1 = self.config.validate) != null ? ref1.maxItems : void 0) > 0) {
        block.li('.i-validation-lower').text(imt.l('formula', 'hints.containmost', {
          data: {
            value: self.config.validate.maxItems
          }
        }));
      }
      if (block.children().length) {
        this.append(block);
      }
      return this.built = true;
    };

    ArrayInput.prototype.save = function() {
      var state;
      state = ArrayInput.__super__.save.call(this);
      if (this.mode !== 'edit') {
        state.items = this._items.children('li').map(function(item) {
          return item.data('restore');
        });
      }
      return state;
    };

    ArrayInput.prototype.toConfig = function() {
      return ArrayInput.toConfig(this.config);
    };

    ArrayInput.toConfig = function(config, includeNested) {
      var obj, ref, spec;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = Input.toConfig(config, includeNested);
      if (Array.isArray(obj.spec)) {
        obj.spec = (function() {
          var j, len, ref, ref1, results;
          ref = obj.spec;
          results = [];
          for (j = 0, len = ref.length; j < len; j++) {
            spec = ref[j];
            results.push(((ref1 = INPUT_TYPES[spec.type]) != null ? ref1 : Input).toConfig(spec, true));
          }
          return results;
        })();
      } else if ('object' === typeof obj.spec) {
        if (obj.spec.type === 'collection') {
          spec = (function() {
            var j, len, ref, ref1, results;
            ref = obj.spec.spec;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
              spec = ref[j];
              results.push(((ref1 = INPUT_TYPES[spec.type]) != null ? ref1 : Input).toConfig(spec, true));
            }
            return results;
          })();
          if (obj.spec.sequence) {
            obj.spec = {
              type: 'collection',
              sequence: true,
              spec: spec
            };
          } else {
            obj.spec = spec;
          }
        } else {
          obj.spec = ((ref = INPUT_TYPES[obj.spec.type]) != null ? ref : Input).toConfig(obj.spec, true);
        }
      }
      return obj;
    };

    ArrayInput.prototype._validateIML = function(ast) {
      var compatible, out, self, source;
      return;
      compatible = function(source, target) {
        var j, len, ref, ref1, srcpar, tarpar;
        if (Array.isArray(source)) {
          source = {
            type: 'collection',
            spec: source
          };
        }
        if (Array.isArray(target)) {
          target = {
            type: 'collection',
            spec: target
          };
        }
        if (source.type === 'array' || target.type === 'array') {
          return true;
        }
        if (source.type !== target.type) {
          return false;
        }
        if (source.type === 'collection') {
          ref = target.spec;
          for (j = 0, len = ref.length; j < len; j++) {
            tarpar = ref[j];
            if (tarpar.required) {
              srcpar = source.spec.find(function(p) {
                return p.name === tarpar.name;
              });
              if (!srcpar) {
                return false;
              }
            }
            if ((ref1 = tarpar.type) === 'array' || ref1 === 'collection') {
              if (!compatible(srcpar.spec, tarpar.spec)) {
                return false;
              }
            }
          }
        }
        return true;
      };
      self = this;
      out = IML.outputs(ast);
      if (out.type === 'variable') {
        source = Inspector.seek(out.name, 'interface');
        if ((source != null ? source.type : void 0) === 'array') {
          if (!compatible(source.spec, this.config.spec)) {
            return this.hints.push({
              text: imt.l('formula', 'hints.incomparray'),
              action: function() {
                var focused;
                focused = Inspector.seek(self.form.options.moduleId);
                if (!focused) {
                  return;
                }
                return Repository.get('builtin', 'BasicFeeder', function(err, iterator) {
                  if (err) {
                    return new Alert(err.message).show();
                  }
                  return Repository.get('builtin', 'BasicAggregator', function(err, aggregator) {
                    var j, len, node, ref;
                    if (err) {
                      return new Alert(err.message).show();
                    }
                    iterator.id = Inspector.instance.scenario.idSequence++;
                    iterator.move(focused.x, focused.y);
                    iterator.mapper = {
                      array: "{{" + out.name + "}}"
                    };
                    Inspector.instance._surface.stage.attach(iterator);
                    aggregator.id = Inspector.instance.scenario.idSequence++;
                    aggregator.move(focused.x + 300, focused.y);
                    aggregator.parameters = {
                      feeder: iterator.id,
                      target: self.imlVariable
                    };
                    Inspector.instance._surface.stage.attach(aggregator);
                    iterator.filter = focused.filter;
                    focused.filter = void 0;
                    focused._inputLink.node2 = iterator;
                    Inspector.instance._surface.stage.attach(new Surface.Link(iterator, aggregator));
                    Inspector.instance._surface.stage.attach(new Surface.Link(aggregator, focused));
                    self.value = "{{" + aggregator.id + ".array}}";
                    ref = aggregator.nextAll();
                    for (j = 0, len = ref.length; j < len; j++) {
                      node = ref[j];
                      new Surface.Animation(node, {
                        x: {
                          plus: 600
                        }
                      }, {
                        interrupt: true,
                        duration: 200,
                        completeOnInterrupt: true,
                        easing: 'easeOutCirc'
                      });
                    }
                    return null;
                  });
                });
              }
            });
          }
        }
      }
    };

    return ArrayInput;

  })(EditableInput);

  INPUT_TYPES['array'] = ArrayInput;

  global.CheckInput = (function(superClass) {
    extend1(CheckInput, superClass);

    function CheckInput() {
      return CheckInput.__super__.constructor.apply(this, arguments);
    }

    CheckInput.property('value', {
      get: function() {
        if (this.mode === 'edit') {
          return this._coder._input.value;
        } else {
          if (this.config.required) {
            return this._input.is(':checked');
          } else {
            return this._input.value;
          }
        }
      },
      set: function(value) {
        if (this.mode === 'edit') {
          return this._coder.value = value != null ? value : '';
        } else {
          if (this.config.required) {
            if (value === 'true' || value === true) {
              return this._input.prop('checked', true);
            } else {
              return this._input.prop('checked', false);
            }
          } else {
            return this._input.value = value;
          }
        }
      }
    });


    /*
    	Build TextInput from config.
     */

    CheckInput.prototype.build = function() {
      var self;
      CheckInput.__super__.build.call(this);
      self = this;
      this.addClass('i-checkbox');
      this._wrap(function() {
        if (self.config.required) {
          this.div('.form-check', function() {
            self._inputRoot = this;
            return this.label('.custom-control.custom-checkbox', function() {
              this.input('.custom-control-input', function() {
                self._input = this;
                this.attr('id', self.id);
                this.attr('name', self.name);
                this.attr('type', 'checkbox');
                return this.on('change blur', function() {
                  return self._changed();
                });
              });
              this.span('.custom-control-indicator');
              return this.span('.custom-control-description').html(' ' + format(self.config.label, 'markdown'));
            });
          });
        } else {
          this.div('.form-check', function() {
            self._input = this;
            self._inputRoot = this;
            this.attr('id', self.id);
            this.attr('name', self.name);
            this.label('.custom-control.custom-radio', function() {
              this.input('.custom-control-input', function() {
                self._radioTrue = this;
                this.attr('name', self.name + "_" + self.id);
                this.attr('type', 'radio');
                this.attr('value', 'true');
                return this.on('change blur', function() {
                  return self._changed();
                });
              });
              this.span('.custom-control-indicator');
              return this.span('.custom-control-description').text(imt.l('base', 'common.yes'));
            });
            this.label('.custom-control.custom-radio', function() {
              this.input('.custom-control-input', function() {
                self._radioFalse = this;
                this.attr('name', self.name + "_" + self.id);
                this.attr('type', 'radio');
                this.attr('value', 'false');
                return this.on('change blur', function() {
                  return self._changed();
                });
              });
              this.span('.custom-control-indicator');
              return this.span('.custom-control-description').text(imt.l('base', 'common.no'));
            });
            this.label('.custom-control.custom-radio', function() {
              this.input('.custom-control-input', function() {
                self._radioNull = this;
                this.attr('name', self.name + "_" + self.id);
                this.attr('type', 'radio');
                this.attr('value', '');
                return this.on('change blur', function() {
                  return self._changed();
                });
              });
              this.span('.custom-control-indicator');
              return this.span('.custom-control-description').text(imt.l('formula', 'fields.undefined'));
            });
            return Object.defineProperty(this, 'value', {
              get: function() {
                if (self._radioTrue.is(':checked')) {
                  return true;
                } else if (self._radioFalse.is(':checked')) {
                  return false;
                } else {
                  return void 0;
                }
              },
              set: function(value) {
                if (value === 'true' || value === true) {
                  self._radioTrue.prop('checked', true);
                  self._radioFalse.prop('checked', false);
                  return self._radioNull.prop('checked', false);
                } else if (value === 'false' || value === false) {
                  self._radioTrue.prop('checked', false);
                  self._radioFalse.prop('checked', true);
                  return self._radioNull.prop('checked', false);
                } else {
                  self._radioTrue.prop('checked', false);
                  self._radioFalse.prop('checked', false);
                  return self._radioNull.prop('checked', true);
                }
              }
            });
          });
        }
        return self._input;
      });
      if (this.config.editable && (this.restored.mode != null)) {
        this.mode = this.restored.mode;
      } else if (this.config.mode != null) {
        this.mode = this.config.mode;
      }
      return this.built = true;
    };


    /*
    	Initialize CheckInput with initial value.
    	
    	@callback [callback] Callback.
     */

    CheckInput.prototype.initialize = function(callback) {
      var fieldsets, self;
      self = this;
      CheckInput.__super__.initialize.call(this);
      if (this.config.nested) {
        fieldsets = [
          {
            config: this.config.nested,
            value: true
          }
        ];
        if (this.config.editable) {
          fieldsets.push({
            config: nestedToEditMode(Object.cloneDeep(this.config.nested)),
            value: EDIT_MODE_ONLY
          });
        }
        return Fieldset.createSubFieldsets(this, fieldsets, callback);
      }
      return typeof callback === "function" ? callback(null) : void 0;
    };

    CheckInput.prototype.toConfig = function() {
      return CheckInput.toConfig(this.config);
    };

    CheckInput.toConfig = function(config, includeNested) {
      var obj, spec;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = Input.toConfig(config, includeNested);
      delete obj['nested'];
      if (includeNested && Array.isArray(config.nested)) {
        obj.nested = (function() {
          var j, len, ref, ref1, results;
          ref = config.nested;
          results = [];
          for (j = 0, len = ref.length; j < len; j++) {
            spec = ref[j];
            results.push(((ref1 = INPUT_TYPES[spec.type]) != null ? ref1 : Input).toConfig(spec, true));
          }
          return results;
        })();
      }
      return obj;
    };

    return CheckInput;

  })(EditableInput);

  INPUT_TYPES['checkbox'] = CheckInput;

  INPUT_TYPES['boolean'] = CheckInput;

  global.CreditCardInput = (function(superClass) {
    extend1(CreditCardInput, superClass);

    function CreditCardInput() {
      return CreditCardInput.__super__.constructor.apply(this, arguments);
    }

    CreditCardInput.property('value', {
      get: function() {
        return {
          card: this._input.value,
          month: this._month.value,
          year: this._year.value,
          cvv: this._cvv.value
        };
      },
      set: function(value) {
        var ref, ref1, ref2, ref3;
        this._input.value = (ref = value != null ? value.card : void 0) != null ? ref : '';
        this._month.value = (ref1 = value != null ? value.month : void 0) != null ? ref1 : '01';
        this._year.value = (ref2 = value != null ? value.year : void 0) != null ? ref2 : new Date().getFullYear().toString();
        this._cvv.value = (ref3 = value != null ? value.cvv : void 0) != null ? ref3 : '';
        return this._changed();
      }
    });


    /*
    	Build TextInput from config.
     */

    CreditCardInput.prototype.build = function() {
      var self;
      CreditCardInput.__super__.build.call(this);
      self = this;
      this.addClass('i-credit-card');
      this._wrap(function() {
        this.input('.form-control', function() {
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          this.attr('name', self.name);
          this.attr('type', 'text');
          if (self.config.required) {
            this.prop('required', true);
          }
          return this.on((browser.ie ? 'keypress paste drop input blur' : 'input blur'), function() {
            return self._changed();
          });
        });
        this.div('.row', function() {
          this.div('.col-xs-2', function() {
            return this.select('.form-control', function() {
              var j, month;
              self._month = this;
              this.attr('type', 'text');
              if (self.config.required) {
                this.prop('required', true);
              }
              this.on((browser.ie ? 'keypress paste drop input blur' : 'input blur'), function() {
                return self._changed();
              });
              for (month = j = 1; j <= 12; month = ++j) {
                this.option(function() {
                  this.attr('value', "" + ('0'.repeat(2 - month.toString().length)) + month);
                  return this.text("" + ('0'.repeat(2 - month.toString().length)) + month);
                });
              }
              return null;
            });
          });
          this.div('.col-xs-3', function() {
            return this.select('.form-control', function() {
              var j, year;
              self._year = this;
              this.attr('type', 'text');
              if (self.config.required) {
                this.prop('required', true);
              }
              this.on((browser.ie ? 'keypress paste drop input blur' : 'input blur'), function() {
                return self._changed();
              });
              for (year = j = 0; j <= 5; year = ++j) {
                this.option(function() {
                  this.attr('value', new Date().getFullYear() + year);
                  return this.text(new Date().getFullYear() + year);
                });
              }
              return null;
            });
          });
          this.div('.col-xs-3', function() {
            return this.input('.form-control', function() {
              self._cvv = this;
              this.attr('type', 'text');
              if (self.config.required) {
                this.prop('required', true);
              }
              return this.on((browser.ie ? 'keypress paste drop input blur' : 'input blur'), function() {
                return self._changed();
              });
            });
          });
          return this.div('.col-xs-3', function() {
            return this.text('CVC2 / CVV2');
          });
        });
        return self._input;
      });
      return this.built = true;
    };

    CreditCardInput.prototype._validate = function(value) {
      console.error("TODO");
      return null;
    };

    return CreditCardInput;

  })(Input);

  INPUT_TYPES['creditcard'] = CreditCardInput;

  DEFAULT_OPERATOR = 'text:equal';

  DEFAULT_OPERATORS = null;


  /*
  Value format:
  ```coffeescript
  value = [
  	// OR
  	[
  		// AND
  		{a: '', o: '', b: ''},
  		{a: '', o: '', b: ''}
  	]
  ]
  ```
   */

  global.FilterInput = (function(superClass) {
    extend1(FilterInput, superClass);

    function FilterInput() {
      return FilterInput.__super__.constructor.apply(this, arguments);
    }

    FilterInput.prototype.type = 'text';

    FilterInput.prototype._cache = null;

    FilterInput.OPERATORS = null;

    FilterInput.property('enabled', {
      get: function() {
        return true;
      }
    });

    FilterInput.property('value', {
      get: function() {
        return this._inputRoot.children('.i-filter-and').map(function(andGroup) {
          return andGroup.children('.i-filter-item').map(function(item) {
            return {
              a: item.find('input.i-filter-a, select.i-filter-a').val(),
              o: item.find('select.i-filter-o').val(),
              b: item.find('input.i-filter-b').val()
            };
          }).filter(function(item) {
            return item.a || item.b;
          });
        }).filter(function(andGroup) {
          return andGroup.length > 0;
        });
      },
      set: function(value) {
        var arrAnd, j, len, ref, self;
        self = this;
        this.find('.i-filter-and').remove();
        if (Array.isArray(value) && value.length === 0) {
          value = [[]];
        }
        ref = value != null ? value : [[]];
        for (j = 0, len = ref.length; j < len; j++) {
          arrAnd = ref[j];
          if (!((arrAnd != null ? arrAnd.length : void 0) > 0)) {
            arrAnd = [{}];
          }
          this._buildAnd()["do"](function() {
            var l, len1, results, val;
            this.appendTo(self._inputRoot);
            results = [];
            for (l = 0, len1 = arrAnd.length; l < len1; l++) {
              val = arrAnd[l];
              this.append(self._buildItem(val));
              results.push(this.append(this.children('button')));
            }
            return results;
          });
          this._inputRoot.append(this._inputRoot.children('.invalid-feedback, .hint-block, .form-text'));
        }
        return this._changed();
      }
    });


    /*
    	Build and section.
     */

    FilterInput.prototype._buildAnd = function(addEmptyItem) {
      var self;
      if (addEmptyItem == null) {
        addEmptyItem = false;
      }
      self = this;
      return sim.div('.i-filter-and', function() {
        var ref, ref1;
        if (addEmptyItem) {
          this.append(self._buildItem());
        }
        if (((ref = self.config.options) != null ? ref.logic : void 0) !== 'or') {
          this.button('.btn.btn-success.btn-xs.i-filter-add', function() {
            var ref1;
            this.attr('type', 'button');
            if (((ref1 = self.config.options) != null ? ref1.logic : void 0) === 'reverse') {
              this.text(imt.l('formula', 'buttons.addor'));
            } else {
              this.text(imt.l('formula', 'buttons.addand'));
            }
            return this.on('click', (function(_this) {
              return function() {
                var item;
                item = self._buildItem();
                item.hide();
                item.insertBefore(_this);
                return item.slideDown({
                  duration: 'fast',
                  progress: function() {
                    return self.form.emit('resize');
                  }
                });
              };
            })(this));
          });
        }
        if (((ref1 = self.config.options) != null ? ref1.logic : void 0) !== 'and') {
          return this.button('.btn.btn-success.btn-xs.i-filter-add.ml-2', function() {
            var ref2;
            this.attr('type', 'button');
            if (((ref2 = self.config.options) != null ? ref2.logic : void 0) === 'reverse') {
              this.text(imt.l('formula', 'buttons.addand'));
            } else {
              this.text(imt.l('formula', 'buttons.addor'));
            }
            return this.on('click', (function(_this) {
              return function() {
                var item;
                item = self._buildAnd(true);
                item.hide();
                item.insertAfter(_this.parent());
                return item.slideDown({
                  duration: 'fast',
                  progress: function() {
                    return self.form.emit('resize');
                  }
                });
              };
            })(this));
          });
        }
      });
    };


    /*
    	Builds filter item.
     */

    FilterInput.prototype._buildItem = function(value) {
      var bCoder, filters, self;
      if (value == null) {
        value = {
          a: '',
          o: '',
          b: ''
        };
      }
      self = this;
      filters = this.find('.i-filter-item');
      bCoder = null;
      if (value.o == null) {
        value.o = DEFAULT_OPERATOR;
      }
      return sim.div('.i-filter-item', function() {
        var ref, root;
        root = this;
        if ((ref = self._options) != null ? ref.length : void 0) {
          this.select('.form-control.custom-select.i-filter-a', function() {
            var j, len, option, ref1, results;
            this.prop('required', true);
            this.on('blur', function() {
              self._changed();
              return true;
            });
            this.on('change', function(event) {
              self._changed();
              return true;
            });
            this.option(function() {
              this.prop('selected', true);
              this.attr('value', '');
              this.attr('data-type', 'string');
              return this.text('');
            });
            ref1 = self._options;
            results = [];
            for (j = 0, len = ref1.length; j < len; j++) {
              option = ref1[j];
              results.push(this.option(function() {
                this.attr('value', option.value);
                this.attr('data-type', typeof option.value);
                return this.text(option.label);
              }));
            }
            return results;
          });
        } else {
          this.input('.form-control.i-filter-a', function() {
            var ref1, ref2, ref3, ref4;
            this.attr('type', 'text');
            this.value = value.a;
            this.prop('required', true);
            this.coder({
              samples: (ref1 = self.config.samples) != null ? ref1 : (ref2 = self.form.options) != null ? ref2.samples : void 0,
              pills: (ref3 = self.config.pills) != null ? ref3 : (ref4 = self.form.options) != null ? ref4.pills : void 0
            });
            return this.on('change', function() {
              return self._changed();
            });
          });
        }
        this.select('.form-control.custom-select.i-filter-o', function() {
          var group, j, len, ref1, ref2;
          ref1 = self._operators();
          for (j = 0, len = ref1.length; j < len; j++) {
            group = ref1[j];
            if ((ref2 = group.options) != null ? ref2.length : void 0) {
              this.optgroup(function() {
                var l, len1, option, ref3, results;
                this.attr('label', group.label);
                ref3 = group.options;
                results = [];
                for (l = 0, len1 = ref3.length; l < len1; l++) {
                  option = ref3[l];
                  results.push(this.option(function() {
                    this.prop('selected', String(option.value) === String(value.o));
                    this.attr('value', option.value);
                    this.data('label', option.label);
                    this.data('short', option.short);
                    return this.text(option.label);
                  }));
                }
                return results;
              });
            }
          }
          return this.on('change blur', function() {
            if (this.value === 'exist' || this.value === 'notexist') {
              bCoder.value = '';
              bCoder.slideUp({
                duration: 'fast',
                progress: function() {
                  return self.form.emit('resize');
                }
              });
            } else {
              bCoder.slideDown({
                duration: 'fast',
                progress: function() {
                  return self.form.emit('resize');
                }
              });
            }
            return self._changed();
          });
        });
        this.input('.form-control.i-filter-b', function() {
          var ref1, ref2, ref3, ref4;
          this.attr('type', 'text');
          this.prop('required', true);
          if (!value.o || value.o === 'exist' || value.o === 'notexist') {
            this.visible = false;
          } else {
            this.value = value.b;
          }
          bCoder = this.coder({
            samples: (ref1 = self.config.samples) != null ? ref1 : (ref2 = self.form.options) != null ? ref2.samples : void 0,
            pills: (ref3 = self.config.pills) != null ? ref3 : (ref4 = self.form.options) != null ? ref4.pills : void 0
          });
          return this.on('change', function() {
            return self._changed();
          });
        });
        return this.div('.i-filter-remove', function() {
          return this.button('.close', function() {
            this.attr('type', 'button');
            this.html('&times;');
            return this.on('click', function() {
              var toRemove;
              root.addClass('i-filter-removing');
              toRemove = root;
              filters = root.parent().children('.i-filter-item:not(.i-filter-removing)');
              if (filters.length === 0 && self.find('.i-filter-and:not(.i-filter-removing)').length > 1) {
                toRemove = root.parent();
              }
              toRemove.slideUp({
                duration: 'fast',
                progress: function() {
                  return self.form.emit('resize');
                },
                complete: function() {
                  return toRemove.remove();
                }
              });
              return filters = self.find('.i-filter-item:not(.i-filter-removing)');
            });
          });
        });
      });
    };


    /*
    	Resolve list of operators.
     */

    FilterInput.prototype._operators = function() {
      var group, groups, name, op, ref, ref1, type;
      if ((ref = this.config.options) != null ? ref.operators : void 0) {
        return this.config.options.operators;
      }
      if (DEFAULT_OPERATORS) {
        return DEFAULT_OPERATORS;
      }
      DEFAULT_OPERATORS = [];
      if (!global.IML) {
        console.error("IML module is not loaded.");
        return DEFAULT_OPERATORS;
      }
      groups = {
        general: []
      };
      ref1 = IML.FILTERS;
      for (name in ref1) {
        op = ref1[name];
        if (-1 === name.indexOf(':')) {
          group = groups.general;
        } else {
          type = name.split(':')[0];
          if (groups[type] == null) {
            groups[type] = [];
          }
          group = groups[type];
        }
        group.push({
          value: name,
          short: op.symbol,
          label: imt.l('iml', "filter." + name + ".label")
        });
      }
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.basic'),
        options: groups.general
      });
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.text'),
        options: groups.text
      });
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.number'),
        options: groups.number
      });
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.date'),
        options: groups.date
      });
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.time'),
        options: groups.time
      });
      DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.boolean'),
        options: groups.boolean
      });
      return DEFAULT_OPERATORS.push({
        label: imt.l('formula', 'operators.array'),
        options: groups.array
      });
    };


    /*
    	Build TextInput from config.
     */

    FilterInput.prototype.build = function() {
      var ref, self;
      FilterInput.__super__.build.call(this);
      self = this;
      this.addClass('i-filter');
      if (((ref = this.config.options) != null ? ref.logic : void 0) === 'reverse') {
        this.addClass('i-filter-reverse');
      }
      this._wrap(function() {
        self._inputRoot = this;
        this.append(self._buildAnd(true));
        return null;
      });
      return this.built = true;
    };


    /*
    	Initialize FilterInput with initial value.
    	
    	@callback callback Callback.
     */

    FilterInput.prototype.initialize = function(callback) {
      var body, buildSelects, k, ref, ref1, ref2, self, v;
      self = this;
      FilterInput.__super__.initialize.call(this, callback);
      if (!this.config.options) {
        return;
      }
      if (Array.isArray(this.config.options)) {
        this.config.options = {
          store: this.config.options
        };
      } else if (typeof this.config.options === 'string') {
        this.config.options = {
          store: this.config.options
        };
      } else if (this.config.options == null) {
        this.config.options = {
          store: []
        };
      }
      buildSelects = function() {
        return self.find('input.i-filter-a').each(function() {
          var value;
          value = this.val();
          return this.parent().replaceWith(sim.select('.form-control.custom-select.i-filter-a', function() {
            var j, len, option, ref, results;
            this.prop('required', true);
            this.on('blur', function() {
              self._changed();
              return true;
            });
            this.on('change', function(event) {
              self._changed();
              return true;
            });
            this.option(function() {
              this.prop('selected', (value == null) || value === '');
              this.attr('value', '');
              this.attr('data-type', 'string');
              return this.text('');
            });
            ref = self._options;
            results = [];
            for (j = 0, len = ref.length; j < len; j++) {
              option = ref[j];
              results.push(this.option(function() {
                this.prop('selected', value === option.value);
                this.attr('value', option.value);
                this.attr('data-type', typeof option.value);
                return this.text(option.label);
              }));
            }
            return results;
          }));
        });
      };
      if (Array.isArray(this.config.options.store)) {
        this._options = this.config.options.store;
        return buildSelects();
      } else {
        body = (ref = Object.clone((ref1 = this.form.options) != null ? ref1.commonRpcParameters : void 0)) != null ? ref : {};
        ref2 = this.fieldset.path;
        for (k in ref2) {
          v = ref2[k];
          body[k] = v;
        }
        return Loader.load(this.config.options.store, {
          data: body,
          parser: 'manifest'
        }, (function(_this) {
          return function(err, options) {
            if (err) {
              console.error(imt.l('formula', 'errors.loadfailed'), err);
              return;
            }
            _this._options = options;
            return buildSelects();
          };
        })(this));
      }
    };

    return FilterInput;

  })(Input);

  INPUT_TYPES['filter'] = FilterInput;

  global.FolderInput = (function(superClass) {
    extend1(FolderInput, superClass);

    FolderInput.prototype._path = null;

    FolderInput.prototype._panel = null;

    FolderInput.prototype._add = null;

    FolderInput.property('value', {
      get: function() {
        if (this.mode === 'edit') {
          return this._coder._input.value;
        } else {
          return this._input.value;
        }
      },
      set: function(value) {
        if (this.mode === 'edit') {
          return this._coder.value = value;
        } else {
          return this._input.value = value;
        }
      }
    });

    function FolderInput() {
      FolderInput.__super__.constructor.apply(this, arguments);
      this.on('focusout', (function(_this) {
        return function() {
          return setImmediate(function() {
            var ref;
            if ((ref = _this._panel) != null) {
              ref.close();
            }
            return _this._panel = null;
          });
        };
      })(this));
    }

    FolderInput.prototype._browse = function(relative, reportEmptyFolder) {
      var body, panel, ref, self;
      if (reportEmptyFolder == null) {
        reportEmptyFolder = true;
      }
      if ((ref = this._panel) != null) {
        ref.close();
      }
      self = this;
      panel = this._panel = new Panel(relative);
      panel.addClass('i-folders');
      panel.offsetX = 5;
      panel.loading = true;
      panel.on('mousedown', function(event) {
        event.stopPropagation();
        return false;
      });
      body = this.fieldset.path;
      body[this.config.name] = "/" + (relative.prevAll('li').not('.i-folder-add').map(function(item) {
        return item.data('value');
      }).join('/'));
      return Loader.load(this.config.options.store, {
        data: body
      }, function(err, folders) {
        if (err) {
          return panel.warn(err.message);
        }
        panel.loading = false;
        panel.width('auto');
        sim.div('.list-group', function() {
          var files, folder, j, len, ref1, results;
          panel.content = this;
          if (relative.is(':first-child') && body[self.config.name] === '/' && self.config.options.showRoot !== false && self.config.type !== 'file') {
            this.a('.list-group-item', function() {
              this.attr('href', '#');
              this.text('/');
              return this.on('click', function(event) {
                panel.close();
                self._path.children('li').not('.i-folder-add').remove();
                self.addRoot();
                self._changed();
                self.emit('change');
                event.stopPropagation();
                return false;
              });
            });
          } else {
            if (folders.length === 0) {
              if (relative.is('.i-folder-add')) {
                if ((ref1 = relative.prev('li')) != null) {
                  ref1.addClass('i-folder-empty');
                }
              }
              if (reportEmptyFolder) {
                return panel.content = sim.p().text(imt.l('formula', 'errors.nosubfolders'));
              } else {
                return panel.close();
              }
            }
          }
          if (folders.length) {
            if (self.config.type === 'file') {
              files = folders.filter(function(item) {
                return item.file === true;
              });
              folders = folders.filter(function(item) {
                return item.file !== true;
              });
              folders = folders.concat(files);
            }
            results = [];
            for (j = 0, len = folders.length; j < len; j++) {
              folder = folders[j];
              results.push((function(_this) {
                return function(folder) {
                  return _this.a('.list-group-item', function() {
                    this.attr('href', '#');
                    this.text(folder.label);
                    if (self.config.type === 'file' && !folder.file) {
                      this.css('font-weight', 'bold');
                    }
                    return this.on('click', function(event) {
                      panel.close();
                      self._path.children('.i-folder-root').remove();
                      panel._relative.nextAll('li').not('.i-folder-add').remove();
                      if (panel._relative !== self._add) {
                        panel._relative.remove();
                      }
                      if (folder.file) {
                        self.addFile(folder.value, folder.label);
                      } else {
                        self.addFolder(folder.value, folder.label, true);
                      }
                      self._changed();
                      self.emit('change');
                      event.stopPropagation();
                      return false;
                    });
                  });
                };
              })(this)(folder));
            }
            return results;
          }
        });
        return panel._resize();
      });
    };

    FolderInput.prototype.addFolder = function(value, label, open) {
      var folder, self;
      if (open == null) {
        open = false;
      }
      self = this;
      folder = sim.li(function() {
        this.data('value', value);
        this.text(label != null ? label : value);
        return this.on('click', function() {
          return self._browse(folder);
        });
      });
      folder.insertBefore(this._add);
      this._input.scrollLeft(9999);
      if (!this.config.options.singleLevel) {
        if (open) {
          this._browse(self._add, false);
        }
      }
      return this;
    };

    FolderInput.prototype.addFile = function(value, label) {
      var fieldset, folder, ref, self;
      self = this;
      folder = sim.li(function() {
        this.data('value', value);
        this.data('file', 'yes');
        this.text(label != null ? label : value);
        return this.on('click', function() {
          return self._browse(folder);
        });
      });
      folder.insertBefore(this._add);
      this._input.scrollLeft(9999);
      if (((ref = this.config.options) != null ? ref.nested : void 0) && this.initialized) {
        fieldset = {
          config: this.config.options.nested,
          value: this._input.value
        };
        Fieldset.createSubFieldsets(this, [fieldset], function() {});
      }
      return this;
    };

    FolderInput.prototype.addRoot = function() {
      var folder, self;
      self = this;
      folder = sim.li(function() {
        this.addClass('i-folder-root');
        this.data('value', '');
        this.text('');
        return this.on('click', function() {
          return self._browse(folder);
        });
      });
      return folder.insertBefore(this._add);
    };


    /*
    	Build FoldersInput from config.
     */

    FolderInput.prototype.build = function() {
      var self;
      FolderInput.__super__.build.call(this);
      if (typeof this.config.options === 'string') {
        this.config.options = {
          store: this.config.options
        };
      }
      self = this;
      this.addClass('i-folder-composer');
      this._wrap(function() {
        this.div('.form-control', function() {
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          this.attr('tabindex', 0);
          this.ul('.list-unstyled.i-folder', function() {
            self._path = this;
            if (self.config.type === 'file') {
              this.addClass('i-file');
            }
            if (self.config.options.singleLevel) {
              this.addClass('i-folder-single-level');
            }
            return self._add = this.li('.i-folder-add', function() {
              this.attr('data-label', imt.l('formula', "buttons.choose" + self.config.type));
              return this.on('click', function() {
                if (!self.enabled) {
                  return false;
                }
                return self._browse(self._add);
              });
            });
          });
          Object.defineProperty(this, 'enabled', {
            get: function() {
              return !this.attr('disabled');
            },
            set: function(value) {
              this.attr('disabled', !value);
              if (value) {
                return this.attr('tabindex', 0);
              } else {
                return this.attr('tabindex', -1);
              }
            }
          });
          return Object.defineProperty(this, 'value', {
            get: function() {
              var folders;
              if (self.config.type === 'file' && !self._path.children('li[data-file="yes"]').length) {
                return null;
              }
              folders = self._path.children('li').not('.i-folder-add');
              if (folders.length) {
                return "" + (self.config.options.showRoot !== false ? "/" : "") + (folders.map(function(item) {
                  return item.data('value');
                }).join('/'));
              } else {
                return null;
              }
            },
            set: function(value) {
              var addMethod, index, item, j, l, len, len1, ref, ref1, ref2, ref3;
              self._path.children('li').not('.i-folder-add').remove();
              if (value) {
                if (value === '/') {
                  return self.addRoot();
                }
                addMethod = self.config.type === 'file' ? 'addFile' : 'addFolder';
                if (self.config.options.singleLevel) {
                  if (self.config.options.ids === true && !self.initialized) {
                    self[addMethod](value, (ref = self.restored) != null ? (ref1 = ref.path) != null ? ref1[0] : void 0 : void 0);
                  } else {
                    self[addMethod](value);
                  }
                } else {
                  value = value.split('/');
                  if (self.config.options.showRoot !== false) {
                    value.shift();
                  }
                  if (self.config.options.ids === true && !self.initialized) {
                    for (index = j = 0, len = value.length; j < len; index = ++j) {
                      item = value[index];
                      self[index === value.length - 1 ? addMethod : 'addFolder'](item, (ref2 = self.restored) != null ? (ref3 = ref2.path) != null ? ref3[index] : void 0 : void 0);
                    }
                  } else {
                    for (index = l = 0, len1 = value.length; l < len1; index = ++l) {
                      item = value[index];
                      self[index === value.length - 1 ? addMethod : 'addFolder'](item);
                    }
                  }
                }
                self._changed();
                return self.emit('change');
              }
            }
          });
        });
        return self._input;
      });
      if (this.config.editable && (this.restored.mode != null)) {
        this.mode = this.restored.mode;
      } else if (this.config.mode != null) {
        this.mode = this.config.mode;
      }
      return this.built = true;
    };

    FolderInput.prototype.initialize = function(callback) {
      var fieldset, ref;
      FolderInput.__super__.initialize.call(this);
      if (!((ref = this.config.options) != null ? ref.nested : void 0)) {
        return callback();
      }
      if (!this._input.value) {
        return callback();
      }
      fieldset = {
        config: this.config.options.nested,
        value: this._input.value
      };
      return Fieldset.createSubFieldsets(this, [fieldset], callback);
    };


    /*
    	Get current state.
     */

    FolderInput.prototype.save = function() {
      var state;
      state = FolderInput.__super__.save.call(this);
      if (this.config.options.ids === true && this._path.children('li').length) {
        state.path = this._path.children('li').not('.i-folder-add').map(function(item) {
          return item.text();
        });
      }
      return state;
    };

    FolderInput.prototype.toConfig = function() {
      return SelectInput.toConfig(this.config);
    };

    FolderInput.toConfig = function(config, includeNested) {
      var obj, spec;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = Input.toConfig(config, includeNested);
      delete obj['options'];
      delete obj['nested'];
      if (includeNested && Array.isArray(config.nested)) {
        obj.nested = (function() {
          var j, len, ref, ref1, results;
          ref = config.nested;
          results = [];
          for (j = 0, len = ref.length; j < len; j++) {
            spec = ref[j];
            results.push(((ref1 = INPUT_TYPES[spec.type]) != null ? ref1 : Input).toConfig(spec, true));
          }
          return results;
        })();
      }
      return obj;
    };

    return FolderInput;

  })(EditableInput);

  FileInput = (function(superClass) {
    extend1(FileInput, superClass);

    function FileInput() {
      return FileInput.__super__.constructor.apply(this, arguments);
    }

    return FileInput;

  })(FolderInput);

  INPUT_TYPES['file'] = FileInput;

  INPUT_TYPES['folder'] = FolderInput;

  global.HiddenInput = (function(superClass) {
    extend1(HiddenInput, superClass);

    function HiddenInput() {
      return HiddenInput.__super__.constructor.apply(this, arguments);
    }

    HiddenInput.property('value', {
      get: function() {
        return this._input.value;
      },
      set: function(value) {
        return this._input.value = value;
      }
    });


    /*
    	Build TextInput from config.
     */

    HiddenInput.prototype.build = function() {
      var self;
      HiddenInput.__super__.build.call(this);
      self = this;
      this.hide();
      sim.input('.form-control', function() {
        self._input = this;
        self._inputRoot = this;
        this.attr('id', self.id);
        this.attr('name', self.name);
        this.attr('type', 'hidden');
        return this.appendTo(self);
      });
      return this.built = true;
    };

    return HiddenInput;

  })(Input);

  INPUT_TYPES['hidden'] = HiddenInput;

  global.Link = (function(superClass) {
    extend1(Link, superClass);

    function Link(fieldset1, group) {
      var ref;
      this.fieldset = fieldset1;
      Link.__super__.constructor.call(this, 'div');
      this.form = this.fieldset.form;
      if (group != null) {
        this.group = group;
      }
      this.addClass('form-group');
      if ((ref = this.form.options) != null ? ref.inline : void 0) {
        this.addClass('row justify-content-end');
      }
      this.appendTo(this.group || this.fieldset);
    }

    Link.prototype.build = function() {
      var self;
      self = this;
      return this.div(function() {
        var ref;
        if ((ref = self.form.options) != null ? ref.inline : void 0) {
          this.addClass('col-8');
        }
        return this.button('.btn.btn-primary.btn-block.i-formula-link', function() {
          this.text(self.config.text);
          return this.on('click', function(event) {
            event.stopPropagation();
            return window.location.href = IML.execute(IML.parse(self.config.link), self.fieldset.form.toJSON());
          });
        });
      });
    };

    return Link;

  })(SIMElement);

  INPUT_TYPES['link'] = Link;

  global.ListInput = (function(superClass) {
    extend1(ListInput, superClass);

    function ListInput() {
      return ListInput.__super__.constructor.apply(this, arguments);
    }

    ListInput.prototype._value = null;

    ListInput.prototype._emptyOption = null;

    ListInput.property('value', {
      get: function() {
        if (this.initialized) {
          return this._input.value;
        } else {
          return this._value;
        }
      },
      set: function(value) {
        if (this.initialized) {
          return this._input.value = value;
        } else {
          return this._value = value;
        }
      }
    });


    /*
    	Build SelectInput from config.
     */

    ListInput.prototype.build = function() {
      var self;
      ListInput.__super__.build.call(this);
      self = this;
      this.addClass('i-list');
      this._wrap(function() {
        this.div('.form-control.list-group', function() {
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          Object.defineProperty(this, 'enabled', {
            get: function() {
              return !this.attr('disabled');
            },
            set: function(value) {
              return this.attr('disabled', !value);
            }
          });
          return Object.defineProperty(this, 'value', {
            get: function() {
              return self._input.children('.active').data('value');
            },
            set: function(value) {
              return self._input.children('.active').removeClass('active').each(function() {
                if (this.data('value') === value) {
                  return this.addClass('active');
                }
              });
            }
          });
        });
        return self._input;
      });
      return this.built = true;
    };


    /*
    	Initialize SelectInput with initial value.
    	
    	@callback callback Callback.
     */

    ListInput.prototype.initialize = function(callback) {
      var base, base1, base2, body, buildOptions, k, ref, ref1, ref2, self, v;
      self = this;
      ListInput.__super__.initialize.call(this);
      this.initialized = false;
      if (Array.isArray(this.config.options)) {
        this.config.options = {
          store: this.config.options
        };
      } else if (typeof this.config.options === 'string') {
        this.config.options = {
          store: this.config.options
        };
      } else if (this.config.options == null) {
        this.config.options = {
          store: []
        };
      }
      if ((base = this.config.options).value == null) {
        base.value = "value";
      }
      if ((base1 = this.config.options).label == null) {
        base1.label = "label";
      }
      if ((base2 = this.config.options)["default"] == null) {
        base2["default"] = "default";
      }
      buildOptions = (function(_this) {
        return function(parent, options) {
          var j, len, option, results, selected;
          if (_this._value == null) {
            _this._value = RESOLVE_DEFAULT(options, _this.config);
          }
          if (_this.config.sort) {
            options = options.sort(SORT_METHOD[_this.config.sort]);
          }
          results = [];
          for (j = 0, len = options.length; j < len; j++) {
            option = options[j];
            selected = String(option[_this.config.options.value]) === _this._value;
            results.push(sim.div('.list-group-item.flex-column.align-items-start', function() {
              this.appendTo(parent);
              this.data('value', option[self.config.options.value]);
              if (option.description) {
                this.div('.list-group-split', function() {
                  this.div('.list-grop-title').text(option[self.config.options.label]);
                  return this.small('.text-muted').text(option.description);
                });
              } else {
                this.div('.list-group-title').text(option[self.config.options.label]);
              }
              if (option.date) {
                this.small('.text-muted').text(format(option.date, 'datetime'));
              }
              return this.on('click', (function(_this) {
                return function(event) {
                  if (!self.enabled) {
                    return false;
                  }
                  parent.children('.list-group-item').removeClass('active');
                  _this.addClass('active');
                  self._changed();
                  event.preventDefault();
                  return false;
                };
              })(this));
            }));
          }
          return results;
        };
      })(this);
      if (Array.isArray(this.config.options.store)) {
        this._input.empty();
        buildOptions(this._input, this.config.options.store);
        this.initialized = true;
        this._changed(false);
        return typeof callback === "function" ? callback(null) : void 0;
      } else {
        this.enabled = false;
        this.addClass('i-loading');
        this.removeClass('i-failed');
        this.form.loadings++;
        this.form.emit('loading-status', {
          detail: {
            status: imt.l('formula', 'common.loading2', {
              data: {
                field: this.config.label || this.config.name
              }
            })
          }
        });
        body = (ref = Object.clone((ref1 = this.form.options) != null ? ref1.commonRpcParameters : void 0)) != null ? ref : {};
        ref2 = this.fieldset.path;
        for (k in ref2) {
          v = ref2[k];
          body[k] = v;
        }
        if (!this.config.options.store) {
          this.addClass('i-failed');
          this.form.loadings--;
          this._loadingError = "Invalid data store '" + this.config.options.store + "'.";
          this.validate();
          return typeof callback === "function" ? callback(null) : void 0;
        }
        return Loader.load(this.config.options.store, {
          data: body,
          parser: 'manifest'
        }, (function(_this) {
          return function(err, options) {
            _this._input.empty();
            _this.removeClass('i-loading');
            _this.form.loadings--;
            if (err) {
              console.error(imt.l('formula', 'errors.loadfailed'), err);
              _this.addClass('i-failed');
              _this._loadingError = err.message;
              _this.validate();
              return typeof callback === "function" ? callback(null) : void 0;
            }
            buildOptions(_this._input, options);
            _this.form.emit('resize');
            _this.enabled = true;
            _this.initialized = true;
            _this._changed(false);
            return typeof callback === "function" ? callback(null) : void 0;
          };
        })(this));
      }
    };

    return ListInput;

  })(Input);

  INPUT_TYPES['list'] = ListInput;

  global.RadioInput = (function(superClass) {
    extend1(RadioInput, superClass);

    function RadioInput() {
      return RadioInput.__super__.constructor.apply(this, arguments);
    }

    RadioInput.prototype.__enabled = true;

    RadioInput.property('enabled', {
      get: function() {
        return this.__enabled;
      },
      set: function(value) {
        if (value === this.__enabled) {
          return;
        }
        this.__enabled = value;
        return this._inputRoot.find(':scope > div > label > input').prop('disabled', !value);
      }
    });

    RadioInput.property('value', {
      get: function() {
        return this._inputRoot.find(':scope > div > label > input:checked').val();
      },
      set: function(value) {
        return this._inputRoot.find(':scope > div > label > input').each(function() {
          return this.prop('checked', this.attr('value') === value);
        });
      }
    });


    /*
    	Build TextInput from config.
     */

    RadioInput.prototype.build = function() {
      var self;
      RadioInput.__super__.build.call(this);
      self = this;
      this.addClass('i-radio');
      this._wrap({
        label: false
      }, function() {
        self._input = this;
        self._inputRoot = this;
        return self._input;
      });
      return this.built = true;
    };


    /*
    	Initialize CheckInput with initial value.
    	
    	@callback [callback] Callback.
     */

    RadioInput.prototype.initialize = function(callback) {
      var base, base1, self;
      self = this;
      RadioInput.__super__.initialize.call(this);
      if (Array.isArray(this.config.options)) {
        this.config.options = {
          store: this.config.options
        };
      } else if (typeof this.config.options === 'string') {
        this.config.options = {
          store: this.config.options
        };
      } else if (this.config.options == null) {
        this.config.options = {
          store: []
        };
      }
      if ((base = this.config.options).value == null) {
        base.value = "value";
      }
      if ((base1 = this.config.options).label == null) {
        base1.label = "label";
      }
      if (Array.isArray(this.config.options.store)) {
        return async.mapSeries(this.config.options.store, function(option, next) {
          var elm;
          elm = sim.div('.radio', function() {
            this.appendTo(self._inputRoot);
            this.label('.custom-control.custom-radio', function() {
              this.input('.custom-control-input', function() {
                this.attr('type', 'radio');
                this.attr('name', self.name);
                this.attr('value', option[self.config.options.value]);
                if (option["default"] === true) {
                  this.prop('checked', true);
                }
                return this.on('change', function() {
                  return self._changed();
                });
              });
              this.span('.custom-control-indicator');
              return this.span('.custom-control-description').text(option[self.config.options.label]);
            });
            if (option.help) {
              return this.div('.form-text', function() {
                return this.html(option.help.replace(/<a([^>]*)href=[\"\']kb:\/\/([^\"\']*)[\"\']([^>]*)>/gi, "<a target=\"_blank\" href=\"/" + imt.user.language + "/kb/$2\">"));
              });
            }
          });
          if (option.nested != null) {
            return Fieldset.createSubFieldsets(self, [
              {
                config: option.nested,
                value: option.value,
                independent: option.independent
              }
            ], function(err, fieldsets) {
              if (err) {
                return next(err);
              }
              fieldsets[0].insertAfter(elm);
              return next();
            });
          } else {
            return next();
          }
        }, (function(_this) {
          return function(err) {
            _this._changed();
            return typeof callback === "function" ? callback(err) : void 0;
          };
        })(this));
      }
    };

    return RadioInput;

  })(Input);

  INPUT_TYPES['radio'] = RadioInput;


  /*
  @param {Array} input Form/fieldset config
   */

  nestedToEditMode = function(config) {
    var item, j, len, output, ref;
    if (!Array.isArray(config)) {
      return config;
    }
    output = [];
    for (j = 0, len = config.length; j < len; j++) {
      item = config[j];
      output.push(item);
      if (item.type === 'select') {
        if ('string' === typeof item.options) {
          delete item.options;
          item.type = 'any';
          if (item.multiple) {
            delete item.multiple;
            item.type = 'array';
            item.spec = {
              type: 'any'
            };
          }
        } else if ('string' === typeof ((ref = item.options) != null ? ref.store : void 0)) {
          if (Array.isArray(item.options.nested)) {
            output.push.apply(output, nestedToEditMode(item.options.nested));
          }
          delete item.options;
          item.type = 'any';
          if (item.multiple) {
            delete item.multiple;
            item.type = 'array';
            item.spec = {
              type: 'any'
            };
          }
        }
      }
    }
    return output;
  };

  RESOLVE_DEFAULT = function(options, config) {
    var j, len, option, values;
    values = config.multiple ? [] : '';
    if (!(options != null ? options.length : void 0)) {
      return values;
    }
    for (j = 0, len = options.length; j < len; j++) {
      option = options[j];
      if (option[config.options["default"]] === true) {
        if (config.multiple) {
          values.push(option[config.options.value]);
        } else {
          return option[config.options.value];
        }
      }
    }
    return values;
  };

  CAST_OPTION_VALUE = function(value, type) {
    switch (type) {
      case 'number':
        return parseFloat(value);
      case 'boolean':
        return value === 'true';
      default:
        return value;
    }
  };

  SORT_METHOD = {
    text: function(a, b) {
      if (String.prototype.localeCompare) {
        return String(a.label).localeCompare(b.label);
      } else {
        if (a.label > b.label) {
          return 1;
        }
        if (a.label < b.label) {
          return -1;
        }
        return 0;
      }
    },
    number: function(a, b) {
      return a.label - b.label;
    }
  };

  global.SelectInput = (function(superClass) {
    extend1(SelectInput, superClass);

    SelectInput.prototype._value = null;

    SelectInput.prototype._emptyOption = null;

    SelectInput.property('value', {
      get: function() {
        var ref, ref1;
        if (this.mode === 'edit') {
          if (this.config.multiple) {
            if (/^{{[^}]*}}$/.test(this._coder._input.value)) {
              return IML.stringify(IML.replace(IML.parse(this._coder._input.value), 'keyword', 'erase', 'erasearray'));
            } else if (this._coder._input.value) {
              return this._coder._input.value.split(',');
            } else {
              return [];
            }
          } else {
            return this._coder._input.value;
          }
        } else {
          if (this.initialized) {
            if (this.config.multiple) {
              return (ref = this._input.value) != null ? ref : [];
            } else {
              return (ref1 = this._input.value) != null ? ref1 : null;
            }
          } else {
            return this._value;
          }
        }
      },
      set: function(value) {
        if (this.mode === 'edit') {
          if (this.config.multiple) {
            if (Array.isArray(value)) {
              return this._coder.value = value.join(',');
            } else {
              if ('string' === typeof value) {
                return this._coder.value = IML.stringify(IML.replace(IML.parse(value), 'keyword', 'erasearray', 'erase'));
              } else {
                return this._coder.value = value;
              }
            }
          } else {
            return this._coder.value = value;
          }
        } else {
          if (this.initialized) {
            return this._input.value = value;
          } else {
            return this._value = value;
          }
        }
      }
    });

    function SelectInput() {
      SelectInput.__super__.constructor.apply(this, arguments);
      this.on('before_mode_change', (function(_this) {
        return function() {
          var ref;
          if ((ref = _this._loader) != null) {
            ref.abort();
          }
          _this.removeClass('i-failed');
          _this.removeClass('i-loading');
          return _this.enabled = true;
        };
      })(this));
    }

    SelectInput.prototype._changed = function(validate) {
      var ref;
      if (validate == null) {
        validate = true;
      }
      if (this.config.required && this.value !== '' && (this.value != null)) {
        if ((ref = this._emptyOption) != null) {
          ref.remove();
        }
      }
      return SelectInput.__super__._changed.call(this, validate);
    };

    SelectInput.prototype.addOption = function(option, selected) {
      var fieldset, self;
      self = this;
      this._input.append(sim.option(function() {
        var key, results;
        this.prop('selected', selected);
        this.attr('value', option.value);
        this.attr('data-type', typeof option.value);
        this.text(option.label);
        if (self.config.options.data) {
          results = [];
          for (key in self.config.options.data) {
            results.push(this.attr("data-" + key, option[self.config.options.data[key]]));
          }
          return results;
        }
      }));
      if (this.config.options.nested) {
        option.nested = this.config.options.nested;
      }
      if (option.nested) {
        fieldset = {
          config: option.nested,
          value: option.value
        };
        Fieldset.createSubFieldsets(this, [fieldset], function() {});
      }
      if (selected) {
        this._changed();
        return this.emit('change');
      }
    };


    /*
    	Build SelectInput from config.
     */

    SelectInput.prototype.build = function() {
      var block, ref, ref1, ref2, self, store, values;
      SelectInput.__super__.build.call(this);
      self = this;
      if (self.config.multiple) {
        this.addClass('i-multiselect');
      }
      this._wrap(function() {
        var lockedInBeforeChange;
        if (self.config.multiple) {
          this.div('.form-control.d-block', function() {
            self._input = this;
            self._inputRoot = this;
            this.attr('id', self.id);
            Object.defineProperty(this, 'enabled', {
              get: function() {
                return !this.attr('disabled');
              },
              set: function(value) {
                this.attr('disabled', !value);
                return self._input.find('input').prop('disabled', !value);
              }
            });
            return Object.defineProperty(this, 'value', {
              get: function() {
                return self._input.find('input:checked').map(function(item) {
                  return CAST_OPTION_VALUE(item.val(), item.data('type'));
                });
              },
              set: function(value) {
                if (!Array.isArray(value)) {
                  value = [];
                }
                return self._input.find('input').each(function() {
                  var ref;
                  return this.prop('checked', (ref = CAST_OPTION_VALUE(this.val(), this.data('type')), indexOf.call(value, ref) >= 0));
                });
              }
            });
          });
        } else {
          lockedInBeforeChange = false;
          this.select('.form-control.custom-select', function() {
            self._input = this;
            self._inputRoot = this;
            this.attr('id', self.id);
            this.attr('name', self.name);
            if (self.config.readonly) {
              this.prop('readOnly', true);
            }
            if (self.config.required) {
              this.prop('required', true);
            }
            this.on('blur', function() {
              if (lockedInBeforeChange) {
                return;
              }
              self._changed();
              return true;
            });
            this.on('change', function(event) {
              var ref;
              if ((ref = self.config.options) != null ? ref.beforeChange : void 0) {
                event.stopImmediatePropagation();
                lockedInBeforeChange = true;
                self.enabled = false;
                self.config.options.beforeChange.call(self, (function(_this) {
                  return function(canChange) {
                    if (!canChange) {
                      _this.value = "";
                    }
                    lockedInBeforeChange = false;
                    self.enabled = true;
                    self._changed();
                    return self.emit('change');
                  };
                })(this));
                return false;
              }
              self._changed();
              return true;
            });
            return Object.defineProperty(this, 'value', {
              get: function() {
                var item;
                item = sim(self._input.__dom.options[self._input.__dom.selectedIndex]);
                if (item == null) {
                  return null;
                }
                return CAST_OPTION_VALUE(item.val(), item.data('type'));
              },
              set: function(value) {
                return self._input.val(value);
              }
            });
          });
        }
        return self._input;
      });
      if (this.config.editable && (this.restored.mode != null)) {
        this.mode = this.restored.mode;
      } else if (this.config.mode != null) {
        this.mode = this.config.mode;
      }
      block = sim.ul('.i-validations-block.list-unstyled');
      if (self.config.multiple) {
        if (((ref = self.config.validate) != null ? ref.minItems : void 0) > 0) {
          block.li('.i-validation-higher').text(imt.l('formula', 'hints.selectleast', {
            data: {
              value: self.config.validate.minItems
            }
          }));
        }
        if (((ref1 = self.config.validate) != null ? ref1.maxItems : void 0) > 0) {
          block.li('.i-validation-lower').text(imt.l('formula', 'hints.selectmost', {
            data: {
              value: self.config.validate.maxItems
            }
          }));
        }
      }
      if (self.config.validate !== false && self.config.dynamic !== true && (Array.isArray(self.config.options || Array.isArray((ref2 = self.config.options) != null ? ref2.store : void 0)))) {
        store = Array.isArray(self.config.options) ? self.config.options : self.config.options.store;
        if (self.config.grouped) {
          values = store.reduce(function(arr, group) {
            if (Array.isArray(group.options)) {
              arr.push.apply(arr, group.options.map(function(item) {
                return item.value;
              }));
            }
            return arr;
          }, []).join(', ');
        } else {
          values = store.map(function(item) {
            return item.value;
          }).join(', ');
        }
        block.li('.i-validation-check.i-edit-mode-only').text(imt.l('formula', 'hints.enum', {
          data: {
            value: values
          }
        }));
      }
      if (block.children().length) {
        this.append(block);
      }
      return this.built = true;
    };


    /*
    	Initialize SelectInput with initial value.
    	
    	@callback callback Callback.
     */

    SelectInput.prototype.initialize = function(callback) {
      var base, base1, base2, buildOptions, fieldsets, group, j, l, len, len1, len2, n, nested, option, ref, ref1, ref2, ref3, ref4, reload, self;
      self = this;
      SelectInput.__super__.initialize.call(this);
      this.initialized = false;
      if (Array.isArray(this.config.options)) {
        this.config.options = {
          store: this.config.options
        };
      } else if (typeof this.config.options === 'string') {
        this.config.options = {
          store: this.config.options
        };
      } else if (this.config.options == null) {
        this.config.options = {
          store: []
        };
      }
      if ((base = this.config.options).value == null) {
        base.value = "value";
      }
      if ((base1 = this.config.options).label == null) {
        base1.label = "label";
      }
      if ((base2 = this.config.options)["default"] == null) {
        base2["default"] = "default";
      }
      nested = [];
      reload = (function(_this) {
        return function(init, callback) {
          var body;
          if (_this.hasClass('i-loading')) {
            return;
          }
          if (_this.mode === 'edit') {
            return;
          }
          if (!init) {
            Fieldset.destroySubFieldsets(_this);
          }
          _this._input.empty();
          nested = [];
          _this.enabled = false;
          _this.addClass('i-loading');
          _this.removeClass('i-failed');
          if (init) {
            _this.form.loadings++;
          }
          if (init) {
            _this.form.emit('loading-status', {
              detail: {
                status: imt.l('formula', 'common.loading2', {
                  data: {
                    field: _this.config.label || _this.config.name
                  }
                })
              }
            });
          }
          body = _this.fieldset.path;
          if (!_this.config.options.store) {
            _this.addClass('i-failed');
            if (init) {
              _this.form.loadings--;
            }
            _this._loadingError = "Invalid data store '" + _this.config.options.store + "'.";
            _this.validate();
            return typeof callback === "function" ? callback(null) : void 0;
          }
          return _this._loader = Loader.load(_this.config.options.store, {
            data: body,
            parser: 'manifest'
          }, function(err, options) {
            var fieldsets, group, j, l, len, len1, len2, n, option, ref, ref1, ref2;
            _this._loader = null;
            if (_this.destroyed) {
              return;
            }
            _this.removeClass('i-loading');
            if (init) {
              _this.form.loadings--;
            }
            if (_this.mode === 'edit') {
              return;
            }
            if (err) {
              _this.addClass('i-failed');
              _this._loadingError = err.message;
              _this.validate();
              return typeof callback === "function" ? callback(null) : void 0;
            }
            if (options == null) {
              options = [];
            }
            if (_this.config.multiple) {
              if (_this.config.options.nested) {
                nested.push({
                  independent: true,
                  nested: _this.config.options.nested
                });
              }
              if (_this.config.grouped) {
                if (_this.config.sort) {
                  options = options.sort(SORT_METHOD[_this.config.sort]);
                }
                for (j = 0, len = options.length; j < len; j++) {
                  group = options[j];
                  if ((ref = group.options) != null ? ref.length : void 0) {
                    _this._input.append(sim.div('.i-optgroup', function() {
                      this.attr('data-label', group.label);
                      return buildOptions(this, group.options);
                    }));
                  }
                }
              } else {
                buildOptions(_this._input, options);
              }
            } else {
              _this._emptyOption = sim.option(function() {
                var ref1, ref2, ref3;
                this.attr('value', '');
                return this.text((ref1 = (ref2 = (ref3 = self.config.options.placeholder) != null ? ref3.label : void 0) != null ? ref2 : self.config.options.placeholder) != null ? ref1 : '');
              });
              _this._input.append(_this._emptyOption);
              if (_this.config.grouped) {
                if (_this.config.sort) {
                  options = options.sort(SORT_METHOD[_this.config.sort]);
                }
                for (l = 0, len1 = options.length; l < len1; l++) {
                  group = options[l];
                  if ((ref1 = group.options) != null ? ref1.length : void 0) {
                    _this._input.append(sim.optgroup(function() {
                      this.attr('label', group.label);
                      return buildOptions(this, group.options);
                    }));
                  }
                }
              } else {
                buildOptions(_this._input, options);
              }
            }
            _this.enabled = true;
            fieldsets = [];
            if (self.config.editable && self.config.options.nested) {
              fieldsets.push({
                config: nestedToEditMode(Object.cloneDeep(self.config.options.nested)),
                value: EDIT_MODE_ONLY
              });
            }
            if ((ref2 = self.config.options.placeholder) != null ? ref2.nested : void 0) {
              fieldsets.push({
                config: self.config.options.placeholder.nested,
                value: '',
                independent: false
              });
            }
            for (n = 0, len2 = nested.length; n < len2; n++) {
              option = nested[n];
              fieldsets.push({
                config: option.nested,
                value: option[_this.config.options.value],
                independent: option.independent
              });
            }
            _this.initialized = true;
            _this._changed(false);
            return Fieldset.createSubFieldsets(_this, fieldsets, callback);
          });
        };
      })(this);
      buildOptions = (function(_this) {
        return function(parent, options) {
          var j, len, option, ref, results, selected;
          if (_this._value == null) {
            _this._value = RESOLVE_DEFAULT(options, _this.config);
          }
          if (_this.config.sort) {
            options = options.sort(SORT_METHOD[_this.config.sort]);
          }
          results = [];
          for (j = 0, len = options.length; j < len; j++) {
            option = options[j];
            if (_this.config.multiple) {
              selected = false;
              if (_this._value instanceof Array) {
                selected = (ref = option[_this.config.options.value], indexOf.call(_this._value, ref) >= 0);
              } else {
                selected = option[_this.config.options.value] === _this._value;
              }
              results.push(sim.label(function() {
                var ref1;
                this.appendTo(parent);
                this.text((ref1 = option[self.config.options.label]) != null ? ref1 : option[self.config.options.value]);
                return this.prepend(sim.input(function() {
                  var key;
                  this.prop('checked', selected);
                  this.attr('type', 'checkbox');
                  this.attr('value', option[self.config.options.value]);
                  this.attr('data-type', typeof option[self.config.options.value]);
                  if (self.config.options.data) {
                    for (key in self.config.options.data) {
                      this.attr("data-" + key, option[self.config.options.data[key]]);
                    }
                  }
                  return this.on('change', function() {
                    return self._changed();
                  });
                }));
              }));
            } else {
              if (_this.config.options.nested && !option.nested) {
                option.nested = _this.config.options.nested;
              }
              if (option.nested) {
                nested.push(option);
              }
              selected = option[_this.config.options.value] === _this._value;
              results.push(sim.option(function() {
                var key, ref1;
                this.prop('selected', selected);
                this.attr('value', option[self.config.options.value]);
                this.attr('data-type', typeof option[self.config.options.value]);
                if (self.config.options.data) {
                  for (key in self.config.options.data) {
                    this.attr("data-" + key, option[self.config.options.data[key]]);
                  }
                }
                this.text((ref1 = option[self.config.options.label]) != null ? ref1 : option[self.config.options.value]);
                return this.appendTo(parent);
              }));
            }
          }
          return results;
        };
      })(this);
      if (Array.isArray(this.config.options.store)) {
        this._input.empty();
        if (this.config.multiple) {
          if (this.config.options.nested) {
            nested.push({
              independent: true,
              nested: this.config.options.nested
            });
          }
          if (this.config.grouped) {
            if (this.config.sort) {
              this.config.options.store = this.config.options.store.sort(SORT_METHOD[this.config.sort]);
            }
            ref = this.config.options.store;
            for (j = 0, len = ref.length; j < len; j++) {
              group = ref[j];
              if ((ref1 = group.options) != null ? ref1.length : void 0) {
                this._input.append(sim.div('.i-optgroup', function() {
                  this.attr('data-label', group.label);
                  return buildOptions(this, group.options);
                }));
              }
            }
          } else {
            buildOptions(this._input, this.config.options.store);
          }
        } else {
          this._emptyOption = sim.option(function() {
            var ref2, ref3, ref4;
            this.attr('value', '');
            return this.text((ref2 = (ref3 = (ref4 = self.config.options.placeholder) != null ? ref4.label : void 0) != null ? ref3 : self.config.options.placeholder) != null ? ref2 : '');
          });
          this._input.append(this._emptyOption);
          if (this.config.grouped) {
            if (this.config.sort) {
              this.config.options.store = this.config.options.store.sort(SORT_METHOD[this.config.sort]);
            }
            ref2 = this.config.options.store;
            for (l = 0, len1 = ref2.length; l < len1; l++) {
              group = ref2[l];
              if ((ref3 = group.options) != null ? ref3.length : void 0) {
                this._input.append(sim.optgroup(function() {
                  this.attr('label', group.label);
                  return buildOptions(this, group.options);
                }));
              }
            }
          } else {
            buildOptions(this._input, this.config.options.store);
          }
        }
        fieldsets = [];
        if (self.config.editable && self.config.options.nested) {
          fieldsets.push({
            config: nestedToEditMode(Object.cloneDeep(self.config.options.nested)),
            value: EDIT_MODE_ONLY
          });
        }
        if ((ref4 = self.config.options.placeholder) != null ? ref4.nested : void 0) {
          fieldsets.push({
            config: self.config.options.placeholder.nested,
            value: '',
            independent: false
          });
        }
        for (n = 0, len2 = nested.length; n < len2; n++) {
          option = nested[n];
          fieldsets.push({
            config: option.nested,
            value: option.value,
            independent: option.independent
          });
        }
        this.initialized = true;
        this._changed(false);
        return Fieldset.createSubFieldsets(this, fieldsets, callback);
      } else {
        if (this.mode === 'edit') {
          fieldsets = [];
          if (self.config.editable && self.config.options.nested) {
            fieldsets.push({
              config: nestedToEditMode(Object.cloneDeep(self.config.options.nested)),
              value: EDIT_MODE_ONLY
            });
          }
          return Fieldset.createSubFieldsets(this, fieldsets, callback);
        }
        if (this.config.reloadable) {
          this.button('.btn.btn-xs.btn-transparent.form-control-refresh', function() {
            this.i('.far.fa-repeat');
            return this.on('click', function() {
              this.prop('enabled', false);
              return reload(false, (function(_this) {
                return function() {
                  return _this.prop('enabled', true);
                };
              })(this));
            });
          });
        }
        return reload(true, callback);
      }
    };

    SelectInput.prototype.save = function() {
      var checked, selected, state;
      state = SelectInput.__super__.save.call(this);
      if (this.mode !== 'edit') {
        if (this.config.multiple) {
          checked = this._input.find('input:checked');
          if (checked.length) {
            state.label = checked.map(function(item) {
              return item.parent().text;
            });
          }
        } else {
          selected = this._input.__dom.options[this._input.__dom.selectedIndex];
          if (selected) {
            state.label = sim(selected).text();
          }
        }
      }
      return state;
    };

    SelectInput.prototype.toConfig = function() {
      return SelectInput.toConfig(this.config);
    };

    SelectInput.toConfig = function(config, includeNested) {
      var obj, store;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = Input.toConfig(config);
      delete obj['options'];
      delete obj['sort'];
      delete obj['grouped'];
      if (obj.reloadable !== false) {
        delete obj['reloadable'];
      }
      store = config.options;
      if ('string' === typeof store) {
        store = null;
      }
      if ((store != null) && !Array.isArray(store)) {
        store = store.store;
      }
      if (Array.isArray(store)) {
        if (config.grouped) {
          store = store.reduce(function(array, value, index) {
            return array.concat(value.options.map(function(item) {
              return item;
            }));
          }, []);
        }
        if (includeNested) {
          obj.options = store.map(function(item) {
            var out, spec;
            out = {
              label: item.label,
              value: item.value
            };
            if (Array.isArray(item.nested)) {
              out.nested = (function() {
                var j, len, ref, ref1, results;
                ref = item.nested;
                results = [];
                for (j = 0, len = ref.length; j < len; j++) {
                  spec = ref[j];
                  results.push(((ref1 = INPUT_TYPES[spec.type]) != null ? ref1 : Input).toConfig(spec, true));
                }
                return results;
              })();
            }
            return out;
          });
        } else if (!config.dynamic && obj.validate !== false && store.length) {
          if (obj.validate == null) {
            obj.validate = {};
          }
          obj.validate["enum"] = store.map(function(item) {
            return item.value;
          });
        }
      }
      return obj;
    };

    SelectInput.prototype._validate = function(value) {
      var ref, ref1, ref2, ref3, ref4, ref5;
      if (this.config.multiple) {
        if (!(value instanceof Array)) {
          this.errors.push(imt.l('formula', 'errors.invalidarray', {
            data: {
              field: (ref = this.config.label) != null ? ref : this.config.name
            }
          }));
          return;
        }
        if (this.config.required && value.length === 0) {
          this.errors.push(imt.l('formula', 'errors.required', {
            data: {
              field: (ref1 = this.config.label) != null ? ref1 : this.config.name
            }
          }));
          return;
        }
        if ((((ref2 = this.config.validate) != null ? ref2.minItems : void 0) != null) && value.length < this.config.validate.minItems) {
          this.errors.push(imt.l('formula', 'errors.selectedless', {
            data: {
              value: this.config.validate.minItems,
              field: (ref3 = this.config.label) != null ? ref3 : this.config.name
            }
          }));
        }
        if ((((ref4 = this.config.validate) != null ? ref4.maxItems : void 0) != null) && value.length > this.config.validate.maxItems) {
          this.errors.push(imt.l('formula', 'errors.selectedmore', {
            data: {
              value: this.config.validate.maxItems,
              field: (ref5 = this.config.label) != null ? ref5 : this.config.name
            }
          }));
        }
      }
      return null;
    };

    SelectInput.prototype.getDataValue = function(name) {
      var sel;
      sel = sim(this._input.__dom.options[this._input.__dom.selectedIndex]);
      return sel.data(name);
    };

    return SelectInput;

  })(EditableInput);

  global.HookSelectInput = (function(superClass) {
    extend1(HookSelectInput, superClass);

    function HookSelectInput() {
      return HookSelectInput.__super__.constructor.apply(this, arguments);
    }

    HookSelectInput.prototype.addOption = function(option, selected) {
      if (this.config.options.learning && selected) {
        this._autoLearn = true;
      }
      return HookSelectInput.__super__.addOption.call(this, option, selected);
    };

    HookSelectInput.prototype.build = function() {
      var self;
      HookSelectInput.__super__.build.call(this);
      self = this;
      this._hookInfo = sim.div('.i-formula-hook-info.collapse', function() {
        var ta;
        ta = this.textarea('.form-control', function() {
          this.prop('readOnly', true);
          this.attr('rows', 1);
          return this.on('focus', function() {
            return ta.__dom.select();
          });
        });
        this.div('.collapse.small.text-left', function() {
          this.p().text(imt.l('inspector', 'panels.hooks.listening'));
          return self._learningInfo = this;
        });
        if (self.config.options.learning) {
          this.button('.btn.btn-xs.btn-info.mr-2', function() {
            this.text(imt.l('inspector', 'panels.hooks.redetermine'));
            return self._learnButton = this;
          });
        }
        return this.button('.btn.btn-xs.btn-default', function() {
          this.text(imt.l('inspector', 'panels.hooks.copy'));
          return this.on('click', function() {
            var ex;
            try {
              ta.__dom.select();
              document.execCommand('copy');
              return new Flash(imt.l('inspector', 'panels.hooks.copied'));
            } catch (error) {
              ex = error;
              return new Prompt(ta.val());
            }
          });
        });
      }).insertAfter(this._inputGroup);
      this._attachedInfo = this.div('.collapse', function() {
        var ref;
        this.p('.small.text-muted.mt-3').text(imt.l('inspector', 'panels.hooks.attached', {
          data: {
            service: (ref = self.form.options["package"]) != null ? ref.label : void 0
          }
        }));
        return this.button('.btn.btn-sm.btn-info', function() {
          this.text(imt.l('inspector', 'panels.hooks.show'));
          return this.on('click', function() {
            this.remove();
            self._hookInfo.toggleClass('collapse');
            return self.form.emit('resize');
          });
        });
      }).insertAfter(this._inputGroup);
      this._goneInfo = this.div('.collapse', function() {
        return this.p('.small.text-muted.mt-3', function() {
          this.text(imt.l('inspector', 'panels.hooks.gone'));
          return this.prepend(sim.i('.fa.far.fa-fw.fa-ban.mr-2.text-danger'));
        });
      }).insertAfter(this._inputGroup);
      return this.on('change', (function(_this) {
        return function() {
          return _this._reloadHookInfo();
        };
      })(this));
    };

    HookSelectInput.prototype.destroy = function() {
      if (typeof this._stopLearning === "function") {
        this._stopLearning();
      }
      return HookSelectInput.__super__.destroy.call(this);
    };

    HookSelectInput.prototype.initialize = function(done) {
      var fails, learning, ping, ref, start, stop, timer;
      learning = false;
      timer = null;
      fails = 0;
      ping = (function(_this) {
        return function() {
          return Loader.api('hooks/ping', {
            method: "POST",
            data: {
              hook: _this.value
            }
          }, function(err, res) {
            if (err) {
              if (++fails > 3) {
                return stop(err);
              }
              timer = delay(2000, ping);
              return;
            }
            fails = 0;
            if (res.learning) {
              timer = delay(2000, ping);
              return;
            }
            return stop(null, true);
          });
        };
      })(this);
      start = this._startLearning = (function(_this) {
        return function() {
          if (learning) {
            return;
          }
          learning = true;
          _this._learningInfo.removeClass('collapse');
          _this._learnButton.removeClass('btn-info').addClass('btn-danger').text('Stop').prepend(sim.i('.far.fa-spin.fa-circle-notch.mr-2'));
          _this.form.emit('resize');
          return Loader.api('hooks/learn/start', {
            method: "POST",
            data: {
              hook: _this.value
            }
          }, function(err, res) {
            if (err) {
              return stop(err);
            }
            return timer = delay(5000, ping);
          });
        };
      })(this);
      stop = this._stopLearning = (function(_this) {
        return function(err, success) {
          if (!learning) {
            return;
          }
          learning = false;
          _this._learningInfo.addClass('collapse');
          _this._learnButton.removeClass('btn-danger').addClass('btn-info').text(imt.l('inspector', 'panels.hooks.redetermine'));
          if (!success) {
            undelay(timer);
            Loader.api('hooks/learn/stop', {
              method: "POST",
              data: {
                hook: _this.value
              }
            }, function(err, res) {
              if (err) {
                return console.error(err);
              }
            });
          } else {
            _this._learnButton.before(sim.small('.text-success.mr-3', function() {
              this.text(imt.l('inspector', 'panels.hooks.determined'));
              return this.prepend(sim.i('.far.fa-check-circle.mr-2'));
            }));
            _this._learnButton.remove();
          }
          return _this.form.emit('resize');
        };
      })(this);
      if ((ref = this._learnButton) != null) {
        ref.on('click', function() {
          if (learning) {
            return stop();
          } else {
            return start();
          }
        });
      }
      return HookSelectInput.__super__.initialize.call(this, (function(_this) {
        return function() {
          _this._reloadHookInfo();
          return done.apply(null, arguments);
        };
      })(this));
    };

    HookSelectInput.prototype._reloadHookInfo = function() {
      var autoLearn;
      autoLearn = this._autoLearn;
      this._autoLearn = false;
      if (!this.value) {
        this._hookInfo.addClass('collapse');
        this.form.emit('resize');
        return;
      }
      return Loader.api('hooks/ping', {
        method: "POST",
        data: {
          hook: this.value
        }
      }, (function(_this) {
        return function(err, res) {
          if (err) {
            return console.error(err);
          }
          if (res.gone) {
            _this._attachedInfo.addClass('collapse');
            _this._goneInfo.removeClass('collapse');
            _this.form.emit('resize');
            return;
          }
          _this._attachedInfo[res.attached ? 'removeClass' : 'addClass']('collapse');
          _this._hookInfo.children('textarea').val(res.address);
          _this._hookInfo[!res.attached ? 'removeClass' : 'addClass']('collapse');
          _this.form.emit('resize');
          if (autoLearn) {
            return _this._startLearning();
          }
        };
      })(this));
    };

    return HookSelectInput;

  })(SelectInput);

  INPUT_TYPES['select'] = SelectInput;

  global.Submit = (function(superClass) {
    extend1(Submit, superClass);

    function Submit(fieldset1, group) {
      var ref;
      this.fieldset = fieldset1;
      Submit.__super__.constructor.call(this, 'div');
      this.form = this.fieldset.form;
      if (group != null) {
        this.group = group;
      }
      this.addClass('form-group');
      if ((ref = this.form.options) != null ? ref.inline : void 0) {
        this.addClass('row justify-content-end');
      }
      this.appendTo(this.group || this.fieldset);
    }

    Submit.prototype.build = function() {
      var self;
      self = this;
      return this.div(function() {
        var ref;
        if ((ref = self.form.options) != null ? ref.inline : void 0) {
          this.addClass('col-8');
        }
        return this.button('.btn.btn-primary.btn-block.i-formula-submit', function() {
          this.attr('type', 'button');
          this.text(self.config.label);
          return this.on('click', self.fieldset.form._submitForm);
        });
      });
    };

    return Submit;

  })(SIMElement);

  INPUT_TYPES['submit'] = Submit;

  global.Suggestion = (function(superClass) {
    extend1(Suggestion, superClass);

    function Suggestion(fieldset1, group1, container) {
      this.fieldset = fieldset1;
      this.group = group1;
      if (container) {
        Suggestion.__super__.constructor.call(this, sim(container));
      } else {
        Suggestion.__super__.constructor.call(this, 'div');
        this.appendTo(this.group || this.fieldset);
      }
      this.suggestionTimeout = null;
    }

    Suggestion.prototype._transformIML = function(config, context) {
      var data, k, v;
      data = {};
      if ('object' === typeof config) {
        for (k in config) {
          v = config[k];
          switch (typeof v) {
            case 'string':
              data[k] = IML.execute(IML.parse(v), context) || {};
              break;
            case 'number':
              data[k] = v;
          }
        }
      }
      return data;
    };

    Suggestion.prototype.build = function() {
      var self;
      self = this;
      if (this.config.watch != null) {
        return this.fieldset.form.values.on(this.config.watch, (function(_this) {
          return function(value) {
            clearTimeout(_this.suggestionTimeout);
            if (!_this.fieldset.active) {
              return;
            }
            if (!value) {
              return _this.empty();
            }
            return _this.suggestionTimeout = setTimeout(function() {
              return Loader.ajax(self.config.request.url, {
                data: _this._transformIML(self.config.request.qs, {
                  value: value
                })
              }, function(err, response) {
                var iterate;
                if (err) {
                  return;
                }
                _this.empty();
                iterate = IML.execute(IML.parse(self.config.request.response.iterate || '{{body}}'), {
                  body: response
                }) || [];
                if (Array.isArray(iterate) && iterate.length > 0) {
                  return _this.div('.i-formula-suggestion', function() {
                    if (self.config.label) {
                      this.div('.i-formula-suggestion-label', function() {
                        return this.text(self.config.label);
                      });
                    }
                    return this.div('.list-group', function() {
                      var data, item, j, len, ref, results;
                      ref = response.results;
                      results = [];
                      for (j = 0, len = ref.length; j < len; j++) {
                        item = ref[j];
                        data = self._transformIML(self.config.request.response.output, {
                          item: item
                        });
                        results.push(this[data.link ? 'a' : 'div']('.list-group-item', function() {
                          if (data.link) {
                            this.attr('href', data.link);
                            this.attr('target', '_blank');
                          }
                          if (data.icon) {
                            this.i(".list-group-icon.fal.fa-" + data.icon);
                          }
                          if (data.content) {
                            return this.div('.list-group-split', function() {
                              this.div('.list-group-title').text(data.title);
                              return this.small().html(data.content);
                            });
                          } else {
                            return this.div('.list-group-title').text(data.title);
                          }
                        }));
                      }
                      return results;
                    });
                  });
                }
              });
            }, 300);
          };
        })(this));
      }
    };

    return Suggestion;

  })(SIMElement);

  INPUT_TYPES['suggestion'] = Suggestion;

  global.TextInput = (function(superClass) {
    extend1(TextInput, superClass);

    function TextInput() {
      return TextInput.__super__.constructor.apply(this, arguments);
    }

    TextInput.property('value', {
      get: function() {
        var m;
        if ((this._input.value == null) || this._input.value === '') {
          return '';
        }
        if (this.mode === 'edit') {
          return this._input.value;
        } else {
          if (this.config.type === 'date') {
            if (this.config.time === false) {
              m = moment.tz(this._input.value, "L", imt.user.timezone);
              if (!m.isValid()) {
                return this._input.value;
              }
              return m.toDate();
            } else {
              m = moment.tz(this._input.value, "L LT", imt.user.timezone);
              if (!m.isValid()) {
                return this._input.value;
              }
              return m.toDate();
            }
          } else if (this.config.type === 'time') {
            m = moment(this._input.value, "LT");
            if (!m.isValid()) {
              return this._input.value;
            }
            return m.locale('en').format('HH:mm');
          } else {
            return this._input.value;
          }
        }
      },
      set: function(value) {
        var m;
        if (this.mode === 'edit') {
          return this._coder.value = value;
        } else {
          if ((value != null) && value !== '') {
            if (this.config.type === 'date') {
              if (this.config.time === false) {
                m = moment.tz(value, 'UTC');
                if (m.isValid()) {
                  value = m.tz(imt.user.timezone).format("L");
                }
              } else {
                m = moment.tz(value, 'UTC');
                if (m.isValid()) {
                  value = m.tz(imt.user.timezone).format("L LT");
                }
              }
            } else if (this.config.type === 'time') {
              m = moment(value, "HH:mm");
              if (m.isValid()) {
                value = m.format("LT");
              }
            }
          }
          this._input.value = value;
          return this._changed();
        }
      }
    });

    TextInput.prototype._fromCoder = function(value) {
      var m;
      if ((value == null) || value === '') {
        return TextInput.__super__._fromCoder.call(this, value);
      }
      if (this.config.type === 'date') {
        if (this.config.time === false) {
          m = moment.tz(value, 'UTC');
          if (!m.isValid()) {
            return TextInput.__super__._fromCoder.call(this, value);
          }
          return m.tz(imt.user.timezone).format("L");
        } else {
          m = moment.tz(value, 'UTC');
          if (!m.isValid()) {
            return TextInput.__super__._fromCoder.call(this, value);
          }
          return m.tz(imt.user.timezone).format("L LT");
        }
      } else if (this.config.type === 'time') {
        m = moment.tz(value, "HH:mm", 'UTC');
        if (!m.isValid()) {
          return TextInput.__super__._fromCoder.call(this, value);
        }
        return m.tz(imt.user.timezone).format("LT");
      } else {
        return TextInput.__super__._fromCoder.call(this, value);
      }
    };

    TextInput.prototype._toCoder = function(value) {
      var m;
      if ((value == null) || value === '') {
        return TextInput.__super__._toCoder.call(this, value);
      }
      if (this.config.type === 'time') {
        m = moment.tz(this._input.value, "LT", imt.user.timezone);
        if (!m.isValid()) {
          return TextInput.__super__._toCoder.call(this, value);
        }
        return m.utc().format('HH:mm');
      } else {
        return TextInput.__super__._toCoder.call(this, value);
      }
    };


    /*
    	Build TextInput from config.
     */

    TextInput.prototype.build = function() {
      var block, element, elm, elm2, exts, ref, ref1, ref2, ref3, ref4, ref5, ref6, resolveFormat, resolveTZ, self;
      TextInput.__super__.build.call(this);
      self = this;
      element = this.config.multiline || this.config.coder ? 'textarea' : 'input';
      this._wrap(function() {
        var ref, ref1;
        this[element]('.form-control', function() {
          var ref, ref1, ref2, ref3, ref4, ref5;
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          this.attr('name', self.name);
          if ((ref = self.form.options) != null ? ref.placeholders : void 0) {
            this.attr('placeholder', self.config.label);
          }
          if (self.config.multiline) {
            this.attr('rows', self.config.rows || 3);
          }
          if (self.config.autoComplete === false) {
            this.attr('autocomplete', 'off');
          }
          if (element === 'input') {
            if (self.config.type === 'password') {
              this.attr('type', 'password');
            } else {
              this.attr('type', 'text');
            }
          }
          if (self.config.readonly) {
            this.prop('readOnly', true);
          }
          if (self.config.required) {
            this.prop('required', true);
          }
          if (self.config.coder || ((ref1 = self.form.options) != null ? ref1.coder : void 0)) {
            self.__mode = 'edit';
            self._coder = this.coder({
              name: self.name,
              type: self.config.type,
              samples: (ref2 = self.config.samples) != null ? ref2 : (ref3 = self.form.options) != null ? ref3.samples : void 0,
              pills: (ref4 = self.config.pills) != null ? ref4 : (ref5 = self.form.options) != null ? ref5.pills : void 0,
              showErasePill: self.config.showErasePill
            });
            return this.on('change', function() {
              return self._changed();
            });
          } else {
            return this.on((browser.ie ? 'keypress paste drop input blur' : 'input blur'), function(event) {
              var ref6;
              return self._changed(self.errors.length > 0 || ((ref6 = event.type) === 'blur' || ref6 === 'paste' || ref6 === 'drop'));
            });
          }
        });
        return (ref = (ref1 = self._coder) != null ? ref1._root : void 0) != null ? ref : self._input;
      });
      block = sim.ul('.i-validations-block.list-unstyled');
      switch (self.config.type) {
        case 'filename':
          if (self.config.extension) {
            exts = Array.isArray(self.config.extension) ? self.config.extension : [self.config.extension];
            block.li('.i-validation-file').text(imt.l('formula', 'hints.filetypes', {
              data: {
                value: exts.join(', ')
              }
            }));
          }
          break;
        case 'text':
          if (((ref = self.config.validate) != null ? ref.max : void 0) > 0 && ((ref1 = self.config.validate) != null ? ref1.min : void 0) > 0) {
            if (self.config.validate.max === self.config.validate.min) {
              block.li('.i-validation-text').text(imt.l('formula', 'hints.exactlength', {
                data: {
                  value: self.config.validate.max
                }
              }));
            } else {
              block.li('.i-validation-text').text(imt.l('formula', 'hints.lengthbetween', {
                data: {
                  a: self.config.validate.min,
                  b: self.config.validate.max
                }
              }));
            }
          } else if (((ref2 = self.config.validate) != null ? ref2.max : void 0) > 0) {
            block.li('.i-validation-text').text(imt.l('formula', 'hints.lengthmost', {
              data: {
                value: self.config.validate.max
              }
            }));
          } else if (((ref3 = self.config.validate) != null ? ref3.min : void 0) > 0) {
            block.li('.i-validation-text').text(imt.l('formula', 'hints.lengthleast', {
              data: {
                value: self.config.validate.min
              }
            }));
          }
          if ((ref4 = self.config.validate) != null ? ref4.pattern : void 0) {
            block.li('.i-validation-check').text(imt.l('formula', 'hints.pattern', {
              data: {
                pattern: self.config.validate.pattern
              }
            }));
          }
          switch (self.config.tags) {
            case 'strip':
            case 'stripall':
              block.li('.i-validation-tags').text(imt.l('formula', 'hints.striptags'));
              break;
            case 'escape':
              block.li('.i-validation-tags').text(imt.l('formula', 'hints.escapetags'));
          }
          break;
        case 'number':
        case 'integer':
        case 'uinteger':
          if (((ref5 = self.config.validate) != null ? ref5.max : void 0) != null) {
            block.li('.i-validation-lower').text(imt.l('formula', 'hints.numberlower', {
              data: {
                value: self.config.validate.max
              }
            }));
          }
          if (((ref6 = self.config.validate) != null ? ref6.min : void 0) != null) {
            block.li('.i-validation-higher').text(imt.l('formula', 'hints.numberhigher', {
              data: {
                value: self.config.validate.min
              }
            }));
          }
          break;
        case 'port':
          block.li('.i-validation-check').text(imt.l('formula', 'hints.port'));
          break;
        case 'date':
          resolveTZ = function() {
            var ref7, ref8;
            if (self.mode === 'edit') {
              return imt.l('formula', 'hints.timezone', {
                data: {
                  value: (ref7 = (ref8 = self.form.options) != null ? ref8.timezone : void 0) != null ? ref7 : imt.user.timezone
                }
              });
            } else {
              return imt.l('formula', 'hints.timezone', {
                data: {
                  value: imt.user.timezone
                }
              });
            }
          };
          resolveFormat = function() {
            if (self.mode === 'edit') {
              return imt.l('formula', 'hints.formats');
            } else {
              return imt.l('formula', 'hints.format', {
                data: {
                  value: (moment.localeData().longDateFormat('L')) + " " + (self.config.time === false ? '' : moment.localeData().longDateFormat('LT'))
                }
              });
            }
          };
          elm = block.li('.i-validation-globe').text(resolveTZ());
          elm2 = block.li('.i-validation-clock').html(format(resolveFormat(), 'markdown'));
          this.on('mode_change', function() {
            elm.text(resolveTZ());
            return elm2.text(resolveFormat());
          });
          break;
        case 'time':
          resolveTZ = function() {
            var ref7, ref8;
            return imt.l('formula', 'hints.timezone', {
              data: {
                value: (ref7 = (ref8 = self.form.options) != null ? ref8.timezone : void 0) != null ? ref7 : imt.user.timezone
              }
            });
          };
          resolveFormat = function() {
            if (self.mode === 'edit') {
              return imt.l('formula', 'hints.format', {
                data: {
                  value: 'HH:mm'
                }
              });
            } else {
              return imt.l('formula', 'hints.format', {
                data: {
                  value: moment.localeData().longDateFormat('LT')
                }
              });
            }
          };
          elm = block.li('.i-validation-globe').text(resolveTZ());
          elm2 = block.li('.i-validation-clock').text(resolveFormat());
          this.on('mode_change', function() {
            elm.text(resolveTZ());
            return elm2.text(resolveFormat());
          });
      }
      if (block.children().length) {
        this.append(block);
      }
      return this.built = true;
    };


    /*
    	Initialize input with initial value.
     */

    TextInput.prototype.initialize = function(callback) {
      var format, panel, self;
      TextInput.__super__.initialize.call(this);
      self = this;
      switch (this.config.type) {
        case 'date':
        case 'time':
          panel = null;
          if (this.config.type === 'date') {
            if (this.config.time === false) {
              format = "L";
            } else {
              format = "L LT";
            }
          } else {
            format = 'LT';
          }
          this._input.on('focusin', (function(_this) {
            return function(event) {
              var datePicker, update, updating;
              datePicker = null;
              updating = false;
              update = function() {
                var m, value;
                value = self._input.value;
                m = moment.tz(value, format, imt.user.timezone);
                if (!m.isValid()) {
                  value = new Date();
                }
                updating = true;
                datePicker.datetimepicker('date', value);
                return updating = false;
              };
              panel = new Panel(_this._input);
              panel.offsetX = 5;
              panel.width(260);
              panel.title = imt.l('formula', 'panels.datepicker.title');
              panel.content = sim.div(function() {
                datePicker = this;
                this.datetimepicker({
                  inline: true,
                  format: format,
                  timeZone: imt.user.timezone,
                  buttons: {
                    showToday: true
                  }
                });
                update();
                this.toJquery().on('change.datetimepicker', function(event) {
                  if (updating) {
                    return;
                  }
                  return self._input.value = event.date.format(format);
                });
                this.toJquery().on('update.datetimepicker', function() {
                  return panel != null ? panel._resize() : void 0;
                });
                return self._input.on('input', update);
              });
              return panel.on('destroy', function() {
                return self._input.off('input', update);
              });
            };
          })(this));
          this._input.on('focusout', function(event) {
            return panel != null ? panel.close() : void 0;
          });
      }
      return typeof callback === "function" ? callback(null) : void 0;
    };

    TextInput.prototype._validate = function(value) {
      var ext, exts, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      switch (this.config.type) {
        case 'number':
        case 'integer':
        case 'uinteger':
        case 'port':
          if (isNaN(Number(value))) {
            this.errors.push(imt.l('formula', 'errors.invalidnumber', {
              data: {
                field: (ref = this.config.label) != null ? ref : this.config.name
              }
            }));
          }
          if ((ref1 = this.config.type) === 'integer, uinteger' || ref1 === 'port') {
            if (Number(value) % 1 !== 0) {
              this.errors.push(imt.l('formula', 'errors.invalidint', {
                data: {
                  field: (ref2 = this.config.label) != null ? ref2 : this.config.name
                }
              }));
            }
            if ((ref3 = this.config.type) === 'uinteger' || ref3 === 'port') {
              if (Number(value) < 0) {
                this.errors.push(imt.l('formula', 'errors.invaliduint', {
                  data: {
                    field: (ref4 = this.config.label) != null ? ref4 : this.config.name
                  }
                }));
              }
            }
          }
          break;
        case 'color':
          if (!/#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})/.test(value)) {
            this.errors.push(imt.l('formula', 'errors.invalidcolor', {
              data: {
                field: (ref5 = this.config.label) != null ? ref5 : this.config.name
              }
            }));
          }
          break;
        case 'date':
          value = IMTDate.parse(value);
          if (!value) {
            this.errors.push(imt.l('formula', 'errors.invaliddate', {
              data: {
                field: (ref6 = this.config.label) != null ? ref6 : this.config.name
              }
            }));
          } else if (((ref7 = this.config.validate) != null ? ref7.past : void 0) === false && new Date() > value) {
            this.errors.push(imt.l('formula', 'errors.dateinpast', {
              data: {
                field: (ref8 = this.config.label) != null ? ref8 : this.config.name
              }
            }));
          }
          break;
        case 'email':
          if (!/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i.test(value)) {
            this.errors.push(imt.l('formula', 'errors.invalidemail', {
              data: {
                field: (ref9 = this.config.label) != null ? ref9 : this.config.name
              }
            }));
          }
          break;
        case 'time':
          value = IMTDate.parseTime(value);
          if (value == null) {
            this.errors.push(imt.l('formula', 'errors.invalidtime', {
              data: {
                field: (ref10 = this.config.label) != null ? ref10 : this.config.name
              }
            }));
          }
          break;
        case 'url':
          if (!/^.+:\/\/.+$/i.test(value)) {
            this.errors.push(imt.l('formula', 'errors.invalidurl', {
              data: {
                field: (ref11 = this.config.label) != null ? ref11 : this.config.name
              }
            }));
          }
          break;
        case "filename":
          if (((ref12 = this.config.validate) != null ? ref12.extension : void 0) != null) {
            exts = 'string' === typeof this.config.validate.extension ? [this.config.validate.extension] : this.config.validate.extension;
            ext = (ref13 = /\.(.+)$/.exec(value)) != null ? ref13[1] : void 0;
            if ((ext == null) || indexOf.call(exts, ext) < 0) {
              this.errors.push(imt.l('formula', 'errors.invalidext', {
                data: {
                  field: (ref14 = this.config.label) != null ? ref14 : this.config.name
                }
              }));
            }
          }
          break;
        case "password":
          if ((ref15 = this.config.validate) != null ? ref15.complexity : void 0) {
            if (value.length > 1024) {
              this.errors.push(imt.l('formula', 'errors.pwdmaxlength'));
            }
            if (value.length < 9) {
              this.errors.push(imt.l('formula', 'errors.pwdlength'));
            }
            if (!/[a-z]/.test(value)) {
              this.errors.push(imt.l('formula', 'errors.pwdlower'));
            }
            if (!/[A-Z]/.test(value)) {
              this.errors.push(imt.l('formula', 'errors.pwdupper'));
            }
            if (!/[0-9]/.test(value)) {
              this.errors.push(imt.l('formula', 'errors.pwdnumber'));
            }
            if (!/[^A-Za-z0-9]/.test(value)) {
              this.errors.push(imt.l('formula', 'errors.pwdspecial'));
            }
          }
      }
      return null;
    };

    TextInput.prototype.toJSON = function() {
      var value;
      value = this.value;
      if (this.mode !== 'edit' && TextInput.cast[this.config.type]) {
        value = TextInput.cast[this.config.type](value, this.config);
      }
      return value;
    };

    TextInput.cast = {
      buffer: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      },
      color: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      },
      date: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      },
      email: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      },
      integer: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return Math.floor(this.number(value, config));
      },
      number: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return Number(value);
      },
      port: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return Math.min(65535, this.uinteger(value, config));
      },
      time: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      },
      timestamp: function(value, config) {
        this.uinteger(value, config);
        return value;
      },
      uinteger: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return Math.max(0, this.integer(value, config));
      },
      url: function(value, config) {
        if (!config.required && String(value).trim() === "") {
          return null;
        }
        return value;
      }
    };

    return TextInput;

  })(Input);

  INPUT_TYPES['text'] = TextInput;

  global.TokensInput = (function(superClass) {
    extend1(TokensInput, superClass);

    function TokensInput() {
      return TokensInput.__super__.constructor.apply(this, arguments);
    }

    TokensInput.prototype.addItem = function(value, replace) {
      if ('string' === typeof value) {
        value = {
          token: value,
          note: ''
        };
      }
      if (!replace && this._items.children('li').toArray().some(function(item) {
        return item.data('value').token === value.token;
      })) {
        return this;
      }
      return TokensInput.__super__.addItem.call(this, value, replace);
    };

    TokensInput.prototype.build = function() {
      var base, ref, ref1, self;
      if ((base = this.config).spec == null) {
        base.spec = [
          {
            label: 'Token',
            name: 'token',
            type: 'text',
            required: true
          }, {
            label: imt.l('base', 'common.note'),
            name: 'note',
            type: 'text'
          }
        ];
      }
      TokensInput.__super__.build.call(this);
      self = this;
      if (((ref = this.config.options) != null ? ref.tokenType : void 0) === 'safari' && (global.safari != null)) {
        this.find('.form-control').first().button('.btn.btn-transparent.btn-xs.text-primary.ml-2', function() {
          this.attr('type', 'button');
          this.text('Add this Safari');
          this.prepend(sim.i('.fab.fa-fw.fa-safari.mr-1'));
          return this.on('click', function(event) {
            var ex, perm;
            event.stopPropagation();
            perm = global.safari.pushNotification.permission("web.com.workfrontfusion." + imt.env);
            if (perm.permission === 'granted') {
              return self.addItem({
                token: perm.deviceToken,
                note: 'My Safari'
              });
            }
            if (perm.permission === 'denied') {
              return new Alert('Permission was denied, please check your Safari settings.').show();
            }
            try {
              return global.safari.pushNotification.requestPermission("https://" + global.location.hostname + "/apn/safari/push", "web.com.workfrontfusion." + imt.env, {}, function(perm) {
                if (perm.permission === 'granted') {
                  return self.addItem({
                    token: perm.deviceToken,
                    note: 'My Safari'
                  });
                }
              });
            } catch (error) {
              ex = error;
              return new Alert('Asking for push notifications permissions is disabled in Safari preferences.').show();
            }
          });
        });
      }
      if (((ref1 = this.config.options) != null ? ref1.tokenType : void 0) === 'chrome' && (global.chrome != null)) {
        return this.find('.form-control').first().button('.btn.btn-transparent.btn-xs.text-primary.ml-2', function() {
          this.attr('type', 'button');
          this.text('Add this Chrome');
          this.prepend(sim.i('.fab.fa-fw.fa-chrome.mr-1'));
          return this.on('click', function(event) {
            event.stopPropagation();
            return global.chrome.runtime.sendMessage('cfamjaolobgncfhomepbmjjihlbkchgb', 'permissions', function(perm) {
              var alert;
              if (!perm) {
                alert = new Alert('Chrome extension is not installed.');
                alert._footer.a('.btn.btn-primary', function() {
                  this.attr('href', 'https://chrome.google.com/webstore/detail/workfrontfusion-customizable-e/cfamjaolobgncfhomepbmjjihlbkchgb');
                  this.attr('target', '_blank');
                  this.text('Install');
                  return this.on('click', function() {
                    return alert.hide();
                  });
                });
                alert.show();
                return;
              }
              if (perm.permissions !== 'granted') {
                return new Alert('Please, activate the extension first.').show();
              }
              return self.addItem({
                token: perm.deviceToken,
                note: 'My Chrome'
              });
            });
          });
        });
      }
    };

    TokensInput.prototype.toConfig = function() {
      return TokensInput.toConfig(this.config);
    };

    TokensInput.toConfig = function(config, includeNested) {
      var obj;
      if (includeNested == null) {
        includeNested = false;
      }
      obj = Input.toConfig(config, includeNested);
      delete obj['options'];
      delete obj['spec'];
      return obj;
    };

    return TokensInput;

  })(ArrayInput);

  INPUT_TYPES['tokens'] = TokensInput;

  global.UploadInput = (function(superClass) {
    extend1(UploadInput, superClass);

    function UploadInput() {
      return UploadInput.__super__.constructor.apply(this, arguments);
    }

    UploadInput.property('value', {
      get: function() {
        return null;
      },
      set: function(value) {}
    });


    /*
    	Build TextInput from config.
     */

    UploadInput.prototype.build = function() {
      var self;
      UploadInput.__super__.build.call(this);
      self = this;
      this._wrap(function() {
        this.input('.form-control', function() {
          self._input = this;
          self._inputRoot = this;
          this.attr('id', self.id);
          this.attr('name', self.name);
          if (self.config.accept) {
            this.attr('accept', self.config.accept);
          }
          this.attr('type', 'file');
          return this.prop('multiple', self.config.multiple !== false);
        });
        return self._input;
      });
      return this.built = true;
    };

    UploadInput.prototype.toJSON = function() {
      return this._input.__dom.files;
    };

    return UploadInput;

  })(Input);

  INPUT_TYPES['upload'] = UploadInput;

  FormulaOAuth = {

    /*
    	Called from RemoteFormula to open popup on user's click event and prevent popup to be blocked.
     */
    win: function(url) {
      if (url == null) {
        url = '/wait';
      }
      if (browser.mobile) {
        return;
      }
      return window.open(url, 'authAccountWindow', 'scrollbars=yes,location=no,status=no,width=1024,height=768');
    },
    auth: function(win, accid, scope, done) {
      var check, url;
      this.status = imt.l('formula', 'panels.account.creating');
      if (scope == null) {
        scope = [];
      }
      url = "/oauth/auth/" + accid + (scope.length ? "?scope=" + (scope.map(encodeURIComponent).join('&scope=')) : '');
      console.log("[imt:oauth_auth]", url);
      check = (function(_this) {
        return function() {
          var tmr;
          _this.status = imt.l('formula', 'panels.account.waiting');
          return tmr = repeat(500, function() {
            if (win.closed) {
              unrepeat(tmr);
              _this.status = imt.l('formula', 'panels.account.verifying');
              return FormulaOAuth.test(accid, done);
            }
          });
        };
      })(this);
      if (browser.mobile) {
        this.loading = false;
        return this.content = sim.button('.btn.btn-primary', function() {
          this.attr('type', 'button');
          this.text(imt.l('formula', 'panels.account.authorize'));
          return this.on('click', function() {
            win = window.open(url, 'authAccountWindow', 'scrollbars=yes,location=no,status=no,width=1024,height=768');
            if (!win) {
              return done(new Error(imt.l('base', 'common.popup')));
            }
            return check();
          });
        });
      } else {
        win.location.href = url;
        return check();
      }
    },
    test: function(accid, done) {
      return Loader.api("account/" + accid + "/test", function(err, working) {
        if (err) {
          return done(err);
        }
        if (working) {
          return done(null);
        } else {
          return done(new Error(imt.l('formula', 'panels.account.verifyfailed')));
        }
      });
    },
    extend: function(accid, scope, done) {
      var tmr, url, win;
      url = "/oauth/extend/" + accid + "?scope=" + (scope.map(encodeURIComponent).join('&scope='));
      console.log("[imt:oauth_extendScope]", url);
      win = window.open(url, 'authAccountWindow', 'scrollbars=yes,location=no,status=no,width=1024,height=768');
      if (!win) {
        return done(new Error(imt.l('formula', 'panels.account.popup')));
      }
      return tmr = repeat(500, (function(_this) {
        return function() {
          if (win.closed) {
            unrepeat(tmr);
            _this.status = imt.l('formula', 'panels.account.verifying');
            return Loader.api("account/" + accid + "/scoped", {
              method: "POST",
              data: {
                scope: JSON.stringify(scope)
              }
            }, function(err, valid) {
              if (err) {
                return done(err);
              }
              if (valid) {
                return done(null);
              } else {
                return done(new Error(imt.l('formula', 'panels.account.extendfailed')));
              }
            });
          }
        };
      })(this));
    }
  };

  global.RemoteFormulaModal = (function(superClass) {
    extend1(RemoteFormulaModal, superClass);

    function RemoteFormulaModal(cfg, relative, loaded) {
      RemoteFormulaModal.__super__.constructor.call(this);
      this.addClass('modal-remote-formula');
      this.build(cfg, relative, loaded);
    }

    RemoteFormulaModal.prototype.build = function(cfg, relative, loaded) {
      var self;
      self = this;
      return Loader.load(cfg.url, {
        headers: {
          'x-imt-remote-formula': 'yes'
        }
      }, function(err, data) {
        var base, form, ref;
        if (typeof loaded === "function") {
          loaded(null);
        }
        if (err) {
          return new Alert(err.message).show();
        }
        form = new Formula(cfg.name);
        form.config = data.config;
        form.values = data.values;
        form.options = (ref = cfg.options) != null ? ref : {};
        if ((base = form.options).company == null) {
          base.company = cfg.company;
        }
        form.build(function(err) {
          var button;
          if (err) {
            return new Alert(err.message).show();
          }
          self.title = form.name;
          self.content = form;
          button = self.addButton(cfg.save || imt.l('base', 'common.save'), 'primary');
          button.on('click', function(event) {
            var elm, file, formData, j, key, l, len, len1, ref1, value, win;
            event.stopPropagation();
            if (form.isValid()) {
              self.loading = true;
              button.prop('disabled', true);
              if (data.multipart) {
                formData = new FormData;
                ref1 = form.toJSON();
                for (key in ref1) {
                  value = ref1[key];
                  if (value instanceof FileList) {
                    for (j = 0, len = value.length; j < len; j++) {
                      file = value[j];
                      formData.append(key + "[]", file);
                    }
                  } else if (Array.isArray(value)) {
                    for (l = 0, len1 = value.length; l < len1; l++) {
                      elm = value[l];
                      formData.append(key + "[]", elm);
                    }
                  } else {
                    formData.append(key, value);
                  }
                }
              } else {
                formData = form.toJSON();
              }
              if (!browser.mobile && form.getDataValueOfSelectedItem('account_type', 'method') === 'oauth') {
                win = FormulaOAuth.win();
                if (!win) {
                  button.prop('disabled', false);
                  return self.warn(new Error(imt.l('base', 'common.popup')), form);
                }
              }
              Loader.load(cfg.url, {
                method: 'POST',
                data: formData,
                headers: {
                  'x-imt-remote-formula': 'yes'
                }
              }, function(err, directives) {
                var oauthing, rebuilding, ref2, ref3, ref4, region, successArgs;
                if (err) {
                  button.prop('disabled', false);
                  return self.warn(err, form);
                }
                rebuilding = false;
                oauthing = false;
                if (directives.formula) {
                  if (directives.formula.oauth) {
                    oauthing = true;
                    successArgs = [directives.formula.oauth.account, directives.formula.oauth.name, directives.formula.oauth.provider];
                    FormulaOAuth.auth.call(self, win, directives.formula.oauth.account, (ref2 = form.options.oauth) != null ? (ref3 = ref2.scope) != null ? ref3[directives.formula.oauth.provider] : void 0 : void 0, function(err) {
                      var ref4;
                      if (err) {
                        button.prop('disabled', false);
                        return self.warn(err, form);
                      }
                      if ((ref4 = cfg.success) != null) {
                        ref4.apply(self, successArgs);
                      }
                      return self.hide();
                    });
                  } else if (win) {
                    win.close();
                  }
                  if (!oauthing && directives.formula.rebuild) {
                    rebuilding = true;
                    button.remove();
                    self.build(extend(cfg, directives.formula.rebuild), relative);
                  }
                  if (!oauthing && directives.formula.success) {
                    if ((ref4 = cfg.success) != null) {
                      ref4.apply(self, directives.formula.success);
                    }
                  }
                  delete directives.formula;
                }
                if (relative) {
                  region = relative.closest('.list-group-item');
                  if (region == null) {
                    region = relative.closest('tr');
                  }
                }
                if (false !== AJAXDirectives.process(relative, directives, region)) {
                  if (!rebuilding && !oauthing) {
                    return self.hide();
                  }
                }
              });
            }
            return false;
          });
          form.on('loading-start', function() {
            return button.prop('disabled', true);
          });
          form.on('loading-stop', function() {
            return button.prop('disabled', false);
          });
          return self.show();
        });
        return form.once('has_advanced_parameters', function() {
          return sim.label('.i-advanced-parameters', function() {
            this.prependTo(self._footer);
            this.input(function() {
              this.attr('type', 'checkbox');
              return this.on('change', (function(_this) {
                return function() {
                  return form.advancedParametersVisible = _this.is(':checked');
                };
              })(this));
            });
            this.write(imt.l('formula', 'buttons.showadvanced'));
            if (form.built) {
              this.addClass('i-yellow-fade');
              return delay(3000, (function(_this) {
                return function() {
                  return _this.removeClass('i-yellow-fade');
                };
              })(this));
            }
          });
        });
      });
    };

    return RemoteFormulaModal;

  })(Modal);

  global.RemoteFormulaPanel = (function(superClass) {
    extend1(RemoteFormulaPanel, superClass);

    function RemoteFormulaPanel(relative, cfg) {
      RemoteFormulaPanel.__super__.constructor.call(this, relative);
      if (cfg.help) {
        this.help = cfg.help;
      }
      if (cfg.width) {
        this.width(cfg.width);
      }
      if (cfg.expandable) {
        this.expandable = cfg.expandable;
      }
      this.title = cfg.name;
      this.loading = true;
      this.build(cfg, relative);
    }

    RemoteFormulaPanel.prototype.build = function(cfg, relative) {
      var buttons, self;
      self = this;
      buttons = sim.array();
      sim.button('.btn.btn-sm.btn-outline-secondary', function() {
        this.attr('type', 'button');
        this.text(imt.l('base', 'common.cancel'));
        this.appendTo(self._footer);
        buttons.push(this);
        return this.on('click', self._close);
      });
      return Loader.load(cfg.url, {
        headers: {
          'x-imt-remote-formula': 'yes'
        }
      }, function(err, data) {
        var base, form, ref;
        if (err) {
          return self.warn(err);
        }
        form = new Formula(cfg.name);
        form.config = data.config;
        form.values = data.values;
        form.options = (ref = cfg.options) != null ? ref : {};
        if ((base = form.options).company == null) {
          base.company = cfg.company;
        }
        form.on('resize', self._resize);
        form.build(function(err) {
          if (err) {
            return self.warn(err);
          }
          sim.button(".btn.btn-sm.btn-primary", function() {
            var ref1;
            this.attr('type', 'button');
            this.text(cfg.save || imt.l('base', 'common.save'));
            this.appendTo(self._footer);
            buttons.push(this);
            if (((ref1 = form.options["package"]) != null ? ref1.name : void 0) === 'quickbooks') {
              this.text('').addClass('p-0 b-0');
              this.img(function() {
                this.attr('src', imt["static"]('/img/3rdparty/quickbooks_connect.png'));
                return this.css('height', '31px');
              });
            }
            this.on('click', function(event) {
              var elm, file, formData, j, key, l, len, len1, ref2, value, win;
              if (form.isValid()) {
                self.loading = true;
                this.prop('disabled', true);
                if (data.multipart) {
                  formData = new FormData;
                  ref2 = form.toJSON();
                  for (key in ref2) {
                    value = ref2[key];
                    if (value instanceof FileList) {
                      for (j = 0, len = value.length; j < len; j++) {
                        file = value[j];
                        formData.append(key + "[]", file);
                      }
                    } else if (Array.isArray(value)) {
                      for (l = 0, len1 = value.length; l < len1; l++) {
                        elm = value[l];
                        formData.append(key + "[]", elm);
                      }
                    } else {
                      formData.append(key, value);
                    }
                  }
                } else {
                  formData = form.toJSON();
                }
                if (!browser.mobile && form.getDataValueOfSelectedItem('account_type', 'method') === 'oauth') {
                  win = FormulaOAuth.win();
                  if (!win) {
                    this.prop('disabled', false);
                    return self.warn(new Error(imt.l('base', 'common.popup')), form);
                  }
                }
                Loader.load(cfg.url, {
                  method: 'POST',
                  data: formData,
                  headers: {
                    'x-imt-remote-formula': 'yes'
                  }
                }, (function(_this) {
                  return function(err, directives) {
                    var oauthing, rebuilding, ref3, ref4, ref5, region, successArgs;
                    if (err) {
                      _this.prop('disabled', false);
                      return self.warn(err, form);
                    }
                    self.emit('save');
                    rebuilding = false;
                    oauthing = false;
                    if (directives.formula) {
                      if (directives.formula.oauth) {
                        oauthing = true;
                        successArgs = [directives.formula.oauth.account, directives.formula.oauth.name, directives.formula.oauth.provider];
                        FormulaOAuth.auth.call(self, win, directives.formula.oauth.account, (ref3 = form.options.oauth) != null ? (ref4 = ref3.scope) != null ? ref4[directives.formula.oauth.provider] : void 0 : void 0, function(err) {
                          var ref5;
                          if (err) {
                            _this.prop('disabled', false);
                            return self.warn(err, form);
                          }
                          if ((ref5 = cfg.success) != null) {
                            ref5.apply(self, successArgs);
                          }
                          return self._close();
                        });
                      } else if (win) {
                        win.close();
                      }
                      if (!oauthing && directives.formula.rebuild) {
                        rebuilding = true;
                        buttons.remove();
                        self.build(extend(cfg, directives.formula.rebuild), relative);
                      }
                      if (!oauthing && directives.formula.success) {
                        if ((ref5 = cfg.success) != null) {
                          ref5.apply(self, directives.formula.success);
                        }
                      }
                      delete directives.formula;
                    }
                    if (relative) {
                      region = relative.closest('.list-group-item');
                      if (region == null) {
                        region = relative.closest('tr');
                      }
                    }
                    if (false !== AJAXDirectives.process(relative, directives, region)) {
                      if (!rebuilding && !oauthing) {
                        return self._close();
                      }
                    }
                  };
                })(this));
              }
              return false;
            });
            form.on('loading-start', (function(_this) {
              return function() {
                return _this.prop('disabled', true);
              };
            })(this));
            return form.on('loading-stop', (function(_this) {
              return function() {
                return _this.prop('disabled', false);
              };
            })(this));
          });
          self.content = form;
          return self.loading = false;
        });
        form.once('has_advanced_parameters', function() {
          return sim.label('.i-advanced-parameters', function() {
            this.appendTo(self._footer);
            this.input(function() {
              this.attr('type', 'checkbox');
              return this.on('change', (function(_this) {
                return function() {
                  return form.advancedParametersVisible = _this.is(':checked');
                };
              })(this));
            });
            this.write(imt.l('formula', 'buttons.showadvanced'));
            if (form.built) {
              this.addClass('i-yellow-fade');
              return delay(3000, (function(_this) {
                return function() {
                  return _this.removeClass('i-yellow-fade');
                };
              })(this));
            }
          });
        });
        return self.on('destroy', function() {
          return form.destroy();
        });
      });
    };

    return RemoteFormulaPanel;

  })(Panel);

}).call(this);
