export default {
	icon: 'far fa-link',
	name: 'swapConnection',
	label: 'Swap Connection',
	description: `
		The Tool takes the connection from the selected module and sets the same
		connection to all modules of the same app in the scenario.`,
	theme: '#EEEEEE',
	modifier: true,
	input: [
		{
			name: 'sourceModule',
			label: 'Source Module',
			type: 'select',
			options: {
				store: 'rpc://listModules',
				nested: [
					{
						name: 'inModule',
						label: 'Target Module',
						type: 'select',
						options: 'rpc://listModulesOfPackage',
						help: 'Module to swap the connection in. If empty, connection is swapped in the whole scenario.',
						mappable: true
					}
				]
			},
			help: 'Source module to copy the connection from.',
			mappable: true,
			required: true
		},
	],
	steps: [
		{
			type: 'javascript',
			code: `

			const connectionParam = Inspector.seek(parameters.sourceModule).config.parameters.find(p => p.type.startsWith('account:'));
			const connectionParamName = connectionParam.name || '__IMTCONN__';

			Inspector.instance._surface.find(Surface.Module)
				.filter(m => m.package.name === Inspector.seek(parameters.sourceModule).package.name)
				.filter(m => parameters.inModule ? m.id === parseInt(parameters.inModule) : true)
				.forEach(m => m.parameters[connectionParamName] = Inspector.seek(parameters.sourceModule).parameters[connectionParamName]);
			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		},
		{
			name: 'listModulesOfPackage',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).filter(m => m.package.name === Inspector.seek(parameters.sourceModule).package.name).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
