import Extercomm from '../lib/Extercomm.mjs';
import * as DManip from '../lib/DManip.mjs';
import * as ChromeAsync from '../lib/ChromeAsync.mjs';

/**
 * VIEW CONFIGURATION
 * Add more views by importing them bellow
 * All entries will be automatically generated by
 * specifying them in views array.
 * The order from views array is preserved.
 */

import * as LiveStream from './views/LiveStream/LiveStream.mjs';
import * as ScenarioDebugger from './views/ScenarioDebugger/ScenarioDebugger.mjs';
import * as Tools from './views/Tools/Tools.mjs';

const views = [
	LiveStream,
	ScenarioDebugger,
	Tools
];

// === END OF VIEW CONFIGURATION

// Connect to background runtime. No usage now but prepared for the future use
// Instance the Extercomm library and some other initial values
// And force the adblock check off
// eslint-disable-next-line no-undef
// imt.adblock = false;
chrome.runtime.connect({ name: 'imt.devtool' });
const extercomm = new Extercomm();
let lastActiveId = views[0].config.id;

// IIFE async startup
(async () => {
	const content = document.getElementById('content');
	content.innerHTML = `
	<div style="height: 100%; width: 100%" class="d-flex">
		<div class="my-auto mx-auto lead font-weight-bold text-secondary">
			Waiting for Extercomm...
		</div>
	</div>`;
	const localSettings = await ChromeAsync.get('localSettings');
	await extercomm.init(localSettings);
	content.innerHTML = '';
	const controls = document.getElementById('controls');
	// Generate menu entry and content pane for each view
	views.forEach(async (view, index) => {
		content.appendChild(DManip.makeArticle(view.config.template, view.config.id, index === 0));
		const control = DManip.makeControl(view.config.id, view.config.name, view.config.sidebarIcon, index === 0);
		const meta = {
			initiated: index === 0 ? true : false
		};
		control.addEventListener('click', (() => {
			return async () => {
				if (!meta.initiated) {
					await view.init(extercomm);
					meta.initiated = true;
				}
				focusSectionView(view.config.id);
			};
		})());
		controls.appendChild(control);
		// Register event handlers of the view
		view.registerHandlers(extercomm, meta, focusSectionView.bind(undefined, view.config.id));
		if (index === 0) {
			await view.init(extercomm);
		}
	});
	// Link to docs
	document.getElementById('openHelp').addEventListener('click', async () => {
		await ChromeAsync.openTab(`https://one.workfront.com/`);
	});
})();

/**
 * Helper function used to re-focus the menu item
 * @param {string} newActiveId New item to focus
 */
async function focusSectionView(newActiveId) {
	if (lastActiveId === newActiveId) {
		return;
	}
	document.getElementById(`${newActiveId}View`).classList.remove('inactive');
	document.getElementById(`${lastActiveId}View`).classList.add('inactive');
	document.getElementById(`${lastActiveId}Control`).classList.remove('active');
	document.getElementById(`${newActiveId}Control`).classList.add('active');
	// If there were some editor changes, the refresh must be done
	DManip.refreshMirrors();
	lastActiveId = newActiveId;
}

/**
 * Reload triggers
 */
chrome.tabs.onUpdated.addListener(async (id, changeInfo) => {
	if (changeInfo.status === 'complete' && id === chrome.devtools.inspectedWindow.tabId) {
		document.location.reload();
	}
});
