export default {
	icon: 'far fa-filter',
	name: 'copyFilter',
	label: 'Copy Filter',
	description: `
		Copies a filter.
		The filter is always assigned to the module that's on it's <b>right</b>.
		For example, when you need to copy a filter that's between modules 1 and 2 and place it between modules 3 and 4, 
		then pick the module 2 as the source and the module 4 as the target.`,
	theme: '#EEEEEE',
	modifier: true,
	input: [
		{
			name: 'source',
			label: 'Source Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'This will copy the filter that\'s on the LEFT side of the selected module.',
			mappable: true,
			required: true
		},
		{
			name: 'target',
			label: 'Target Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'This will paste the filter to the LEFT side of the selected module.',
			mappable: true,
			required: true
		},
		{
			name: 'preserveFallback',
			label: 'Preserve Fallback Route setting',
			type: 'boolean',
			required: true,
			default: false,
			help: 'When checked, then if the filter is used as a fallback route on a router and is copied to another router, then the fallback setting will be preserved, but only if there\'s no another fallback route on the target router.'
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
					Inspector.seek(parameters.target).filter = Inspector.seek(parameters.source).filter;

					// If should preserve fallback
					if(parameters.preserveFallback === true) {

						// Test prevInFlow
						const prevInFlow = Inspector.seek(parameters.source).prevInFlow
						if(!prevInFlow || prevInFlow.config.name !== 'BasicRouter') {
							return;
						}

						// Now we know it exists and it's a router
						const els = prevInFlow.parameters && prevInFlow.parameters.else;
						if(els === undefined) {
							return;
						}

						// Now we know there's an else branch, let's confirm if it's our branch
						const elseLink = prevInFlow._outputLinks[els];
						if(!elseLink) {
							// Should never happen, but you know.
							return;
						}

						// There's an else branch, but this is not our source, so we won't continue
						if(elseLink.node2.__id !== parameters.source) {
							return;
						}

						// Now we can be sure, that we should copy the Fallback.

						// Check if there's a router before the target
						const prevInTargetFlow = Inspector.seek(parameters.target).prevInFlow
						if(!prevInTargetFlow || prevInTargetFlow.config.name !== 'BasicRouter') {
							return;
						}

						// Check if else is set on the target router, if so, then return 
						const elseTarget = prevInTargetFlow.parameters && prevInTargetFlow.parameters.else;
						if(elseTarget) {
							return;
						}

						if(!(prevInTargetFlow.parameters)) {
							prevInTargetFlow.parameters = {};
						}

						// So we know we can set the else, but we need to find on which link we are
						let index;
						prevInTargetFlow._outputLinks.forEach((l, i) => {
							if(l.node2.__id === parameters.target) {
								index = i;
							}
						});

						// If no index, return. This should not happen.
						if(index === undefined) {
							return;
						}

						// Finally, set the else
						prevInTargetFlow.parameters.else = index;

					}
			`
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
