export default {
	icon: 'fas fa-search',
	name: 'searchByConfig',
	label: 'Find module(s) by mapping',
	description: 'Returns IDs of modules with a specified keyword in their mapping.',
	theme: '#EEEEEE',
	input: [
		{
			name: 'keyword',
			label: 'Keyword',
			type: 'text',
			help: 'A keyword to search for.',
			required: true
		},
		{
			name: 'useOnlyValues',
			label: 'Use Only Values',
			type: 'boolean',
			required: true,
			default: true,
			help: 'When using this option, the tool will search only through values. If unchecked, even the keys are considered.'
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
				if(parameters.useOnlyValues) {
					const searchThruVals = (o,n) => {
						console.log(o);
						let found = false;
						for(const a of Object.values(o)) {
							if((typeof a === 'string' && a.toLowerCase().includes(n.toLowerCase())) || a === n){ return true; }
							if(typeof a === 'object' && a !== null && a !== undefined){ 
								if(Array.isArray(a)) {
									found = a.some(e => {
										return searchThruVals(e, n);
									})
								} else {
									if(!found) {
										return searchThruVals(a, n); 
									}
								}
							}
						} 
						return found;
					}
					return Inspector.instance._surface.find(Surface.Module)
						.filter(m => searchThruVals(Object.assign({}, m.parameters || {}, m.mapper || {}), parameters.keyword)).map(m => m.__id)
				} else {
					const extract = (spec, property) => {
						const ex = (property, element) => {
							return (element[property]
								? [element[property]]
								: []).concat(element.spec
									? Array.isArray(element.spec)
										? element.spec.flatMap(ex.bind({}, property))
										: element.spec[property] || []
									: []);
						}
						return spec.flatMap(ex.bind({}, property))
					};
					return Inspector.instance._surface.find(Surface.Module)
						.filter(m => { 
							const labels = extract((m.metadata.expect || []).concat(m.metadata.parameters || []), 'label').map(l => l.toLowerCase());
							return JSON.stringify(Object.assign({}, m.parameters || {}, m.mapper || {})).toLowerCase().includes(parameters.keyword.toLowerCase()) || labels.includes(parameters.keyword.toLowerCase())
					}).map(m => m.__id)
				}
			`,
			response: {
				output: '{{result}}'
			}
		}
	]
};
