export default {
	icon: 'far fa-table',
	name: 'resheet',
	label: 'Migrate GS',
	description: `
		Replace your Google Sheet modules with ease.`,
	theme: '#0FA763',
	input: [
	],
	steps: [
		{
			type: 'javascript',
			code: `
				(async() => {
					const replacator = {
						ActionAddRow: 'addRow',
						ActionUpdateRow: 'updateRow',
						ActionDeleteRow: 'deleteRow',
						ActionGetReport: 'filterRows',
						ActionUpdateCell: 'updateCell',
						ActionAddWorksheet: 'addSheet',
						ActionGetCell: 'getCell',
						TriggerNewRow: 'watchRows',
						ActionListWorksheets: 'listSheets',
						ActionDeleteWorksheet: 'deleteSheet'
					};
					let shift = 0;
					let timeout = 500;
					const output = [];
					const originals = Inspector.instance._surface.find(Surface.Module).filter(m => m.package.name === 'google-sheets' && m.package.version.startsWith('1.'));
					for(const original of originals) {

						await new Promise(resolve => {
							setTimeout(resolve, timeout);
						})

						if(timeout >= 200) {
							timeout -= 50;
						}

						const plop = (module, x, y) => { module.x = x + shift; module.y = y; Inspector.instance._surface.stage.attach(module); }
						const newModuleName = replacator[original.config.name];
						if(newModuleName) {
							await new Promise(resolve => {
								Repository.get('google-sheets', newModuleName, async (err, replacee) => {
									if(replacee) {
										replacee.id = Inspector.instance.scenario.idSequence++;
										plop(replacee, original.x + 300, original.y);
										original.nextAll().forEach(nextie => {
											new Surface.Animation(nextie, {
												x: {
													plus: 300
												}
											},
											{
												interrupt: true,
												duration: 200,
												completeOnInterrupt: true,
												easing: 'easeOutCirc'
											})
										});
										if(original.next) {
											original.next._inputLink.node1 = replacee;
										}
										Inspector.instance._surface.stage.attach(new Surface.Link(original, replacee));
										replacee.setupRequired = true;
										replacee.validate();
									}
									resolve();
								})
							})
						}

						Inspector.instance.align();

					}
					Inspector.instance.align();
				})();
			`
		}
	]
};
