export default {
  icon: 'fad fa-biohazard',
  name: 'pandemia',
  label: 'Pandemia',
  description: 'Fight against the global pandemia in your Workfront Scenario!',
  theme: '#ff4500',
  input: [],
  hidden: true,
  steps: [
    {
      type: 'javascript',
      code: `
			(() => {
				const PAN = 5000;

				Array.prototype.forEach.call(document.getElementsByTagName("header"), (e) => e.style.setProperty('display', 'none'));
				Array.prototype.forEach.call(document.getElementsByClassName("i-inspector-menu"), (e) => e.style.setProperty('display', 'none'));

				Inspector.instance._surface.find(Surface.Node).filter(n => n.__gamenode === true).forEach(m => Inspector.instance._surface.stage.detach(m));
				Inspector.instance._surface.find(Surface.Label).forEach(m => Inspector.instance._surface.stage.detach(m));
				Inspector.instance._surface.camera.zoom = 0.4;
				Inspector.instance._surface.camera.panTo(PAN, PAN);
				Inspector.instance._surface.stage._events.dblclick[0] = () => { };
				Inspector.instance._surface.input.doubleClickEnabled = false;
				Inspector.instance._surface.input.contextMenuEnabled = false;
				Inspector.instance._surface.camera.locked = true;
				Inspector.instance._surface.input.enabled = true;

				const GRID_Y_DIMM = 10;
				const GRID_X_DIMM = 20;
			
				const COLOR_HEALTHY = new Color(0, 126, 229);
				const COLOR_ILL = new Color(240, 20, 20);
				const COLOR_IMMUNE = new Color(50, 205, 50);
				const COLOR_DEAD = new Color(0, 0, 0);

				const ICON_HEALTHY = 'https://app.workfrontfusion.com/static/img/temporary/pandemia-head.png';
				const ICON_ILL = 'https://app.workfrontfusion.com/static/img/temporary/pandemia-infected.png';
				const ICON_IMMUNE = 'https://app.workfrontfusion.com/static/img/temporary/pandemia-mask.png';
				const ICON_DEAD = 'https://app.workfrontfusion.com/static/img/temporary/pandemia-skull.png';
				const ICON_COUGH = 'https://app.workfrontfusion.com/static/img/temporary/pandemia-cough.png';

				let GAME_OVER = false;
				let POINTS = 0;

				const scoreCounter = new Surface.Label('Score', -PAN + 30 + 10 * 180, -PAN - 30 - 5 * 180, 500, 0);
				Inspector.instance._surface.stage.attach(scoreCounter);
				scoreCounter.text = 'Score:'
				scoreCounter.scale = 3;
				scoreCounter.width = 500;
				scoreCounter.text = 'Score: ' + POINTS;
				scoreCounter.width = scoreCounter.textWidth;
				scoreCounter.update = (value) => {
					scoreCounter.text = 'Score: ' + (value || POINTS);
					scoreCounter.width = scoreCounter.textWidth;
				}
			
				const GRID = Array(GRID_X_DIMM);
				const CELLS = [];
			
				for (let i = 0; i < GRID_X_DIMM; i++) {
					GRID[i] = Array(GRID_Y_DIMM);
					for (let j = 0; j < GRID_Y_DIMM; j++) {
						const cell = {
							hasVirus: false,
							module: undefined,
							hidden: true,
							x_pos: i,
							y_pos: j,
							neighbors: () => {
								const o = [];
								for (let k = i - 1; k <= i + 1; k++) {
									for (let l = j - 1; l <= j + 1; l++) {
										if (GRID[k] !== undefined && GRID[k][l] !== undefined && GRID[k][l].module !== undefined && !(k == i && l == j)) {
											o.push(GRID[k][l]);
										}
									}
								}
								return o;
							}
						};
						CELLS.push(cell);
						GRID[i][j] = cell;
					}
				}
			
				function getRandomInt(min, max) {
					min = Math.ceil(min);
					max = Math.floor(max);
					return Math.floor(Math.random() * (max - min)) + min;
				}
			
				function getRandomFreeCell() {
					const freeCells = CELLS.filter(c => c.module === undefined);
					return freeCells[getRandomInt(0, freeCells.length)];
				}
			
				function areCellsAvailable() {
					return CELLS.some(c => c.module === undefined);
				}
			
				function healtyCells() {
					return CELLS.some(c => (c.module !== undefined && c.hasVirus === false && c.dead !== true));
				}
			
				function healtyCellsCount() {
					return (CELLS.filter(c => (c.module !== undefined && c.hasVirus === false && c.dead !== true))).length;
				}
			
				function immuneCellsCount() {
					return (CELLS.filter(c => (c.module !== undefined && c.immune === true && c.hasVirus === false && c.dead !== true))).length;
				}
			
				function allHealtyCells() {
					return CELLS.every(c => (c.module !== undefined && (c.hasVirus === false || c.dead === true)));
				}
			
				function checkGameState() {
					if (GAME_OVER) {
						return;
					}
					if (!healtyCells()) {
						GAME_OVER = true;
						scoreCounter.update();
						Inspector.instance._surface.input.enabled = false;
						m = new Modal;
						m.title = 'Game Over';
						m.content = sim.p().text('All modules were infected. Your Score: ' + POINTS);
						m.show()
					} else if (allHealtyCells() && !areCellsAvailable()) {
						GAME_OVER = true;
						POINTS += 100 * healtyCellsCount();
						POINTS += 100 * immuneCellsCount();
						scoreCounter.update();
						Inspector.instance._surface.input.enabled = false;
						m = new Modal;
						m.title = 'You Win!';
						m.content = sim.p().text('At least one module was saved! Your Score: ' + POINTS);
						m.show()
					}
				}
			
				const die = (cell) => {
					clearInterval(cell.lifeInterval);
					cell.dead = true;
					POINTS -= 50;
					cell.module.progress = 0;
					cell.module.theme = COLOR_DEAD;
					cell.module._icon.url = ICON_DEAD;
					cell.module.grayed = true;
					cell.module.focusable = false;
					cell.module.interactive = false;
					cell.module._events.mousedown[0] = () => { };
					checkGameState();
				}
			
				const cure = (cell) => {
					if (cell.hasVirus === true) {
						clearInterval(cell.lifeInterval);
						cell.module.progress = 0;
						cell.hasVirus = false;
						cell.module.theme = COLOR_IMMUNE;
						cell.module._icon.url = ICON_IMMUNE;
						cell.immune = true;
						cell.lifeTotal = getRandomInt(10, 20);
						cell.life = 0;
						cell.lifeInterval = setInterval(() => {
							cell.life += 0.05;
							cell.module.progress = (cell.life / cell.lifeTotal) * 100;
							if (cell.life > cell.lifeTotal) {
								cell.module.theme = COLOR_HEALTHY;
								cell.immune = false;
								cell.module._icon.url = ICON_HEALTHY;
								cell.module.progress = 0;
								clearInterval(cell.lifeInterval);
							}
						}, 50);
						Inspector.instance._surface.stage.detach(cell.module);
						Inspector.instance._surface.stage.attach(cell.module);
					} else {
						die(cell)
					}
					checkGameState();
				}
			
				const infect = (cell, plop = true) => {
					if (cell.hasVirus || cell.immune === true) {
						return;
					}
					cell.hasVirus = true;
					cell.module.theme = COLOR_ILL;
					cell.module._icon.url = ICON_ILL;
					cell.lifeTotal = getRandomInt(8, 15);
					cell.life = 0;
					cell.lifeInterval = setInterval(() => {
						cell.life += 0.05;
						cell.module.progress = (cell.life / cell.lifeTotal) * 100;
						if (cell.life > cell.lifeTotal) {
							die(cell);
						}
					}, 50);
					if (plop) {
						Inspector.instance._surface.stage.detach(cell.module);
						Inspector.instance._surface.stage.attach(cell.module);
					}
					checkGameState();
				}
			
				function plop(module, x, y) {
					module.x = -1700 - PAN + x * 180;
					module.y = -850 - PAN + y * 180;
					Inspector.instance._surface.stage.attach(module);
				}
			
				const updateMod = (mod, cell) => {
					mod.id = Inspector.instance.scenario.idSequence++;
					mod.draggable = false;
					mod.focusable = false;
					mod.interactive = true;
					mod.removable = false;
					cell.canSneeze = true;
					mod.__gamenode = true;
					setTimeout(() => {
						cell.canSneeze = true
					}, 500);
					mod._title.__text = '';
					mod._description.__text = '';
					mod._badge.visible = false;
					mod._shadow.visible = false;
					mod.theme = COLOR_HEALTHY;
					mod._icon.url = ICON_HEALTHY;
					mod._inputAnchorDragger.visible = false;
					mod._outputAnchorDragger.visible = false;
					mod._events.mousedown[0] = () => {
						cure(cell)
					};
				}
			
				function makeHealtyModule() {
					if (!areCellsAvailable()) {
						return;
					}
					const mod = new Surface.Node();
					const cell = getRandomFreeCell();
					updateMod(mod, cell);
					cell.module = mod;
					plop(mod, cell.x_pos, cell.y_pos);
				}
			
				function makeIllModule() {
					if (!areCellsAvailable()) {
						return;
					}
					const mod = new Surface.Node();	
					const cell = getRandomFreeCell();
					updateMod(mod, cell);
					cell.module = mod;
					infect(cell, false);
					plop(mod, cell.x_pos, cell.y_pos);
				}
			
				const illModules = () => CELLS.filter(c => c.hasVirus === true && c.dead !== true);
			
				const sneeze = (m) => {
					if (m.canSneeze !== true) {
						return;
					}
					m.neighbors().forEach(n => {
						if (n.dead) { return; }
						infect(n);
					});
				}
			
				const sneezeGlobal = () => illModules().forEach(m => sneeze(m));
			
				for (let i = 0; i < 30; i++) { makeHealtyModule(); }
			
				const acceleratingInterval = (rules, fun) => {
					let i = 0;
					let currentRepeats = 0;
					let currentRule = rules[i];
					const handler = () => {
						++currentRepeats;
						fun();
						if (currentRule.repeats && currentRepeats >= currentRule.repeats) {
							clearInterval(ticker);
							i++;
							currentRule = rules[i];
							if (currentRule) {
								currentRepeats = 0;
								ticker = setInterval(handler, currentRule.timeout);
							}
						}
					}
					let ticker = setInterval(handler, currentRule.timeout);
				}
			
				acceleratingInterval([
					{
						repeats: 3,
						timeout: 5000
					},
					{
						repeats: 3,
						timeout: 4000
					},
					{
						repeats: 3,
						timeout: 2000
					},
					{
						timeout: 1000
					}
				], () => {
					if (GAME_OVER) {
						return;
					}
					makeIllModule();
				});
			
				acceleratingInterval([
					{
						repeats: 7,
						timeout: 4000
					},
					{
						repeats: 6,
						timeout: 3000
					},
					{
						repeats: 6,
						timeout: 2000
					},
					{
						timeout: 1500
					}
				], () => {
					if (GAME_OVER) {
						return;
					}
					makeHealtyModule();
				});
			
			
				acceleratingInterval([
					{
						repeats: 3,
						timeout: 3000
					},
					{
						repeats: 5,
						timeout: 2000
					},
					{
						timeout: 1300
					}
				], () => {
					if (GAME_OVER) {
						return;
					}
					sneezeGlobal();
				});
			
				setInterval(checkGameState, 1000);
				setInterval(() => {
					if (GAME_OVER) {
						return;
					}
					POINTS += (healtyCellsCount());
					POINTS += (immuneCellsCount());
					scoreCounter.update();
				}, 500);
			
			})();
			`,
    },
  ],
};
