export default {
	icon: 'far fa-highlighter',
	name: 'highlightApp',
	label: 'Highlight App',
	description: 'Use this tool to highlight a specific version of the App in your scenario',
	theme: '#EEEEEE',
	input: [
		{
			name: 'toFind',
			label: 'App to be highlighted',
			type: 'select',
			help: 'Name of the app to be highlighted.',
			required: true,
			options: {
				store: 'rpc://listAppsInScenario',
				nested: [
					{
						name: 'srcVersion',
						label: 'Version',
						type: 'select',
						options: 'rpc://listAppVersionsInScenario',
						help: 'Version of the app to be highlighted.',
						required: true
					}
				]
			}
		},
		{
			name: 'color',
			type: 'color',
			label: 'Highlight Color',
			help: 'Color to use when highlighting.',
			required: true,
			default: '#FF00FF'
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
					Inspector.instance._surface.find(Surface.Module)
					.filter(m => (m.package.name === parameters.toFind && m.package.version === parameters.srcVersion))
					.forEach(m => m.theme = parameters.color);
			`
		}
	],
	rpcs: [
		{
			name: 'listAppsInScenario',
			steps: [
				{
					type: 'javascript',
					code: `
					const visited = [];
					const out = [];
					const modules = Inspector.instance._surface.find(Surface.Module);
					modules.forEach(m => {
						if(!visited.includes(m.package.name)) {
							visited.push(m.package.name);
							out.push({label:\`\${m.package.label} (\${m.package.name})\`, value: m.package.name});
						}
					})
					return out;
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		},
		{
			name: 'listAppVersionsInScenario',
			steps: [
				{
					type: 'javascript',
					code: `
					const visited = [];
					const out = [];
					const modules = Inspector.instance._surface.find(Surface.Module).filter(m => m.package.name === parameters.toFind);
					modules.forEach(m => {
						if(!visited.includes(m.package.version)) {
							visited.push(m.package.version);
							out.push({value: m.package.version});
						}
					})
					return out;
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
