export default {
	icon: 'fas fa-search',
	name: 'getAppId',
	label: 'Get App Metadata',
	description: 'Retrieves metadata of the selected app.',
	theme: '#EEEEEE',
	input: [
		{
			name: 'sourceModule',
			label: 'Source Module',
			type: 'select',
			options: 'rpc://listModules',
			help: 'Source module to get the metadata of.',
			mappable: true,
			required: true
		}
	],
	steps: [
		{
			type: 'javascript',
			code: `
				const o = {}; const m = Inspector.seek(parameters.sourceModule).package;
				['name', 'label', 'keywords', 'version'].forEach(e => {
					o[e] = m[e];
				});
				return o;
			`,
			response: {
				output: '{{result}}'
			}
		}
	],
	rpcs: [
		{
			name: 'listModules',
			steps: [
				{
					type: 'javascript',
					code: `
						return Inspector.instance._surface.find(Surface.Module).map(m => {return{label:\`\${m.config.label} (\${m.__id})\`,value: m.__id}})
					`,
					response: {
						output: '{{result}}'
					}
				}
			]
		}
	]
};
