const express = require('express');
const path = require('path');
const app = express();
const port = 3000;

// Serve static assets (CSS, JS, images) from the public folder
app.use(express.static(path.join(__dirname, 'public')));

// Route to serve formula123.html
app.get('/formula123.html', (req, res) => {
  res.sendFile(path.join(__dirname, 'views', 'formula.html'));
});

// Route to serve login.html
app.get('/login.html', (req, res) => {
  res.sendFile(path.join(__dirname, 'views', 'login.html'));
});

// Route to serve home.html
app.get('/home.html', (req, res) => {
  res.sendFile(path.join(__dirname, 'views', 'home.html'));
});

app.listen(port, () => {
  console.log(`Server running at http://localhost:${port}`);
});
