function toggleNav() {
  const links = document.querySelector('.nav-links');
  if (links) {
    links.classList.toggle('active');
  }
}

let currentIndex = 0;
let offers = [];
let currentOfferIndex = 0;

function initializeCarousel() {
  const container = document.getElementById("single-offer-container");
  const offerCard = container.querySelector(".offer-card");
  const offerDivs = offerCard.querySelectorAll('[data-tags~="ajo"]');
  if (!offerDivs.length) return;

  const existingControls = offerCard.querySelector(".carousel-controls");
  if (existingControls) existingControls.remove();

  const existingTrack = offerCard.querySelector(".carousel-track");
  if (existingTrack) existingTrack.remove();

  const carouselTrack = document.createElement("div");
  carouselTrack.className = "carousel-track";

  offerDivs.forEach(div => {
    const slide = document.createElement("div");
    slide.className = "carousel-item";
    slide.appendChild(div);
    carouselTrack.appendChild(slide);
  });

  offerCard.appendChild(carouselTrack);

  const controls = document.createElement("div");
  controls.className = "carousel-controls";
  controls.innerHTML = `
    <button onclick="showPreviousOffer()">◀</button>
    <button onclick="showNextOffer()">▶</button>
  `;
  offerCard.appendChild(controls);
}

function scrollCarousel(direction) {
  const track = document.getElementById("carousel-track");
  const scrollAmount = 350;
  track.scrollBy({ left: direction * scrollAmount, behavior: "smooth" });
}

function decodeHtmlEntities(html) {
  const txt = document.createElement("textarea");
  txt.innerHTML = html;
  return txt.value;
}

function runPersonalization() {
  alloy("sendEvent", {
    renderDecisions: true,
    personalization: {
      surfaces: ["#offers-div"]
    }
  }).then(result => {
    const propositions = result.propositions || [];
    let allOffers = [];
    propositions.forEach(prop => {
      allOffers = allOffers.concat(prop.items || []);
    });
    offers = allOffers;

    if (!offers.length) {
      document.getElementById("single-offer-container").innerHTML = "<p>No offers available.</p>";
      return;
    }

    currentOfferIndex = 0;
    renderCurrentOffer();
    initializeCarousel();
  }).catch(error => {
    console.error("❌ Personalization failed:", error);
  });
}

function renderCurrentOffer() {
  const container = document.getElementById("single-offer-container");
  if (!container || !offers.length) return;

  const html = decodeHtmlEntities(offers[currentOfferIndex]?.data?.content || "");
  const wrapper = document.createElement("div");
  wrapper.innerHTML = html.trim();

  container.innerHTML = "";
  const offerCard = document.createElement("div");
  offerCard.className = "offer-card";

  Array.from(wrapper.children).forEach(child => {
    offerCard.appendChild(child);
  });

  container.appendChild(offerCard);
}

function showNextOffer() {
  const track = document.querySelector('.carousel-track');
  const items = document.querySelectorAll('.carousel-item');
  currentIndex = (currentIndex + 1) % items.length;
  track.style.transform = `translateX(-${currentIndex * 100}%)`;
}

function showPreviousOffer() {
  const track = document.querySelector('.carousel-track');
  const items = document.querySelectorAll('.carousel-item');
  currentIndex = (currentIndex - 1 + items.length) % items.length;
  track.style.transform = `translateX(-${currentIndex * 100}%)`;
}

const users = {
  alice: { password: "pass123", crmid: "FIN001" },
  bob: { password: "secret99", crmid: "FIN002" },
  charlie: { password: "qwerty", crmid: "FIN003" }
};

function loadPage(section) {
  const content = document.getElementById("offers-div");
  if (section === "home") {
    fetch("home.html")
      .then(res => res.text())
      .then(html => {
        document.getElementById("offers-div").innerHTML = html;
      });
  } else {
    fetch(section + ".html")
      .then(response => response.text())
      .then(html => {
        content.innerHTML = html;
      })
      .catch(error => {
        content.innerHTML = "<p>Failed to load content.</p>";
      });
  }

  document.querySelectorAll(".nav-link").forEach(link => {
    link.classList.remove("active");
    if (link.dataset.section === section) {
      link.classList.add("active");
    }
  });
}

function toggleCart() {
  alert("Cart clicked! (This is a placeholder function.)");
}

function attachLoginHandler() {
  const form = document.getElementById("loginForm");
  if (!form) return;

  form.addEventListener("submit", function (e) {
    e.preventDefault();
    const username = document.getElementById("username").value;
    const password = document.getElementById("password").value;

    if (users[username] && users[username].password === password) {
      const crmid = users[username].crmid;

      window.adobeDataLayer = window.adobeDataLayer || [];
      window.adobeDataLayer.push({
        event: "userloggedin",
        user: {
          crmid: crmid,
          authenticatedState: "authenticated"
        }
      });

      document.getElementById("loginArea").innerHTML = `
        <div id="userInfo">
          Welcome, <strong>${username}</strong>
          <div class="cart-icon" onclick="toggleCart()">🛒 <span id="cartCount">0</span></div>
        </div>
      `;
      document.getElementById("offers-div").innerHTML = `
        <h2>Welcome back to FinWise</h2>
        <p>We’re glad to see you again! Explore our latest financial insights and tools tailored to your goals.</p>
        <div class="carousel-wrapper">
          <div id="single-offer-container"></div>
        </div>
      `;
      runPersonalization();
    } else {
      alert("Invalid username or password.");
    }
  });
}

document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll(".nav-link").forEach(link => {
    link.addEventListener("click", function (e) {
      e.preventDefault();
      loadPage(this.dataset.section);
    });
  });

  loadPage("home");

  fetch("login.html")
    .then(res => res.text())
    .then(html => {
      document.getElementById("loginArea").innerHTML = html;
      attachLoginHandler();
    });
});
