/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.workitemuserservice.core;

import com.adobe.fd.workspace.service.external.WorkitemUserMetadataService;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(property={"service.description=A sample implementation of a user metadata service.", "service.vendor=Adobe Systems", "process.label=Sample Custom Metadata Service"})
public class WorkItemUserServiceImpl
implements WorkitemUserMetadataService {
    private static final Logger log = LoggerFactory.getLogger(WorkItemUserServiceImpl.class);

    public Map<String, String> getUserMetadata(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metadataMap) {
        HashMap<String, String> customMetadataMap = null;
        customMetadataMap = new HashMap<String, String>();
        WorkflowData wfData = workItem.getWorkflowData();
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        String dataFilePath = payloadPath + "/Data.xml/jcr:content";
        Session session = (Session)workflowSession.adaptTo(Session.class);
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document xmlDocument = null;
        javax.jcr.Node xmlDataNode = null;
        try {
            xmlDataNode = session.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            XPath xPath = XPathFactory.newInstance().newXPath();
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlDataStream);
            Node firstNameNode = (Node)xPath.compile("afData/afUnboundData/data/firstName").evaluate(xmlDocument, XPathConstants.NODE);
            log.debug("The value of first name element  is " + firstNameNode.getTextContent());
            Node lastNameNode = (Node)xPath.compile("afData/afUnboundData/data/lastName").evaluate(xmlDocument, XPathConstants.NODE);
            Node amountRequested = (Node)xPath.compile("afData/afUnboundData/data/amountRequested").evaluate(xmlDocument, XPathConstants.NODE);
            Node reason = (Node)xPath.compile("afData/afUnboundData/data/reason").evaluate(xmlDocument, XPathConstants.NODE);
            customMetadataMap.put("firstName", firstNameNode.getTextContent());
            customMetadataMap.put("lastName", lastNameNode.getTextContent());
            customMetadataMap.put("amountRequested", amountRequested.getTextContent());
            customMetadataMap.put("reason", reason.getTextContent());
            log.debug("Created  " + customMetadataMap.size() + " metadata  properties");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        return customMetadataMap;
    }
}

