import CryptoJS from "crypto-js";

// Helper function for URL-safe base64 encoding
function base64URLEncode(buffer) {
  return CryptoJS.enc.Base64.stringify(buffer)
    .replace(/\+/g, "-")
    .replace(/\//g, "_")
    .replace(/=+$/, "");
}

// Generate a random code verifier
export function generateCodeVerifier() {
  const array = new Uint8Array(32);
  window.crypto.getRandomValues(array);
  const wordArray = CryptoJS.lib.WordArray.create(array);
  return base64URLEncode(wordArray);
}

// Generate code challenge using SHA-256
export function generateCodeChallenge(codeVerifier) {
  const hash = CryptoJS.SHA256(codeVerifier);
  return base64URLEncode(hash);
}
