import React, { useEffect, memo } from 'react';
import { useNavigate } from 'react-router-dom';
import { useIMSAuth } from '../context/IMSAuthContext';

// Constants
const ROUTES = {
  HOME: '/'
};

const MESSAGES = {
  LOGGING_OUT: 'Logging out...'
};

// Loading component
const LogoutMessage = memo(() => (
  <div className="loading-container">
    <div className="spinner"></div>
    <div>{MESSAGES.LOGGING_OUT}</div>
  </div>
));

LogoutMessage.displayName = 'LogoutMessage';

function Logout() {
  const { logout } = useIMSAuth();
  const navigate = useNavigate();

  useEffect(() => {
    const handleLogout = async () => {
      try {
        await logout();
      } catch (error) {
        console.error('Logout failed:', error);
      } finally {
        navigate(ROUTES.HOME);
      }
    };

    handleLogout();
  }, [logout, navigate]);

  return <LogoutMessage />;
}

// Add display name for debugging
Logout.displayName = 'Logout';

// Memoize the component to prevent unnecessary re-renders
export default memo(Logout); 