import React, { memo } from "react";
import { Link } from "react-router-dom";
import { useIMSAuth } from "../context/IMSAuthContext";
import logo from "../images/wknd-icon.svg";

// Constants
const ROUTES = {
  HOME: "/",
  LOGOUT: "/logout"
};

const USER_TYPES = {
  LOGGED_IN: "AdobeUser",
  ANONYMOUS: "Anonymous"
};

// Memoized sub-components
const Logo = memo(() => (
  <div className="logo-container">
    <Link to={ROUTES.HOME}>
      <img src={logo} className="logo" alt="WKND Logo" />
    </Link>
  </div>
));

Logo.displayName = 'Logo';

const UserInfo = memo(({ isLoggedIn }) => (
  <div className="user-info">
    <p>
      Welcome,{" "}
      <strong>
        {isLoggedIn ? USER_TYPES.LOGGED_IN : USER_TYPES.ANONYMOUS}
      </strong>
    </p>
    {isLoggedIn && <Link to={ROUTES.LOGOUT}>Logout</Link>}
  </div>
));

UserInfo.displayName = 'UserInfo';

// Main component
function Header() {
  const { isLoggedIn } = useIMSAuth();

  return (
    <header className="intro-header">
      <div className="top-bar">
        <Logo />
        <UserInfo isLoggedIn={isLoggedIn} />
      </div>
    </header>
  );
}

export default memo(Header);
