import React, { memo } from "react";
import { Route, BrowserRouter as Router, Routes } from "react-router-dom";
import "./App.css";
import Home from "./components/Home";
import InvokeAemApis from "./components/InvokeAemApis";
import { IMSAuthProvider } from "./context/IMSAuthContext";
import ProtectedRoute from "./components/ProtectedRoute";
import Callback from "./components/Callback";
import Header from "./components/Header";
import Logout from "./components/Logout";

// App layout component
const AppLayout = memo(({ children }) => (
  <div className="App">
    <Header />
    {children}
  </div>
));

AppLayout.displayName = 'AppLayout';

// Main App component
function App() {
  return (
    <IMSAuthProvider>
      <Router>
        <AppLayout>
          <Routes>
            <Route 
              path="/" 
              element={<Home />} 
            />
            <Route
              path="/invoke-aem-apis"
              element={
                <ProtectedRoute>
                  <InvokeAemApis />
                </ProtectedRoute>
              }
            />
            <Route 
              path="/callback" 
              element={<Callback />} 
            />
            <Route 
              path="/logout" 
              element={<Logout />} 
            />
          </Routes>
        </AppLayout>
      </Router>
    </IMSAuthProvider>
  );
}

// Add display name for debugging
App.displayName = 'App';

// Memoize the component to prevent unnecessary re-renders
export default memo(App);
