# WKND SPA & AEM APIs - Demo App 

A demo WKND Single Page Application (SPA) that uses OpenAPI-based AEM APIs from the **client-side**, authenticating on behalf of the user via OAuth 2.0 PKCE (Single Page App flow).

Please see related tutorials [How to invoke OpenAPI-based AEM APIs from a SPA](https://experienceleague.adobe.com/en/docs/experience-manager-learn/cloud-service/aem-apis/openapis/invoke-api-using-oauth-single-page-app)

![WKND SPA & AEM APIs - Demo App](./WKND-SPA-n-AEMAPIs-Demo.png)

## Prerequisites

- [Node.js](https://nodejs.org/en/download/)
- [npm](https://www.npmjs.com/get-npm)
- [Adobe Developer Console (ADC) Project](https://developer.adobe.com/console)
- [AEM as a Cloud Service Assets Instance](https://experienceleague.adobe.com/en/docs/experience-manager-learn/cloud-service/cloud-manager/environments)
- Copy the `.env.example` file to `.env` and update the environment variables.

## Configuration

Before running the application, you need to configure the environment variables. Refer to the `.env.example` file for the required environment variables.
Create a `.env` file in the root directory of your project and add the following variables:

```env
########################################################################
# Adobe IMS, Adobe Developer Console (ADC), and AEM as a Cloud Service Information
########################################################################
# Adobe IMS OAuth endpoints
REACT_APP_ADOBE_IMS_AUTHORIZATION_ENDPOINT=https://ims-na1.adobelogin.com/ims/authorize/v2
REACT_APP_ADOBE_IMS_TOKEN_ENDPOINT=https://ims-na1.adobelogin.com/ims/token/v3
REACT_APP_ADOBE_IMS_USERINFO_ENDPOINT=https://ims-na1.adobelogin.com/ims/userinfo

# Adobe Developer Console (ADC) Project's OAuth Web App credential
REACT_APP_ADC_CLIENT_ID=<ADC Project OAuth Server-to-Server credential ClientID>
REACT_APP_ADC_SCOPES=<ADC Project OAuth Server-to-Server credential Scopes>

# AEM Assets Information
REACT_APP_AEM_ASSET_HOSTNAME=<AEMCS Hostname, e.g., https://author-p63947-e1502138.adobeaemcloud.com/>

################################################
# Single Page Application Information
################################################

# Enable HTTPS for local development
HTTPS=true
PORT=3001

# SSL Certificate and Key for local development 
SSL_CRT_FILE=./ssl/server.crt
SSL_KEY_FILE=./ssl/server.key

# The URL to which the user will be redirected after the OAuth flow is complete
REACT_APP_REDIRECT_URI=https://localhost:3000/callback
```

## Installation & Usage

To install and run the **WKND SPA & AEM APIs - Demo App**, follow these steps:

```bash
$ npm install
$ npm start
```

Verify the app is running by navigating to `https://localhost:3001` in your browser. Accept the self-signed certificate if prompted.

## Project Structure

The project is organized as follows:

- `src/`: Contains the source code for the application.
- `public/`: Contains the public assets for the application.
- `ssl/`: Contains the SSL certificate and key for the application.

### Key Files

- **`config/config.js`**: Central configuration file that loads environment variables
- **`.env`**: Required configuration file (see Configuration section)
- **`components/Home.js`**: Landing page with configuration validation
- **`context/IMSAuthContext.js`**: Manages Adobe IMS authentication context and necessary OAuth 2.0 PKCE flow
- **`components/InvokeAemApis.js`**: Demonstrates AEM API usage that uses the access token acquired via the OAuth 2.0 PKCE flow

## Create React App's General Information

This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app). Please see following general information provided by Create React App.

### Available Scripts via Create React App

In the project directory, you can run:

#### `npm start`

Runs the app in the development mode.\
Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

#### `npm test`

Launches the test runner in the interactive watch mode.\
See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.

#### `npm run build`

Builds the app for production to the `build` folder.\
It correctly bundles React in production mode and optimizes the build for the best performance.

The build is minified and the filenames include the hashes.\
Your app is ready to be deployed!

See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.

#### `npm run eject`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

If you aren't satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.

Instead, it will copy all the configuration files and the transitive dependencies (webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you're on your own.

You don't have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn't feel obligated to use this feature. However we understand that this tool wouldn't be useful if you couldn't customize it when you are ready for it.

### Learn More

You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).

To learn React, check out the [React documentation](https://reactjs.org/).

#### Code Splitting

This section has moved here: [https://facebook.github.io/create-react-app/docs/code-splitting](https://facebook.github.io/create-react-app/docs/code-splitting)

#### Analyzing the Bundle Size

This section has moved here: [https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size](https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size)

#### Making a Progressive Web App

This section has moved here: [https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app](https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app)

#### Advanced Configuration

This section has moved here: [https://facebook.github.io/create-react-app/docs/advanced-configuration](https://facebook.github.io/create-react-app/docs/advanced-configuration)

#### Deployment

This section has moved here: [https://facebook.github.io/create-react-app/docs/deployment](https://facebook.github.io/create-react-app/docs/deployment)

#### `npm run build` fails to minify

This section has moved here: [https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify](https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify)
