import React, { memo } from "react";
import PropTypes from 'prop-types';
import { Navigate } from "react-router-dom";
import { useIMSAuth } from "../context/IMSAuthContext";

// Constants
const ROUTES = {
  HOME: "/"
};

function ProtectedRoute({ children, redirectPath = ROUTES.HOME }) {
  const { isLoggedIn } = useIMSAuth();

  // Early return if not authenticated
  if (!isLoggedIn) {
    return (
      <Navigate 
        to={redirectPath} 
        replace 
        state={{ from: window.location.pathname }}
      />
    );
  }

  // Render children if authenticated
  return <>{children}</>;
}

// PropTypes for type checking
ProtectedRoute.propTypes = {
  children: PropTypes.node.isRequired,
  redirectPath: PropTypes.string
};

// Default props
ProtectedRoute.defaultProps = {
  redirectPath: ROUTES.HOME
};

// Add display name for debugging
ProtectedRoute.displayName = 'ProtectedRoute';

// Memoize the component to prevent unnecessary re-renders
export default memo(ProtectedRoute);
