import express from "express";
import getUserInfo from "../utils/userUtils.js";
import config from "../config.js";

const aemAssetsConfig = config.adobe.aem;

const router = express.Router();

// The index or home route
router.get("/", async (req, res) => {

  const userInfo = await getUserInfo(req);

  res.render("index", {
    userInfo: userInfo,
    aemAssetsInfo: aemAssetsConfig,
  });
});

export default router;
