export default {
  // Adobe related configurations such as IMS, ADC, and AEM
  adobe: {
    ims: {
      authorizationEndpoint: process.env.ADOBE_IMS_AUTHORIZATION_ENDPOINT,
      tokenEndpoint: process.env.ADOBE_IMS_TOKEN_ENDPOINT,
      userInfoEndpoint: process.env.ADOBE_IMS_USERINFO_ENDPOINT,
    },

    adc: {
      clientId: process.env.ADC_CLIENT_ID,
      clientSecret: process.env.ADC_CLIENT_SECRET,
      scopes: process.env.ADC_SCOPES,
    },

    aem: {
      hostname: process.env.AEM_ASSET_HOSTNAME,
      assetIds: process.env.AEM_ASSET_IDS,
    },
  },

  // Express related configurations, such as the port and session secret
  express: {
    port: process.env.PORT || 3000,
    sessionSecret: process.env.SESSION_SECRET,
  },
};
