import "dotenv/config";
import express from "express";
import fetch from "node-fetch";
import URLSearchParams from "url-search-params";
import session from "express-session";
import path from "path";
import { fileURLToPath } from "url";
import index from "./routes/index.js";
import updateProductAttributes from "./routes/update-product-attributes.js";
import authRoutes from "./routes/adobe-ims-auth.js";
import invokeAEMAPIs from "./routes/invoke-aem-apis.js";

// Initialize the app
const app = express();

// Use the express-session middleware to store the IMS access token of the user
app.use(
  session({
    secret: process.env.EXPRESS_SESSION_SECRET,
    resave: false,
    saveUninitialized: true,
    //cookie: { secure: true }, // Only send cookies over HTTPS, uncomment this line when deploying to non-self-signed HTTPS
  })
);

// Middleware for parsing JSON and urlencoded form data
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Manually define __dirname for ES modules
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

// Middleware for static files and view engine
app.use(express.static(path.join(__dirname, "public")));
app.set("view engine", "ejs");
app.set("views", path.join(__dirname, "views")); // Set the views directory

// Use modularized routes
app.use("/", index); // The index or home route
app.use("/", updateProductAttributes); // The update-product-attributes route, shows the product attributes form with tabs
app.use("/", authRoutes); // The Adobe IMS authentication routes to get the access token
app.use("/", invokeAEMAPIs); // The route to invoke AEM APIs

// Start server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});
