import fetch from "node-fetch";

import config from "../config.js";

const ims = config.adobe.ims;

async function getUserInfo(req) {
  // Check if userinfo is already present in the session
  if (req.session.userInfo) {
    return req.session.userInfo;
  } else if (req.session.accessToken) {
    // Fetch the userinfo from the IMS userinfo endpoint
    const userInfoResponse = await fetch(ims.userInfoEndpoint, {
      method: "GET",
      headers: {
        Authorization: `Bearer ${req.session.accessToken}`,
      },
    });

    if (!userInfoResponse.ok) {
      console.error("Error fetching userinfo:", await userInfoResponse.text());
      return res.redirect("/auth");
    }

    const userInfoObj = await userInfoResponse.json();
    //console.log("Userinfo Object:", userInfoObj);
    const sub = userInfoObj.sub;

    // Sub value is 9330F0A495E53@80731c0c7d495fb3.e, let's format it to 9330F0A495E53
    const formattedSub = sub.split("@")[0];

    // Store the userinfo in the session
    req.session.userInfo = {
      sub: formattedSub,
    };

    return req.session.userInfo;
  } else {
    return null;
  }
}

export default getUserInfo;
