import express from "express";
import getUserInfo from "../utils/userUtils.js";
import config from "../config.js";

const aemAssetsInfo = config.adobe.aem;

const router = express.Router();

// The update-product-attributes route, shows the product attributes form with tabs
router.get("/update-product-attributes", async (req, res) => {
  // Check if the user is authenticated, if not redirect to the auth route
  if (!req.session.accessToken) {
    return res.redirect("/auth");
  }

  // Fetch the user info from the IMS user info endpoint
  const userInfo = await getUserInfo(req);

  // Render the update-product-attributes view
  res.render("update-product-attributes", {
    userInfo: userInfo,
    aemAssetsInfo: aemAssetsInfo,
  });
});

export default router;
