# WKND PIM - Demo Web App

This is a demo web application for managing and updating product attributes using OpenAPI-based AEM APIs.

The application demonstrates how to invoke OpenAPI-based AEM APIs using OAuth 2.0 User Auth Web App (Authorization Code Flow) credentials.

Please see related tutorials [How to invoke OpenAPI-based AEM APIs from a web app](https://experienceleague.adobe.com/en/docs/experience-manager-learn/cloud-service/aem-apis/invoke-openapi-based-aem-apis-from-web-app.md)

## Prerequisites

- [Node.js](https://nodejs.org/en/download/)
- [npm](https://www.npmjs.com/get-npm)
- [local-ssl-proxy](https://www.npmjs.com/package/local-ssl-proxy)
- [Adobe Developer Console (ADC) Project](https://developer.adobe.com/console)
- [AEM as a Cloud Service Assets Instance](https://experienceleague.adobe.com/en/docs/experience-manager-learn/cloud-service/cloud-manager/environments)

## Configuration

Before running the application, you need to configure the environment variables. Refer to the `.env.sample` file for the required environment variables.
Create a `.env` file in the root directory of your project and add the following variables:

```env
########################################################################
# Adobe IMS, Adobe Developer Console (ADC), and AEM Assets Information
########################################################################
# Adobe IMS OAuth endpoints
ADOBE_IMS_AUTHORIZATION_ENDPOINT=https://ims-na1.adobelogin.com/ims/authorize/v2
ADOBE_IMS_TOKEN_ENDPOINT=https://ims-na1.adobelogin.com/ims/token/v3
ADOBE_IMS_USERINFO_ENDPOINT=https://ims-na1.adobelogin.com/ims/userinfo/v2

# Adobe Developer Console (ADC) Project OAuth Web App credential
ADC_CLIENT_ID=<ADC Project OAuth Server-to-Server credential ClientID>
ADC_CLIENT_SECRET=<ADC Project OAuth Server-to-Server credential Client Secret>
ADC_SCOPES=AdobeID,openid,aem.folders,aem.assets.author

# AEM Assets Information
AEM_ASSET_HOSTNAME=https://author-p63947-e1502138.adobeaemcloud.com/
AEM_ASSET_IDS=urn:aaid:aem:aa689a9f-04da-4fbb-b460-74a5b6a69090,urn:aaid:aem:e4fdb6f6-1007-4e84-9726-a9522931786a,urn:aaid:aem:58f9aef2-f273-40da-afae-73fb68867a79,urn:aaid:aem:32c1b7bc-f181-481b-8c0d-f43b0de5e126

################################################
# Web App Information
################################################
# The port number on which this server (web app) will run
PORT=3000

# The URL to which the user will be redirected after the OAuth flow is complete
REDIRECT_URI=https://localhost:3000/auth/callback

# The Express (express-session) uses this secret to encrypt and verify the authenticity of that cookie
EXPRESS_SESSION_SECRET=<Express Session Secret>
```

## Installation & Usage

To install and run the WKND PIM - Demo Web App, follow these steps:


```bash
$ npm install
$ npm start
$ local-ssl-proxy --source 3001 --target 3000 --cert ./ssl/server.crt --key ./ssl/server.key
```

Verify the app is running by navigating to `https://localhost:3001` in your browser. Accept the self-signed certificate if prompted.

## Project Structure

- app.js: Main application file.
- config.js: Configuration file for environment variables.
- routes: Directory containing route handlers.
- utils: Directory containing utility functions.
- public: Directory containing static files (CSS, JS).
- views: Directory containing EJS templates.
- ssl: Directory containing SSL certificates.
- .env: Environment variables file.
- package.json: Project metadata and dependencies.


## Self-Signed Certs

The project uses self-signed certificates for local development. The `ssl` directory contains the self-signed certificates. You can generate your own self-signed certificates using the following commands:

```bash
openssl genpkey -algorithm RSA -out server.key
openssl req -new -key server.key -out server.csr
openssl x509 -req -in server.csr -signkey server.key -out server.crt
```

## License

This project is licensed under the ISC License.
