/*
 * Decompiled with CFR 0.152.
 */
package com.welcomekit.core.workflowprocess;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CreatePage
implements WorkflowProcess {
    private static final String WORKFLOW_WELCOME_KIT_PAGE_TEMPLATE_PATH = "WELCOME_KIT_PAGE_TEMPLATE_PATH";
    private static final String WORKFLOW_WELCOME_KIT_COMPONENT_RESOURCE_TYPE = "WELCOME_KIT_COMPONENT_RESOURCE_TYPE";
    private static final String WORKFLOW_ROOT_PAGE_PATH = "ROOT_PAGE_PATH";
    String[] docummentNames = null;
    @Reference
    private QueryBuilder queryBuilder;

    private Page createWelcomeKitPage(ResourceResolver resourceResolver, String welcomeKitId, String templatePath, String pageTitle) throws RepositoryException, WCMException {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Node node = JcrUtil.createPath((String)StringUtils.substringBeforeLast((String)welcomeKitId, (String)"/"), (String)"sling:OrderedFolder", (String)"sling:OrderedFolder", (Session)((Session)resourceResolver.adaptTo(Session.class)), (boolean)false);
        Page page = pageManager.create(node.getPath(), StringUtils.substringAfterLast((String)welcomeKitId, (String)"/"), templatePath, pageTitle, true);
        return page;
    }

    private <T> boolean persistData(WorkItem workItem, WorkflowSession workflowSession, String key, T val) {
        WorkflowData data = workItem.getWorkflow().getWorkflowData();
        if (data.getMetaDataMap() == null) {
            return false;
        }
        data.getMetaDataMap().put((Object)key, val);
        workflowSession.updateWorkflowData(workItem.getWorkflow(), data);
        return true;
    }

    private Resource findResourceByResourceType(Page page, String resourceType) throws RepositoryException {
        ResourceResolver resourceResolver = page.getContentResource().getResourceResolver();
        System.out.println("Finding resource type" + resourceType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", page.getContentResource().getPath());
        map.put("path.self", "true");
        map.put("property", "sling:resourceType");
        map.put("property.value", resourceType);
        map.put("p.limit", "1");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)resourceResolver.adaptTo(Session.class));
        SearchResult result = query.getResult();
        if (result.getHits().size() > 0) {
            return resourceResolver.getResource(((Hit)result.getHits().get(0)).getPath());
        }
        return null;
    }

    private void updateComponentOnPage(Page page, String resourceType, String propertyName, String propertyValue) throws PersistenceException, RepositoryException {
        Resource resource = this.findResourceByResourceType(page, resourceType);
        if (resource != null) {
            ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (propertyName.equalsIgnoreCase("paths")) {
                properties.remove((Object)propertyName);
                String[] docummentNames = propertyValue.split(",");
                properties.put((Object)propertyName, (Object)docummentNames);
            } else {
                System.out.println("Finding resource type" + propertyName);
                properties.remove((Object)propertyName);
                properties.put((Object)propertyName, (Object)propertyValue);
            }
        }
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String docSelected = (String)workItem.getWorkflow().getWorkflowData().getMetaDataMap().get((Object)"documentsSelected");
        String submitter = (String)workItem.getWorkflow().getWorkflowData().getMetaDataMap().get((Object)"submitter");
        this.docummentNames = docSelected.split(",");
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        String templatePath = (String)metaDataMap.get(WORKFLOW_WELCOME_KIT_PAGE_TEMPLATE_PATH, String.class);
        String welcomeKitResourceType = (String)metaDataMap.get(WORKFLOW_WELCOME_KIT_COMPONENT_RESOURCE_TYPE, String.class);
        String rootPagePath = (String)metaDataMap.get(WORKFLOW_ROOT_PAGE_PATH, (Object)"/content/welcome-kits");
        String welcomeKitId = rootPagePath + "/" + new SimpleDateFormat("yyyy/MM").format(new Date()) + "/" + UUID.randomUUID();
        String welcomeKitName = "Welcome Kit";
        try {
            Page page = this.createWelcomeKitPage(resourceResolver, welcomeKitId, templatePath, "Welcome Kit");
            this.updateComponentOnPage(page, welcomeKitResourceType, "paths", docSelected);
            this.updateComponentOnPage(page, "wcm/foundation/components/text", "text", "<p>Hello " + submitter + ".</p><p> Thank you for submitting your request. Please find the documents requested by you</p>");
            resourceResolver.commit();
            Externalizer externalizer = (Externalizer)resourceResolver.adaptTo(Externalizer.class);
            String myExternalizedUrl = externalizer.externalLink(resourceResolver, "local", page.getPath()) + ".html";
            this.persistData(workItem, workflowSession, "welcomekiturl", myExternalizedUrl);
        }
        catch (WCMException | RepositoryException | PersistenceException e) {
            throw new WorkflowException(String.format("Could not build Welcome Kit page for [ %s ]", "selected documents"), e);
        }
    }
}

