/*
 * Decompiled with CFR 0.152.
 */
package com.welcomekit.core.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.welcomekit.core.presskit.PressKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.resource.collection.ResourceCollection;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={PressKit.class}, resourceType={"asset-share-commons/components/press-kit"})
public class PressKitImpl
implements PressKit {
    public static final String RESOURCE_TYPE = "asset-share-commons/components/press-kit";
    @Self
    private SlingHttpServletRequest request;
    @ValueMapValue
    @Optional
    private List<String> paths;
    @ValueMapValue
    @Optional
    private String displayResourceType;
    @OSGiService
    private ModelFactory modelFactory;
    List<Asset> assets;

    @Override
    public List<Asset> getAssets() {
        if (this.assets != null) {
            return this.assets;
        }
        this.assets = new ArrayList<Asset>();
        System.out.println("In list model get assets");
        for (String path : this.paths) {
            System.out.println("In list model get assets" + path);
            Resource resource = this.request.getResourceResolver().getResource(path);
            if (resource != null && this.isAssetPath(resource)) {
                this.assets.addAll(this.getAssetsFromAssetPath(resource));
            }
            if (resource == null) continue;
            this.assets.addAll(this.getAssetsFromAssetFolderPath(resource));
        }
        return this.assets;
    }

    @Override
    public boolean isReady() {
        return this.getAssets().size() > 0;
    }

    private Collection<? extends Asset> getAssetsFromAssetCollectionPath(Resource resource) {
        System.out.println("In Get Assets From Asset Collection");
        ArrayList results = new ArrayList();
        ResourceCollection collection = (ResourceCollection)resource.adaptTo(ResourceCollection.class);
        if (collection != null) {
            collection.getResources().forEachRemaining(r -> {
                if (this.isAssetPath((Resource)r)) {
                    results.addAll(this.getAssetsFromAssetPath((Resource)r));
                }
            });
        }
        return results;
    }

    private Collection<? extends Asset> getAssetsFromAssetFolderPath(Resource resource) {
        System.out.println("The resource is " + resource.getName());
        ArrayList results = new ArrayList();
        resource.getChildren().forEach(child -> {
            if (!"jcr:content".equals(child.getName()) && this.isAssetPath((Resource)child)) {
                results.addAll(this.getAssetsFromAssetPath((Resource)child));
            }
        });
        System.out.println("##### The resource path is ##### " + resource.getPath());
        String pressKitBannerImage = "banner.jpg";
        return this.filterAssets(results, pressKitBannerImage);
    }

    private Collection<? extends Asset> getAssetsFromAssetPath(Resource resource) {
        System.out.println("The resource path is " + resource.getPath());
        ArrayList<Asset> results = new ArrayList<Asset>();
        results.add(DamUtil.resolveToAsset((Resource)resource));
        return results;
    }

    private boolean isAssetPath(Resource resource) {
        return resource != null && DamUtil.isAsset((Resource)resource);
    }

    private Collection<? extends Asset> filterAssets(Collection<? extends Asset> assets, String bannerImage) {
        if (bannerImage == null) {
            System.out.println("The banner image is null");
            return assets;
        }
        String bannerImageRegex = bannerImage.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        System.out.println("The banner image is not null");
        ArrayList results = new ArrayList();
        assets.forEach(asset -> {
            if (!asset.getName().matches(bannerImageRegex)) {
                results.add(asset);
            }
        });
        return results;
    }
}

