(function(window, hobs) {
    'use strict';

	var ts = new hobs.TestSuite("Validation Test", {
        path: '/etc/clientlibs/testingAFUsingCalvinSDK/validationTest.js',
		register: true
	})	

	.addTestCase(new hobs.TestCase("Pattern Validation")
        // navigate to the testForm which is to be test
        .navigateTo("/content/forms/af/cal/demoform.html?wcmmode=disabled&dataRef=crx:///content/forms/af/cal/prefill.xml")
        // check if adaptive form is loaded
        .asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })
        .execSyncFct(function () {
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("GeneralInformation.email", "abc");
        })
        .asserts.isTrue(function () {
            return calvin.view("GeneralInformation.email").error.text() == "Field not filled in expected format.";
        })
    )
    .addTestCase(new hobs.TestCase("Server side validation")
        // navigate to the testForm which is to be test
        .navigateTo("/content/forms/af/cal/demoform.html?wcmmode=disabled&dataRef=crx:///content/forms/af/cal/prefill.xml")
        .execSyncFct(function () {
            calvin.setValueInDOM("GeneralInformation.email", "abc");
            calvin.testServerSideValidation();
        })
        .asserts.isTrue(function () {
            return calvin.view("GeneralInformation.email").error.text() == "Field not filled in expected format.";
        })
    );

    

 }(window, window.hobs));
