(function(window, hobs) {
    'use strict';

	var ts = new hobs.TestSuite("Script Test", {
        path: '/etc/clientlibs/testingAFUsingCalvinSDK/scriptingTest.js',
		register: true
	})	

    .addTestCase(new hobs.TestCase("Calvin SDK with AEM Forms")
        // navigate to the testForm which is to be tested
        .navigateTo("/content/forms/af/cal/testform.html?wcmmode=disabled")
        // check if adaptive form is loaded
        .asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })
         .execSyncFct(function () {
            // create a spy before checking for the expression
            calvin.spyOnExpression("panel1.AnnualSalary");
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("panel1.monthlySalary", "5000");
        })

    )

    .addTestCase(new hobs.TestCase("Checking execution of calculate script")
        // navigate to the testForm which is to be tested
        .navigateTo("/content/forms/af/testForm.html?wcmmode=disabled")
        // check if adaptive form is loaded
        .asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })
        .execSyncFct(function () {
            // create a spy before checking for the expression
            calvin.spyOnExpression("panel1.textbox1");
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("panel1.textbox", "5");
        })
        // if the calculate expression was setting "textbox1" value to "5", let's also check that
        .asserts.isTrue(function () {
            return calvin.isExpressionExecuted("panel1.textbox1", "Calculate");
        })
        .execSyncFct(function () {
            calvin.destroySpyOnExpression("panel1.textbox1");
        })
        .asserts.isTrue(function () {
            return calvin.model("panel1.textbox1").value == "5"
        })
    )

    .addTestCase(new hobs.TestCase("Calculate script Test")
        // navigate to the testForm which is to be tested
        .navigateTo("/content/forms/af/cal/demoform.html?wcmmode=disabled&dataRef=crx:///content/forms/af/cal/prefill.xml")
        // check if adaptive form is loaded
        .asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })

        .execSyncFct(function () {
            // create a spy before checking for the expression
            calvin.spyOnExpression("panel2.panel1488218690733.downPayment");
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("panel2.panel1488218690733.priceProperty", "1000000");
        })
        .asserts.isTrue(function () {
            return calvin.isExpressionExecuted("panel2.panel1488218690733.downPayment", "Calculate");
        })
        .execSyncFct(function () {
            calvin.destroySpyOnExpression("panel2.panel1488218690733.downPayment");
        })
        .asserts.isTrue(function () {
            // if the calculate expression was setting "downPayment" value to "10000", let's also check that
			return calvin.model("panel2.panel1488218690733.downPayment").value == 10000
        })
    )

    .addTestCase(new hobs.TestCase("Checking execution of Value commit script")
        // navigate to the testForm which is to be tested
        .navigateTo("/content/forms/af/cal/demoform.html?wcmmode=disabled&dataRef=crx:///content/forms/af/cal/prefill.xml")
        // check if adaptive form is loaded
        .asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })

        .execSyncFct(function () {
            // create a spy before checking for the expression
            calvin.spyOnExpression("panel2.panel1488218690733.priceProperty");
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("panel2.panel1488218690733.priceProperty", "100");
        })
        .asserts.isTrue(function () {
            return calvin.isExpressionExecuted("panel2.panel1488218690733.priceProperty", "Value Commit");
        })
        .execSyncFct(function () {
            calvin.destroySpyOnExpression("panel2.panel1488218690733.priceProperty");
        })
        .asserts.isTrue(function () {
	        // if the value commit expression was setting "textbox1488215618594" value to "0", let's also check that
            return calvin.model("panel2.panel1488218690733.textbox1488215618594").value == 0
        })
    );

	
 }(window, window.hobs));
