(function(window, hobs) {
    'use strict';

	var mortgageFormTS = new hobs.TestSuite("Mortgage Form Test", {
        path: '/etc/clientlibs/testingAFUsingCalvinSDK/mortgageForm.js',
		register: true
	})	

    .addTestCase(new hobs.TestCase("Calculate amount to borrow")
        // navigate to the mortgage form  which is to be tested
        .navigateTo("/content/forms/af/cal/mortgageform.html?wcmmode=disabled")
		.asserts.isTrue(function () {
            return calvin.isFormLoaded()
        })
        .execSyncFct(function () {
            // create a spy before checking for the expression
            calvin.spyOnExpression("GeneralInformation.info.purchasePrice");
            // setValue would trigger enter, set the value and exit from the field
            calvin.setValueInDOM("GeneralInformation.info.downPayment", "20");
             calvin.setValueInDOM("GeneralInformation.info.purchasePrice", "50000");
            calvin.spyOnExpression("GeneralInformation.info.amountToBorrow");
         })
                 .asserts.isTrue(function () {
             calvin.spyOnExpression("GeneralInformation.info.amountToBorrow");
            return calvin.isExpressionExecuted("GeneralInformation.info.amountToBorrow", "Calculate");

        })




      );

 }(window, window.hobs));
