/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.storeandexport.core;

import com.aemforms.storeandexport.core.CSVUtils;
import com.aemforms.storeandexport.core.StoreAndExport;
import com.aemforms.storeandexport.core.StoreAndExportConfigurationService;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(service={StoreAndExport.class})
public class StoreAndExportImpl
implements StoreAndExport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    StoreAndExportConfigurationService config;
    @Reference(target="(&(objectclass=javax.sql.DataSource)(datasource.name=aemformstutorial))")
    private DataSource dataSource;

    private List<String> getRowValues(String row) {
        ArrayList<String> rowValues = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(row)));
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            Node dataNode = (Node)xpath.evaluate("//afData/afUnboundData/data", doc, XPathConstants.NODE);
            NodeList dataElements = dataNode.getChildNodes();
            for (int i = 0; i < dataElements.getLength(); ++i) {
                this.log.debug("The name of the node is" + dataElements.item(i).getNodeName() + " the node value is " + dataElements.item(i).getTextContent());
                rowValues.add(i, dataElements.item(i).getTextContent());
            }
            return rowValues;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            return null;
        }
    }

    private List<String> getHeaderValues(String row) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        ArrayList<String> rowValues = new ArrayList<String>();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(row)));
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            Node dataNode = (Node)xpath.evaluate("//afData/afUnboundData/data", doc, XPathConstants.NODE);
            NodeList dataElements = dataNode.getChildNodes();
            for (int i = 0; i < dataElements.getLength(); ++i) {
                rowValues.add(i, dataElements.item(i).getNodeName());
            }
            return rowValues;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getCSVFile(String formName) {
        this.log.debug("In get CSV File");
        String selectStatement = "SELECT " + this.config.getFORM_DATA_COLUMN() + " FROM aemformstutorial." + this.config.getTABLE_NAME() + " where " + this.config.getFORM_NAME_COLUMN() + "='" + formName + "'";
        this.log.debug("The select statment is " + selectStatement);
        Connection con = this.getConnection();
        Statement st = null;
        ResultSet rs = null;
        CSVUtils csvUtils = new CSVUtils();
        try {
            st = con.createStatement();
            rs = st.executeQuery(selectStatement);
            this.log.debug("Got Result Set in getCSVFile");
            StringBuilder sb = new StringBuilder();
            while (rs.next()) {
                if (rs.isFirst()) {
                    sb = csvUtils.writeLine(this.getHeaderValues(rs.getString(1)), sb);
                }
                sb = csvUtils.writeLine(this.getRowValues(rs.getString(1)), sb);
                this.log.debug("$$$$The current strng buffer is " + sb.toString());
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                st.close();
            }
            catch (Exception exception) {}
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private Connection getConnection() {
        this.log.debug("Getting Connection ");
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.log.debug("got connection");
            return con;
        }
        catch (Exception e) {
            this.log.debug("not able to get connection ");
            this.log.debug(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inserFormData(String formData) {
        String formDataColumn = this.config.getFORM_DATA_COLUMN();
        String formNameColumn = this.config.getFORM_NAME_COLUMN();
        String tableName = this.config.getTABLE_NAME();
        String insertStatement = "Insert into aemformstutorial." + tableName + "(" + formDataColumn + "," + formNameColumn + ") VALUES(?,?)";
        this.log.debug("The insert statment is" + insertStatement);
        Connection con = this.getConnection();
        Statement pstmt = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document xmlDoc = builder.parse(new InputSource(new StringReader(formData)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node submittedFormNameNode = (Node)xPath.compile("/afData/afSubmissionInfo/afPath").evaluate(xmlDoc, XPathConstants.NODE);
            String[] paths = submittedFormNameNode.getTextContent().split("/");
            String formName = paths[paths.length - 1];
            this.log.debug("The form name submiited is" + formName);
            pstmt = null;
            pstmt = con.prepareStatement(insertStatement);
            pstmt.setString(1, formData);
            pstmt.setString(2, formName);
            this.log.debug("Executing the insert statment  " + pstmt.execute());
            con.commit();
        }
        catch (SQLException e) {
            this.log.debug(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            this.log.debug(e.getMessage());
        }
        catch (SAXException e) {
            this.log.debug(e.getMessage());
        }
        catch (IOException e) {
            this.log.debug(e.getMessage());
        }
        catch (XPathExpressionException e) {
            this.log.debug(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }
}

