/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.storeandexport.core;

import java.io.IOException;
import java.util.List;

public class CSVUtils {
    private static final char DEFAULT_SEPARATOR = ',';

    public StringBuilder writeLine(List<String> values, StringBuilder stringBuilder) throws IOException {
        stringBuilder = this.writeLine(values, ',', ' ', stringBuilder);
        System.out.println("Before returning" + stringBuilder.toString());
        return stringBuilder;
    }

    public void writeLine(List<String> values, char separators, StringBuilder stringBuilder) throws IOException {
        this.writeLine(values, separators, ' ', stringBuilder);
    }

    private static String followCVSformat(String value) {
        String result = value;
        if (result.contains("\"")) {
            result = result.replace("\"", "\"\"");
        }
        return result;
    }

    public synchronized StringBuilder writeLine(List<String> values, char separators, char customQuote, StringBuilder stringBuilder) throws IOException {
        boolean first = true;
        if (separators == ' ') {
            separators = (char)44;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (!first) {
                sb.append(separators);
            }
            if (customQuote == ' ') {
                sb.append(CSVUtils.followCVSformat(value));
            } else {
                sb.append(customQuote).append(CSVUtils.followCVSformat(value)).append(customQuote);
            }
            first = false;
        }
        sb.append("\n");
        return stringBuilder.append(sb.toString());
    }
}

