/*
 * Decompiled with CFR 0.152.
 */
package com.aem.forms.signmultipleforms.impl;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.aem.forms.signmultipleforms.SignMultipleForms;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.UUID;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SignMultipleFormsImpl
implements SignMultipleForms {
    private static final Logger log = LoggerFactory.getLogger(SignMultipleFormsImpl.class);
    @Reference(target="(&(objectclass=javax.sql.DataSource)(datasource.name=aemformstutorial))")
    private DataSource dataSource;

    public Connection getConnection() {
        log.debug("Getting Connection ");
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            log.debug("got connection");
            return con;
        }
        catch (Exception e) {
            log.debug("not able to get connection ");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertData(String[] formNames, String formData, String serverURL, WorkItem workItem, WorkflowSession workflowSession) {
        String insertTableSQL = "INSERT INTO aemformstutorial.signingforms(formName,formData,guid,status,customerID) VALUES(?,?,?,?,?)";
        Random r = new Random();
        Connection con = this.getConnection();
        Statement pstmt = null;
        int customerIDGnerated = r.nextInt(1000) + 1;
        log.debug("The number of forms to insert are  " + formNames.length);
        try {
            for (int i = 0; i < formNames.length; ++i) {
                log.debug("Inserting form name " + formNames[i]);
                UUID uuid = UUID.randomUUID();
                String randomUUIDString = uuid.toString();
                String formUrl = serverURL + formNames[i] + "/jcr:content?wcmmode=disabled&guid=" + randomUUIDString + "&customerID=" + customerIDGnerated;
                pstmt = con.prepareStatement(insertTableSQL);
                pstmt.setString(1, formUrl);
                pstmt.setString(2, formData.replace("<guid>3938</guid>", "<guid>" + uuid + "</guid>"));
                pstmt.setString(3, uuid.toString());
                pstmt.setInt(4, 0);
                pstmt.setInt(5, customerIDGnerated);
                log.debug("customerIDGnerated the insert statment  " + pstmt.execute());
                if (i != 0) continue;
                WorkflowData wfData = workItem.getWorkflowData();
                wfData.getMetaDataMap().put((Object)"formURL", (Object)formUrl);
                workflowSession.updateWorkflowData(workItem.getWorkflow(), wfData);
                log.debug("$$$$ Done updating the map");
            }
            con.commit();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    log.debug(e.getMessage());
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.debug(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNextFormToSign(int customerID) {
        log.debug("### inside my next form to sign " + customerID);
        String selectStatement = "SELECT formName FROM aemformstutorial.signingforms where status = 0 and customerID=" + customerID;
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(selectStatement);
            if (rs.next()) {
                log.debug("Got result set object");
                String string = rs.getString("formName");
                return string;
            }
            if (!rs.next()) {
                String string = "AllDone";
                return string;
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.debug(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSignatureStatus(String formData, String guid) {
        String updateStatment = "update aemformstutorial.signingforms SET formData = ?, status = ? where guid = ?";
        log.debug("In update Signature Status  " + formData);
        PreparedStatement updatePS = null;
        Connection con = this.getConnection();
        try {
            updatePS = con.prepareStatement(updateStatment);
            updatePS.setString(1, formData.replace("<signed>N</signed>", "<signed>Y</signed>"));
            updatePS.setInt(2, 1);
            updatePS.setString(3, guid);
            log.debug("Updated the signature status " + String.valueOf(updatePS.execute()));
        }
        catch (SQLException e) {
            log.debug(e.getMessage());
        }
        finally {
            try {
                con.commit();
                updatePS.close();
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getFormData(String guid) {
        log.debug("### Getting form data asscoiated with guid " + guid);
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT formData FROM aemformstutorial.signingforms where guid = '" + guid + "'";
            log.debug(" The query being consrtucted " + query);
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                return rs.getString("formData");
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage());
        }
        return null;
    }
}

