/*
 * Decompiled with CFR 0.152.
 */
package com.aem.forms.signmultipleforms;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.aem.forms.signmultipleforms.SignMultipleForms;
import java.io.InputStream;
import java.io.StringWriter;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(property={"service.description=Update Signature Status in DB", "service.vendor=Adobe Systems", "process.label=Update Signature Status in DB"})
public class UpdateSignatureStatusWorkflowStep
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(UpdateSignatureStatusWorkflowStep.class);
    @Reference
    SignMultipleForms signMultipleForms;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        String dataFilePath = payloadPath + "/Data.xml/jcr:content";
        log.debug("the data file path is " + dataFilePath);
        Session session = (Session)workflowSession.adaptTo(Session.class);
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document xmlDocument = null;
        javax.jcr.Node xmlDataNode = null;
        try {
            session.refresh(true);
            xmlDataNode = session.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            log.debug("in update signature status - input stream size is " + xmlDataStream.available());
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlDataStream);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.compile("/afData/afUnboundData/data/guid").evaluate(xmlDocument, XPathConstants.NODE);
            String guid = node.getTextContent();
            System.out.println("The guid is " + guid);
            DOMSource domSource = new DOMSource(xmlDocument);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            StreamResult sr = new StreamResult(writer);
            transformer.transform(domSource, sr);
            System.out.println("After transformer copy" + writer.toString());
            String formData = writer.toString();
            this.signMultipleForms.updateSignatureStatus(formData.toString(), guid);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }
}

