/*
 * Decompiled with CFR 0.152.
 */
package com.aem.forms.signmultipleforms;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.aem.forms.signmultipleforms.SignMultipleForms;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(property={"service.description=StoreFormsToSign", "service.vendor=Adobe Systems", "process.label=StoreFormsToSign"})
public class StoreFormsToSignWorkflowStep
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(StoreFormsToSignWorkflowStep.class);
    @Reference
    SignMultipleForms signMultipleForms;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        log.debug("The payload  in StoreFormsToSign " + workItem.getWorkflowData().getPayload().toString());
        String dataFilePath = payloadPath + "/Data.xml/jcr:content";
        String serverURL = ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString();
        Session session = (Session)workflowSession.adaptTo(Session.class);
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document xmlDocument = null;
        javax.jcr.Node xmlDataNode = null;
        try {
            xmlDataNode = session.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            XPath xPath = XPathFactory.newInstance().newXPath();
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlDataStream);
            Node node = (Node)xPath.compile("/afData/afUnboundData/data/formsToSign").evaluate(xmlDocument, XPathConstants.NODE);
            log.debug("The form names to sign are  t" + node.getTextContent());
            String[] formNamesToSign = node.getTextContent().split(",");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource source = new DOMSource(xmlDocument);
            StreamResult outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(source, outputTarget);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String formData = writer.toString();
            this.signMultipleForms.insertData(formNamesToSign, formData, serverURL, workItem, workflowSession);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }
}

