/*
 * Decompiled with CFR 0.152.
 */
package aem.forms.generateic.core.servlets;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.ccm.channels.print.api.exception.PrintChannelException;
import com.adobe.fd.ccm.channels.print.api.model.PrintChannel;
import com.adobe.fd.ccm.channels.print.api.model.PrintChannelRenderOptions;
import com.adobe.fd.ccm.channels.print.api.model.PrintDocument;
import com.adobe.fd.ccm.channels.print.api.service.PrintChannelService;
import com.adobe.forms.common.service.ContentType;
import com.adobe.forms.common.service.DataOptions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/generateic"})
public class GeneratePrintChannelServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(GeneratePrintChannelServlet.class);
    @Reference
    GetResolver getResolver;
    @Reference
    PrintChannelService printChannelService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            System.out.println("The Param name is " + params.nextElement());
        }
        String submittedDataXml = request.getParameter("dataXml");
        log.info("The submiited data is " + submittedDataXml);
        JsonParser jsonPrser = new JsonParser();
        log.info("Created json parser");
        JsonObject jsonObject = jsonPrser.parse(submittedDataXml).getAsJsonObject().get("afData").getAsJsonObject().get("afBoundData").getAsJsonObject().get("data").getAsJsonObject();
        log.info("Successfully Parsed gson");
        ByteArrayInputStream targetStream = new ByteArrayInputStream(jsonObject.toString().getBytes());
        log.info("Successfully Parsed gson" + jsonObject.toString());
        String formName = "/content/forms/af/beneficiariesconfirmation/channels/print";
        PrintChannel printChannel = null;
        try {
            int bytes;
            log.info("$$$$$The size of target stream$$$$$$ " + ((InputStream)targetStream).available());
            printChannel = this.printChannelService.getPrintChannel(formName);
            log.info("Got  printChannel Object   ");
            PrintChannelRenderOptions options = new PrintChannelRenderOptions();
            options.setMergeDataOnServer(true);
            options.setRenderInteractive(false);
            DataOptions dataOptions = new DataOptions();
            dataOptions.setServiceName(printChannel.getPrefillService());
            dataOptions.setContentType(ContentType.JSON);
            log.info("Set content type");
            Resource icResource = this.getResolver.getFormsServiceResolver().getResource(formName);
            log.info("####Got ic resource ######" + icResource.getPath());
            dataOptions.setFormResource(this.getResolver.getFormsServiceResolver().getResource(formName));
            log.info("Got form resource");
            dataOptions.setServiceName("ccm-print-test");
            dataOptions.setExtras(new HashMap());
            dataOptions.getExtras().put("data", targetStream);
            options.setDataOptions(dataOptions);
            log.info("####Set the data options");
            PrintDocument printDocument = printChannel.render(options);
            Document generatedDocument = new Document(printDocument.getInputStream());
            log.info("####Generated the document");
            InputStream fileInputStream = printDocument.getInputStream();
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=AemFormsRocks.pdf");
            response.setContentLength(fileInputStream.available());
            ServletOutputStream responseOutputStream = response.getOutputStream();
            log.info("the inputstream size is " + fileInputStream.available());
            while ((bytes = fileInputStream.read()) != -1) {
                responseOutputStream.write(bytes);
            }
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (PrintChannelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

