/*
 * Decompiled with CFR 0.152.
 */
package aem.forms.generateic.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.ccm.channels.print.api.model.PrintChannel;
import com.adobe.fd.ccm.channels.print.api.model.PrintChannelRenderOptions;
import com.adobe.fd.ccm.channels.print.api.model.PrintDocument;
import com.adobe.fd.ccm.channels.print.api.service.PrintChannelService;
import com.adobe.forms.common.service.ContentType;
import com.adobe.forms.common.service.DataOptions;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Generate Print Channel Document", "service.vendor=Adobe Systems", "process.label=Generate Print Channel Document"})
public class GeneratePrintChannelDocument
implements WorkflowProcess {
    @Reference
    GetResolver getResolver;
    @Reference
    PrintChannelService printChannelService;
    @Reference
    ResourceResolverHelper resHelper;
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    private static Logger logger = LoggerFactory.getLogger(GeneratePrintChannelDocument.class);

    public void execute(final WorkItem workItem, final WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        final String params = ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString();
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        String dataFile = params.split(",")[0];
        final String icFileName = params.split(",")[1];
        String dataFilePath = payloadPath + "/" + dataFile + "/jcr:content";
        final Session session = (Session)workflowSession.adaptTo(Session.class);
        Node xmlDataNode = null;
        try {
            xmlDataNode = session.getNode(dataFilePath);
            InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
            JsonParser jsonParser = new JsonParser();
            BufferedReader streamReader = null;
            try {
                streamReader = new BufferedReader(new InputStreamReader(xmlDataStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            StringBuilder responseStrBuilder = new StringBuilder();
            try {
                String inputStr;
                while ((inputStr = streamReader.readLine()) != null) {
                    responseStrBuilder.append(inputStr);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String submittedDataXml = responseStrBuilder.toString();
            JsonObject jsonObject = jsonParser.parse(submittedDataXml).getAsJsonObject().get("afData").getAsJsonObject().get("afBoundData").getAsJsonObject().get("data").getAsJsonObject();
            logger.info("Successfully Parsed gson" + jsonObject.toString());
            final InputStream targetStream = IOUtils.toInputStream((String)jsonObject.toString());
            logger.info("Got resource using resource resolver");
            this.resHelper.callWith(this.getResolver.getFormsServiceResolver(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    System.out.println("The target stream is " + targetStream.available());
                    PrintChannel printChannel = null;
                    String formName = params.split(",")[2];
                    logger.info("The form name I got was " + formName);
                    printChannel = GeneratePrintChannelDocument.this.printChannelService.getPrintChannel(formName);
                    logger.info("Did i get print channel?");
                    PrintChannelRenderOptions options = new PrintChannelRenderOptions();
                    options.setMergeDataOnServer(true);
                    options.setRenderInteractive(false);
                    DataOptions dataOptions = new DataOptions();
                    dataOptions.setServiceName(printChannel.getPrefillService());
                    dataOptions.setContentType(ContentType.JSON);
                    logger.info("####Set the content type####");
                    dataOptions.setFormResource(GeneratePrintChannelDocument.this.getResolver.getFormsServiceResolver().getResource(formName));
                    dataOptions.setServiceName("ccm-print-test");
                    dataOptions.setExtras(new HashMap());
                    dataOptions.getExtras().put("data", targetStream);
                    options.setDataOptions(dataOptions);
                    logger.info("####Set the data options");
                    PrintDocument printDocument = printChannel.render(options);
                    logger.info("####Generated the document");
                    Document uploadedDocument = new Document(printDocument.getInputStream());
                    logger.info("Generated the document");
                    Binary binary = session.getValueFactory().createBinary(printDocument.getInputStream());
                    Session jcrSession = (Session)workflowSession.adaptTo(Session.class);
                    String dataFilePath = workItem.getWorkflowData().getPayload().toString();
                    System.out.println("The dataFilePath is " + dataFilePath);
                    Node dataFileNode = jcrSession.getNode(dataFilePath);
                    Node icPdf = dataFileNode.addNode(icFileName, "nt:file");
                    Node contentNode = icPdf.addNode("jcr:content", "nt:resource");
                    contentNode.setProperty("jcr:data", binary);
                    jcrSession.save();
                    logger.info("Copied the generated document");
                    uploadedDocument.close();
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error("Exception encountered", (Throwable)e);
        }
    }
}

