package com.aemformscs.documentservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class AssemblePDFFiles {
public String SAVE_LOCATION = "c:\\aspire1";
	
	public void assemblePDF(String postURL)
	{
	
		HttpPost httpPost = new HttpPost(postURL);
		CredentialUtilites cu = new CredentialUtilites();
		String accessToken = cu.getAccessToken();
		httpPost.addHeader("Authorization", "Bearer " + accessToken);
		ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
		URL ddxFile = classLoader.getResource("ddxfiles/assemble2pdfs.ddx");
		MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		
		builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
  		
		File ddx = new File(ddxFile.getPath());
		builder.addBinaryBody("ddx",ddx,ContentType.create("application/xml"),ddx.getName());
		URL url = classLoader.getResource("pdffiles");
		System.out.println(url.getPath());
		File files[] = new File(url.getPath()).listFiles();
		
		for(int i=0;i<files.length;i++)
		{
	  		System.out.println("Added  "+files[i].getName());
	  		builder.addBinaryBody(files[i].getName(),files[i],ContentType.APPLICATION_OCTET_STREAM,files[i].getName());
		}
		try
  		{
			
  			HttpEntity entity = builder.build();
  			httpPost.setEntity(entity);
				CloseableHttpClient httpclient = HttpClients.createDefault();
				CloseableHttpResponse response = httpclient.execute(httpPost);
				System.out.println("The success code is "+response.getStatusLine().getStatusCode());
				InputStream generatedPDF = response.getEntity().getContent();
  				byte[] bytes = IOUtils.toByteArray(generatedPDF);
  				File saveLocation = new File(SAVE_LOCATION);
  				if(!saveLocation.exists())
  				{
  					saveLocation.mkdirs();
  				}
  				File outputFile = new File(SAVE_LOCATION+File.separator+"assembledPDF.pdf");
  				FileOutputStream outputStream = new FileOutputStream(outputFile);
  			    outputStream.write(bytes);
  			    outputStream.close();
  			    System.out.println("AssembledPDF.pdf saved to "+SAVE_LOCATION);
  				
  				
  		}
  		catch(Exception e)
  		{
  			System.out.println("The message is "+e.getMessage());
  		}
	}

}
