/*
 * Decompiled with CFR 0.152.
 */
package com.onlineToOffline.core.servlets;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.forms.api.AcrobatVersion;
import com.adobe.fd.forms.api.FormsService;
import com.adobe.fd.forms.api.PDFFormRenderOptions;
import com.adobe.fd.forms.api.RenderAtClient;
import com.adobe.fd.output.api.OutputService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/pdffordownload"})
public class StreamPDFToEmbed
extends SlingAllMethodsServlet {
    @Reference
    OutputService outputService;
    @Reference
    FormsService formsService;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(StreamPDFToEmbed.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String xdpName = request.getParameter("template");
        String formData = request.getParameter("data");
        log.debug("in doPOST of Stream PDF Form Data is >>> " + formData + " template is >>> " + xdpName);
        try {
            int bytes;
            XPathFactory xfact = XPathFactory.newInstance();
            XPath xpath = xfact.newXPath();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document xmlDataDoc = builder.parse(new InputSource(new StringReader(formData)));
            Node afBoundData = (Node)xpath.evaluate("afData/afBoundData", xmlDataDoc, XPathConstants.NODE);
            NodeList afBoundDataChildren = afBoundData.getChildNodes();
            String afDataNodeName = afBoundDataChildren.item(0).getNodeName();
            Node nodeWithDataToMerge = (Node)xpath.evaluate("afData/afBoundData/" + afDataNodeName, xmlDataDoc, XPathConstants.NODE);
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(nodeWithDataToMerge), new StreamResult(writer));
            String xml = writer.toString();
            if (log.isDebugEnabled()) {
                log.debug("The submitted data" + xml);
            }
            ByteArrayInputStream targetStream = new ByteArrayInputStream(xml.getBytes());
            Document xmlDataDocument = new Document((InputStream)targetStream);
            Document xdpTemplate = new Document(xdpName);
            log.debug("got the  xdp Template " + xdpTemplate.length());
            String xdpTemplatePath = "crx:///content/dam/formsanddocuments";
            PDFFormRenderOptions renderOptions = new PDFFormRenderOptions();
            renderOptions.setAcrobatVersion(AcrobatVersion.Acrobat_11);
            renderOptions.setContentRoot(xdpTemplatePath);
            renderOptions.setRenderAtClient(RenderAtClient.NO);
            Document documentToReturn = this.formsService.importData(xdpTemplate, xmlDataDocument);
            InputStream fileInputStream = documentToReturn.getInputStream();
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=AemFormsRocks.pdf");
            response.setContentLength(fileInputStream.available());
            ServletOutputStream responseOutputStream = response.getOutputStream();
            while ((bytes = fileInputStream.read()) != -1) {
                responseOutputStream.write(bytes);
            }
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (Exception e) {
            System.out.println("Error " + e.getMessage());
        }
    }
}

