/*
 * Decompiled with CFR 0.152.
 */
package com.onlineToOffline.core.impl;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.forms.api.DataFormat;
import com.adobe.fd.forms.api.FormsService;
import com.adobe.fd.forms.api.FormsServiceException;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import com.onlineToOffline.core.ExportFormData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(service={ExportFormData.class}, immediate=true)
public class ExportFormDataImpl
implements ExportFormData {
    @Reference
    FormsService formsService;
    @Reference
    GetResolver getResolver;
    @Reference
    DocumentServices documentServices;
    private static final Logger log = LoggerFactory.getLogger(ExportFormDataImpl.class);

    private static Node getChildByTagName(Node parent, String tagName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(tagName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getFormData(String pdfForm) {
        System.out.println("In getFormData" + pdfForm + "/jcr:content");
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        org.w3c.dom.Document xmlDocument = null;
        javax.jcr.Node pdfDocumentNode = (javax.jcr.Node)this.getResolver.getFormsServiceResolver().getResource(pdfForm + "/jcr:content").adaptTo(javax.jcr.Node.class);
        System.out.println("Got pdfDocument Node");
        try {
            InputStream pdfDocumentStream = pdfDocumentNode.getProperty("jcr:data").getBinary().getStream();
            Document pdfDocument = new Document(pdfDocumentStream);
            Document xmlData = this.formsService.exportData(pdfDocument, DataFormat.Auto);
            xmlData.copyToFile(new File("xmlData.xml"));
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlData.getInputStream());
            Element xdpNode = xmlDocument.getDocumentElement();
            System.out.println("Got xdp " + xdpNode.getNodeName());
            Node datasets = ExportFormDataImpl.getChildByTagName(xdpNode, "xfa:datasets");
            System.out.println("Got datasets " + datasets.getNodeName());
            Node data = ExportFormDataImpl.getChildByTagName(datasets, "xfa:data");
            System.out.println("Got data " + data.getNodeName());
            Node topmostSubform = ExportFormDataImpl.getChildByTagName(data, "topmostSubform");
            if (topmostSubform != null) {
                org.w3c.dom.Document newXmlDocument = builder.newDocument();
                Node importedNode = newXmlDocument.importNode(topmostSubform, true);
                newXmlDocument.appendChild(importedNode);
                return this.documentServices.saveDocumentInCrx("/content/exporteddata", ".xml", this.documentServices.orgw3cDocumentToAEMFDDocument(newXmlDocument));
            }
        }
        catch (FormsServiceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getFormData(Document pdfForm) {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        org.w3c.dom.Document xmlDocument = null;
        try {
            Document xmlData = this.formsService.exportData(pdfForm, DataFormat.Auto);
            xmlData.copyToFile(new File("xmlData.xml"));
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(xmlData.getInputStream());
            Element xdpNode = xmlDocument.getDocumentElement();
            System.out.println("Got xdp " + xdpNode.getNodeName());
            Node datasets = ExportFormDataImpl.getChildByTagName(xdpNode, "xfa:datasets");
            System.out.println("Got datasets " + datasets.getNodeName());
            Node data = ExportFormDataImpl.getChildByTagName(datasets, "xfa:data");
            System.out.println("Got data " + data.getNodeName());
            Node topmostSubform = ExportFormDataImpl.getChildByTagName(data, "topmostSubform");
            if (topmostSubform != null) {
                org.w3c.dom.Document newXmlDocument = builder.newDocument();
                Node importedNode = newXmlDocument.importNode(topmostSubform, true);
                newXmlDocument.appendChild(importedNode);
                Document aemFDXmlDocument = this.documentServices.orgw3cDocumentToAEMFDDocument(newXmlDocument);
                aemFDXmlDocument.copyToFile(new File("aemFDXmlDocument.xml"));
                return this.documentServices.saveDocumentInCrx("/content/exporteddata", ".xml", aemFDXmlDocument);
            }
        }
        catch (Exception e) {
            log.debug("Error:  " + e.getMessage());
        }
        return null;
    }
}

