import React, { useContext } from 'react';
import { useRuleEngine, renderChildren, FormContext } from '@aemforms/af-react-renderer';

const Panel = function (fieldset) {
  const context = useContext(FormContext);
  const [props, handlers] = useRuleEngine(fieldset);

  if (props.visible) {
    return (
      <div>
        <div>{props?.label?.value}</div>
        {renderChildren(props, context.mappings, context.modelId, handlers)}
      </div>
    );
  } else {
    return null;
  }
};

export default Panel;