import React from 'react';
import { useRuleEngine } from '@aemforms/af-react-renderer';

const Button = (fieldset) => {
  const [props, handlers] = useRuleEngine(fieldset);
  const { label, enabled } = props;

  return (
      <div className="cmp-adaptiveform-button" >
       <button className="cmp-adaptiveform-button__widget" aria-label="Button" disabled={!enabled} onClick={handlers.dispatchClick}>
          {label?.visible && <span className="cmp-adaptiveform-button__text">{label.value}</span>}
       </button>
    </div>
  );
};

export default Button;
