/*
 * Decompiled with CFR 0.152.
 */
package com.mysite.samples.impl;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.output.api.AcrobatVersion;
import com.adobe.fd.output.api.OutputService;
import com.adobe.fd.output.api.OutputServiceException;
import com.adobe.fd.output.api.PDFOutputOptions;
import com.mysite.samples.MyFirstInterface;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MyFirstInterface.class}, enabled=true, immediate=true)
public class MyFirstInterfaceImpl
implements MyFirstInterface {
    @Reference
    OutputService outputService;
    private static final Logger log = LoggerFactory.getLogger(MyFirstInterfaceImpl.class);

    @Override
    public Document mergeDataWithXDPTemplate(Document xdpTemplate, Document xmlDocument) {
        PDFOutputOptions pdfOptions = new PDFOutputOptions();
        pdfOptions.setAcrobatVersion(AcrobatVersion.Acrobat_11);
        try {
            return this.outputService.generatePDFOutput(xdpTemplate, xmlDocument, pdfOptions);
        }
        catch (OutputServiceException e) {
            log.error("Failed to merge data with XDP Template", (Throwable)e);
            return null;
        }
    }
}

