import { useState } from "react";
export default function EmergencyContact({formData,setFormData,page,setPage}) {
  const [spinner,setSpinner]=useState(false)
  const frmSRC = formData.widgetURL;
  if(frmSRC)
    {
        //return(<div>No iframe yet</div>)
      
        return null;

    }  

  const getWebForm=async()=>
     {
      
      setSpinner(true)
        console.log("inside widgetURL function emergency contact");
        let res = await fetch("https://forms.enablementadobe.com/bin/getwidgeturl",
          {
            method: "POST",
            body: JSON.stringify({"icTemplate":"/content/forms/af/waiver/waiver/channels/print","waiver":formData})
            
                
            
         })
         let myresp = await res.json();
         console.log("Got  JSON response!!!! "+myresp.widgetURL);

         setFormData({...formData,widgetURL:myresp.widgetURL})
         setSpinner(false);
         
         
        }

        if(spinner)
        {
          return(
            <div className="loading">
            <div className="loader"></div>
            </div>
          )
        }
    return (
      <div className="card">
        <p>Who is the participants emergency contact?</p>
        <div className="step-title"></div>
        <input
          type="text"
          placeholder="Emergency Contact Name"
          value={formData.emergencycontact}
          onChange={(e) =>
            setFormData({...formData,emergencycontact:e.target.value})
          }
        />
        <input
          type="text"
          placeholder="Emergency Contact Telephone"
          value={formData.emergencyphone}
          onChange={(e) =>
            setFormData({...formData,emergencyphone:e.target.value})
          }
        />
        <input
          type="text"
          placeholder="Contact Relationship to Participant"
          value={formData.emergencyrelation}
          onChange={(e) =>
            setFormData({...formData,emergencyrelation:e.target.value})
          }

        />
       
       <button onClick={()=>getWebForm()}> 
          Submit
        </button>
        <br/>
        <button onClick={()=>{
          setPage(page-1);
        }}>
          Previous
        </button>
      </div>
    );
  };
  