import logo from './logo.svg';
import { useState } from 'react';
import './App.css';
import ActivityName from "./components/ActivityName";
import PersonalInfo from "./components/PersonalInfo";
import LocationInfo from "./components/LocationInfo";
import GetWidgetURL from './components/GetWidgetURL';
import ReceivingPartyName from './components/ReceivingPartyName';
import EmergencyContact from './components/EmergencyContact';



function App()
 {
  const [formData, setFormData] = useState({
    activity:"",
    partyname: "YMCA Rose Bowl",
    partyaddress: "777 Rose Street",
    partystate: "CA",
    partyzip: "",
    partycity:"Pasadena",
    activityperson: "John Doe",
    personaddress: "345 Park Ave",
    personcity: "San Carlos",
    personzip: "34109",
    personstate:"CA",
    emergencycontact:"Jane Doe",
    emergencyphone:"111-222-3333",
    emergencyrelation: "Spouse",
    widgetURL:"",
    
  });
  const [page,setPage] = useState(0);
  const componentList = [
        <ActivityName
          formData={formData}
          setFormData={setFormData}
          page={page}
          setPage={setPage}
        />,
        <ReceivingPartyName
          formData={formData}
          setFormData={setFormData}
          page={page}
          setPage={setPage}
        />,
         <LocationInfo
          page={page}
          formData={formData}
          setFormData={setFormData}
          setPage={setPage}
         />,
        <PersonalInfo
          page={page}
          setPage={setPage}
          formData={formData}
          setFormData={setFormData}
          />,
        <EmergencyContact
          page={page}
          setPage={setPage}
          formData={formData}
          setFormData={setFormData}
     />,
        <GetWidgetURL
          formData={formData}
     />
  ];
  return (
    <div className="App">
    
       <div>{componentList[page]}</div>
       <GetWidgetURL formData={formData}/>    
      
    
    </div>
  );
}

export default App;
